/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.emp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class GCContractMoveHandler
implements ISHRControlMoveDataHandler {
    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveContractData(ctx);
        this.moveContractTypeData(ctx);
        this.moveContractFirstPartyData(ctx);
        this.moveEmployeeContractIsElectronicSign(ctx);
        return null;
    }

    private void moveContractData(Context ctx) throws BOSException {
        String[] tableNames = new String[]{"T_HR_EmployeeContract", "T_HR_HRContractInfo", "T_HR_EmployeeOtherContract"};
        StringBuffer sql = null;
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set FHrOrgUnitID = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract set FHrOrgUnitID = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract contract set FEndDateReal=DATEADD(-3600*24,(select newCon.FEffectDate from T_HR_EmployeeContract newCon where newCon.FSOURCECONTRACTID = contract.Fid)) where fid in (").append(" select sourceContract.fid from T_HR_EmployeeContract newContract inner join T_HR_EmployeeContract sourceContract on sourceContract.fid=newContract.FSourceContractID").append(" where sourceContract.FNewState=3 and newContract.FEffectDate>sourceContract.FEffectDate").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo contract set FEndDateReal=DATEADD(-3600*24,(select newCon.FEffectDate from T_HR_EmployeeContract newCon where newCon.FSOURCECONTRACTID = contract.FEmployeeContractID)) where FEmployeeContractID in (").append(" select sourceContract.fid from T_HR_EmployeeContract newContract inner join T_HR_EmployeeContract sourceContract on sourceContract.fid=newContract.FSourceContractID").append(" where sourceContract.FNewState=3 and newContract.FEffectDate>sourceContract.FEffectDate").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int type = 0;
        for (String tableName : tableNames) {
            sql = new StringBuffer();
            sql.append("update ").append(tableName).append(" set FEndDateReal=FEndDate where ").append("fstate = 4 and FEndDateReal is null and FEndDate is not null");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("update ").append(tableName).append(" set FEndDateReal=FToDate where ").append("fstate = 5 and FEndDateReal is null and FToDate is not null");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                type = KSqlUtil.getDbType((Connection)conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            if (DbType.isOracle((int)type)) {
                sql = new StringBuffer();
                sql.append("/*dialect*/update ").append(tableName).append(" set FContractLimitAutoReal=round((TO_DATE(TO_CHAR(FEndDateReal,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)").append(" where FEndDateReal is not null and FContractLimitAutoReal is null");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                continue;
            }
            sql = new StringBuffer();
            sql.append("update ").append(tableName).append(" set FContractLimitAutoReal=round(DateDiff(FEffectDate,FEndDateReal)/31536000.0,1)").append(" where FEndDateReal is not null and FContractLimitAutoReal is null");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        this.fixContractEndDate(ctx, type);
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract contract set FAdminOrgId = (").append("select position.FAdminOrgUnitId from T_ORG_PositionMember member ").append("left join T_ORG_Position position on member.FPositionId = position.Fid ").append("where contract.FEmployeeId = member.FPersonId  and member.FisPrimary=1) where FAdminOrgId is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract contract set FAdminOrgId = (").append("select position.FAdminOrgUnitId from T_ORG_PositionMember member ").append("left join T_ORG_Position position on member.FPositionId = position.Fid ").append("where contract.FEmployeeId = member.FPersonId  and member.FisPrimary=1) where FAdminOrgId is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void fixContractEndDate(Context ctx, int dbType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='GC_T_HR_HRContractEndDateBak')").append(" Create Table GC_T_HR_HRContractEndDateBak ( FHRContractInfoID VARCHAR(44), FEmployeeContractID VARCHAR(44), FEndDate DateTime, FEndDateFix DateTime, FContractLimitAuto NUMERIC(28,10), FContractLimit NVARCHAR(20), FBillBOSType VARCHAR(40),FBillID VARCHAR(44), FEntryID VARCHAR(44),FBILLSTATE INT, FCreateTime DateTime) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into GC_T_HR_HRContractEndDateBak( FHRContractInfoID, FEmployeeContractID, FEndDate, FEndDateFix, FContractLimitAuto, FContractLimit, FBillBOSType, FBillID, FEntryID, FBILLSTATE, FCreateTime) ").append(" select contract.Fid, contract.FEmployeeContractID, contract.FEndDate, entry.FEndDate, contract.FContractLimitAuto, entry.FContractLimit, contract.FBillBOSType, contract.FBillID, contract.FEntryID, contract.FBillState, now() ").append(" from T_HR_HRContractInfo contract ").append(" left join T_HR_ContractSignBizbillEntry entry on entry.Fid = contract.FEntryId ").append(" where contract.FbillState = 3 and contract.FEntryID is not null and contract.FBILLBOSTYPE = '502B7D81' ").append(" and exists (select null from T_HR_ContractSignBizbillEntry where FId = contract.FEntryId) ").append(" and contract.Fid not in ( select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where contract.FBILLBOSTYPE = '502B7D81' and contract.FbillState = 3 ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into GC_T_HR_HRContractEndDateBak( FHRContractInfoID, FEmployeeContractID, FEndDate, FEndDateFix, FContractLimitAuto, FContractLimit, FBillBOSType, FBillID, FEntryID, FBILLSTATE, FCreateTime) ").append(" select contract.Fid, contract.FEmployeeContractID, contract.FEndDate, entry.FEndDate, contract.FContractLimitAuto, entry.FContractLimit, contract.FBillBOSType, contract.FBillID, contract.FEntryID, contract.FBillState, now() ").append(" from T_HR_HRContractInfo contract ").append(" left join T_HR_ContractRenewBizbillEntry entry on entry.Fid = contract.FEntryId ").append(" where contract.FbillState = 3 and contract.FEntryID is not null and contract.FBILLBOSTYPE = '2A2632A9' ").append(" and exists (select null from T_HR_ContractRenewBizbillEntry where FId = contract.FEntryId) ").append(" and contract.Fid not in ( select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where contract.FBILLBOSTYPE = '2A2632A9' and contract.FbillState = 3 ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into GC_T_HR_HRContractEndDateBak( FHRContractInfoID, FEmployeeContractID, FEndDate, FEndDateFix, FContractLimitAuto, FContractLimit, FBillBOSType, FBillID, FEntryID, FBILLSTATE, FCreateTime) ").append(" select contract.Fid, contract.FEmployeeContractID, contract.FEndDate, entry.FEndDate, contract.FContractLimitAuto, entry.FContractLimit, contract.FBillBOSType, contract.FBillID, contract.FEntryID, contract.FBillState, now() ").append(" from T_HR_HRContractInfo contract ").append(" left join T_HR_ContractChangeBillEntry entry on entry.Fid = contract.FEntryId ").append(" where contract.FbillState = 3 and contract.FEntryID is not null and contract.FBILLBOSTYPE = '056FBF2E' ").append(" and exists (select null from T_HR_ContractChangeBillEntry where FId = contract.FEntryId) ").append(" and contract.Fid not in ( select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where contract.FBILLBOSTYPE = '056FBF2E' and contract.FbillState = 3 ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_HRContractInfo contract set FEndDate = ").append(" (select FEndDateFix from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '502B7D81' and FHRContractInfoID = contract.Fid), ").append(" FContractLimitAuto = to_number(select FContractLimit from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '502B7D81' and FHRContractInfoID = contract.Fid) ").append(" where Fid in (select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '502B7D81') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_HRContractInfo contract set FEndDate = ").append(" (select FEndDateFix from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '2A2632A9' and FHRContractInfoID = contract.Fid), ").append(" FContractLimitAuto = to_number(select FContractLimit from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '2A2632A9' and FHRContractInfoID = contract.Fid) ").append(" where Fid in (select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '2A2632A9') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_HRContractInfo contract set FEndDate = ").append(" (select FEndDateFix from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '056FBF2E' and FHRContractInfoID = contract.Fid), ").append(" FContractLimitAuto = to_number(select FContractLimit from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '056FBF2E' and FHRContractInfoID = contract.Fid) ").append(" where Fid in (select FHRContractInfoID from GC_T_HR_HRContractEndDateBak where FBILLBOSTYPE = '056FBF2E') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_EmployeeContract contract set FEndDate = ").append(" (Select FEndDateFix From GC_T_HR_HRContractEndDateBak where FEMPLOYEECONTRACTID = contract.Fid and  FbillState = 3  and FBILLBOSTYPE in ('502B7D81','2A2632A9','056FBF2E')), ").append(" FContractLimitAuto = (Select FContractLimitAuto from T_HR_HRContractInfo where FEmployeeContractId = contract.Fid and FEntryId is not null and FBillState = 3 and FBILLBOSTYPE in ('502B7D81','2A2632A9','056FBF2E')) ").append(" where Fid in (select FEmployeeContractId From GC_T_HR_HRContractEndDateBak where FbillState = 3  and FBILLBOSTYPE in ('502B7D81','2A2632A9','056FBF2E')) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void moveContractTypeData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_ContractType set FIsRenewWarn = FIsLaborContract where FIsRenewWarn is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void moveContractFirstPartyData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_LabContractFirstParty set FSourceType = 0 where FSourceType is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void moveEmployeeContractIsElectronicSign(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set FIsElectronicSign = 0 where FIsElectronicSign is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
    }
}

