/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.emp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.EmpPosOrgRelationEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.PersonPositionEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.PersonPositionHisEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.util.EntitySQLUtil;
import com.kingdee.shr.hr.mvdt.handler.emp.util.IRowSetUtil;
import com.kingdee.shr.hr.mvdt.handler.emp.util.TableDataUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class GCPersonPositionMoveHandler
implements ISHRControlMoveDataHandler {
    private static final String PPHISMAP = "PPHISMAP";
    private static final String PPMAP = "PPMAP";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.hr.mvdt.handler.emp.GCPersonPositionMoveHandler");
    private Set<String> resignPersonSet = new HashSet<String>();
    private Set<String> retirePersonSet = new HashSet<String>();

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        this.getResignPersonSet(ctx);
        this.getRetirePersonSet(ctx);
        String sql = EmpPosOrgRelationEntity.getQuerySql();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        IRowSetUtil rsUtil = new IRowSetUtil();
        List<EmpPosOrgRelationEntity> empOrgRelationList = rsUtil.resultSetToObjectList((ResultSet)rs, EmpPosOrgRelationEntity.class);
        Map<String, Object> personPositionInfoMap = this.findPersonCompanyRecord(empOrgRelationList);
        this.deleteData(ctx);
        this.doMoveData(ctx, personPositionInfoMap);
        return null;
    }

    private void deleteData(Context ctx) throws BOSException {
        String sql = "delete from T_HR_PersonPositionhis where fpersonid in (select fpersonid from T_HR_EmpOrgRelation)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void doMoveData(Context ctx, Map<String, Object> personPositionInfoMap) throws BOSException {
        Map ppHisMap = (Map)personPositionInfoMap.get(PPHISMAP);
        Map ppMap = (Map)personPositionInfoMap.get(PPMAP);
        EntitySQLUtil sqlUtil = new EntitySQLUtil();
        Collection coll = ppMap.values();
        try {
            sqlUtil.updateBatchData(ctx, PersonPositionEntity.class, coll);
        }
        catch (SQLDataException e) {
            e.printStackTrace();
            throw new BOSException("\u66f4\u65b0\u804c\u4e1a\u4fe1\u606f\u9519\u8bef");
        }
        EntitySQLUtil sqlUtil2 = new EntitySQLUtil();
        Set ppHisMapKeys = ppHisMap.keySet();
        int i = 0;
        int total = ppHisMapKeys.size();
        Iterator it = ppHisMapKeys.iterator();
        while (it.hasNext()) {
            ++i;
            String personId = (String)it.next();
            List ppHisList = (List)ppHisMap.get(personId);
            sqlUtil2.insertBatchData(ctx, PersonPositionHisEntity.class, ppHisList);
        }
        String sql = "update T_HR_PersonPosition set FcontrolUnitId= '00000000-0000-0000-0000-000000000000CCE7AED4',fversion =1";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_HR_PersonPositionHis set FcontrolUnitId= '00000000-0000-0000-0000-000000000000CCE7AED4',fversion =1";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_HR_PersonPositionHis set FCreatorId ='256c221a-0106-1000-e000-10d7c0a813f413B7DE7F',FCreatetime=Feffdt,FLastUpdateUserId='256c221a-0106-1000-e000-10d7c0a813f413B7DE7F',FLastUpdateTime =Feffdt where fpersonid in (select fpersonid from T_HR_EmpOrgRelation) ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_HR_PersonPositionhis set FISLEADER  = SELECT FISLEADER FROM t_hr_personposition where T_HR_PersonPosition.fpersonid = T_HR_PersonPositionhis.fpersonid  where T_HR_PersonPositionhis.fleffdt={ts '2199-12-31'}";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_HR_PersonPosition SET FIsLatestInAday =1";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_HR_PersonPositionhis SET FIsLatestInAday =1";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_HR_PersonPosition SET FISINNER =1";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "UPDATE T_HR_PersonPositionhis SET FISINNER =1";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private Map<String, Object> findPersonCompanyRecord(List<EmpPosOrgRelationEntity> empOrgRelationList) throws BOSException {
        HashMap<String, List<PersonPositionHisEntity>> ppHisMap = new HashMap<String, List<PersonPositionHisEntity>>();
        HashMap<String, PersonPositionEntity> ppMap = new HashMap<String, PersonPositionEntity>();
        List<PersonPositionHisEntity> companyRZList = null;
        String personId = null;
        EmpPosOrgRelationEntity preEmpRelationInfo = null;
        if (empOrgRelationList != null) {
            int size = empOrgRelationList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    PersonPositionHisEntity prePPHis;
                    EmpPosOrgRelationEntity info = empOrgRelationList.get(i);
                    personId = info.getPersonId();
                    logger.info((Object)("\u6b63\u5728\u5904\u7406\u804c\u4e1a\u4fe1\u606fpersonId:" + personId));
                    if (!ppHisMap.containsKey(personId)) {
                        companyRZList = new ArrayList();
                        ppHisMap.put(personId, companyRZList);
                    } else {
                        companyRZList = (List)ppHisMap.get(personId);
                    }
                    if (companyRZList.size() == 0) {
                        preEmpRelationInfo = null;
                        PersonPositionEntity pp = new PersonPositionEntity();
                        pp.setId(info.getPersonPositionId());
                        PersonPositionHisEntity ppHis = new PersonPositionHisEntity();
                        this.copyEmpOrgInfoToPPHis(ppHis, info, pp);
                        if ("P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(info.getActionId())) {
                            if (this.resignPersonSet.contains(personId)) {
                                if (info.getPpHisEnterDate() != null) {
                                    ppHis.setJoinDate(info.getPpHisEnterDate());
                                }
                                ppHis.setLeftDate(info.getEffdt());
                                ppHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)ppHis.getLeftDate(), (long)-1L));
                            }
                            if (this.retirePersonSet.contains(personId)) {
                                if (info.getPpHisEnterDate() != null) {
                                    ppHis.setJoinDate(info.getPpHisEnterDate());
                                }
                                ppHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)info.getEffdt(), (long)-1L));
                            }
                        }
                        if (info.getJoinGroupDate() == null) {
                            if (info.getPpHisEnterDate() != null) {
                                ppHis.setJoinGroupDate(info.getPpHisEnterDate());
                                ppHis.setJoinGroupDateCur(info.getPpHisEnterDate());
                            } else {
                                ppHis.setJoinGroupDate(info.getEffdt());
                                ppHis.setJoinGroupDateCur(info.getEffdt());
                            }
                        } else if (info.getJoinGroupDate() != null) {
                            ppHis.setJoinGroupDate(info.getJoinGroupDate());
                            ppHis.setJoinGroupDateCur(info.getJoinGroupDate());
                        }
                        ppHis.setJoinGroupYears(0.0f);
                        ppHis.setAdjustGroupVal(info.getAdjustGroupVal());
                        companyRZList.add(ppHis);
                        this.copyEmpOrgInfoToPP(pp, ppHis, info);
                        ppMap.put(personId, pp);
                    } else {
                        prePPHis = (PersonPositionHisEntity)companyRZList.get(companyRZList.size() - 1);
                        String actionId = info.getActionId();
                        String preActionId = preEmpRelationInfo.getActionId();
                        if (actionId.equals("DawAAAApC9TmaL7Z") && !preActionId.equals("DawAAAApC9TmaL7Z")) {
                            PersonPositionHisEntity ppHis = new PersonPositionHisEntity();
                            this.copyEmpOrgInfoToPPHis(ppHis, info, prePPHis.getCurrentPP());
                            ppHis.setJoinGroupDate(prePPHis.getCurrentPP().getJoinGroupDate());
                            ppHis.setJoinGroupDateCur(info.getEffdt());
                            ppHis.setAdjustGroupVal(prePPHis.getCurrentPP().getAdjustGroupVal());
                            companyRZList.add(ppHis);
                            if (preEmpRelationInfo != null && preEmpRelationInfo.getPersonId() == personId && prePPHis.getLeftCompanyDate() == null) {
                                prePPHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)preEmpRelationInfo.getEffdt(), (long)-1L));
                            }
                        } else {
                            String curCompanyId = info.getCompanyId();
                            if (4 == info.getBizDefineType()) {
                                prePPHis.setLeftDate(info.getEffdt());
                                prePPHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)info.getEffdt(), (long)-1L));
                            }
                            if (6 == info.getBizDefineType()) {
                                prePPHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)info.getEffdt(), (long)-1L));
                            }
                            if (StringUtils.isEmpty((String)curCompanyId)) {
                                throw new BOSException("\u6570\u636e\u5f02\u5e38\uff0c\u5458\u5de5" + personId + "\u53d8\u52a8\u8bb0\u5f55\u7684\u6240\u5c5e\u516c\u53f8\u5b57\u6bb5\u4e3a\u7a7a");
                            }
                            if (!StringUtils.equals((String)curCompanyId, (String)prePPHis.getCompanyID())) {
                                PersonPositionHisEntity ppHis = new PersonPositionHisEntity();
                                this.copyEmpOrgInfoToPPHis(ppHis, info, prePPHis.getCurrentPP());
                                ppHis.setJoinGroupDate(prePPHis.getCurrentPP().getJoinGroupDate());
                                ppHis.setJoinGroupDateCur(prePPHis.getCurrentPP().getJoinGroupDateCur());
                                ppHis.setAdjustGroupVal(prePPHis.getCurrentPP().getAdjustGroupVal());
                                companyRZList.add(ppHis);
                                prePPHis.setLeftCompanyDate(DateTimeUtils.addDay((Date)info.getEffdt(), (long)-1L));
                            } else {
                                Date prePPHisEFFDT = prePPHis.getEffdt();
                                this.copyEmpOrgInfoToPPHis(prePPHis, info, prePPHis.getCurrentPP());
                                prePPHis.setEffdt(prePPHisEFFDT);
                                prePPHis.setJoinDate(prePPHisEFFDT);
                            }
                        }
                    }
                    if (HRUtil.getMaxEndDate().equals(info.getLeffdt())) {
                        prePPHis = (PersonPositionHisEntity)companyRZList.get(companyRZList.size() - 1);
                        PersonPositionEntity pp = prePPHis.getCurrentPP();
                        String ppIdTemp = pp.getId();
                        try {
                            BeanUtils.copyProperties((Object)pp, (Object)prePPHis);
                            pp.setId(ppIdTemp);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            throw new BOSException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                            throw new BOSException((Throwable)e);
                        }
                        ppMap.put(personId, pp);
                    }
                    preEmpRelationInfo = info;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String errorMsg = "[" + personId + "]\u5347\u7ea7\u5931\u8d25";
                    logger.error((Object)errorMsg);
                    throw new BOSException(errorMsg + e.getMessage());
                }
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(PPHISMAP, ppHisMap);
        returnMap.put(PPMAP, ppMap);
        return returnMap;
    }

    private void copyEmpOrgInfoToPP(PersonPositionEntity pp, PersonPositionHisEntity ppHis, EmpPosOrgRelationEntity info) {
        pp.setId(info.getPersonPositionId());
        pp.setJoinGroupDate(ppHis.getJoinGroupDate());
        pp.setJoinGroupDateCur(ppHis.getJoinGroupDate());
        pp.setAdjustGroupVal(ppHis.getAdjustGroupVal());
    }

    private void copyEmpOrgInfoToPPHis(PersonPositionHisEntity ppHis, EmpPosOrgRelationEntity info, PersonPositionEntity personPositionEntity) {
        ppHis.setCompanyID(info.getCompanyId());
        ppHis.setDimissionReasonID(TableDataUtil.dismissReasonCacheMap.get(info.getActionReasonId()));
        BOSUuid id = BOSUuid.create((String)"F819339F");
        ppHis.setId(id.toString());
        ppHis.setPersondep(info.getAdminOrgId());
        ppHis.setPrimaryPositionID(info.getPositionId());
        ppHis.setEffdt(info.getEffdt());
        ppHis.setLeffdt(info.getLeffdt());
        ppHis.setJoinDate(info.getEffdt());
        ppHis.setHistoryRelateID(personPositionEntity.getId());
        ppHis.setPersonId(info.getPersonId());
        ppHis.setCurrentPP(personPositionEntity);
        if (info.getIsEnrollAgain() == 1) {
            ppHis.setIsEnrollAgain(1);
        } else {
            ppHis.setIsEnrollAgain(0);
        }
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    public Set<String> getResignPersonSet(Context ctx) throws BOSException {
        String resignPersonSQL = "SELECT emprelation.fpersonid FROM t_hr_emporgrelation emprelation inner join t_hr_emplaborrelationhis emptypehis on emprelation.fleffdt>= emptypehis.feffdt and emprelation.fleffdt <= emptypehis.FLEFFDT and emprelation.fpersonid = emptypehis.fpersonid  INNER JOIN T_HR_BDEMPLOYEETYPE EMPTYPE ON emptypehis.FLABORRELATIONSTATEID  =EMPTYPE.FID WHERE  emprelation.factionid ='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and EMPTYPE.FINSERVICE =2 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)resignPersonSQL);
        if (rs != null) {
            try {
                while (rs.next()) {
                    this.resignPersonSet.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return this.resignPersonSet;
    }

    public Set<String> getRetirePersonSet(Context ctx) throws BOSException {
        String retirePersonSQL = "SELECT emprelation.fpersonid FROM t_hr_emporgrelation emprelation inner join t_hr_emplaborrelationhis emptypehis on emprelation.fleffdt>= emptypehis.feffdt and emprelation.fleffdt <= emptypehis.FLEFFDT and emprelation.fpersonid = emptypehis.fpersonid  INNER JOIN T_HR_BDEMPLOYEETYPE EMPTYPE ON emptypehis.FLABORRELATIONSTATEID  =EMPTYPE.FID WHERE  emprelation.factionid ='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and EMPTYPE.FINSERVICE =3 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)retirePersonSQL);
        if (rs != null) {
            try {
                while (rs.next()) {
                    this.retirePersonSet.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return this.retirePersonSet;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
    }
}

