/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.emp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DbUtil {
    private static final Logger logger = Logger.getLogger(DbUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] executeBatchAndReturn(Context ctx, List<String> sqls) throws BOSException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            ps = conn.createStatement(1005, 1007);
            for (int i = 0; i < sqls.size(); ++i) {
                ps.addBatch(sqls.get(i));
            }
            ps.executeBatch();
            conn.commit();
        }
        catch (SQLException exc) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException("Sql execute exception : ", (Throwable)e);
                }
                logger.error((Object)exc);
                throw new BOSException("Sql execute exception : ", (Throwable)exc);
                catch (Exception exc2) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    logger.error((Object)exc2);
                    throw new BOSException((Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }
}

