/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler.emp.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.reflect.FieldUtils;

public class EntitySQLUtil<T> {
    public static final int BATCH_SIZE = 500;
    private String updateSql = "";

    public String getInsertSQL(Class<?> intputClass) {
        StringBuffer sqlBuffer = new StringBuffer();
        int insertFieldCount = 0;
        if (intputClass.isAnnotationPresent(Table.class)) {
            Table table = intputClass.getAnnotation(Table.class);
            String tableName = table.name();
            Field[] fields = this.getFields(intputClass);
            sqlBuffer.append("insert into ").append(tableName).append(" ( ");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                sqlBuffer.append("F").append(field.getName()).append(",");
                ++insertFieldCount;
            }
        }
        int length = sqlBuffer.length();
        sqlBuffer.delete(length - 1, length).append(")");
        sqlBuffer.append("values (");
        for (int i = 0; i < insertFieldCount; ++i) {
            if (i != 0) {
                sqlBuffer.append(",");
            }
            sqlBuffer.append("?");
        }
        sqlBuffer.append(");");
        return sqlBuffer.toString();
    }

    public String getUpdateSQL(Class<?> intputClass) {
        if (!StringUtils.isEmpty((String)this.updateSql)) {
            return this.updateSql;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        if (intputClass.isAnnotationPresent(Table.class)) {
            Table table = intputClass.getAnnotation(Table.class);
            String tableName = table.name();
            String idName = "";
            Field[] fields = this.getFields(intputClass);
            sqlBuffer.append("UPDATE ").append(tableName).append(" SET ");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                Id id = field.getAnnotation(Id.class);
                if (id == null) {
                    sqlBuffer.append("F").append(field.getName()).append("=?");
                    sqlBuffer.append(",");
                    continue;
                }
                idName = "fid";
            }
            if (idName == "") {
                throw new RuntimeException("not found of " + intputClass.getClass() + "'s ID");
            }
            String preSQL = sqlBuffer.toString();
            preSQL = preSQL.substring(0, preSQL.lastIndexOf(","));
            sqlBuffer = new StringBuffer(preSQL);
            sqlBuffer.append(" WHERE ").append(idName).append("=?");
        }
        this.updateSql = sqlBuffer.toString();
        return this.updateSql;
    }

    private Field[] getFields(Class<?> clazz) {
        Field[] fields = null;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null && !clazz.getName().toLowerCase().equals("java.lang.object")) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        fields = new Field[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            fields[i] = (Field)fieldList.get(i);
        }
        return fields;
    }

    protected Object readField(Field field, T targetBean) {
        try {
            Object dateObj;
            if (field.getGenericType().toString().equals("class java.util.Date") && (dateObj = FieldUtils.readField((Field)field, targetBean, (boolean)true)) != null) {
                Date date = (Date)dateObj;
                return new java.sql.Date(date.getTime());
            }
            return FieldUtils.readField((Field)field, targetBean, (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateBatchData(Context ctx, Class<?> intputClass, Collection<T> coll) throws SQLDataException {
        String updateSQL = this.getUpdateSQL(intputClass);
        Iterator<T> it = coll.iterator();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] params = null;
        ArrayList<Object> objParams = null;
        int cursor = 0;
        int collToal = coll.size();
        while (it.hasNext()) {
            ++cursor;
            T valObj = it.next();
            String idValue = "noid";
            Field[] fields = this.getFields(intputClass);
            objParams = new ArrayList<Object>();
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                Id id = field.getAnnotation(Id.class);
                if (id != null) {
                    idValue = (String)this.readField(field, valObj);
                    continue;
                }
                objParams.add(this.readField(field, valObj));
            }
            objParams.add(idValue);
            params = objParams.toArray();
            paramsList.add(params);
            if (paramsList.size() != 500) continue;
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
            paramsList.clear();
        }
        if (paramsList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
            paramsList.clear();
        }
    }

    public void insertBatchData(Context ctx, Class<?> intputClass, List<T> entityList) throws SQLDataException {
        String insertSQL = this.getInsertSQL(intputClass);
        Iterator<T> it = entityList.iterator();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] params = null;
        ArrayList<Object> objParams = null;
        while (it.hasNext()) {
            T valObj = it.next();
            Field[] fields = this.getFields(intputClass);
            objParams = new ArrayList<Object>();
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                objParams.add(this.readField(field, valObj));
            }
            params = objParams.toArray();
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSQL, paramsList);
    }
}

