/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.chart;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ShowViewUIFactory;
import com.kingdee.eas.basedata.org.client.chart.DrawOrgUnit;
import com.kingdee.eas.basedata.org.client.chart.HistoryNode;
import com.kingdee.eas.basedata.org.client.chart.OrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DrawingPanel
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private DefaultMutableTreeNode root = null;
    private DrawOrgUnit drawOrgUnit = null;
    public OrgUnit selOrgUnit = null;
    private OrgUnit currOrgUnit = null;
    private int translateX = 0;
    private int translateY = 0;
    public Color rectLineColor = new Color(0x9E9E9E);
    public Color currRectLineColor = new Color(14581776);
    public Color selRectLineColor = new Color(14588434);
    public Color orgRectColor = new Color(13296622);
    public Color currOrgRectColor = new Color(16247737);
    public Color selOrgRectColor = new Color(15653292);
    public Color otherRectColor = new Color(0xFFFFFF);
    public Color selOtherRectColor = new Color(16314050);
    public Color textColor = Color.BLACK;
    public Color separateLineColor = new Color(0xE6E6E6);
    public Color selSeparateLineColor = new Color(15653292);
    public Color lineColor = new Color(4145719);
    public Color currOtherRectColor = new Color(0xFFFFFF);
    public Color currSeparateLineColor = new Color(0xE6E6E6);
    public Color noPPBackgroudColor = new Color(0xD9D9D0);
    public Color bgColor = new Color(0xD9D9D0);
    private Point startPoint = null;
    private Point endPoint = null;
    private boolean finded = false;

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void clearSelectNode() {
        this.selOrgUnit = null;
        this.currOrgUnit = null;
    }

    public void setDrawingPaneSize(int maxX, int maxY) {
        this.setPreferredSize(new Dimension(maxX + 30, maxY + 30));
        this.translateX = 0;
        this.translateY = 0;
        if (this.drawOrgUnit.horizontal) {
            if (maxX < this.drawOrgUnit.getWidth()) {
                this.translateX = (this.drawOrgUnit.getWidth() - maxX) / 2;
            }
        } else if (maxY < this.drawOrgUnit.getHeight()) {
            this.translateY = (this.drawOrgUnit.getHeight() - maxY) / 2 - 30;
        }
    }

    public DrawingPanel(DrawOrgUnit drawOrgUnit) {
        this.drawOrgUnit = drawOrgUnit;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.bgColor);
        g2.translate(this.translateX, this.translateY);
        if (this.root != null) {
            this.drawOrgNode(g2, this.root);
            g2.setColor(this.lineColor);
            if (this.drawOrgUnit.horizontal) {
                this.drawOrgUnitLineH(g2, this.root);
            } else {
                this.drawOrgUnitLineV(g2, this.root);
            }
        }
    }

    private void drawOrgUnit(Graphics2D g2, OrgUnit orgUnit) {
        Color tempRectLineColor = null;
        Color tempOrgRectColor = null;
        Color tempTextColor = this.textColor;
        Color tempOtherRectColor = null;
        Color tempSeparateLineColor = null;
        if (orgUnit.isMain || orgUnit.isCurrent) {
            tempRectLineColor = this.currRectLineColor;
            tempOrgRectColor = this.currOrgRectColor;
            tempOtherRectColor = this.currOtherRectColor;
            tempSeparateLineColor = this.currSeparateLineColor;
        } else if (orgUnit.isSelected) {
            tempRectLineColor = this.selRectLineColor;
            tempOrgRectColor = this.selOrgRectColor;
            tempOtherRectColor = this.selOtherRectColor;
            tempSeparateLineColor = this.selSeparateLineColor;
        } else {
            tempRectLineColor = this.rectLineColor;
            tempOrgRectColor = this.orgRectColor;
            tempOtherRectColor = orgUnit.canView ? this.otherRectColor : this.noPPBackgroudColor;
            tempSeparateLineColor = this.separateLineColor;
        }
        orgUnit.rect = new Rectangle((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height);
        g2.setColor(tempOrgRectColor);
        g2.fillRoundRect((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height, 10, 10);
        g2.setColor(tempTextColor);
        int length = 0;
        if (StringUtils.isEmpty((String)orgUnit.name)) {
            length = 0;
            g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 15);
        } else {
            length = g2.getFontMetrics().stringWidth(orgUnit.name);
            g2.drawString(orgUnit.name, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 15);
        }
        if (this.drawOrgUnit.chartType == 1) {
            g2.setColor(tempOtherRectColor);
            g2.fillRoundRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 60, 10, 10);
            g2.fillRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 20);
            g2.setColor(tempTextColor);
            length = g2.getFontMetrics().stringWidth(orgUnit.otherInfo);
            g2.drawString(orgUnit.otherInfo, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 35);
            g2.setColor(tempSeparateLineColor);
            g2.drawLine((int)orgUnit.X, (int)orgUnit.Y + 40, (int)orgUnit.X + (int)orgUnit.width, (int)orgUnit.Y + 40);
            g2.setColor(tempTextColor);
            length = g2.getFontMetrics().stringWidth(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"0_DrawingPanel") + orgUnit.bzCount);
            g2.drawString(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"0_DrawingPanel") + orgUnit.bzCount, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 57);
            g2.setColor(tempSeparateLineColor);
            g2.drawLine((int)orgUnit.X, (int)orgUnit.Y + 60, (int)orgUnit.X + (int)orgUnit.width, (int)orgUnit.Y + 60);
            g2.setColor(tempTextColor);
            length = g2.getFontMetrics().stringWidth(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"1_DrawingPanel") + orgUnit.factCount);
            g2.drawString(EASResource.getString((String)"com.kingdee.eas.basedata.org.ORGAutoGenerateResource", (String)"1_DrawingPanel") + orgUnit.factCount, (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 77);
        }
        if (this.drawOrgUnit.displayPositionAndPerson) {
            g2.setColor(tempOtherRectColor);
            g2.fillRoundRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 80, 10, 10);
            g2.fillRect((int)orgUnit.X, (int)orgUnit.Y + 20, (int)orgUnit.width, 20);
            g2.setColor(tempTextColor);
            if (orgUnit.posiInfo != null) {
                if (StringUtils.isEmpty((String)orgUnit.posiInfo.getName())) {
                    length = 0;
                    g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 35);
                } else {
                    length = g2.getFontMetrics().stringWidth(orgUnit.posiInfo.getName());
                    g2.drawString(orgUnit.posiInfo.getName(), (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 35);
                }
            }
            g2.setColor(tempSeparateLineColor);
            g2.drawLine((int)orgUnit.X, (int)orgUnit.Y + 40, (int)orgUnit.X + (int)orgUnit.width, (int)orgUnit.Y + 40);
            g2.setColor(tempTextColor);
            if (orgUnit.empInfo != null) {
                int size = orgUnit.empInfo.size();
                if (size > 0) {
                    if (StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(0)).getName())) {
                        length = 0;
                        g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 57);
                    } else {
                        length = g2.getFontMetrics().stringWidth(((PersonInfo)orgUnit.empInfo.get(0)).getName());
                        g2.drawString(((PersonInfo)orgUnit.empInfo.get(0)).getName(), (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 57);
                    }
                }
                if (size > 1) {
                    if (StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(1)).getName())) {
                        length = 0;
                        g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 74);
                    } else {
                        length = g2.getFontMetrics().stringWidth(((PersonInfo)orgUnit.empInfo.get(1)).getName());
                        g2.drawString(((PersonInfo)orgUnit.empInfo.get(1)).getName(), (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 74);
                    }
                }
                if (size == 3) {
                    if (StringUtils.isEmpty((String)((PersonInfo)orgUnit.empInfo.get(2)).getName())) {
                        length = 0;
                        g2.drawString("", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 91);
                    } else {
                        length = g2.getFontMetrics().stringWidth(((PersonInfo)orgUnit.empInfo.get(2)).getName());
                        g2.drawString(((PersonInfo)orgUnit.empInfo.get(2)).getName(), (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 91);
                    }
                }
                if (size > 3) {
                    length = g2.getFontMetrics().stringWidth(".....");
                    g2.drawString(".....", (int)orgUnit.X + ((int)orgUnit.width - length) / 2, (int)orgUnit.Y + 85);
                }
            }
        }
        g2.setColor(tempRectLineColor);
        g2.drawRoundRect((int)orgUnit.X, (int)orgUnit.Y, (int)orgUnit.width, (int)orgUnit.height, 10, 10);
    }

    private void drawOrgNode(Graphics2D g2, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawOrgUnit.baseLevel + 1 > this.drawOrgUnit.chooseLevel && this.drawOrgUnit.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        this.drawOrgUnit(g2, orgUnit);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawOrgNode(g2, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void drawOrgUnitLineV(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawOrgUnit.baseLevel + 1 > this.drawOrgUnit.chooseLevel && this.drawOrgUnit.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawOrgUnit.baseLevel + 1 < this.drawOrgUnit.chooseLevel || this.drawOrgUnit.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointV(node);
            this.endPoint = new Point();
            this.endPoint.y = this.startPoint.y;
            this.endPoint.x = this.startPoint.x + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineV(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawOrgUnit.baseLevel + 1 < this.drawOrgUnit.chooseLevel || this.drawOrgUnit.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointV(node);
            this.endPoint = new Point();
            this.endPoint.y = this.startPoint.y;
            this.endPoint.x = this.startPoint.x + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            OrgUnit startOrg = (OrgUnit)firstChildNode.getUserObject();
            OrgUnit endOrg = (OrgUnit)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X - 20.0f), (int)(startOrg.Y + startOrg.height / 2.0f), (int)(endOrg.X - 20.0f), (int)(endOrg.Y + endOrg.height / 2.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointV(lastChildNode);
                this.startPoint.y = this.endPoint.y;
                this.startPoint.x = this.endPoint.x - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineV(g, lastChildNode);
            }
        }
    }

    private void drawOrgUnitLineH(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawOrgUnit.baseLevel + 1 > this.drawOrgUnit.chooseLevel && this.drawOrgUnit.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawOrgUnit.baseLevel + 1 < this.drawOrgUnit.chooseLevel || this.drawOrgUnit.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineH(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawOrgUnit.baseLevel + 1 < this.drawOrgUnit.chooseLevel || this.drawOrgUnit.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            OrgUnit startOrg = (OrgUnit)firstChildNode.getUserObject();
            OrgUnit endOrg = (OrgUnit)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X + startOrg.width / 2.0f), (int)(startOrg.Y - 20.0f), (int)(endOrg.X + endOrg.width / 2.0f), (int)(endOrg.Y - 20.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointH(lastChildNode);
                this.startPoint.x = this.endPoint.x;
                this.startPoint.y = this.endPoint.y - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineH(g, lastChildNode);
            }
        }
    }

    private Point getStartPointV(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width);
        point.y = (int)(orgUnit.Y + orgUnit.height / 2.0f);
        return point;
    }

    private Point getEndPointV(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)orgUnit.X;
        point.y = (int)(orgUnit.Y + orgUnit.height / 2.0f);
        return point;
    }

    private Point getStartPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width / 2.0f);
        point.y = (int)(orgUnit.Y + orgUnit.height);
        return point;
    }

    private Point getEndPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        point.x = (int)(orgUnit.X + orgUnit.width / 2.0f);
        point.y = (int)orgUnit.Y;
        return point;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            Point point = e.getPoint();
            point.x -= this.translateX;
            point.y -= this.translateY;
            if (!SwingUtilities.isRightMouseButton(e)) {
                this.clickTreeNode(e, this.root, point, true);
            }
            this.finded = false;
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clickTreeNode(MouseEvent e, DefaultMutableTreeNode node, Point point, boolean flag) throws Exception {
        if (node.getLevel() - this.drawOrgUnit.baseLevel + 1 > this.drawOrgUnit.chooseLevel && this.drawOrgUnit.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        Rectangle tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y, orgUnit.rect.width, orgUnit.rect.height);
        if (tempRect.contains(point)) {
            this.currOrgUnit = null;
            if (this.selOrgUnit != null) {
                this.selOrgUnit.isSelected = false;
            }
            if (e.getClickCount() == 1) {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.translate(this.translateX, this.translateY);
                if (this.selOrgUnit != null) {
                    this.drawOrgUnit(g2, this.selOrgUnit);
                }
                orgUnit.isSelected = true;
                orgUnit.isCurrent = false;
                this.selOrgUnit = orgUnit;
                this.drawOrgUnit(g2, this.selOrgUnit);
                if (flag) {
                    return;
                }
            }
            if (e.getClickCount() == 2) {
                if (!flag || !this.drawOrgUnit.isPenetrable) {
                    return;
                }
                if (this.drawOrgUnit.historyNode != null && this.drawOrgUnit.historyNode.value.equalsIgnoreCase(orgUnit.ID)) {
                    return;
                }
                orgUnit.isCurrent = false;
                orgUnit.isSelected = false;
                HistoryNode hisNode = new HistoryNode();
                hisNode.previous = this.drawOrgUnit.historyNode;
                hisNode.next = null;
                hisNode.value = orgUnit.ID;
                hisNode.curNode = node;
                this.drawOrgUnit.preButton.setEnabled(true);
                this.drawOrgUnit.nextButton.setEnabled(false);
                this.drawOrgUnit.historyNode = hisNode;
                this.drawOrgUnit.startDraw();
                this.expandTreeNode(this.drawOrgUnit.getTreeMain(), orgUnit.ID);
            } else if (!flag) {
                tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y, orgUnit.rect.width, 20);
                if (tempRect.contains(point)) {
                    if (this.drawOrgUnit.chartType == 0) {
                        if (!orgUnit.canView) {
                            PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfoByNumber("HR_Org_View");
                            Object[] objs = new Object[]{orgUnit.name, permItemInfo.getAlias()};
                            throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, objs);
                        }
                        this.showOrgViewUI(orgUnit);
                    } else {
                        this.showPositionViewUI(orgUnit);
                    }
                }
                if ((tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y + 20, orgUnit.rect.width, 20)).contains(point)) {
                    this.showPositionViewUI(orgUnit);
                }
                if ((tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y + 40, orgUnit.rect.width, 20)).contains(point)) {
                    this.showEmpViewUI(orgUnit, 1);
                }
                if ((tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y + 60, orgUnit.rect.width, 20)).contains(point)) {
                    this.showEmpViewUI(orgUnit, 2);
                }
                if ((tempRect = new Rectangle(orgUnit.rect.x, orgUnit.rect.y + 80, orgUnit.rect.width, 20)).contains(point)) {
                    this.showEmpViewUI(orgUnit, 3);
                }
            }
            this.finded = true;
            return;
        }
        for (int i = 0; i < node.getChildCount() && !this.finded; ++i) {
            this.clickTreeNode(e, (DefaultMutableTreeNode)node.getChildAt(i), point, flag);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showEmpViewUI(OrgUnit orgUnit, int index) throws Exception {
        if (orgUnit.empInfo == null || orgUnit.empInfo.size() == 0) {
            return;
        }
        if (orgUnit.empInfo.size() > 3 && index == 3) {
            return;
        }
        String strSelectId = null;
        if (index == 1) {
            strSelectId = ((PersonInfo)orgUnit.empInfo.get(0)).getId().toString();
        } else if (index == 2) {
            if (orgUnit.empInfo.size() <= 1) return;
            strSelectId = ((PersonInfo)orgUnit.empInfo.get(1)).getId().toString();
        } else {
            if (orgUnit.empInfo.size() != 3) return;
            strSelectId = ((PersonInfo)orgUnit.empInfo.get(2)).getId().toString();
        }
        final String tempId = strSelectId;
        final BOSUuid hrOrgId = OrgUnitRelationFactory.getRemoteInstance().getToUnit(orgUnit.ID, 0, 16).get(0).getId();
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window windowTemp = SwingUtilities.getWindowAncestor(owner);
        GetDataDialog dlg = null;
        dlg = windowTemp instanceof Frame ? new GetDataDialog((Frame)windowTemp) : (windowTemp instanceof Dialog ? new GetDataDialog((Dialog)windowTemp) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                SysContext ctx = SysContext.getSysContext();
                IPermission per = PermissionFactory.getRemoteInstance();
                per.checkDataPermission((IObjectPK)new ObjectUuidPK(ctx.getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(hrOrgId), "employee_view", (IObjectPK)new ObjectUuidPK(tempId));
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"Owner", (Object)this);
                uiContext.put((Object)"FromChart", (Object)"YES");
                uiContext.put((Object)"ID", (Object)tempId);
                RealModeIDList idList = new RealModeIDList();
                idList.add(tempId);
                uiContext.put((Object)"IDList", (Object)idList);
                uiContext.put((Object)"isPosition", (Object)true);
                IUIWindow curDialog = ShowViewUIFactory.getUIInstance().showEmpViewUI((Map)uiContext, null, OprtState.VIEW);
                return curDialog;
            }

            public void finish(Object obj) throws Exception {
                ((IUIWindow)obj).show();
            }
        });
        dlg.show();
    }

    private void showPositionViewUI(OrgUnit orgUnit) throws Exception {
        String pId = null;
        if (this.drawOrgUnit.chartType == 0) {
            if (orgUnit.posiInfo == null) {
                return;
            }
            pId = orgUnit.posiInfo.getId().toString();
        } else {
            pId = orgUnit.ID;
        }
        final String tempId = pId;
        OrgUnitCollection hrCollection = OrgUnitRelationFactory.getRemoteInstance().getToUnit(orgUnit.ID, 0, 16);
        if (hrCollection.size() > 0) {
            final BOSUuid hrOrgId = hrCollection.get(0).getId();
            Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Window windowTemp = SwingUtilities.getWindowAncestor(owner);
            GetDataDialog dlg = null;
            dlg = windowTemp instanceof Frame ? new GetDataDialog((Frame)windowTemp) : (windowTemp instanceof Dialog ? new GetDataDialog((Dialog)windowTemp) : new GetDataDialog());
            dlg.setGetDataTask(new GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    SysContext ctx = SysContext.getSysContext();
                    IPermission per = PermissionFactory.getRemoteInstance();
                    per.checkDataPermission((IObjectPK)new ObjectUuidPK(ctx.getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(hrOrgId), "HRPosition_View", (IObjectPK)new ObjectUuidPK(tempId));
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"Owner", (Object)this);
                    uiContext.put((Object)"ID", (Object)tempId);
                    uiContext.put((Object)"FromChart", (Object)"YES");
                    IUIWindow curDialog = ShowViewUIFactory.getUIInstance().showPositionViewUI((Map)uiContext, null, OprtState.VIEW);
                    return curDialog;
                }

                public void finish(Object obj) throws Exception {
                    ((IUIWindow)obj).show();
                }
            });
            dlg.show();
        }
    }

    private void showOrgViewUI(final OrgUnit orgUnit) throws Exception {
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window windowTemp = SwingUtilities.getWindowAncestor(owner);
        GetDataDialog dlg = null;
        dlg = windowTemp instanceof Frame ? new GetDataDialog((Frame)windowTemp) : (windowTemp instanceof Dialog ? new GetDataDialog((Dialog)windowTemp) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"Owner", (Object)this);
                uiContext.put((Object)"ID", (Object)orgUnit.ID);
                uiContext.put((Object)"FromChart", (Object)"YES");
                IUIWindow curDialog = ShowViewUIFactory.getUIInstance().showOrgViewUI((Map)uiContext, null, OprtState.VIEW);
                return curDialog;
            }

            public void finish(Object obj) throws Exception {
                ((IUIWindow)obj).show();
            }
        });
        dlg.show();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
        Rectangle tempRect = null;
        if (this.currOrgUnit != null && (tempRect = new Rectangle(this.currOrgUnit.rect.x + this.translateX, this.currOrgUnit.rect.y + this.translateY, this.currOrgUnit.rect.width, this.currOrgUnit.rect.height)).contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (this.currOrgUnit != null && this.currOrgUnit.isCurrent && !tempRect.contains(e.getPoint()) && !this.currOrgUnit.isMain) {
            this.currOrgUnit.isCurrent = false;
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.translate(this.translateX, this.translateY);
            this.drawOrgUnit(g2, this.currOrgUnit);
            this.currOrgUnit = null;
        }
        if (this.root != null) {
            this.setCurrentNode(this.root, e.getPoint());
        }
    }

    private void setCurrentNode(DefaultMutableTreeNode node, Point point) {
        if (node.getLevel() - this.drawOrgUnit.baseLevel + 1 > this.drawOrgUnit.chooseLevel && this.drawOrgUnit.chartType == 0) {
            return;
        }
        OrgUnit orgUnit = (OrgUnit)node.getUserObject();
        if (orgUnit.rect == null) {
            return;
        }
        Rectangle tempRect = new Rectangle(orgUnit.rect.x + this.translateX, orgUnit.rect.y + this.translateY, orgUnit.rect.width, orgUnit.rect.height);
        if (tempRect.contains(point) && !orgUnit.isCurrent) {
            if (orgUnit.isSelected) {
                return;
            }
            this.currOrgUnit = orgUnit;
            this.currOrgUnit.isCurrent = true;
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.translate(this.translateX, this.translateY);
            this.drawOrgUnit(g2, this.currOrgUnit);
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setCurrentNode((DefaultMutableTreeNode)node.getChildAt(i), point);
        }
    }

    public void expandTreeNode(KDTree tree, String id) {
        if (tree != null && !StringUtils.isEmpty((String)id)) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
            DefaultKingdeeTreeNode node = this.searchTreeNodeById(root, id);
            TreePath currentPath = new TreePath(node.getPath());
            tree.expandPath(currentPath);
            tree.scrollPathToVisible(currentPath);
            tree.setSelectionNode(node);
        }
    }

    public DefaultKingdeeTreeNode searchTreeNodeById(DefaultKingdeeTreeNode root, String id) {
        if (root == null) {
            return null;
        }
        Object userObject = root.getUserObject();
        String rootId = null;
        if (userObject instanceof AdminOrgUnitInfo) {
            rootId = ((AdminOrgUnitInfo)root.getUserObject()).getId().toString();
        }
        if (id.equals(rootId)) {
            return root;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode node = this.searchTreeNodeById((DefaultKingdeeTreeNode)root.getChildAt(i), id);
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

