/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.client.chart.OrgChartInfo;
import com.kingdee.eas.hr.org.client.AbstractOrgCharSetingUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OrgCharSetingUI
extends AbstractOrgCharSetingUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgCharSetingUI.class);
    private static final String ORG_NAME = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_6");
    private static final String POSITION_NAME = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_7");
    private static final String EMP_NAME = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_8");
    private static final String STR_1 = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_2");
    private static final String STR_2 = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_1");
    private static final String STR_3 = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_3");
    private static final String STR_4 = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_4");
    private static final String STR_5 = EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_5");
    private int length = 0;
    private FontMetrics fontM = null;
    public OrgChartInfo info = null;
    public OrgChartInfo oldInfo = null;
    private ArrayList list = new ArrayList();
    private String temp = null;

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap map = (HashMap)this.getUIContext();
        this.info = map.get("ID") != null ? (OrgChartInfo)map.get("ID") : new OrgChartInfo();
        this.oldInfo = (OrgChartInfo)this.info.clone();
        KDWorkButton btnOK = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_9"));
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OrgCharSetingUI.this.pressOKButton();
            }
        });
        KDWorkButton btnDefault = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_10"));
        btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OrgCharSetingUI.this.pressDefaultButton();
            }
        });
        KDWorkButton btnCancel = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_11"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OrgCharSetingUI.this.pressCancelButton();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OrgCharSetingUI.this.processMouseClick(e);
            }
        });
        this.setLayout(null);
        btnOK.setBounds(414, 450, 40, 19);
        btnDefault.setBounds(462, 450, 80, 19);
        btnCancel.setBounds(550, 450, 40, 19);
        this.add((Component)btnOK, null);
        this.add((Component)btnDefault, null);
        this.add((Component)btnCancel, null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                OrgCharSetingUI.this.processMouseMove(e);
            }
        });
    }

    private void pressDefaultButton() {
        this.info = new OrgChartInfo();
        this.repaint();
    }

    private void pressOKButton() {
        this.getUIWindow().close();
    }

    private void pressCancelButton() {
        this.info = this.oldInfo;
        this.getUIWindow().close();
    }

    private void processMouseClick(MouseEvent e) {
        Point point = e.getPoint();
        for (int i = 0; i < this.list.size(); ++i) {
            Rectangle rect = (Rectangle)this.list.get(i);
            if (!rect.contains(point)) continue;
            Color selectColor = KDColorChooser.showDialog((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_12"), null);
            this.changeOrgChartInfo(i, selectColor);
        }
        this.repaint();
    }

    private void changeOrgChartInfo(int i, Color selectColor) {
        if (selectColor == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.info.rectLineColor = selectColor;
                break;
            }
            case 1: {
                this.info.orgRectColor = selectColor;
                break;
            }
            case 2: {
                this.info.separateLineColor = selectColor;
                break;
            }
            case 3: {
                this.info.otherRectColor = selectColor;
                break;
            }
            case 4: {
                this.info.lineColor = selectColor;
                break;
            }
            case 5: {
                this.info.currRectLineColor = selectColor;
                break;
            }
            case 6: {
                this.info.currOrgRectColor = selectColor;
                break;
            }
            case 7: {
                this.info.currSeparateLineColor = selectColor;
                break;
            }
            case 8: {
                this.info.currOtherRectColor = selectColor;
                break;
            }
            case 9: {
                this.info.selRectLineColor = selectColor;
                break;
            }
            case 10: {
                this.info.selOrgRectColor = selectColor;
                break;
            }
            case 11: {
                this.info.selSeparateLineColor = selectColor;
                break;
            }
            case 12: {
                this.info.selOtherRectColor = selectColor;
                break;
            }
            case 13: {
                this.info.textColor = selectColor;
                break;
            }
            case 14: {
                this.info.bgColor = selectColor;
            }
        }
        this.repaint();
    }

    private void processMouseMove(MouseEvent e) {
        Point point = e.getPoint();
        for (int i = 0; i < this.list.size(); ++i) {
            Rectangle rect = (Rectangle)this.list.get(i);
            if (!rect.contains(point)) continue;
            this.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_13"));
            return;
        }
        this.setToolTipText("");
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.list = new ArrayList();
        Graphics2D g2D = (Graphics2D)g;
        this.setBackground(this.info.bgColor);
        this.fontM = g2D.getFontMetrics();
        this.drawOrgUnit(g2D);
        this.drawJoinLine(g2D);
        this.drawLinkLine(g2D);
    }

    private void drawLinkLine(Graphics2D g2D) {
        g2D.setStroke(new BasicStroke(1.0f));
        g2D.setColor(Color.RED);
        g2D.drawLine(300, 100, 300, 80);
        g2D.drawLine(300, 80, 500, 80);
        this.temp = STR_1 + this.convertValueToHex(this.info.rectLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 350, 75);
        this.list.add(new Rectangle(350, 65, this.length, this.fontM.getHeight()));
        g2D.drawLine(260, 110, 80, 110);
        this.temp = STR_2 + this.convertValueToHex(this.info.orgRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 80, 105);
        this.list.add(new Rectangle(120, 95, this.length, this.fontM.getHeight()));
        g2D.drawLine(340, 140, 480, 140);
        this.temp = STR_3 + this.convertValueToHex(this.info.separateLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 360, 135);
        this.list.add(new Rectangle(360, 125, this.length, this.fontM.getHeight()));
        g2D.drawLine(80, 170, 260, 170);
        this.temp = STR_2 + this.convertValueToHex(this.info.otherRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 80, 165);
        this.list.add(new Rectangle(120, 155, this.length, this.fontM.getHeight()));
        g2D.drawLine(300, 210, 370, 210);
        g2D.drawLine(370, 210, 370, 190);
        g2D.drawLine(370, 190, 500, 190);
        this.temp = STR_4 + this.convertValueToHex(this.info.lineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 380, 185);
        this.list.add(new Rectangle(380, 175, this.length, this.fontM.getHeight()));
        g2D.drawLine(180, 240, 180, 220);
        g2D.drawLine(50, 220, 180, 220);
        this.temp = STR_1 + this.convertValueToHex(this.info.currRectLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 55, 215);
        this.list.add(new Rectangle(55, 205, this.length, this.fontM.getHeight()));
        g2D.drawLine(1, 250, 160, 250);
        this.temp = STR_2 + this.convertValueToHex(this.info.currOrgRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 2, 245);
        this.list.add(new Rectangle(30, 235, this.length, this.fontM.getHeight()));
        g2D.drawLine(1, 280, 155, 280);
        this.temp = STR_3 + this.convertValueToHex(this.info.currSeparateLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 2, 275);
        this.list.add(new Rectangle(20, 265, this.length, this.fontM.getHeight()));
        g2D.drawLine(1, 330, 160, 330);
        this.temp = STR_2 + this.convertValueToHex(this.info.currOtherRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 2, 325);
        this.list.add(new Rectangle(30, 315, this.length, this.fontM.getHeight()));
        g2D.drawLine(425, 220, 425, 240);
        g2D.drawLine(425, 220, 550, 220);
        this.temp = STR_1 + this.convertValueToHex(this.info.selRectLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 440, 215);
        this.list.add(new Rectangle(440, 205, this.length, this.fontM.getHeight()));
        g2D.drawLine(440, 250, 580, 250);
        this.temp = STR_2 + this.convertValueToHex(this.info.selOrgRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 452, 245);
        this.list.add(new Rectangle(470, 235, this.length, this.fontM.getHeight()));
        g2D.drawLine(440, 280, 595, 280);
        this.temp = STR_3 + this.convertValueToHex(this.info.selSeparateLineColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 452, 275);
        this.list.add(new Rectangle(470, 265, this.length, this.fontM.getHeight()));
        g2D.drawLine(440, 320, 580, 320);
        this.temp = STR_2 + this.convertValueToHex(this.info.selOtherRectColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 452, 315);
        this.list.add(new Rectangle(470, 305, this.length, this.fontM.getHeight()));
        g2D.drawLine(320, 30, 390, 30);
        this.temp = STR_5 + this.convertValueToHex(this.info.textColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 395, 35);
        this.list.add(new Rectangle(395, 25, this.length, this.fontM.getHeight()));
        g2D.drawLine(30, 30, 100, 30);
        this.temp = STR_2 + this.convertValueToHex(this.info.bgColor);
        this.length = this.fontM.stringWidth(this.temp);
        g2D.drawString(this.temp, 105, 35);
        this.list.add(new Rectangle(105, 25, this.length, this.fontM.getHeight()));
    }

    private String convertValueToHex(Color color) {
        String red = Integer.toHexString(color.getRed()).toUpperCase();
        String green = Integer.toHexString(color.getGreen()).toUpperCase();
        String blue = Integer.toHexString(color.getBlue()).toUpperCase();
        if (red.equals("0")) {
            red = "00";
        }
        if (green.equals("0")) {
            green = "00";
        }
        if (blue.equals("0")) {
            blue = "00";
        }
        return "#" + red + green + blue;
    }

    private void drawJoinLine(Graphics2D g2D) {
        g2D.setStroke(new BasicStroke(1.0f));
        g2D.setColor(this.info.lineColor);
        g2D.drawLine(300, 200, 300, 220);
        g2D.drawLine(200, 220, 400, 220);
        g2D.drawLine(200, 240, 200, 220);
        g2D.drawLine(400, 240, 400, 220);
    }

    private void drawOrgUnit(Graphics2D g2D) {
        g2D.setStroke(new BasicStroke(1.0f));
        Rectangle rect = new Rectangle(250, 100, 100, 100);
        g2D.setColor(this.info.orgRectColor);
        g2D.fillRoundRect(rect.x, rect.y, rect.width, rect.height - 2, 10, 10);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(ORG_NAME);
        g2D.drawString(ORG_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 15);
        g2D.setColor(this.info.otherRectColor);
        g2D.fillRoundRect(rect.x, rect.y + 20, rect.width, 80, 10, 10);
        g2D.fillRect(rect.x, rect.y + 20, rect.width, 20);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(POSITION_NAME);
        g2D.drawString(POSITION_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 35);
        g2D.setColor(this.info.separateLineColor);
        g2D.drawLine(rect.x, rect.y + 40, rect.x + rect.width, rect.y + 40);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(EMP_NAME);
        g2D.drawString(EMP_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 57);
        g2D.setColor(this.info.rectLineColor);
        g2D.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        rect = new Rectangle(150, 240, 100, 100);
        g2D.setColor(this.info.currOrgRectColor);
        g2D.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(ORG_NAME);
        g2D.drawString(ORG_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 15);
        g2D.setColor(this.info.currOtherRectColor);
        g2D.fillRoundRect(rect.x, rect.y + 20, rect.width, 80, 10, 10);
        g2D.fillRect(rect.x, rect.y + 20, rect.width, 20);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(POSITION_NAME);
        g2D.drawString(POSITION_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 35);
        g2D.setColor(this.info.currSeparateLineColor);
        g2D.drawLine(rect.x, rect.y + 40, rect.x + rect.width, rect.y + 40);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(EMP_NAME);
        g2D.drawString(EMP_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 57);
        g2D.setColor(this.info.currRectLineColor);
        g2D.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        rect = new Rectangle(350, 240, 100, 100);
        g2D.setColor(this.info.selOrgRectColor);
        g2D.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(ORG_NAME);
        g2D.drawString(ORG_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 15);
        g2D.setColor(this.info.selOtherRectColor);
        g2D.fillRoundRect(rect.x, rect.y + 20, rect.width, 80, 10, 10);
        g2D.fillRect(rect.x, rect.y + 20, rect.width, 20);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(POSITION_NAME);
        g2D.drawString(POSITION_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 35);
        g2D.setColor(this.info.selSeparateLineColor);
        g2D.drawLine(rect.x, rect.y + 40, rect.x + rect.width, rect.y + 40);
        g2D.setColor(this.info.textColor);
        this.length = this.fontM.stringWidth(EMP_NAME);
        g2D.drawString(EMP_NAME, rect.x + (rect.width - this.length) / 2, rect.y + 57);
        g2D.setColor(this.info.selRectLineColor);
        g2D.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 10, 10);
        g2D.setColor(Color.RED);
        g2D.drawLine(200, 340, 200, 360);
        g2D.drawString(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_15"), 130, 375);
        g2D.drawLine(280, 200, 280, 395);
        g2D.drawString(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_14"), 260, 410);
        g2D.drawLine(400, 340, 400, 360);
        g2D.drawString(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.CHART_SET_STR_16"), 380, 375);
    }
}

