/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.rec.InterviewEntryFactory;
import com.kingdee.eas.hr.rec.InterviewEntryInfo;
import com.kingdee.eas.hr.rec.InterviewResultEnum;
import com.kingdee.eas.hr.rec.client.AbstractBatchRecordUI;
import com.kingdee.eas.hr.rec.client.InterviewTaskPromptBox;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BatchRecordUI
extends AbstractBatchRecordUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchRecordUI.class);
    private Set set = new HashSet();
    private List oldTaskList = new ArrayList();
    private JButton btnAdd;
    private JButton btnRemove;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        if (count <= 0) {
            return;
        }
        ArrayList<InterviewEntryInfo> list = new ArrayList<InterviewEntryInfo>();
        this.oldTaskList.clear();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            InterviewEntryInfo info = new InterviewEntryInfo();
            Object obj = row.getCell("id").getValue();
            boolean flag = true;
            if (obj == null) continue;
            info.setId(BOSUuid.read((String)obj.toString()));
            obj = row.getCell("score").getValue();
            if (obj != null) {
                info.setScore(new BigDecimal(obj.toString()));
                flag = false;
            }
            if ((obj = row.getCell("comment").getValue()) != null) {
                info.setInterviewComent(obj.toString());
                flag = false;
            } else {
                info.setInterviewComent(null);
            }
            obj = row.getCell("description").getValue();
            if (obj != null) {
                info.setDescription(obj.toString());
            } else {
                info.setDescription(null);
            }
            obj = row.getCell("result").getValue();
            if (obj != null) {
                info.setInterviewResult((InterviewResultEnum)((Object)obj));
                flag = false;
            }
            if (flag) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"score_comment_result_can_not_all_null"));
                SysUtil.abort();
            }
            list.add(info);
            this.oldTaskList.add(info);
        }
        InterviewEntryFactory.getRemoteInstance().batchUpdate(list);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"save_success"));
        this.refreshOwner();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        if (count <= 0) {
            return;
        }
        HashMap<String, InterviewEntryInfo> map = new HashMap<String, InterviewEntryInfo>();
        boolean flag = true;
        this.oldTaskList.clear();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            InterviewEntryInfo info = new InterviewEntryInfo();
            Object obj = row.getCell("id").getValue();
            if (obj == null) continue;
            info.setId(BOSUuid.read((String)obj.toString()));
            obj = row.getCell("score").getValue();
            if (obj != null) {
                info.setScore(new BigDecimal(obj.toString()));
                flag = false;
            }
            if ((obj = row.getCell("comment").getValue()) != null) {
                info.setInterviewComent(obj.toString());
                flag = false;
            } else {
                info.setInterviewComent(null);
            }
            obj = row.getCell("description").getValue();
            if (obj != null) {
                info.setDescription(obj.toString());
            } else {
                info.setDescription(null);
            }
            obj = row.getCell("result").getValue();
            if (obj != null) {
                info.setInterviewResult((InterviewResultEnum)((Object)obj));
                flag = false;
            }
            if (flag) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"score_comment_result_can_not_all_null"));
                SysUtil.abort();
            }
            if ((obj = row.getCell("interviewId").getValue()) != null) {
                map.put(obj.toString(), info);
            }
            this.oldTaskList.add(info);
        }
        InterviewEntryFactory.getRemoteInstance().batchSubmit(map);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"submit_success"));
        this.btnSave.setEnabled(false);
        this.btnSubmit.setEnabled(false);
        this.refreshOwner();
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    private void init() {
        this.tblMain.checkParsed();
        KDBizPromptBox prmtName = new KDBizPromptBox();
        prmtName.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewTaskQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            try {
                filterInfo.mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
        }
        evi.setFilter(filterInfo);
        prmtName.setEntityViewInfo(evi);
        prmtName.setEnabledMultiSelection(false);
        prmtName.setSelectorCollection(RecUtils.getSic(new String[]{"*", "interview.id", "interview.resumeBase.id", "interview.resumeBase.name"}));
        prmtName.setEditable(false);
        RecUtils.setCellPrmtEditor(this.tblMain, "name", prmtName);
        RecUtils.setCellNumberEditor(this.tblMain, "score", 1, 2, 0, 1000000);
        RecUtils.setCellTextEditor(this.tblMain, "comment", 0, 1000);
        RecUtils.setCellTextEditor(this.tblMain, "description", 0, 1000);
        List list = InterviewResultEnum.getEnumList();
        RecUtils.setCellComboBoxEditor(this.tblMain, "result", list.toArray());
        this.btnAdd = this.contMain.add((Action)((Object)new AddRow()));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAdd.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewRecordResource", (String)"please_select_interviewTask"));
        this.btnRemove = this.contMain.add((Action)((Object)new RemoveRow()));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemove.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"delete_row"));
        List ids = (List)this.getUIContext().get("ids");
        List infoList = null;
        try {
            infoList = InterviewEntryFactory.getRemoteInstance().getBatchByIds(ids);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (infoList != null && infoList.size() > 0) {
            DecimalFormat df = new DecimalFormat("0.##");
            int j = ids.size();
            for (int i = 0; i < j; ++i) {
                InterviewResultEnum rEnum;
                InterviewEntryInfo info = (InterviewEntryInfo)infoList.get(i);
                if (info.isIsRecorded()) continue;
                IRow row = this.tblMain.addRow();
                row.getCell("name").setValue((Object)info.getInterview().getResumeBase().getName());
                row.getCell("id").setValue((Object)info.getId().toString());
                row.getCell("interviewId").setValue((Object)info.getInterview().getId().toString());
                BigDecimal score = info.getScore();
                if (score != null) {
                    row.getCell("score").setValue((Object)df.format(score.doubleValue()));
                } else {
                    row.getCell("score").setValue((Object)"0.00");
                }
                if (info.getInterviewComent() != null) {
                    row.getCell("comment").setValue((Object)info.getInterviewComent());
                }
                if (info.getDescription() != null) {
                    row.getCell("description").setValue((Object)info.getDescription());
                }
                if ((rEnum = info.getInterviewResult()) != null) {
                    row.getCell("result").setValue((Object)rEnum);
                }
                this.set.add(info.getId().toString());
                this.oldTaskList.add(info);
            }
        }
        prmtName.addPreChangeListener((PreChangeListener)new PreChangeClass());
    }

    private boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (this.oldTaskList.size() != this.tblMain.getRowCount()) {
            return true;
        }
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            InterviewEntryInfo entryInfo;
            Object value = this.tblMain.getCell(i, "id").getValue().toString();
            if (!value.equals((entryInfo = (InterviewEntryInfo)this.oldTaskList.get(i)).getId().toString())) {
                return true;
            }
            value = this.tblMain.getCell(i, "score").getValue();
            if (value == null && entryInfo.getScore() != null) {
                return true;
            }
            if (value != null && entryInfo.getScore() == null) {
                return true;
            }
            if (value != null && entryInfo.getScore() != null && !entryInfo.getScore().equals(new BigDecimal(value.toString()))) {
                return true;
            }
            value = this.tblMain.getCell(i, "comment").getValue();
            if (value != null && entryInfo.getInterviewComent() == null) {
                return true;
            }
            if (value == null && entryInfo.getInterviewComent() != null) {
                return true;
            }
            if (value != null && entryInfo.getInterviewComent() != null && !value.equals(entryInfo.getInterviewComent())) {
                return true;
            }
            value = this.tblMain.getCell(i, "result").getValue();
            if (value != null && entryInfo.getInterviewResult() == null) {
                return true;
            }
            if (value == null && entryInfo.getInterviewResult() != null) {
                return true;
            }
            if (value != null && entryInfo.getInterviewResult() != null && !value.equals((Object)entryInfo.getInterviewResult())) {
                return true;
            }
            value = this.tblMain.getCell(i, "description").getValue();
            if (value == null && entryInfo.getDescription() != null) {
                return true;
            }
            if (value != null && entryInfo.getDescription() == null) {
                return true;
            }
            if (value == null || entryInfo.getDescription() == null || value.equals(entryInfo.getDescription())) continue;
            return true;
        }
        return false;
    }

    private void refreshOwner() {
        ListUI ui = (ListUI)this.getUIContext().get("Owner");
        try {
            ui.actionRefresh_actionPerformed(null);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private class RemoveRow
    extends ItemAction {
        private RemoveRow() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (BatchRecordUI.this.tblMain.getSelectManager().size() == 0 || RecUtils.isTableColumnSelected(BatchRecordUI.this.tblMain)) {
                return;
            }
            int[] selectRowsIndex = KDTableUtil.getSelectedRows((KDTable)BatchRecordUI.this.tblMain);
            if (selectRowsIndex.length > 0) {
                int[] selectedColumnIndexs = TrainHelper.getSelectedColumns((KDTable)BatchRecordUI.this.tblMain);
                Arrays.sort(selectRowsIndex);
                for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                    IRow row = BatchRecordUI.this.tblMain.getRow(selectRowsIndex[i]);
                    Object id = row.getCell("id").getValue();
                    if (id != null) {
                        BatchRecordUI.this.set.remove(id.toString());
                    }
                    BatchRecordUI.this.tblMain.removeRow(selectRowsIndex[i]);
                }
                if (BatchRecordUI.this.tblMain.getRowCount() > 0) {
                    Arrays.sort(selectedColumnIndexs);
                    int columnIndex = 0;
                    if (selectedColumnIndexs.length > 0) {
                        columnIndex = selectedColumnIndexs[0];
                    }
                    BatchRecordUI.this.tblMain.getSelectManager().select(selectRowsIndex[0], columnIndex);
                }
            }
        }
    }

    private class AddRow
    extends ItemAction {
        public AddRow() {
            this(null);
        }

        public AddRow(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift p"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent arg0) {
            InterviewTaskPromptBox dlg = new InterviewTaskPromptBox((IUIObject)BatchRecordUI.this);
            dlg.setMultiSelect(true);
            dlg.show();
            if (dlg.isCanceled()) {
                return;
            }
            Object[] obj = (Object[])dlg.getData();
            if (obj != null && obj.length > 0) {
                DecimalFormat df = new DecimalFormat("0.##");
                for (int i = 0; i < obj.length; ++i) {
                    InterviewEntryInfo info = (InterviewEntryInfo)obj[i];
                    if (BatchRecordUI.this.set.contains(info.getId().toString())) continue;
                    IRow row = BatchRecordUI.this.tblMain.addRow();
                    BatchRecordUI.this.set.add(info.getId().toString());
                    row.getCell("name").setValue((Object)info.getInterview().getResumeBase().getName());
                    BigDecimal score = info.getScore();
                    if (score != null) {
                        row.getCell("score").setValue((Object)df.format(score.doubleValue()));
                    } else {
                        row.getCell("score").setValue((Object)"0.00");
                    }
                    row.getCell("comment").setValue((Object)info.getInterviewComent());
                    row.getCell("id").setValue((Object)info.getId().toString());
                    row.getCell("result").setValue((Object)info.getInterviewResult());
                    row.getCell("description").setValue((Object)info.getDescription());
                    row.getCell("interviewId").setValue((Object)info.getInterview().getId().toString());
                }
            }
        }
    }

    private class PreChangeClass
    implements PreChangeListener {
        private PreChangeClass() {
        }

        public void preChange(PreChangeEvent event) {
            InterviewEntryInfo info = (InterviewEntryInfo)event.getData();
            if (!BatchRecordUI.this.set.contains(info.getId().toString())) {
                event.setData((Object)info.getInterview().getResumeBase().getName());
                int[] rows = KDTableUtil.getSelectedRows((KDTable)BatchRecordUI.this.tblMain);
                if (rows != null && rows.length > 0) {
                    IRow row = BatchRecordUI.this.tblMain.getRow(rows[0]);
                    row.getCell("score").setValue((Object)info.getScore());
                    row.getCell("description").setValue((Object)info.getDescription());
                    row.getCell("comment").setValue((Object)info.getInterviewComent());
                    row.getCell("result").setValue((Object)info.getInterviewResult());
                    row.getCell("id").setValue((Object)info.getId().toString());
                    row.getCell("interviewId").setValue((Object)info.getInterview().getId().toString());
                }
            } else {
                event.setData(null);
            }
        }
    }
}

