/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.rec.BlacklistExtendFactory;
import com.kingdee.eas.hr.rec.IBlacklistExtend;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.client.AbstractBlacklistExtendListUI;
import com.kingdee.eas.hr.rec.client.ResumeExtendEditUI;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BlacklistExtendListUI
extends AbstractBlacklistExtendListUI {
    private static final Logger logger = CoreUIObject.getLogger(BlacklistExtendListUI.class);
    private static final String blacklistRES = "com.kingdee.eas.hr.rec.BlacklistResource";

    public void onLoad() throws Exception {
        RecUtils.checkValidPerson((CoreUI)this);
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                BlacklistExtendListUI.this.setButtonStatus(e);
            }
        });
        this.setButtonStatus(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.btnDelete.setEnabled(true);
        this.btnPersonInfo.setEnabled(true);
        this.btnResume.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnPersonInfo.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
        this.menuResume.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuPersonInfo.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuRemoveBlacklist.setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
    }

    private void setButtonStatus(KDTSelectEvent e) {
        IRow row = null;
        this.actionResume.setEnabled(true);
        this.actionDeleteBlacklist.setEnabled(true);
        this.actionPersonInfo.setEnabled(true);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int j = rows.length - 1; j >= 0; --j) {
            row = this.tblMain.getRow(rows[j]);
            if (row == null || row.getCell("isInsider") == null || row.getCell("isInsider").getValue() == null) continue;
            Boolean isInsider = (Boolean)row.getCell("isInsider").getValue();
            if (isInsider.booleanValue()) {
                this.actionResume.setEnabled(false);
                this.menuResume.setEnabled(false);
                continue;
            }
            this.actionPersonInfo.setEnabled(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BlacklistExtendFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ResumeExtendEditUI.class.getName();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (this.isPerformDefaultQuery(iQuery, queryName = BlacklistExtendListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (defaultView == null) {
                defaultView = new EntityViewInfo();
            }
            this.mainQuery.getSorter().clear();
            this.mainQuery = this.getEntityViewInfo(defaultView);
        } else {
            super.actionQuery_actionPerformed(e);
        }
    }

    public void actionDeleteBlacklist_actionPerformed(ActionEvent e) throws Exception {
        int state = MsgBox.showConfirm2((String)EASResource.getString((String)blacklistRES, (String)"confirm_delete"));
        if (state == 0) {
            List resumeIds = this.getSelectedResumeBaseIds();
            List ids = this.getSelectedIds();
            IResumeBase resumeBase = ResumeBaseFactory.getRemoteInstance();
            IBlacklistExtend blacklistExtend = BlacklistExtendFactory.getRemoteInstance();
            for (int i = 0; i < resumeIds.size(); ++i) {
                blacklistExtend.delete((IObjectPK)new ObjectUuidPK((String)ids.get(i)));
                resumeBase.delete((IObjectPK)new ObjectUuidPK((String)resumeIds.get(i)));
            }
        }
        super.actionRefresh_actionPerformed(e);
    }

    private List getSelectedResumeBaseIds() {
        return this.getSelectedValues("resumeBase.id");
    }

    private List getSelectedIds() {
        return this.getSelectedValues("id");
    }

    private List getSelectedValues(String cellName) {
        this.checkSelected();
        ArrayList<Object> ids = new ArrayList<Object>();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        int num = 0;
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            num = sb.getBottom();
            for (int j = sb.getTop(); j <= num; ++j) {
                row = this.tblMain.getRow(j);
                ids.add(row.getCell(cellName).getValue());
            }
        }
        return ids;
    }

    public void actionPersonInfo_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() < 1) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        Boolean isInsider = (Boolean)this.tblMain.getCell(this.tblMain.getSelectManager().get(0).getBeginRow(), "isInsider").getValue();
        if (isInsider.booleanValue()) {
            String personid = (String)this.tblMain.getCell(this.tblMain.getSelectManager().get(0).getBeginRow(), "personID").getValue();
            RealModeIDList idList = new RealModeIDList();
            idList.add(personid);
            uiContext.put((Object)"IDList", (Object)idList);
            uiContext.put((Object)"ID", (Object)personid);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeTreeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)blacklistRES, (String)"outerPerson"));
        }
    }

    public void actionResume_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.tblMain.getSelectManager().size() < 1) {
            return;
        }
        Boolean isInsider = (Boolean)this.tblMain.getCell(this.tblMain.getSelectManager().get(0).getBeginRow(), "isInsider").getValue();
        if (!isInsider.booleanValue()) {
            String resumeBaseID = (String)this.tblMain.getCell(this.tblMain.getSelectManager().get(0).getBeginRow(), "resumeBase.id").getValue();
            uiContext.put((Object)"resID", (Object)resumeBaseID);
            uiContext.put((Object)"ID", (Object)resumeBaseID);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResumeExtendEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)blacklistRES, (String)"innerPerson"));
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"resID", this.getUIContext().get("ID"));
        super.prepareUIContext(uiContext, e);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int rowcount = this.tblMain.getRowCount();
        IPerson personFactory = null;
        try {
            personFactory = PersonFactory.getRemoteInstance();
            PersonInfo personInfo = null;
            for (int i = 0; i < rowcount; ++i) {
                String oql;
                PersonCollection personCollection;
                IRow row = this.tblMain.getRow(i);
                Boolean isInsider = (Boolean)row.getCell("isInsider").getValue();
                if (!isInsider.booleanValue() || (personCollection = personFactory.getPersonCollection(oql = "select * where id='" + row.getCell("personID").getValue().toString() + "'")) == null || personCollection.size() <= 0) continue;
                personInfo = personCollection.get(0);
                row.getCell("resumeBase.idCardNO").setValue((Object)personInfo.getIdCardNO());
                row.getCell("resumeBase.passportNO").setValue((Object)personInfo.getPassportNO());
                row.getCell("resumeBase.name").setValue((Object)personInfo.getName());
                if (personInfo.getHighestDegree() != null) {
                    row.getCell("Diploma.name").setValue((Object)personInfo.getHighestDegree().toString());
                }
                if (personInfo.getBirthday() == null) continue;
                row.getCell("resumeBase.age").setValue((Object)("" + RecServerUtils.subTwoDate(new Date(System.currentTimeMillis()), personInfo.getBirthday())));
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        super.afterTableFillData(e);
    }
}

