/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ICity;
import com.kingdee.eas.basedata.assistant.IProvince;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ILangGrade;
import com.kingdee.eas.hr.base.LangGradeCollection;
import com.kingdee.eas.hr.base.LangGradeFactory;
import com.kingdee.eas.hr.base.LangGradeInfo;
import com.kingdee.eas.hr.base.SpecialtyTypeCollection;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.SpecialtyTypeInfo;
import com.kingdee.eas.hr.rec.CertificateInfo;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.IImportByAccessFacade;
import com.kingdee.eas.hr.rec.ImportByAccessFacadeFactory;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.SkillInfo;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.TrainExpInfo;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.client.AccessField;
import com.kingdee.eas.hr.rec.client.AccessInfoParamName;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;

public class DealWithAccessField {
    private static int diplomaMin = 2;
    private static int diplomaMax = 0;
    private static int gradeMin = 2;
    private static int gradeMax = 0;

    public static List splitEduExp(String eduExp) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        if (eduExp == null || eduExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)eduExp, (String)"********************");
        DealWithAccessField.setDiplomaLength();
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\n\r");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                info.add(date[m]);
                            }
                            continue;
                        }
                        info.add(temp[j]);
                    }
                    continue;
                }
                if (k == 1) {
                    DealWithAccessField.checkDiplomaExist(splits[k], info);
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    private static void setDiplomaLength() throws BOSException {
        IDiploma diploma = DiplomaFactory.getRemoteInstance();
        DiplomaCollection diplomaColl = diploma.getDiplomaCollection();
        for (int i = 0; i < diplomaColl.size(); ++i) {
            int length = diplomaColl.get(i).getName().trim().length();
            if (diplomaMin > length) {
                diplomaMin = length;
            }
            if (diplomaMax >= length) continue;
            diplomaMax = length;
        }
        if (diplomaMin < 2) {
            diplomaMin = 2;
        }
    }

    private static void setGradeLength() throws BOSException {
        ILangGrade grade = LangGradeFactory.getRemoteInstance();
        LangGradeCollection gradeColl = grade.getLangGradeCollection();
        for (int i = 0; i < gradeColl.size(); ++i) {
            int length = gradeColl.get(i).getName().trim().length();
            if (gradeMin > length) {
                gradeMin = length;
            }
            if (gradeMax >= length) continue;
            gradeMax = length;
        }
        if (gradeMin < 2) {
            gradeMin = 2;
        }
    }

    private static boolean isSimilar(String toSplit, String haved) {
        if (StringUtils.isEmpty((String)toSplit) || StringUtils.isEmpty((String)haved)) {
            return true;
        }
        int index = haved.indexOf(toSplit.substring(0, 1));
        if (index < 0) {
            return false;
        }
        return DealWithAccessField.isSimilar(toSplit.substring(1), haved.substring(index));
    }

    private static void checkDiplomaExist(String sp, List info) throws EASBizException, BOSException {
        IDiploma diploma = DiplomaFactory.getRemoteInstance();
        DiplomaCollection diplomaColl = diploma.getDiplomaCollection();
        DiplomaInfo diplomaInfo = null;
        if (sp.length() <= diplomaMin) {
            throw new ImportDataException(ImportDataException.SPECIALTY_DIPLOMA_ERROR);
        }
        int len = sp.length();
        boolean isHave = false;
        String temp = null;
        String diplomaName = null;
        int count = diplomaMax < len ? diplomaMax : len;
        for (int i = diplomaMin; i <= count; ++i) {
            for (int j = 0; j < diplomaColl.size(); ++j) {
                diplomaInfo = diplomaColl.get(j);
                temp = sp.substring(len - i);
                diplomaName = diplomaInfo.getName();
                if (diplomaName.indexOf(temp) >= 0) {
                    info.add(sp.substring(0, len - i));
                    info.add(diplomaInfo);
                    isHave = true;
                    break;
                }
                if (!DealWithAccessField.isSimilar(temp, diplomaName)) continue;
                info.add(sp.substring(0, len - i));
                info.add(diplomaInfo);
                isHave = true;
                break;
            }
            if (isHave) break;
        }
        if (!isHave) {
            info.add(sp);
        }
    }

    private static void checkGradeExist(String sp, List info) throws EASBizException, BOSException {
        ILangGrade grade = LangGradeFactory.getRemoteInstance();
        LangGradeCollection gradeColl = grade.getLangGradeCollection();
        LangGradeInfo gradeInfo = null;
        if (sp.length() <= gradeMin) {
            throw new ImportDataException(ImportDataException.SKILL_GRADE_ERROR);
        }
        int len = sp.length();
        boolean isHave = false;
        String temp = null;
        String gradeName = null;
        int count = gradeMax < len ? gradeMax : len;
        for (int i = gradeMin; i <= count; ++i) {
            for (int j = 0; j < gradeColl.size(); ++j) {
                gradeInfo = gradeColl.get(j);
                temp = sp.substring(len - i);
                gradeName = gradeInfo.getName();
                if (gradeName.indexOf(temp) >= 0) {
                    info.add(sp.substring(0, len - i));
                    info.add(gradeInfo);
                    isHave = true;
                    break;
                }
                if (!DealWithAccessField.isSimilar(temp, gradeName)) continue;
                info.add(sp.substring(0, len - i));
                info.add(gradeInfo);
                isHave = true;
                break;
            }
            if (isHave) break;
        }
        if (!isHave) {
            info.add(sp);
        }
    }

    public static List splitWorkExp(String workExp) {
        String REPORTOBJECT = AccessField.getReportObjet();
        String PERSONLEADED = AccessField.getPersonLeaded();
        String REASONTOLEAVE = AccessField.getReasonToLeave();
        String ATTESTOR = AccessField.getAttestor();
        String OUTSTANDINGACHIEVEMENT = AccessField.getOutstandingArchievement();
        ArrayList result = new ArrayList();
        if (workExp == null || workExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)workExp, (String)"********************");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            HashMap<AccessInfoParamName, String> info = new HashMap<AccessInfoParamName, String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\n\r");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                if (m == 0) {
                                    info.put(AccessInfoParamName.DATESTART, date[m]);
                                    continue;
                                }
                                info.put(AccessInfoParamName.DATEEND, date[m]);
                            }
                            continue;
                        }
                        info.put(AccessInfoParamName.COMPANY, temp[j]);
                    }
                    continue;
                }
                if (k == 1) {
                    info.put(AccessInfoParamName.POSITIONNAME, splits[k]);
                    continue;
                }
                if (k == 2) {
                    info.put(AccessInfoParamName.POSITIONDISCRIPTION, splits[k]);
                    continue;
                }
                if (k <= 2) continue;
                if (splits[k].lastIndexOf(REPORTOBJECT) >= 0) {
                    info.put(AccessInfoParamName.REPORTOBJECT, splits[k].substring(splits[k].lastIndexOf(REPORTOBJECT) + REPORTOBJECT.length()));
                }
                if (splits[k].lastIndexOf(PERSONLEADED) >= 0) {
                    info.put(AccessInfoParamName.PERSONLEADED, splits[k].substring(splits[k].lastIndexOf(PERSONLEADED) + PERSONLEADED.length()));
                }
                if (splits[k].lastIndexOf(REASONTOLEAVE) >= 0) {
                    info.put(AccessInfoParamName.REASONTOLEAVE, splits[k].substring(splits[k].lastIndexOf(REASONTOLEAVE) + REASONTOLEAVE.length()));
                }
                if (splits[k].lastIndexOf(ATTESTOR) >= 0) {
                    info.put(AccessInfoParamName.ATTESTOR, splits[k].substring(splits[k].lastIndexOf(ATTESTOR) + ATTESTOR.length()));
                }
                if (splits[k].lastIndexOf(OUTSTANDINGACHIEVEMENT) < 0) continue;
                info.put(AccessInfoParamName.OUTSTANDINGACHIEVEMENT, splits[k].substring(splits[k].lastIndexOf(OUTSTANDINGACHIEVEMENT) + OUTSTANDINGACHIEVEMENT.length()));
            }
            result.add(info);
        }
        return result;
    }

    public static List splitTrainExp(String trainExp) {
        ArrayList result = new ArrayList();
        if (trainExp == null || trainExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)trainExp, (String)"********************");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\n\r");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                info.add(date[m]);
                            }
                            continue;
                        }
                        info.add(temp[j]);
                    }
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    public static List splitCertificate(String certificate) {
        ArrayList result = new ArrayList();
        if (certificate == null || certificate.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)certificate, (String)"\n\r");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)":");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        info.add(temp[j]);
                    }
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    public static List splitLanguage(String language) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        if (language == null || language.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)language, (String)"/");
        DealWithAccessField.setGradeLength();
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList info = new ArrayList();
            DealWithAccessField.checkGradeExist(infos[i], info);
            result.add(info);
        }
        return result;
    }

    public static List splitSkill(String skill) throws BOSException {
        ArrayList result = new ArrayList();
        if (skill == null || skill.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)skill, (String)"\n\r");
        String separate = "-";
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            int split = infos[i].lastIndexOf(separate);
            if (split < 0) continue;
            ArrayList<String> info = new ArrayList<String>();
            info.add(infos[i].substring(0, split));
            info.add((String)DealWithAccessField.getLGInfo(infos[i].substring(split += separate.length())));
            result.add(info);
        }
        return result;
    }

    public static List splitJobs(String jobs) {
        ArrayList<String> result = new ArrayList<String>();
        if (jobs == null || jobs.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)jobs, (String)",");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            result.add(infos[i]);
        }
        return result;
    }

    public static ResumeBaseInfo formResumeBaseInfo(Map resumeBaseMap, boolean isOvercast) throws Exception {
        ResumeBaseInfo info = new ResumeBaseInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (resumeBaseMap == null || !(resumeBaseMap instanceof HashMap)) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_MAP_NULL);
        }
        if (RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.NAME))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_NAME_NULL);
        }
        info.setName((String)resumeBaseMap.get(AccessInfoParamName.NAME));
        if (RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.SEX))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_SEX_NULL);
        }
        if (((String)resumeBaseMap.get(AccessInfoParamName.SEX)).equals(Genders.getEnum((String)"Male").toString())) {
            info.setGender(Genders.getEnum((String)"Male"));
        } else if (((String)resumeBaseMap.get(AccessInfoParamName.SEX)).equals(Genders.getEnum((String)"Female").toString())) {
            info.setGender(Genders.getEnum((String)"Female"));
        } else {
            throw new ImportDataException(ImportDataException.RESUMEBASE_SEX_INVALID);
        }
        if (RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.BIRTHDAY))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_BIRTHDAY_NULL);
        }
        Date birth = format.parse((String)resumeBaseMap.get(AccessInfoParamName.BIRTHDAY));
        info.setBirthday(birth);
        info.setAge(DealWithAccessField.getAgeByDate(birth));
        if (RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.NESTEDPLACE))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_NESTEDPLACE_NULL);
        }
        Object[] obj = DealWithAccessField.getProvinceCity((String)resumeBaseMap.get(AccessInfoParamName.NESTEDPLACE));
        info.setCity((CityInfo)obj[1]);
        info.setProvince((ProvinceInfo)obj[0]);
        if (RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.WORKYEARS))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_WORKYEARS_NULL);
        }
        info.setWorkYears(Integer.valueOf((String)resumeBaseMap.get(AccessInfoParamName.WORKYEARS)));
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.HUKOU))) {
            info.setNativePlace((String)resumeBaseMap.get(AccessInfoParamName.HUKOU));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.ADDRESS))) {
            info.setAddressTX((String)resumeBaseMap.get(AccessInfoParamName.ADDRESS));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.EMAIL))) {
            info.setEmail((String)resumeBaseMap.get(AccessInfoParamName.EMAIL));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.TEL_HOME))) {
            info.setHomePhone((String)resumeBaseMap.get(AccessInfoParamName.TEL_HOME));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.TEL_COM))) {
            info.setOfficePhone((String)resumeBaseMap.get(AccessInfoParamName.TEL_COM));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.TEL_MOBILE))) {
            info.setCell((String)resumeBaseMap.get(AccessInfoParamName.TEL_MOBILE));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.WORKEXPECTED))) {
            info.setWorkAspect((String)resumeBaseMap.get(AccessInfoParamName.WORKEXPECTED));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.JOB1))) {
            info.setJob_1((String)resumeBaseMap.get(AccessInfoParamName.JOB1));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.JOB2))) {
            info.setJob_2((String)resumeBaseMap.get(AccessInfoParamName.JOB2));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.JOB3))) {
            info.setJob_3((String)resumeBaseMap.get(AccessInfoParamName.JOB3));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.SALARYEXPECTED))) {
            info.setSalaryReq((String)resumeBaseMap.get(AccessInfoParamName.SALARYEXPECTED));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get(AccessInfoParamName.EVALUATE))) {
            info.setEvaluate((String)resumeBaseMap.get(AccessInfoParamName.EVALUATE));
        }
        if (!isOvercast) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        info.setYingPDate(new Date(System.currentTimeMillis()));
        info.setHrOrgUnit(RecUtils.getCurrentHROrgUnit());
        return info;
    }

    private static int getAgeByDate(Date birth) {
        int age = 0;
        int birthYear = 0;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(birth);
        birthYear = calendar.get(1);
        Date now = new Date();
        calendar.setTime(now);
        age = calendar.get(1) - birthYear;
        return age;
    }

    private static Object[] getProvinceCity(String place) throws BOSException {
        int i;
        String provinceKey = AccessField.getProvince();
        String cityKey = AccessField.getCity();
        String provinceName = null;
        String cityName = null;
        CityInfo cityInfo = null;
        ProvinceInfo provinceInfo = null;
        int provinceIndex = 0;
        int cityIndex = 0;
        Object[] obj = new Object[2];
        provinceIndex = place.indexOf(provinceKey);
        cityIndex = place.indexOf(cityKey);
        if (provinceIndex >= 0 && cityIndex == -1) {
            provinceName = place.substring(0, provinceIndex);
        } else if (provinceIndex >= 0 && cityIndex >= 0) {
            int cityLength = cityIndex + cityKey.length();
            int provinceLen = provinceIndex + provinceKey.length();
            if (provinceIndex > cityIndex) {
                provinceName = place.substring(cityLength, provinceIndex);
                cityName = place.substring(0, cityIndex);
            } else {
                cityName = place.substring(provinceLen, cityIndex);
                provinceName = place.substring(0, provinceIndex);
            }
        } else if (provinceIndex == -1 && cityIndex >= 0) {
            cityName = place.substring(0, cityIndex);
        }
        if (provinceName != null) {
            IProvince province = ProvinceFactory.getRemoteInstance();
            ProvinceCollection pcol = province.getProvinceCollection();
            for (i = 0; i < pcol.size(); ++i) {
                if (!pcol.get(i).getName().equals(provinceName)) continue;
                provinceInfo = pcol.get(i);
                break;
            }
        }
        if (cityName != null) {
            ICity city = CityFactory.getRemoteInstance();
            CityCollection ccol = city.getCityCollection();
            for (i = 0; i < ccol.size(); ++i) {
                if (!ccol.get(i).getName().equals(cityName)) continue;
                cityInfo = ccol.get(i);
                provinceInfo = cityInfo.getProvince();
                break;
            }
        }
        obj[0] = provinceInfo;
        obj[1] = cityInfo;
        return obj;
    }

    public static boolean isEnqualsNow(String date) {
        return date.equals(AccessField.getToNow()) || date.equals(AccessField.getNow());
    }

    public static WorkExpInfo formWorkExp(Map workExp, ResumeBaseInfo resumeBase) throws Exception {
        WorkExpInfo info = new WorkExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (workExp == null || !(workExp instanceof HashMap)) {
            throw new ImportDataException(ImportDataException.WORKEXP_MAP_NULL);
        }
        if (RecUtils.objectIsNull(workExp.get(AccessInfoParamName.DATESTART))) {
            throw new ImportDataException(ImportDataException.WORKEXP_DATESTART_NULL);
        }
        info.setStartDate(format.parse((String)workExp.get(AccessInfoParamName.DATESTART)));
        if (RecUtils.objectIsNull(workExp.get(AccessInfoParamName.DATEEND))) {
            throw new ImportDataException(ImportDataException.WORKEXP_DATEEND_NULL);
        }
        if (DealWithAccessField.isEnqualsNow((String)workExp.get(AccessInfoParamName.DATEEND))) {
            info.setEndDate(new Date(System.currentTimeMillis()));
        } else {
            info.setEndDate(format.parse((String)workExp.get(AccessInfoParamName.DATEEND)));
        }
        if (RecUtils.objectIsNull(workExp.get(AccessInfoParamName.COMPANY))) {
            throw new ImportDataException(ImportDataException.WORKEXP_COMPANY_NULL);
        }
        info.setOrgan((String)workExp.get(AccessInfoParamName.COMPANY));
        if (RecUtils.objectIsNull(workExp.get(AccessInfoParamName.POSITIONNAME))) {
            throw new ImportDataException(ImportDataException.WORKEXP_POSITIONNAME_NULL);
        }
        info.setPosition((String)workExp.get(AccessInfoParamName.POSITIONNAME));
        if (RecUtils.objectIsNull(workExp.get(AccessInfoParamName.POSITIONDISCRIPTION))) {
            throw new ImportDataException(ImportDataException.WORKEXP_POSITIONDISCRIPTION_NULL);
        }
        info.setDuty((String)workExp.get(AccessInfoParamName.POSITIONDISCRIPTION));
        if (!RecUtils.objectIsNull(workExp.get(AccessInfoParamName.PERSONLEADED))) {
            info.setUnderNum(Integer.valueOf((String)workExp.get(AccessInfoParamName.PERSONLEADED)));
        }
        if (!RecUtils.objectIsNull(workExp.get(AccessInfoParamName.ATTESTOR))) {
            info.setLinkman((String)workExp.get(AccessInfoParamName.ATTESTOR));
        }
        if (!RecUtils.objectIsNull(workExp.get(AccessInfoParamName.REASONTOLEAVE))) {
            info.setDimissionReson((String)workExp.get(AccessInfoParamName.REASONTOLEAVE));
        }
        if (!RecUtils.objectIsNull(workExp.get(AccessInfoParamName.OUTSTANDINGACHIEVEMENT))) {
            info.setRemark((String)workExp.get(AccessInfoParamName.OUTSTANDINGACHIEVEMENT));
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static EducationExpInfo formEducationExp(List eduExp, ResumeBaseInfo resumeBase) throws Exception {
        EducationExpInfo info = new EducationExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (eduExp == null || !(eduExp instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.EDUEXP_LIST_NULL);
        }
        block7: for (int i = 0; i < eduExp.size(); ++i) {
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_DATESTART_NULL);
                    }
                    info.setStartDate(format.parse((String)eduExp.get(i)));
                    continue block7;
                }
                case 1: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_DATEEND_NULL);
                    }
                    if (DealWithAccessField.isEnqualsNow((String)eduExp.get(i))) {
                        info.setEndDate(new Date(System.currentTimeMillis()));
                        continue block7;
                    }
                    info.setEndDate(format.parse((String)eduExp.get(i)));
                    continue block7;
                }
                case 2: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_SCHOOL_NULL);
                    }
                    info.setSchool((String)eduExp.get(i));
                    continue block7;
                }
                case 3: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_SPECIALTY_NULL);
                    }
                    info.setSpecialty((String)eduExp.get(i));
                    continue block7;
                }
                case 4: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_DIPLOMA_NULL);
                    }
                    info.setDiploma((DiplomaInfo)eduExp.get(i));
                    continue block7;
                }
            }
        }
        SpecialtyTypeCollection stCol = SpecialtyTypeFactory.getRemoteInstance().getSpecialtyTypeCollection();
        SpecialtyTypeInfo stInfo = null;
        for (int i = 0; i < stCol.size(); ++i) {
            if (!stCol.get(i).getName().equals(AccessField.getUnknown())) continue;
            stInfo = stCol.get(i);
            break;
        }
        info.setSpecialtyType(stInfo);
        info.setResumeBase(resumeBase);
        return info;
    }

    public static TrainExpInfo formTrainExp(List trainExp, ResumeBaseInfo resumeBase) throws Exception {
        TrainExpInfo info = new TrainExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (trainExp == null || !(trainExp instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.TRAINEXP_LIST_NULL);
        }
        block7: for (int i = 0; i < trainExp.size(); ++i) {
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) {
                        throw new ImportDataException(ImportDataException.TRAINEXP_DATESTART_NULL);
                    }
                    info.setStartDate(format.parse((String)trainExp.get(i)));
                    continue block7;
                }
                case 1: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) {
                        throw new ImportDataException(ImportDataException.TRAINEXP_DATEEND_NULL);
                    }
                    if (DealWithAccessField.isEnqualsNow((String)trainExp.get(i))) {
                        info.setEndDate(new Date(System.currentTimeMillis()));
                        continue block7;
                    }
                    info.setEndDate(format.parse((String)trainExp.get(i)));
                    continue block7;
                }
                case 2: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) {
                        throw new ImportDataException(ImportDataException.TRAINEXP_ORG_NULL);
                    }
                    info.setTrainOrg((String)trainExp.get(i));
                    continue block7;
                }
                case 3: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) {
                        throw new ImportDataException(ImportDataException.TRAINEXP_COURCE_NULL);
                    }
                    info.setTrainItem((String)trainExp.get(i));
                    continue block7;
                }
                case 4: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) continue block7;
                    info.setTrainContent((String)trainExp.get(i));
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static SkillInfo formSkillInfo(List skill, ResumeBaseInfo resumeBase) throws Exception {
        SkillInfo info = new SkillInfo();
        if (skill == null || !(skill instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.SKILL_LIST_NULL);
        }
        block4: for (int i = 0; i < skill.size(); ++i) {
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(skill.get(i))) {
                        throw new ImportDataException(ImportDataException.SKILL_NAME_NULL);
                    }
                    info.setName((String)skill.get(i));
                    continue block4;
                }
                case 1: {
                    if (RecUtils.objectIsNull(skill.get(i))) {
                        throw new ImportDataException(ImportDataException.SKILL_LG_NULL);
                    }
                    info.setLangGrade((LangGradeInfo)skill.get(i));
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    private static LangGradeInfo getLGInfo(String name) throws BOSException {
        LangGradeInfo info = null;
        LangGradeCollection lgCol = LangGradeFactory.getRemoteInstance().getLangGradeCollection();
        for (int i = 0; i < lgCol.size() && !(info = lgCol.get(i)).getName().equals(name); ++i) {
        }
        return info;
    }

    public static CertificateInfo formCertificateInfo(List cer, ResumeBaseInfo resumeBase) throws Exception {
        CertificateInfo info = new CertificateInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (cer == null || !(cer instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.CERTIFICATE_LIST_NULL);
        }
        block4: for (int i = 0; i < cer.size(); ++i) {
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(cer.get(i))) {
                        throw new ImportDataException(ImportDataException.CERTIFICATE_DATE_NULL);
                    }
                    info.setCertifyDate(format.parse((String)cer.get(i)));
                    continue block4;
                }
                case 1: {
                    if (RecUtils.objectIsNull(cer.get(i))) {
                        throw new ImportDataException(ImportDataException.CERTIFICATE_NAME_NULL);
                    }
                    info.setName((String)cer.get(i));
                    continue block4;
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static String workYearsTrans(String workyears) {
        String result = null;
        if (!StringUtils.isEmpty((String)workyears)) {
            int yearsIndex = workyears.indexOf(AccessField.getYear());
            result = yearsIndex == -1 ? "0" : DealWithAccessField.numberTrans(workyears.substring(0, yearsIndex));
        }
        return result;
    }

    public static String numberTrans(String number) {
        String result = null;
        int tenIndex = number.indexOf(AccessField.getTen());
        result = tenIndex == -1 ? String.valueOf(DealWithAccessField.singleNumberTrans(number)) : String.valueOf(DealWithAccessField.singleNumberTrans(number.substring(0, tenIndex))) + String.valueOf(DealWithAccessField.singleNumberTrans(number.substring(tenIndex + AccessField.getTen().length())));
        return result;
    }

    public static int singleNumberTrans(String number) {
        if (number.equals(AccessField.getZero())) {
            return 0;
        }
        if (number.equals(AccessField.getOne())) {
            return 1;
        }
        if (number.equals(AccessField.getTwo())) {
            return 2;
        }
        if (number.equals(AccessField.getThree())) {
            return 3;
        }
        if (number.equals(AccessField.getFour())) {
            return 4;
        }
        if (number.equals(AccessField.getFive())) {
            return 5;
        }
        if (number.equals(AccessField.getSix())) {
            return 6;
        }
        if (number.equals(AccessField.getSeven())) {
            return 7;
        }
        if (number.equals(AccessField.getEight())) {
            return 8;
        }
        if (number.equals(AccessField.getNine())) {
            return 9;
        }
        return 0;
    }

    public static void rollBack(Map recordToRollback) throws Exception {
        Object obj = null;
        ArrayList list = null;
        IObjectPK pk = null;
        IImportByAccessFacade importByAccessFacade = null;
        if (recordToRollback != null && recordToRollback instanceof HashMap) {
            int i;
            importByAccessFacade = ImportByAccessFacadeFactory.getRemoteInstance();
            obj = recordToRollback.get(AccessInfoParamName.WORKEXP);
            if (obj != null && obj instanceof ArrayList) {
                list = obj;
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    if (list.get(i) instanceof IObjectPK) {
                        pk = (IObjectPK)list.get(i);
                        importByAccessFacade.deleteWorkExp(pk);
                        continue;
                    }
                    throw new ImportDataException(ImportDataException.WORKEXP_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.EDUCATIONEXP)) != null && obj instanceof ArrayList) {
                list = obj;
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    if (list.get(i) instanceof IObjectPK) {
                        pk = (IObjectPK)list.get(i);
                        importByAccessFacade.deleteEducationExp(pk);
                        continue;
                    }
                    throw new ImportDataException(ImportDataException.EDUCATIONEXP_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.TRAINEXP)) != null && obj instanceof ArrayList) {
                list = obj;
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    if (list.get(i) instanceof IObjectPK) {
                        pk = (IObjectPK)list.get(i);
                        importByAccessFacade.deleteTrainExp(pk);
                        continue;
                    }
                    throw new ImportDataException(ImportDataException.TRAINEXP_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.SKILL)) != null && obj instanceof ArrayList) {
                list = obj;
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    if (list.get(i) instanceof IObjectPK) {
                        pk = (IObjectPK)list.get(i);
                        importByAccessFacade.deleteSkill(pk);
                        continue;
                    }
                    throw new ImportDataException(ImportDataException.SKILL_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.CERTIFICATE)) != null && obj instanceof ArrayList) {
                list = obj;
                for (i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    if (list.get(i) instanceof IObjectPK) {
                        pk = (IObjectPK)list.get(i);
                        importByAccessFacade.deleteCertificate(pk);
                        continue;
                    }
                    throw new ImportDataException(ImportDataException.CERTIFICATE_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.RESUMEEXTEND)) != null) {
                if (obj instanceof IObjectPK) {
                    pk = obj;
                    importByAccessFacade.deleteResumeExtend(pk);
                } else {
                    throw new ImportDataException(ImportDataException.RESUMEEXTEND_ROLLBACK_ERROR);
                }
            }
            if ((obj = recordToRollback.get(AccessInfoParamName.RESUMEBASE)) != null) {
                if (obj instanceof IObjectPK) {
                    pk = obj;
                    importByAccessFacade.deleteResumeBase(pk);
                } else {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_ROLLBACK_ERROR);
                }
            }
        }
    }

    public static List excuteImport(RowSet rs, ResumeCategoryInfo rcInfo, boolean isOvercast) throws Exception {
        HashMap<AccessInfoParamName, String> resumeBaseMap = new HashMap<AccessInfoParamName, String>();
        IImportByAccessFacade importByAccessFacade = null;
        ResumeBaseInfo resumeBaseInfo = null;
        IObjectPK pk = null;
        List list = null;
        String accessID = null;
        String accessName = null;
        ArrayList<String> importInfo = new ArrayList<String>();
        StringBuffer exInfo = null;
        int totalRecord = 0;
        int successRecord = 0;
        HashMap<AccessInfoParamName, Object> recordToRollback = new HashMap<AccessInfoParamName, Object>();
        ArrayList<IObjectPK> pksList = null;
        importByAccessFacade = ImportByAccessFacadeFactory.getRemoteInstance();
        while (rs.next()) {
            int i;
            ++totalRecord;
            accessID = rs.getString(AccessField.getID());
            accessName = rs.getString(AccessField.getName());
            resumeBaseMap.put(AccessInfoParamName.NAME, rs.getString(AccessField.getName()));
            resumeBaseMap.put(AccessInfoParamName.SEX, rs.getString(AccessField.getGender()));
            resumeBaseMap.put(AccessInfoParamName.BIRTHDAY, rs.getString(AccessField.getBirthday()));
            resumeBaseMap.put(AccessInfoParamName.NESTEDPLACE, rs.getString(AccessField.getCurrentResidency()));
            resumeBaseMap.put(AccessInfoParamName.WORKYEARS, DealWithAccessField.workYearsTrans(rs.getString(AccessField.getYearsofWorking())));
            resumeBaseMap.put(AccessInfoParamName.HUKOU, rs.getString(AccessField.getHuKou()));
            resumeBaseMap.put(AccessInfoParamName.ADDRESS, rs.getString(AccessField.getAddress()));
            resumeBaseMap.put(AccessInfoParamName.EMAIL, rs.getString(AccessField.getEMail()));
            resumeBaseMap.put(AccessInfoParamName.TEL_HOME, rs.getString(AccessField.getHomeTelephone()));
            resumeBaseMap.put(AccessInfoParamName.TEL_COM, rs.getString(AccessField.getWorkPhone()));
            resumeBaseMap.put(AccessInfoParamName.TEL_MOBILE, rs.getString(AccessField.getMobilePhone()));
            resumeBaseMap.put(AccessInfoParamName.EVALUATE, rs.getString(AccessField.getSelfAssessment()));
            resumeBaseMap.put(AccessInfoParamName.SALARYEXPECTED, rs.getString(AccessField.getSalaryExpected()));
            StringBuffer workExpected = new StringBuffer();
            workExpected.append(AccessField.getTypeofEmployment());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getTypeofEmployment()));
            workExpected.append("\n");
            workExpected.append(AccessField.getTypeofCompany());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getTypeofCompany()));
            workExpected.append("\n");
            workExpected.append(AccessField.getIndustryExpected());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getIndustryExpected()));
            workExpected.append("\n");
            workExpected.append(AccessField.getWorkingPlaceExpected());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getWorkingPlaceExpected()));
            workExpected.append("\n");
            resumeBaseMap.put(AccessInfoParamName.WORKEXPECTED, workExpected.toString());
            List jobs = DealWithAccessField.splitJobs(rs.getString(AccessField.getJobFunctionExpected()));
            int max = jobs.size() > 3 ? 3 : jobs.size();
            for (i = 0; i < max; ++i) {
                if (i == 0) {
                    resumeBaseMap.put(AccessInfoParamName.JOB1, (String)jobs.get(i));
                }
                if (i == 1) {
                    resumeBaseMap.put(AccessInfoParamName.JOB2, (String)jobs.get(i));
                }
                if (i != 2) continue;
                resumeBaseMap.put(AccessInfoParamName.JOB3, (String)jobs.get(i));
            }
            try {
                resumeBaseInfo = DealWithAccessField.formResumeBaseInfo(resumeBaseMap, isOvercast);
                if (isOvercast) {
                    List resumebaseInfos = importByAccessFacade.overcastExtendSameData(resumeBaseInfo);
                    ResumeBaseInfo baseinfo = null;
                    for (int j = 0; j < resumebaseInfos.size(); ++j) {
                        int i2;
                        int i3;
                        baseinfo = (ResumeBaseInfo)resumebaseInfos.get(j);
                        pk = new ObjectUuidPK(baseinfo.getId());
                        recordToRollback.put(AccessInfoParamName.RESUMEBASE, pk);
                        pksList = null;
                        list = DealWithAccessField.splitWorkExp(rs.getString(AccessField.getWorkingExperience()));
                        for (i3 = 0; i3 < list.size(); ++i3) {
                            pksList = new ArrayList();
                            pk = importByAccessFacade.workExpImport(DealWithAccessField.formWorkExp((Map)list.get(i3), baseinfo));
                            pksList.add(pk);
                        }
                        if (pksList != null) {
                            recordToRollback.put(AccessInfoParamName.WORKEXP, pksList);
                        }
                        pksList = null;
                        list = DealWithAccessField.splitEduExp(rs.getString(AccessField.getEducation()));
                        for (i3 = 0; i3 < list.size(); ++i3) {
                            pksList = new ArrayList();
                            pk = importByAccessFacade.educationExpImport(DealWithAccessField.formEducationExp((List)list.get(i3), baseinfo));
                            pksList.add(pk);
                        }
                        if (pksList != null) {
                            recordToRollback.put(AccessInfoParamName.EDUCATIONEXP, pksList);
                        }
                        pksList = null;
                        list = DealWithAccessField.splitTrainExp(rs.getString(AccessField.getTraining()));
                        for (i3 = 0; i3 < list.size(); ++i3) {
                            pksList = new ArrayList();
                            pk = importByAccessFacade.trainExpImport(DealWithAccessField.formTrainExp((List)list.get(i3), baseinfo));
                            pksList.add(pk);
                        }
                        if (pksList != null) {
                            recordToRollback.put(AccessInfoParamName.TRAINEXP, pksList);
                        }
                        pksList = null;
                        list = DealWithAccessField.splitSkill(rs.getString(AccessField.getITSkill()));
                        for (i3 = 0; i3 < list.size(); ++i3) {
                            pksList = new ArrayList();
                            pk = importByAccessFacade.skillImport(DealWithAccessField.formSkillInfo((List)list.get(i3), baseinfo));
                            pksList.add(pk);
                        }
                        List listLan = DealWithAccessField.splitLanguage(rs.getString(AccessField.getLanguage()));
                        for (i2 = 0; i2 < listLan.size(); ++i2) {
                            if (pksList == null) {
                                pksList = new ArrayList();
                            }
                            pk = importByAccessFacade.skillImport(DealWithAccessField.formSkillInfo((List)listLan.get(i2), baseinfo));
                            pksList.add(pk);
                        }
                        if (pksList != null) {
                            recordToRollback.put(AccessInfoParamName.SKILL, pksList);
                        }
                        pksList = null;
                        list = DealWithAccessField.splitCertificate(rs.getString(AccessField.getCertifications()));
                        for (i2 = 0; i2 < list.size(); ++i2) {
                            pksList = new ArrayList();
                            pk = importByAccessFacade.certificateImport(DealWithAccessField.formCertificateInfo((List)list.get(i2), baseinfo));
                            pksList.add(pk);
                        }
                        if (pksList != null) {
                            recordToRollback.put(AccessInfoParamName.CERTIFICATE, pksList);
                        }
                        if (rcInfo == null) continue;
                        FilterInfo talentFilter = new FilterInfo();
                        talentFilter.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)baseinfo.getId().toString(), CompareType.EQUALS));
                        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
                        if (filter != null) {
                            talentFilter.mergeFilter(filter, "and");
                        }
                        if (TalentExtendFactory.getRemoteInstance().exists(talentFilter)) continue;
                        pk = importByAccessFacade.resumeExtendImport(baseinfo, rcInfo);
                        recordToRollback.put(AccessInfoParamName.RESUMEEXTEND, pk);
                    }
                } else {
                    int i4;
                    pk = importByAccessFacade.resumeBaseImport(resumeBaseInfo);
                    if (pk == null) {
                        throw new ImportDataException(ImportDataException.RESUMEBASE_UPDATE_ERROR);
                    }
                    recordToRollback.put(AccessInfoParamName.RESUMEBASE, pk);
                    pksList = null;
                    list = DealWithAccessField.splitWorkExp(rs.getString(AccessField.getWorkingExperience()));
                    for (i = 0; i < list.size(); ++i) {
                        pksList = new ArrayList<IObjectPK>();
                        pk = importByAccessFacade.workExpImport(DealWithAccessField.formWorkExp((Map)list.get(i), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    if (pksList != null) {
                        recordToRollback.put(AccessInfoParamName.WORKEXP, pksList);
                    }
                    pksList = null;
                    list = DealWithAccessField.splitEduExp(rs.getString(AccessField.getEducation()));
                    for (i = 0; i < list.size(); ++i) {
                        pksList = new ArrayList();
                        pk = importByAccessFacade.educationExpImport(DealWithAccessField.formEducationExp((List)list.get(i), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    if (pksList != null) {
                        recordToRollback.put(AccessInfoParamName.EDUCATIONEXP, pksList);
                    }
                    pksList = null;
                    list = DealWithAccessField.splitTrainExp(rs.getString(AccessField.getTraining()));
                    for (i = 0; i < list.size(); ++i) {
                        pksList = new ArrayList();
                        pk = importByAccessFacade.trainExpImport(DealWithAccessField.formTrainExp((List)list.get(i), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    if (pksList != null) {
                        recordToRollback.put(AccessInfoParamName.TRAINEXP, pksList);
                    }
                    pksList = null;
                    list = DealWithAccessField.splitSkill(rs.getString(AccessField.getITSkill()));
                    for (i = 0; i < list.size(); ++i) {
                        pksList = new ArrayList();
                        pk = importByAccessFacade.skillImport(DealWithAccessField.formSkillInfo((List)list.get(i), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    List listLan = DealWithAccessField.splitLanguage(rs.getString(AccessField.getLanguage()));
                    for (i4 = 0; i4 < listLan.size(); ++i4) {
                        if (pksList == null) {
                            pksList = new ArrayList();
                        }
                        pk = importByAccessFacade.skillImport(DealWithAccessField.formSkillInfo((List)listLan.get(i4), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    if (pksList != null) {
                        recordToRollback.put(AccessInfoParamName.SKILL, pksList);
                    }
                    pksList = null;
                    list = DealWithAccessField.splitCertificate(rs.getString(AccessField.getCertifications()));
                    for (i4 = 0; i4 < list.size(); ++i4) {
                        pksList = new ArrayList();
                        pk = importByAccessFacade.certificateImport(DealWithAccessField.formCertificateInfo((List)list.get(i4), resumeBaseInfo));
                        pksList.add(pk);
                    }
                    if (pksList != null) {
                        recordToRollback.put(AccessInfoParamName.CERTIFICATE, pksList);
                    }
                    if (rcInfo != null) {
                        pk = importByAccessFacade.resumeExtendImport(resumeBaseInfo, rcInfo);
                        recordToRollback.put(AccessInfoParamName.RESUMEEXTEND, pk);
                    }
                }
                ++successRecord;
            }
            catch (Exception imEx) {
                exInfo = new StringBuffer();
                exInfo.append(AccessField.getID());
                exInfo.append(accessID);
                exInfo.append(" ");
                exInfo.append(accessName);
                exInfo.append(" :");
                exInfo.append(imEx.getMessage());
                importInfo.add(exInfo.toString());
                if (!(imEx instanceof ImportDataException)) continue;
                DealWithAccessField.rollBack(recordToRollback);
            }
        }
        if (exInfo != null) {
            exInfo = new StringBuffer();
            exInfo.append("\n" + AccessField.getError() + ":");
            importInfo.add(exInfo.toString());
        }
        exInfo = new StringBuffer();
        exInfo.append(AccessField.getTotal());
        exInfo.append(totalRecord);
        exInfo.append(AccessField.getPiece() + AccessField.getRecord() + ",");
        exInfo.append(AccessField.getSuccessToImport());
        exInfo.append(successRecord);
        exInfo.append(AccessField.getPiece() + AccessField.getRecord());
        importInfo.add(exInfo.toString());
        return importInfo;
    }
}

