/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.rec.AccessImportTaskStateEnum;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.client.ResumeCategoryPromptBox;
import com.kingdee.eas.hr.rec.client.ShowImportInfoUI;
import com.kingdee.eas.hr.rec.util.AccessField;
import com.kingdee.eas.hr.rec.util.AccessFieldUtils;
import com.kingdee.eas.hr.rec.util.AccessFunction;
import com.kingdee.eas.hr.rec.util.AccessImportTaskLog;
import com.kingdee.eas.hr.rec.util.DlgAccessImportTaskLog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DlgEASFileImport
extends KDDialog
implements ActionListener,
ComponentListener {
    private static final Logger logger = Logger.getLogger(DlgEASFileImport.class);
    private static String RES = "com.kingdee.eas.hr.rec.client.TalentResource";
    public static final String AccessFileType = "mdb";
    public static final long MAXFILESIZE = 0xA00000L;
    public boolean isOK = false;
    private KDPanel pnlInfos = new KDPanel();
    private KDPanel pnlBtns = new KDPanel();
    private static KDStatusBar statusBar = null;
    private static KDProgressBar progressBar = null;
    private KDComboBox cbxMoreExcels = new KDComboBox();
    private KDLabel lblBizs = new KDLabel();
    private KDLabel lblFile = new KDLabel();
    private KDTextField txtFile = new KDTextField();
    private KDLabelContainer lblcFile = new KDLabelContainer();
    private KDWorkButton btnOpen = new KDWorkButton("", EASResource.getIcon((String)"imgTbtn_open"));
    private KDSeparator separator = new KDSeparator();
    private KDButton btnOk = new KDButton();
    private KDButton btnCancel = new KDButton();
    protected KDBizPromptBox prmtResumeType = new KDBizPromptBox();
    private KDPanel pnlCanHide = new KDPanel();
    private KDPanel ImportModePanel = new KDPanel();
    private KDLabelContainer lcSheet = new KDLabelContainer();
    private KDLabel lblSheet = new KDLabel(EASResource.getString((String)RES, (String)"RusumeType"));
    private KDWorkButton btnRefreshSheet = new KDWorkButton("", EASResource.getIcon((String)"imgTbtn_refresh"));
    private KDCheckBox boxIsOverRide = new KDCheckBox();
    private final int nWidth = 330;
    private final int nHeight = 150;
    private boolean isSltSheet = false;
    private DlgAccessImportTaskLog dlgLog = null;

    public DlgEASFileImport(KDFrame parent, boolean isSltSheet) {
        super((Frame)parent);
        this.isSltSheet = isSltSheet;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
    }

    public void setHideOverBox(boolean isHide) {
        this.boxIsOverRide.setVisible(!isHide);
    }

    private void initGUIControl() {
        this.lblFile.setText(EASResource.getString((String)RES, (String)"file"));
        this.txtFile.setText("");
        this.lblBizs.setText(EASResource.getString((String)RES, (String)"RusumeImportByAccess"));
        this.lblcFile.setBoundEditor((JComponent)this.txtFile);
        this.lblcFile.setBoundLabel((JLabel)this.lblFile);
        this.lblcFile.setBoundLabelUnderline(true);
        this.lblcFile.setBoundLabelLength(70);
        this.initPrmtResumeType(this.prmtResumeType);
        this.lcSheet.add((Component)this.prmtResumeType);
        this.lcSheet.setBoundEditor((JComponent)this.prmtResumeType);
        this.lcSheet.setBoundLabel((JLabel)this.lblSheet);
        this.lcSheet.setBoundLabelUnderline(true);
        this.lcSheet.setBoundLabelLength(70);
        this.btnOk.setText(EASResource.getString((String)RES, (String)"btnOK"));
        this.btnCancel.setText(EASResource.getString((String)RES, (String)"btnCancel"));
        this.txtFile.setEditable(false);
        this.boxIsOverRide.setText(EASResource.getString((String)RES, (String)"overridesamedata"));
        this.setStatusBar(this.getStatusBar());
        this.getStatusBar().validate();
        this.getStatusBar().setVisible(false);
        this.changeByMode();
    }

    private void initUIContentLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.pnlInfos.setLayout((LayoutManager)new GridBagLayout());
        this.pnlInfos.add((Component)this.lblcFile, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.pnlInfos.add((Component)this.btnOpen, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 1, 0, 10), 0, 0));
        this.pnlBtns.setLayout((LayoutManager)new GridBagLayout());
        this.pnlBtns.add((Component)this.separator, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlBtns.add((Component)new KDPanel(), (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
        this.pnlBtns.add((Component)this.btnOk, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
        this.pnlBtns.add((Component)this.btnCancel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 8, 10), 0, 0));
        if (this.isSltSheet) {
            this.pnlCanHide.setLayout((LayoutManager)new GridBagLayout());
            this.pnlCanHide.add((Component)this.lcSheet, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(8, 10, 0, 0), 0, 0));
            this.pnlCanHide.add((Component)this.btnRefreshSheet, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 1, 0, 10), 0, 0));
            this.pnlCanHide.add((Component)this.ImportModePanel, (Object)new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            contentPane.add((Component)this.pnlInfos, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            contentPane.add((Component)this.pnlCanHide, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            contentPane.add((Component)this.pnlBtns, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.ImportModePanel.setLayout((LayoutManager)new BorderLayout());
            this.ImportModePanel.add((Component)this.boxIsOverRide, (Object)"Center");
        } else {
            this.setSize(330, 100);
            contentPane.add((Component)this.pnlInfos, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            contentPane.add((Component)this.pnlBtns, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void initListener() {
        this.addComponentListener(this);
        this.btnOpen.addActionListener((ActionListener)this);
        this.btnOk.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnRefreshSheet.addActionListener((ActionListener)this);
    }

    private void jbInit() {
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.nWidth) / 2, (screenSize.height - this.nHeight) / 2, 330, 150);
        this.getRootPane().setDefaultButton((JButton)this.btnOk);
        this.initGUIControl();
        this.initUIContentLayout();
        this.initListener();
    }

    private void initPrmtResumeType(KDBizPromptBox prmt) {
        prmt.setName("prmtResumeType");
        prmt.setRequired(true);
        ResumeCategoryPromptBox box = new ResumeCategoryPromptBox((Dialog)((Object)this));
        prmt.setSelector((KDPromptSelector)box);
        prmt.setEnabledMultiSelection(false);
    }

    private void changeByMode() {
        this.setTitle(EASResource.getString((String)RES, (String)"RusumeImportByAccessTitle"));
    }

    private static SimpleStatusBarPart createStatusBarPart() {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setBorder(BorderFactory.createEmptyBorder());
        part.setHgrap(0);
        return part;
    }

    private static SimpleStatusBarPart buildPartProgress() {
        SimpleStatusBarPart part = DlgEASFileImport.createStatusBarPart();
        part.setLayout((LayoutManager)new BorderLayout());
        SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JComponent)DlgEASFileImport.getProgressBar(), "");
        part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"Progress bar");
        return part;
    }

    public static synchronized KDProgressBar getProgressBar() {
        if (progressBar == null) {
            progressBar = new KDProgressBar();
            progressBar.setMinimum(0);
            progressBar.setMaximum(100);
            progressBar.setStringPainted(true);
            progressBar.setString("");
        }
        return progressBar;
    }

    private static void initStatusBar() {
        statusBar.add((Component)DlgEASFileImport.buildPartProgress(), (Object)"Progress bar part");
    }

    public KDStatusBar getStatusBar() {
        if (statusBar == null) {
            statusBar = new KDStatusBar();
            statusBar.setPreferredSize(new Dimension(1000, 21));
            statusBar.setBorder(BorderFactory.createEmptyBorder());
            DlgEASFileImport.initStatusBar();
        }
        return statusBar;
    }

    private void toDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void enableButtons() {
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpen.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.cbxMoreExcels.setEnabled(true);
        this.btnRefreshSheet.setEnabled(true);
        this.btnRefreshSheet.setEnabled(true);
        this.prmtResumeType.setEnabled(true);
        this.boxIsOverRide.setEnabled(true);
        this.setDefaultCloseOperation(2);
    }

    private void disableButtons() {
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpen.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.cbxMoreExcels.setEnabled(false);
        this.btnRefreshSheet.setEnabled(false);
        this.prmtResumeType.setEnabled(false);
        this.boxIsOverRide.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    private void onFinishedRunning() {
        this.enableButtons();
        DlgEASFileImport.getProgressBar().setIndeterminate(false);
        this.getStatusBar().setVisible(false);
        if (this.isSltSheet) {
            this.setSize(330, 150);
        } else {
            this.setSize(330, 100);
        }
    }

    private void onPreparedToRun() {
        if (this.isSltSheet) {
            this.setSize(330, 172);
        } else {
            this.setSize(330, 122);
        }
        this.getStatusBar().setVisible(true);
        DlgEASFileImport.getProgressBar().setIndeterminate(true);
        this.disableButtons();
    }

    private boolean isValidFile(String filePath) {
        FileInputStream f = null;
        try {
            f = new FileInputStream(filePath);
            if (f != null && (long)f.available() > 0xA00000L) {
                f.close();
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"importfiletoolarge"));
                return false;
            }
            f.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"fileNotExist"));
            return false;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    private void onBtnOKClicked() {
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"chooseImportDocument"));
            return;
        }
        if (!this.isValidFile(filePath)) {
            return;
        }
        if (!AccessFunction.isSupportFileType(filePath)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"supportfiletype"));
            return;
        }
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AccessImportTaskLog log = DlgEASFileImport.this.invokeUpdateDB(true);
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setLog(log);
                    SwingUtilities.invokeLater(update);
                    DlgEASFileImport.this.isOK = true;
                }
                catch (Exception e) {
                    DlgEASFileImport.this.isOK = false;
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setException(e);
                    SwingUtilities.invokeLater(update);
                }
                finally {
                    if (DlgEASFileImport.getProgressBar().isIndeterminate()) {
                        DlgEASFileImport.getProgressBar().setIndeterminate(false);
                    }
                }
            }
        };
        taskThread.start();
    }

    private List invokeUpdateDB() throws Exception {
        List list = null;
        Object typeInfo = this.prmtResumeType.getValue();
        if (typeInfo == null || !(typeInfo instanceof ResumeCategoryInfo)) {
            return list;
        }
        RowSet rs = AccessFunction.getJdbcRowSet(this.getFileName(), "select * from Chinese");
        list = AccessFieldUtils.excuteImport(rs, (ResumeCategoryInfo)typeInfo, this.isOvercast());
        return list;
    }

    private AccessImportTaskLog invokeUpdateDB(boolean isLog) throws Exception {
        AccessImportTaskLog _log = null;
        Object typeInfo = this.prmtResumeType.getValue();
        if (typeInfo == null || !(typeInfo instanceof ResumeCategoryInfo)) {
            return _log;
        }
        RowSet rs = AccessFunction.getJdbcRowSet(this.getFileName(), "select * from Chinese");
        _log = AccessFieldUtils.excuteImport(rs, (ResumeCategoryInfo)typeInfo, this.isOvercast(), isLog);
        return _log;
    }

    private void showImportInfoUI(List list) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShowImportInfoUI.class.getName(), (Map)uiContext);
            ((ShowImportInfoUI)uiWindow.getUIObject()).setImortInfos(list);
            uiWindow.show();
            uiWindow.close();
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private void updateLogUI(AccessImportTaskLog log) {
        if (log == null) {
            return;
        }
        if (log.getTaskState().equals((Object)AccessImportTaskStateEnum.FAILEND)) {
            if (this.dlgLog == null) {
                this.dlgLog = new DlgAccessImportTaskLog(this, log, AccessField.getImportFailed());
                this.dlgLog.setModal(true);
                this.dlgLog.show();
                this.dlgLog.dispose();
                this.dlgLog = null;
            }
        } else if (log.getTaskState().equals((Object)AccessImportTaskStateEnum.SUCCESSEND)) {
            StringBuffer exInfo = new StringBuffer();
            exInfo.append(AccessField.getSuccessToImport());
            exInfo.append(log.getSuccessRecordCount());
            exInfo.append(AccessField.getPiece() + AccessField.getRecord());
            MsgBox.showInfo((Component)((Object)this), (String)exInfo.toString());
            this.dispose();
        }
    }

    private void onBtnCancelClicked() {
        this.setVisible(false);
        this.dispose();
    }

    private void onBtnOpenClicked() {
        String sFileName = null;
        try {
            sFileName = AccessFunction.accessFileChoose((Component)((Object)this));
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
            return;
        }
        if (sFileName != null && !sFileName.equals("")) {
            this.txtFile.setText(sFileName);
            String fileExtension = AccessFunction.getFileExtension(sFileName);
            this.HideOrVisibleSheet(fileExtension);
            if (!this.isValidFile(sFileName)) {
                return;
            }
            if (this.isSltSheet && AccessFileType.equals(fileExtension)) {
                this.refreshSheet();
            }
        }
    }

    private void refreshSheet() {
    }

    private void HideOrVisibleSheet(String fileType) {
        if (AccessFileType.equals(fileType)) {
            this.lcSheet.setVisible(true);
            this.btnRefreshSheet.setVisible(true);
        } else {
            this.lcSheet.setVisible(false);
            this.btnRefreshSheet.setVisible(false);
        }
    }

    public String getFileName() {
        return this.txtFile.getText();
    }

    public boolean isOvercast() {
        return this.boxIsOverRide.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOk)) {
            this.onBtnOKClicked();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.onBtnCancelClicked();
        } else if (e.getSource().equals(this.btnOpen)) {
            this.onBtnOpenClicked();
        } else if (e.getSource().equals(this.btnRefreshSheet)) {
            String filePath = this.txtFile.getText();
            if (filePath == null || filePath.equals("")) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"chooseImportDocument"));
                return;
            }
            this.refreshSheet();
        }
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    private class UpdateUIRunnable
    implements Runnable {
        private Exception _e = null;
        private List _info = null;
        private AccessImportTaskLog _log = null;

        private UpdateUIRunnable() {
        }

        public void setException(Exception e) {
            this._e = e;
        }

        public void setImportInfo(List info) {
            this._info = info;
        }

        public void setLog(AccessImportTaskLog log) {
            this._log = log;
        }

        public void run() {
            if (this._log == null && this._e == null) {
                DlgEASFileImport.this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)DlgEASFileImport.this), (String)EASResource.getString((String)RES, (String)"chooseResumeCategory"));
                return;
            }
            if (this._log != null) {
                DlgEASFileImport.this.onFinishedRunning();
                DlgEASFileImport.this.updateLogUI(this._log);
                return;
            }
            if (this._e != null && this._e instanceof FileNotFoundException) {
                DlgEASFileImport.this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)DlgEASFileImport.this), (String)EASResource.getString((String)RES, (String)"openedfile"));
                return;
            }
            if (this._e != null && this._e instanceof SQLException) {
                DlgEASFileImport.this.onFinishedRunning();
                MsgBox.showError((Component)((Object)DlgEASFileImport.this), (String)EASResource.getString((String)RES, (String)"accessTypeError"));
                logger.error((Object)this._e.getMessage(), (Throwable)this._e);
                return;
            }
            if (this._e != null) {
                DlgEASFileImport.this.onFinishedRunning();
                ExceptionHandler.handle((Component)((Object)DlgEASFileImport.this), (Throwable)this._e);
                logger.error((Object)this._e.getMessage(), (Throwable)this._e);
                return;
            }
        }
    }

    private class ExceptionRunnable
    implements Runnable {
        private String exMsg;

        private ExceptionRunnable() {
        }

        public void setExMsg(String msg) {
            this.exMsg = msg;
        }

        public void run() {
            MsgBox.showInfo((Component)((Object)DlgEASFileImport.this), (String)this.exMsg);
            DlgEASFileImport.this.toDefaultCursor();
            DlgEASFileImport.this.enableButtons();
        }
    }
}

