/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractEducationExpListUI;
import com.kingdee.eas.hr.rec.client.IResumeBaseUI;
import com.kingdee.eas.hr.rec.client.ResumeListEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class EducationExpListUI
extends AbstractEducationExpListUI
implements IResumeBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(EducationExpListUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private ItemAction[] kdtEducationExpActions;
    private ItemAction[] kdtTrainExpActions;
    private boolean isHistory = false;
    protected boolean isCheckModify = true;
    private boolean requireReLoad = false;

    public void onLoad() throws Exception {
        this.initKdtEducationExp();
        this.initKdtTrainExp();
        super.onLoad();
    }

    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    public void beforeStoreFields(ActionEvent e) throws Exception {
        Date endDate;
        Date startDate;
        IRow row;
        int i;
        for (i = 0; i < this.kdtEducationExp.getRowCount(); ++i) {
            BigDecimal length;
            row = this.kdtEducationExp.getRow(i);
            String name = (String)row.getCell("school").getValue();
            if (name == null) {
                this.kdtEducationExp.getEditManager().editCellAt(i, 0);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"school_name_null"));
                SysUtil.abort();
            }
            startDate = (Date)row.getCell("startDate").getValue();
            endDate = (Date)row.getCell("endDate").getValue();
            if (startDate != null && endDate != null && startDate.after(endDate)) {
                this.kdtEducationExp.getEditManager().editCellAt(i, 2);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"endDate_little_startDate"));
                SysUtil.abort();
            }
            if ((length = (BigDecimal)row.getCell("length").getValue()) == null || !(length.floatValue() < 0.0f)) continue;
            this.kdtEducationExp.getEditManager().editCellAt(i, 4);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"is_negative"));
            SysUtil.abort();
        }
        for (i = 0; i < this.kdtTrainExp.getRowCount(); ++i) {
            row = this.kdtTrainExp.getRow(i);
            String trainItem = (String)row.getCell("trainItem").getValue();
            if (trainItem == null) {
                this.kdtTrainExp.getEditManager().editCellAt(i, 1);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"trainItem_Not_null"));
                SysUtil.abort();
            }
            startDate = (Date)row.getCell("startDate").getValue();
            endDate = (Date)row.getCell("endDate").getValue();
            if (startDate == null || endDate == null || !startDate.after(endDate)) continue;
            this.kdtTrainExp.getEditManager().editCellAt(i, 4);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"endDate_little_startDate"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        if (this.isHistory) {
            ResumeHistoryInfo resumeHistoryInfo = new ResumeHistoryInfo();
            return resumeHistoryInfo;
        }
        ResumeBaseInfo resumeBaseInfo = new ResumeBaseInfo();
        return resumeBaseInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isHistory) {
            return ResumeHistoryFactory.getRemoteInstance();
        }
        return ResumeBaseFactory.getRemoteInstance();
    }

    public void initWorkButton() {
        this.btnPrintResume.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void actionPrintResume_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid resumeBaseId = this.editData.getId();
        if (resumeBaseId != null) {
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            list.add(resumeBaseId);
            ResumePrintProvider.executeActionPrint(list, (Component)((Object)this), this.isHistory);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        super.actionSubmit_actionPerformed(e);
        resumeListEditUI.showSubmitSuccess();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verifyHighDegree();
    }

    private void verifyHighDegree() {
        if (this.kdtEducationExp.getRowCount() == 0) {
            return;
        }
        IRow row = null;
        boolean hasHighDegree = false;
        int count = this.kdtEducationExp.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEducationExp.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("highDegree").getValue())) continue;
            hasHighDegree = true;
            break;
        }
        if (!hasHighDegree) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"must_highDegree"));
            this.kdtEducationExp.getEditManager().editCellAt(0, this.kdtEducationExp.getColumnIndex("highDegree"));
            SysUtil.abort();
        }
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return objectPK;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        if (resumeListEditUI.getUIContext().get("ID") != null) {
            recordId = resumeListEditUI.getUIContext().get("ID").toString();
        }
        this.isHistory = this.getUIContext().get("isHistory") != null ? (Boolean)this.getUIContext().get("isHistory") : false;
        if (recordId != null) {
            if (this.isHistory) {
                ResumeHistoryInfo resumeHistoryInfo = ResumeHistoryFactory.getRemoteInstance().getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.editData = resumeHistoryInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeHistoryInfo.getNumber());
                this.txtName.setText(resumeHistoryInfo.getName());
                Genders gender = resumeHistoryInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeHistoryInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            } else {
                ResumeBaseInfo resumeBaseInfo = ResumeBaseFactory.getRemoteInstance().getResumeBaseInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.editData = resumeBaseInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeBaseInfo.getNumber());
                this.txtName.setText(resumeBaseInfo.getName());
                Genders gender = resumeBaseInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeBaseInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            }
        }
        return this.editData;
    }

    private void initKdtEducationExp() {
        ItemAction ia;
        int i;
        this.kdtEducationExp.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtEducationExpActions != null && this.kdtEducationExpActions.length == 3) {
            for (i = 0; i < this.kdtEducationExpActions.length; ++i) {
                ia = this.kdtEducationExpActions[i];
                ia.setEnabled(true);
            }
            this.kdtEducationExp.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtEducationExpActions == null) {
            this.kdtEducationExpActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contEducationExp, (KDTable)this.kdtEducationExp);
            this.kdtEducationExp.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtEducationExpActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contEducationExp, (KDTable)this.kdtEducationExp);
            for (i = 0; i < this.kdtEducationExpActions.length; ++i) {
                ia = this.kdtEducationExpActions[i];
                ia.setEnabled(false);
            }
            this.kdtEducationExp.setEnabled(false);
        }
        RecUtils.setCellNumberEditor(this.kdtEducationExp, "length", 1, 1, 0, 1000);
        RecUtils.setCellDateEditor(this.kdtEducationExp, "startDate", false);
        RecUtils.setCellDateEditor(this.kdtEducationExp, "endDate", false);
        RecUtils.setCellQueryInfo2(this.kdtEducationExp, "specialtyType", "com.kingdee.eas.hr.base.app.SpecialtyTypeQuery", false);
        RecUtils.setCellQueryInfo2(this.kdtEducationExp, "diploma", "com.kingdee.eas.basedata.hraux.app.DiplomaF7Query", false);
        RecUtils.setCellQueryInfo2(this.kdtEducationExp, "degree", "com.kingdee.eas.basedata.hraux.app.DegreeF7Query", false);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "schoolAddress", 0, 250);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "grade", 0, 80);
        RecUtils.setCellCheckBoxEditor(this.kdtEducationExp, "isStudent", true);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "school", 0, 80);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "pattern", 0, 80);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "specialty", 0, 80);
        RecUtils.setCellTextEditor(this.kdtEducationExp, "school", 0, 80);
        this.kdtEducationExp.getColumn("school").setRequired(true);
        KDCheckBox highDegree_checkBox = new KDCheckBox();
        KDTDefaultCellEditor highDegree_cellEditor = new KDTDefaultCellEditor((JCheckBox)highDegree_checkBox);
        this.kdtEducationExp.getColumn("highDegree").setEditor((ICellEditor)highDegree_cellEditor);
        this.kdtEducationExp.setAfterAction((BeforeActionListener)new tblAfterAction());
        highDegree_checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                block3: {
                    int currentRowIndex;
                    block2: {
                        currentRowIndex = KDTableUtil.getSelectedRows((KDTable)EducationExpListUI.this.kdtEducationExp)[0];
                        IRow currentRow = EducationExpListUI.this.kdtEducationExp.getRow(currentRowIndex);
                        Object highDegree = currentRow.getCell("highDegree").getValue();
                        if (highDegree == null) break block2;
                        if (!highDegree.equals(false)) break block3;
                        for (int i = 0; i < EducationExpListUI.this.kdtEducationExp.getRowCount(); ++i) {
                            if (i == currentRowIndex) continue;
                            IRow row = EducationExpListUI.this.kdtEducationExp.getRow(i);
                            row.getCell("highDegree").setValue((Object)false);
                        }
                        break block3;
                    }
                    for (int i = 0; i < EducationExpListUI.this.kdtEducationExp.getRowCount(); ++i) {
                        if (i == currentRowIndex) continue;
                        IRow row = EducationExpListUI.this.kdtEducationExp.getRow(i);
                        row.getCell("highDegree").setValue((Object)false);
                    }
                }
            }
        });
        highDegree_checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KDCheckBox checkBox = (KDCheckBox)e.getSource();
                if (!checkBox.isSelected()) {
                    checkBox.setSelected(true);
                }
            }
        });
    }

    private void initKdtTrainExp() {
        this.kdtTrainExp.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtTrainExpActions != null && this.kdtTrainExpActions.length == 3) {
            for (int i = 0; i < this.kdtTrainExpActions.length; ++i) {
                ItemAction ia = this.kdtTrainExpActions[i];
                ia.setEnabled(true);
            }
            this.kdtTrainExp.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtTrainExpActions == null) {
            this.kdtTrainExpActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contTrainExp, (KDTable)this.kdtTrainExp);
            this.kdtTrainExp.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtTrainExpActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contTrainExp, (KDTable)this.kdtTrainExp);
            for (int i = 0; i < this.kdtTrainExpActions.length; ++i) {
                ItemAction ia = this.kdtTrainExpActions[i];
                ia.setEnabled(false);
            }
            this.kdtTrainExp.setEnabled(false);
        }
        RecUtils.setCellTextEditor(this.kdtTrainExp, "trainContent", 0, 1000);
        RecUtils.setCellTextEditor(this.kdtTrainExp, "trainOrg", 0, 80);
        RecUtils.setCellTextEditor(this.kdtTrainExp, "trainItem", 0, 80);
        this.kdtTrainExp.getColumn("trainItem").setRequired(true);
        RecUtils.setCellDateEditor(this.kdtTrainExp, "startDate", false);
        RecUtils.setCellDateEditor(this.kdtTrainExp, "endDate", false);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("gender"));
        sic.add(new SelectorItemInfo("job_1"));
        sic.add(new SelectorItemInfo("job_2"));
        sic.add(new SelectorItemInfo("job_3"));
        sic.add(new SelectorItemInfo("educationExp.*"));
        sic.add(new SelectorItemInfo("educationExp.specialtyType.name"));
        sic.add(new SelectorItemInfo("educationExp.diploma.name"));
        sic.add(new SelectorItemInfo("educationExp.degree.name"));
        sic.add(new SelectorItemInfo("trainExp.*"));
        return sic;
    }

    public boolean isModify() {
        if (!this.isCheckModify) {
            return false;
        }
        return super.isModify();
    }

    public boolean isCheckModify() {
        return this.isCheckModify;
    }

    public void setCheckModify(boolean isCheckModify) {
        this.isCheckModify = isCheckModify;
    }

    public boolean isRequireReLoad() {
        return this.requireReLoad;
    }

    public void reLoad() throws Exception {
        this.loadData();
    }

    public void setRequireReLoad(boolean requireReLoad) {
        this.requireReLoad = requireReLoad;
    }

    private class tblAfterAction
    implements BeforeActionListener {
        private tblAfterAction() {
        }

        public void beforeAction(BeforeActionEvent e) {
            if (e.getType() == 0) {
                IRow row;
                boolean flag = false;
                int rowIndex = (Integer)e.getParameter();
                int rowNum = EducationExpListUI.this.kdtEducationExp.getRowCount();
                if (rowNum > 0) {
                    for (int i = 0; i < rowNum - 1; ++i) {
                        row = EducationExpListUI.this.kdtEducationExp.getRow(i);
                        Boolean isHigh = (Boolean)row.getCell("highDegree").getValue();
                        if (isHigh == null || !isHigh.booleanValue()) continue;
                        flag = true;
                        break;
                    }
                }
                row = EducationExpListUI.this.kdtEducationExp.getRow(rowIndex);
                if (flag) {
                    row.getCell("highDegree").setValue((Object)false);
                } else {
                    row.getCell("highDegree").setValue((Object)true);
                }
            }
        }
    }
}

