/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.base.uiframe.client.UINewSession;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.IWorkflowUIEnhancement;
import com.kingdee.eas.framework.client.workflow.IWorkflowUISupport;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.rec.HRRecBaseFacadeFactory;
import com.kingdee.eas.hr.rec.HRRecBaseFactory;
import com.kingdee.eas.hr.rec.HRRecException;
import com.kingdee.eas.hr.rec.IHRRecBase;
import com.kingdee.eas.hr.rec.RequireAdjustBillFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillFactory;
import com.kingdee.eas.hr.rec.client.AbstractHRRecBillListUI;
import com.kingdee.eas.hr.rec.client.HRRecBillEditUI;
import com.kingdee.eas.hr.rec.client.RequireAdjustBillEditUI;
import com.kingdee.eas.hr.rec.client.RequireAdjustBillListUI;
import com.kingdee.eas.hr.rec.client.RequireApplyBillEditUI;
import com.kingdee.eas.hr.rec.client.RequireApplyBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRRecBillListUI
extends AbstractHRRecBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(HRRecBillListUI.class);
    protected BOSUuid personId = null;
    protected boolean isAddNew = false;

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = true;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = false;
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = false;
        super.actionView_actionPerformed(e);
    }

    protected String getEditUIModal() {
        return HRRecBillListUI.getEditUIMode((CoreUIObject)this);
    }

    public static String getEditUIMode(CoreUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        if (win instanceof UINewSession) {
            return "com.kingdee.eas.base.uiframe.client.UINewSessionFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private HashSet getAdminOrgIdSet(String hroId) {
        AdminOrgUnitCollection c = null;
        try {
            IHROrgUnit ihrou = HROrgUnitFactory.getRemoteInstance();
            c = ihrou.getAdminOrgUnitCollectionWithOrgRangeFilter(hroId);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        HashSet<String> set = new HashSet<String>();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            set.add(c.get(i).getId().toString());
        }
        return set;
    }

    protected void checkDelegateAdminOrg() throws Exception {
    }

    private HashSet getAdminOrgIdSet() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        OrgRangeCollection oc = null;
        try {
            oc = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection("select org.id where user.id = '" + userId + "' and type = " + 20);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        HashSet<String> set = new HashSet<String>();
        if (oc != null && oc.size() > 0) {
            int size = oc.size();
            for (int i = 0; i < size; ++i) {
                set.add(oc.get(i).getOrg().getId().toString());
            }
        }
        return set;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"adminOrg.id");
        return filter;
    }

    public HRRecBillListUI() throws Exception {
        this.actionRemove.setBindWorkFlow(true);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        Object isMulti = null;
        if (this instanceof RequireApplyBillListUI) {
            return RequireApplyBillEditUI.class.getName();
        }
        if (this instanceof RequireAdjustBillListUI) {
            return RequireAdjustBillEditUI.class.getName();
        }
        return HRRecBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this instanceof RequireApplyBillListUI) {
            return RequireApplyBillFactory.getRemoteInstance();
        }
        if (this instanceof RequireAdjustBillListUI) {
            return RequireAdjustBillFactory.getRemoteInstance();
        }
        return HRRecBaseFactory.getRemoteInstance();
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.trim().length() < 1) {
            return;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)((Object)this));
    }

    protected Object getCellValue(String colName) {
        IRow row;
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null && block.getTop() != -1 && (row = this.tblMain.getRow(block.getTop())).getCell(colName) != null && row.getCell(colName).getValue() != null) {
            return row.getCell(colName).getValue();
        }
        return null;
    }

    protected boolean canUpdate() throws Exception {
        boolean value = true;
        String id = this.getSelectedKeyValue();
        value = id != null ? HRRecBaseFacadeFactory.getRemoteInstance().canUpdate(id) : false;
        return value;
    }

    protected boolean isEditable() throws Exception {
        boolean value = true;
        BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
        if (state == null) {
            value = true;
        } else if (state.getInt() != 0) {
            value = false;
            return value;
        }
        String proposerId = (String)this.getCellValue("proposer.id");
        if (proposerId == null) {
            value = true;
        }
        return value;
    }

    protected boolean isRemoveable() throws Exception {
        boolean value = true;
        BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
        if (state == null) {
            value = true;
        } else if (state.getInt() != 0 && state.getInt() != 1) {
            value = false;
            return value;
        }
        String proposerId = (String)this.getCellValue("proposer.id");
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (proposerId == null) {
            value = true;
        } else if (isMulti != null && !isMulti.booleanValue()) {
            value = proposerId.equals(this.personId.toString());
        }
        return value;
    }

    protected boolean isMultiEntry() {
        return (Boolean)this.getCellValue("isMultiEntry");
    }

    protected void setEditAction() throws Exception {
        if (!this.isEditable()) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
        if (!this.isRemoveable()) {
            this.actionRemove.setEnabled(false);
        } else {
            this.actionRemove.setEnabled(true);
        }
        this.setAuditAction();
    }

    protected void setAuditAction() throws Exception {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null && block.getTop() == -1) {
            return;
        }
        if (block == null) {
            this.actionAudit.setEnabled(false);
        } else {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            IRow row = null;
            BizEnumValueInfo approveState = null;
            BizEnumValueInfo submitState = null;
            BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
            for (int i = 0; i < rows.length; ++i) {
                row = this.tblMain.getRow(rows[i]);
                state = (BizEnumValueInfo)this.getCellValue("bizState");
                approveState = (BizEnumValueInfo)row.getCell("approveState").getValue();
                submitState = (BizEnumValueInfo)row.getCell("submitState").getValue();
                if (approveState != null && state.getInt() == 0 && approveState.getInt() == 0) {
                    this.actionAudit.setEnabled(true);
                    return;
                }
                if (approveState != null && approveState.getInt() == 1) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                if (state.getInt() != 1) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                if (state.getInt() == 1) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                if (row.getCell("approveState").getValue() == null || row.getCell("submitState").getValue() == null) {
                    this.actionAudit.setEnabled(true);
                    return;
                }
                if (approveState == null || approveState.getInt() != 0 || submitState.getInt() != 10) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                this.actionAudit.setEnabled(true);
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setEditAction();
    }

    protected void selectFirstRow() {
        super.selectFirstRow();
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        try {
            this.setEditAction();
            if (this.isTempEnable()) {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private boolean isTempEnable() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        BizEnumValueInfo state = null;
        boolean flag = true;
        IRow row = null;
        if (rows.length <= 0) {
            return false;
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == -1) {
                return false;
            }
            row = this.tblMain.getRow(rows[i]);
            state = (BizEnumValueInfo)row.getCell("bizState").getValue();
            if (state.getInt() == -1) continue;
            return false;
        }
        return flag;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    public void onLoad() throws Exception {
        UserInfo info = (UserInfo)SysContext.getSysContext().getCurrentUser();
        if (info.getPerson() == null) {
            throw new HRRecException(HRRecException.USER_NO_MATCH_PERSON);
        }
        this.personId = info.getPerson().getId();
        super.onLoad();
        this.setColumnMerge();
        this.actionRemove.setBindWorkFlow(true);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.setColumnMoveable(true);
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    public void setColumnMerge() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmAudit()) {
            ArrayList list = super.getSelectedIdValues();
            String[] ids = new String[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = list.get(i).toString();
            }
            ((IHRRecBase)this.getBizInterface()).batchPassAudit(ids);
            this.showAuditSuccess();
            this.refresh(e);
        }
    }

    protected boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.Confirm_Audit")));
    }

    protected void showAuditSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.Msg_Audit_OK"));
        this.showMessage();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"Owner", (Object)this);
    }

    public void refresh() throws Exception {
        this.refresh(null);
        this.refreshList();
    }

    public void actionWorkflowG_actionPerformed(ActionEvent e) throws Exception {
        this.actionViewDoProccess_actionPerformed(e);
    }

    public final String getQueryFieldNameBindingWf() {
        if (this instanceof IWorkflowUISupport) {
            IWorkflowUIEnhancement enhancement = ((IWorkflowUISupport)this).getWorkflowUIEnhancement();
            return enhancement.getQueryFieldNameBindingWf((CoreUIObject)this);
        }
        return this.getKeyFieldNameForWF();
    }

    public final ArrayList getSelectedFieldValues(String fieldName) {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell(fieldName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        WorkflowUtils.viewWorkFlowGraph((CoreUIObject)this, (String)id);
    }

    protected void fillFirstData(RequestRowSetEvent e) {
        SorterItemInfo sortInfo = new SorterItemInfo("applyDate");
        sortInfo.setSortType(SortType.DESCEND);
        if (this.mainQuery.getSorter().contains(new SorterItemInfo("id"))) {
            this.mainQuery.getSorter().remove(new SorterItemInfo("id"));
        }
        if (!this.mainQuery.getSorter().contains(sortInfo)) {
            this.mainQuery.getSorter().add(sortInfo);
        }
        super.fillFirstData(e);
    }
}

