/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.HireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.HireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.HireApplyBillEntryInfo;
import com.kingdee.eas.hr.rec.HireApplyBillInfo;
import com.kingdee.eas.hr.rec.IRequireApplyBill;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.InterviewRecordFactory;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillInfo;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.client.AbstractHireApplyBillEditUI;
import com.kingdee.eas.hr.rec.client.InterviewHistoryStepUI;
import com.kingdee.eas.hr.rec.client.InterviewPassPersonPromptBox;
import com.kingdee.eas.hr.rec.client.ResumeExtendEditUI;
import com.kingdee.eas.hr.rec.client.ResumePostionCollectionUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HireApplyBillEditUI
extends AbstractHireApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(HireApplyBillEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";
    private boolean isIntermit = false;
    private boolean isModifiable = false;

    public HireApplyBillEditUI() throws Exception {
        RecUtils.setPersonF7(this.prmtproposer, false, false, "$name$");
        this.prmtadminOrg.setSelector((KDPromptSelector)new NewAdminByHROF7());
        this.prmtadminOrg.setEditable(false);
    }

    public void loadFields() {
        super.loadFields();
        this.fillKdtEntrysTableData();
        this.setEditButtonStatus(null);
    }

    private void fillKdtEntrysTableData() {
        int n = this.kdtEntrys.getRowCount();
        if (n <= 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String id = UIRuleUtil.getString((Object)this.kdtEntrys.getCell(i, "id").getValue());
            if (!UIRuleUtil.isNotNull((String)id)) continue;
            ids.add(id);
        }
        Map map = null;
        try {
            map = HireApplyBillEntryFactory.getRemoteInstance().getHireApplyBillEntryRelationInfos(ids);
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (map != null) {
            this.fillKdtEntrysTableData((Map)map.get("entryMainRelation"));
            this.fillKdtEntrysTablePECData((Map)map.get("planNumber"), "planNumber");
            this.fillKdtEntrysTablePECData((Map)map.get("factNumber"), "factNumber");
            this.fillKdtEntrysTableSourceNumberData((Map)map.get("sourceNumber"));
        }
    }

    private void fillKdtEntrysTableData(Map entrysMap) {
        if (entrysMap == null || entrysMap.isEmpty()) {
            return;
        }
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            HireApplyBillEntryInfo habeInfo = (HireApplyBillEntryInfo)entrysMap.get(UIRuleUtil.getString((Object)row.getCell("id").getValue()));
            if (habeInfo == null) continue;
            ResumeBaseInfo rbInfo = habeInfo.getResumeBase();
            if (habeInfo.getHirePosition() != null) {
                this.fillKdtEntrysTableData0(row, rbInfo, habeInfo.getHirePosition(), habeInfo.getHirePosition().getAdminOrgUnit());
                continue;
            }
            this.fillKdtEntrysTableData0(row, rbInfo, habeInfo.getHirePosition(), null);
        }
    }

    private void fillKdtEntrysTableData0(IRow row, ResumeBaseInfo rbInfo, PositionInfo hirePosition, AdminOrgUnitInfo aouInfo) {
        row.getCell("resumeBase").setValue((Object)rbInfo);
        row.getCell("resumeBase.name").setValue((Object)rbInfo.getName());
        row.getCell("resumeBase.gender").setValue((Object)rbInfo.getGender());
        row.getCell("resumeBase.age").setValue((Object)rbInfo.getAge());
        row.getCell("resumeBase.workYears").setValue((Object)rbInfo.getWorkYears());
        if (!rbInfo.getEducationExp().isEmpty()) {
            EducationExpInfo eeInfo = rbInfo.getEducationExp().get(0);
            if (eeInfo.getDiploma() != null) {
                row.getCell("highestDiploma.name").setValue((Object)eeInfo.getDiploma().getName());
            } else {
                row.getCell("highestDiploma.name").setValue(null);
            }
            row.getCell("educationExp.specialty").setValue((Object)eeInfo.getSpecialty());
            row.getCell("graduatedFrom").setValue((Object)eeInfo.getSchool());
        } else {
            row.getCell("highestDiploma.name").setValue(null);
            row.getCell("educationExp.specialty").setValue(null);
            row.getCell("graduatedFrom").setValue(null);
        }
        if (rbInfo.getInterviewActivity() != null && !rbInfo.getInterviewActivity().getEntry().isEmpty()) {
            row.getCell("RequireApplyBill.number").setValue((Object)rbInfo.getInterviewActivity().getEntry().get(0).getSourceNumber());
        } else {
            row.getCell("RequireApplyBill.number").setValue(null);
        }
        if (rbInfo.isIsInter()) {
            row.getCell("recChanne.name").setValue((Object)"\u5185\u90e8\u62db\u8058");
        } else if (rbInfo.getRecChanne() != null) {
            row.getCell("recChanne.name").setValue((Object)rbInfo.getRecChanne().getName());
        }
        row.getCell("hirePosition").setValue((Object)hirePosition);
        if (hirePosition != null && aouInfo != null) {
            row.getCell("adminOrgUnit.name").setValue((Object)aouInfo.getName());
            row.getCell("adminOrgUnit.displayName").setValue((Object)aouInfo.getDisplayName());
        } else {
            row.getCell("adminOrgUnit.name").setValue(null);
            row.getCell("adminOrgUnit.displayName").setValue(null);
        }
        if (rbInfo.getPersonID() != null) {
            row.getCell("resumeBase.personID").setValue((Object)rbInfo.getPersonID());
        }
    }

    private void fillKdtEntrysTablePECData(Map map, String fieldName) {
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            String postionId = ((PositionInfo)this.kdtEntrys.getCell(i, "hirePosition").getValue()).getId().toString();
            this.fillPersonCountData(map, i, postionId, fieldName);
        }
    }

    private void fillPersonCountData(Map map, int rowIndex, String postionId, String fieldName) {
        if (map == null || map.isEmpty() || map.get(postionId) == null) {
            this.kdtEntrys.getCell(rowIndex, fieldName).setValue((Object)0);
        } else {
            this.kdtEntrys.getCell(rowIndex, fieldName).setValue((Object)Integer.valueOf(map.get(postionId).toString()));
        }
    }

    private void fillKdtEntrysTableSourceNumberData(Map map) {
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            ResumeBaseInfo rbInfo = (ResumeBaseInfo)this.kdtEntrys.getCell(i, "resumeBase").getValue();
            this.fillSourceNumberData(map, rbInfo.getId().toString(), i);
        }
    }

    private void fillSourceNumberData(Map map, String resumeBaseId, int rowIndex) {
        if (map == null || map.isEmpty()) {
            this.kdtEntrys.getCell(rowIndex, "RequireApplyBill.number").setValue(null);
        } else {
            this.kdtEntrys.getCell(rowIndex, "RequireApplyBill.number").setValue(map.get(resumeBaseId));
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
            if (!result) {
                PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtadminOrg);
        ArrayList<String> noNullColumns = new ArrayList<String>();
        noNullColumns.add("hirePosition");
        noNullColumns.add("interviewPassDate");
        HRAffairClientUtils.checkHasInputRows((KDTable)this.kdtEntrys, noNullColumns);
    }

    public void onLoad() throws Exception {
        RecUtils.checkValidPerson((CoreUI)this);
        super.onLoad();
        this.btnEdit.setVisible(false);
        this.btnResPositionCol.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pkapplyDate.setValue((Object)RecCommonUtilFacadeFactory.getRemoteInstance().getServerDate());
            this.prmtproposer.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getPerson());
        }
        this.menuBar.setVisible(false);
        KDComboBox comb = (KDComboBox)((KDTDefaultCellEditor)this.kdtEntrys.getColumn("medCheckup").getEditor()).getComponent();
        comb.insertItemAt(null, 0);
        this.kdtEntrys.checkParsed();
        KDBizPromptBox kdtEntrys_resumeBase_PromptBox = new KDBizPromptBox();
        kdtEntrys_resumeBase_PromptBox.setQueryInfo("com.kingdee.eas.hr.rec.app.ResumeBaseQuery");
        kdtEntrys_resumeBase_PromptBox.setVisible(true);
        kdtEntrys_resumeBase_PromptBox.setEditable(true);
        kdtEntrys_resumeBase_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_resumeBase_PromptBox.setEditFormat("$number$");
        kdtEntrys_resumeBase_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntrys_resumeBase_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_resumeBase_PromptBox);
        this.kdtEntrys.getColumn("resumeBase").setEditor((ICellEditor)kdtEntrys_resumeBase_CellEditor);
        Color color = CtrlUtil.Color.parseColor((String)"#E8E8E3");
        this.kdtEntrys.getColumn("resumeBase.name").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("resumeBase.gender").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("resumeBase.age").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("resumeBase.workYears").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("highestDiploma.name").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("educationExp.specialty").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("graduatedFrom").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("planNumber").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("factNumber").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("RequireApplyBill.number").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("adminOrgUnit.name").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("adminOrgUnit.displayName").getStyleAttributes().setBackground(color);
        this.kdtEntrys.getColumn("recChanne.name").getStyleAttributes().setBackground(color);
        if (this.editData.getApproveType() != null) {
            if (this.editData.getApproveType().equals((Object)ApproveTypeEnum.DIRECT)) {
                if (this.editData.getBillState() != null && this.editData.getBillState().equals((Object)HRBillStateEnum.SAVED)) {
                    this.setEditButtonStatus(Boolean.TRUE);
                } else {
                    this.setEditButtonStatus(Boolean.FALSE);
                }
            } else {
                switch (this.editData.getBillState().getValue()) {
                    case 0: {
                        this.setEditButtonStatus(Boolean.TRUE);
                        break;
                    }
                    case 2: {
                        this.setEditButtonStatus(Boolean.FALSE);
                        break;
                    }
                    case 3: {
                        this.setEditButtonStatus(Boolean.FALSE);
                        break;
                    }
                    case 4: {
                        this.setEditButtonStatus(Boolean.FALSE);
                    }
                }
            }
        }
        this.btnResPositionCol.setEnabled(true);
        this.prmtadminOrg.setEditable(false);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        this.kdtEntrys.getSelectManager().get();
        int selSize = this.kdtEntrys.getSelectManager().size();
        for (int i = 0; i < selSize; ++i) {
            KDTSelectBlock sb = this.kdtEntrys.getSelectManager().get(i);
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    private void setEditButtonStatus(Boolean enabled) {
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("FINDVIEW")) {
            this.btnImpByIntePassPers.setEnabled(false);
            this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
            if (enabled != null && !enabled.booleanValue()) {
                this.actionEdit.setEnabled(false);
                this.actionColumnCopy.setEnabled(false);
                this.actionSelectedCopy.setEnabled(false);
            }
        } else if (enabled != null) {
            this.actionColumnCopy.setEnabled(enabled);
            this.actionSelectedCopy.setEnabled(enabled);
            if (!enabled.booleanValue()) {
                this.actionEdit.setEnabled(false);
            }
            this.actionSave.setEnabled(enabled.booleanValue());
            this.actionSubmit.setEnabled(enabled.booleanValue());
            this.btnImpByIntePassPers.setEnabled(enabled.booleanValue());
            this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(enabled.booleanValue());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.addButtonToEntry(this.btnImpByIntePassPers);
        this.btnColumnCopy.setIcon(this.btnCopy.getIcon());
        this.btnSelectedCopy.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.btnResume.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnInterviewRecord.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.saveRrsumeBasePosition(this.editData.getEntrys());
        this.btnImpByIntePassPers.setEnabled(true);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(true);
    }

    private void saveRrsumeBasePosition(HireApplyBillEntryCollection entrys) {
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        try {
            IPosition positionFac = PositionFactory.getRemoteInstance();
            IResumeBase resumeBaseFac = ResumeBaseFactory.getRemoteInstance();
            for (int i = 0; i < entrys.size(); ++i) {
                HireApplyBillEntryInfo hireAppBillEntryInfo = entrys.get(i);
                String resumeBaseId = hireAppBillEntryInfo.getResumeBase().getId().toString();
                if (hireAppBillEntryInfo.getHirePosition() == null || hireAppBillEntryInfo.getHirePosition().getId() == null) {
                    return;
                }
                String positionId = hireAppBillEntryInfo.getHirePosition().getId().toString();
                if (StringUtils.isEmpty((String)resumeBaseId)) continue;
                ResumeBaseInfo resumeBase = resumeBaseFac.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
                PositionInfo position = positionFac.getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
                resumeBase.setPosition(position);
                coreBaseCol.add((CoreBaseInfo)resumeBase);
            }
            resumeBaseFac.saveBatchData(coreBaseCol);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> noNullColumns = new ArrayList<String>();
        noNullColumns.add("hirePosition");
        noNullColumns.add("interviewPassDate");
        HRAffairClientUtils.checkHasInputRows((KDTable)this.kdtEntrys, noNullColumns);
        this.saveRrsumeBasePosition(this.editData.getEntrys());
        super.actionSubmit_actionPerformed(e);
        this.btnImpByIntePassPers.setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    private void addButtonToEntry(KDWorkButton button) {
        KDPanel controlPanel = null;
        Component[] components = this.kdtEntrys_detailPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!"controlPanel".equals(component.getName())) continue;
            controlPanel = (KDPanel)component;
        }
        if (controlPanel != null) {
            Rectangle rect = this.kdtEntrys_detailPanel.getBounds();
            int x = rect.width - (button.getWidth() + 5 + 30);
            controlPanel.add((Component)button, new KDLayout.Constraints(x, 5, button.getWidth(), 19, 9));
        }
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        HireApplyBillEntryInfo entryInfo = new HireApplyBillEntryInfo();
        entryInfo.setMedCheckup(null);
        try {
            entryInfo.setInterviewPassDate(RecCommonUtilFacadeFactory.getRemoteInstance().getServerDate());
        }
        catch (Exception e) {
            super.handleException(e);
        }
        return entryInfo;
    }

    protected IObjectValue createNewData() {
        HireApplyBillInfo objectValue = new HireApplyBillInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApproveType(ApproveTypeEnum.WORKFLOW);
        return objectValue;
    }

    public void actionImportInterviewPassPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportInterviewPassPerson_actionPerformed(e);
        InterviewPassPersonPromptBox pmt = new InterviewPassPersonPromptBox();
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length <= 0) {
                return;
            }
            if (obj.length > 0) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        HireApplyBillEditUI.this.dealAddResume(obj);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddResume(obj);
            }
        }
    }

    private void dealAddResume(Object[] data) throws Exception {
        ResumeBaseInfo rbInfo;
        ArrayList<String> positionList = new ArrayList<String>();
        for (int i = 0; i < data.length; ++i) {
            rbInfo = (ResumeBaseInfo)data[i];
            if (rbInfo.getPosition() == null) continue;
            positionList.add(rbInfo.getPosition().getId().toString());
        }
        IRequireApplyBill rab = RequireApplyBillFactory.getRemoteInstance();
        Map pnMap = positionList.isEmpty() ? Collections.EMPTY_MAP : rab.getCurrPlanCountByPosition(positionList, null);
        Map fnMap = positionList.isEmpty() ? Collections.EMPTY_MAP : rab.getFactCountByPosition(positionList);
        boolean flag = false;
        for (int i = 0; i < data.length; ++i) {
            rbInfo = (ResumeBaseInfo)data[i];
            if (this.isExistsHireResume(rbInfo)) continue;
            super.actionAddLine_actionPerformed(null);
            IRow row = this.kdtEntrys.getRow(this.kdtEntrys.getRowCount() - 1);
            this.fillKdtEntrysTableData0(row, rbInfo, rbInfo.getPosition(), rbInfo.getAdminOrgUnit());
            if (rbInfo.getPosition() == null) continue;
            this.fillPersonCountData(pnMap, row.getRowIndex(), rbInfo.getPosition().getId().toString(), "planNumber");
            this.fillPersonCountData(fnMap, row.getRowIndex(), rbInfo.getPosition().getId().toString(), "factNumber");
        }
    }

    private boolean isExistsHireResume(ResumeBaseInfo rbInfo) {
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!((ResumeBaseInfo)this.kdtEntrys.getCell(i, "resumeBase").getValue()).getId().equals((Object)rbInfo.getId())) continue;
            return true;
        }
        return false;
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if ("hirePosition".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            PositionInfo pInfo = (PositionInfo)this.kdtEntrys.getCell(rowIndex, "hirePosition").getValue();
            if (pInfo != null) {
                ArrayList<String> positionList = new ArrayList<String>();
                String positionID = pInfo.getId().toString();
                positionList.add(positionID);
                IRequireApplyBill rab = RequireApplyBillFactory.getRemoteInstance();
                Map map = rab.getCurrPlanCountByPosition(positionList, null);
                this.fillPersonCountData(map, rowIndex, positionID, "planNumber");
                map = rab.getFactCountByPosition(positionList);
                this.fillPersonCountData(map, rowIndex, positionID, "factNumber");
                ResumeBaseInfo rbInfo2 = (ResumeBaseInfo)this.kdtEntrys.getCell(rowIndex, "resumeBase").getValue();
                ResumeBaseCollection rbColl = new ResumeBaseCollection();
                rbColl.add(rbInfo2);
                map = HireApplyBillEntryFactory.getRemoteInstance().getSourceNumbers((IObjectCollection)rbColl);
                this.fillSourceNumberData(map, rbInfo2.getId().toString(), rowIndex);
                AdminOrgUnitInfo aouInfo = pInfo.getAdminOrgUnit();
                if (aouInfo == null || UIRuleUtil.isNull((String)aouInfo.getName())) {
                    aouInfo = this.getMainPositionInfo(pInfo.getId());
                }
                this.kdtEntrys.getCell(rowIndex, "adminOrgUnit.name").setValue((Object)aouInfo.getName());
                this.kdtEntrys.getCell(rowIndex, "adminOrgUnit.displayName").setValue((Object)aouInfo.getDisplayName());
            } else {
                this.kdtEntrys.getCell(rowIndex, "planNumber").setValue((Object)0);
                this.kdtEntrys.getCell(rowIndex, "factNumber").setValue((Object)0);
                this.kdtEntrys.getCell(rowIndex, "adminOrgUnit.name").setValue(null);
                this.kdtEntrys.getCell(rowIndex, "adminOrgUnit.displayName").setValue(null);
                this.kdtEntrys.getCell(rowIndex, "RequireApplyBill.number").setValue(null);
            }
        }
    }

    private AdminOrgUnitInfo getMainPositionInfo(BOSUuid id) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        return PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(id), sic).getAdminOrgUnit();
    }

    public void actionColumnCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnCopy_actionPerformed(e);
        this.selectCopy(true);
    }

    public void actionSelectedCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectedCopy_actionPerformed(e);
        this.selectCopy(false);
    }

    private void selectCopy(boolean isColumnCopy) {
        int rowCount = this.kdtEntrys.getRowCount();
        if (rowCount <= 0) {
            return;
        }
        int selSize = this.kdtEntrys.getSelectManager().size();
        if (selSize <= 0) {
            return;
        }
        KDTSelectBlock sb = this.kdtEntrys.getSelectManager().get(0);
        int column = sb.getLeft();
        if (column != this.kdtEntrys.getColumn("hirePosition").getColumnIndex() && column != this.kdtEntrys.getColumn("interviewPassDate").getColumnIndex() && column != this.kdtEntrys.getColumn("medCheckup").getColumnIndex() && column != this.kdtEntrys.getColumn("remark").getColumnIndex()) {
            return;
        }
        sb = this.kdtEntrys.getSelectManager().get(0);
        int row = sb.getTop();
        IColumn iColumn = this.kdtEntrys.getColumn(column);
        if (iColumn.getStyleAttributes().isLocked()) {
            return;
        }
        Object value = this.kdtEntrys.getCell(row, column).getValue();
        HashMap<String, Object> posiRelaMap = new HashMap<String, Object>();
        if (column == this.kdtEntrys.getColumn("hirePosition").getColumnIndex()) {
            posiRelaMap.put("planNumber", this.kdtEntrys.getCell(row, "planNumber").getValue());
            posiRelaMap.put("factNumber", this.kdtEntrys.getCell(row, "factNumber").getValue());
            posiRelaMap.put("RequireApplyBill.number", this.kdtEntrys.getCell(row, "RequireApplyBill.number").getValue());
            posiRelaMap.put("adminOrgUnit.name", this.kdtEntrys.getCell(row, "adminOrgUnit.name").getValue());
            posiRelaMap.put("adminOrgUnit.displayName", this.kdtEntrys.getCell(row, "adminOrgUnit.displayName").getValue());
        }
        if (isColumnCopy) {
            this.selectCopyTo(0, rowCount - 1, column, value, posiRelaMap);
        } else {
            for (int i = 0; i < selSize; ++i) {
                sb = this.kdtEntrys.getSelectManager().get(i);
                this.selectCopyTo(sb.getBeginRow(), sb.getEndRow(), column, value, posiRelaMap);
            }
        }
    }

    private void selectCopyTo(int beginRow, int endRow, int column, Object sourceValue, Map posiRelaMap) {
        for (int j = beginRow; j <= endRow; ++j) {
            if (this.kdtEntrys.getCell(j, column).getStyleAttributes().isLocked()) continue;
            this.kdtEntrys.getCell(j, column).setValue(sourceValue);
            if (posiRelaMap.size() <= 0) continue;
            this.copyPostionRelationInfo(j, posiRelaMap);
        }
    }

    private void copyPostionRelationInfo(int rowIndex, Map posiRelaMap) {
        for (Map.Entry entry : posiRelaMap.entrySet()) {
            this.kdtEntrys.getCell(rowIndex, entry.getKey().toString()).setValue(entry.getValue());
        }
    }

    public void actionViewResumeInfo_actionPerformed(ActionEvent e) throws Exception {
        String resumeBaseId;
        if (this.kdtEntrys.getRowCount() == 0 || this.kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int rowIndex = RecUtils.getSelectedRow(this.kdtEntrys);
        ResumeBaseInfo resumeInfo = (ResumeBaseInfo)this.kdtEntrys.getCell(rowIndex, "resumeBase").getValue();
        String resumeState = resumeInfo.getResumeState().toString();
        boolean isvisible_entryed = RecUtils.getParamValue("hr_rec_isvisible_entryed");
        if (!isvisible_entryed && resumeState.equals(ResumeStateEnum.entryed.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.ResumeResource", (String)"resume_cannot_view"));
            SysUtil.abort();
        }
        String personID = null;
        if (this.kdtEntrys.getCell(rowIndex, "resumeBase.personID").getValue() != null) {
            personID = this.kdtEntrys.getCell(rowIndex, "resumeBase.personID").getValue().toString();
        }
        if ((resumeBaseId = resumeInfo.getId().toString()) != null && ResumeBaseFactory.getRemoteInstance().exists("where ID= '" + resumeBaseId + "' and isInter=1")) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this.ui);
            uiContext.put((Object)"ID", (Object)personID);
            RealModeIDList idList = new RealModeIDList();
            idList.add(personID);
            uiContext.put((Object)"IDList", (Object)idList);
            uiContext.put((Object)"isPosition", (Object)new Boolean(true));
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeTreeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)resumeInfo.getId());
            uiContext.put((Object)"resID", (Object)resumeInfo.getId());
            uiContext.put((Object)"isOnlyView", (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResumeExtendEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ResumeExtendEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    public void actionHistoryInterviewInfo_actionPerformed(ActionEvent e) throws Exception {
        ResumeBaseInfo resumeInfo;
        if (this.kdtEntrys.getRowCount() == 0 || this.kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int rowIndex = RecUtils.getSelectedRow(this.kdtEntrys);
        String personID = null;
        if (this.kdtEntrys.getCell(rowIndex, "resumeBase.personID").getValue() != null) {
            personID = this.kdtEntrys.getCell(rowIndex, "resumeBase.personID").getValue().toString();
        }
        if ((resumeInfo = (ResumeBaseInfo)this.kdtEntrys.getCell(rowIndex, "resumeBase").getValue()) != null) {
            String resumeBaseId = resumeInfo.getId().toString();
            String sql = "select FID from T_HR_InterviewRecord where finterviewid in(select fid from t_hr_interview where fresumebaseid = '" + resumeBaseId + "')";
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            if (!InterviewRecordFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"not interview"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"resumeState", (Object)resumeInfo.getResumeState().toString());
            uiContext.put((Object)"currentResumeBaseId", (Object)resumeBaseId);
            if (resumeInfo.getInterviewActivity() != null) {
                uiContext.put((Object)"currentActivityId", (Object)resumeInfo.getInterviewActivity().getId());
            }
            uiContext.put((Object)"resumeBase.personID", (Object)personID);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewHistoryStepUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("approveType"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.btnImpByIntePassPers.setEnabled(true);
        if (HireApplyBillEditUI.getParamValue("REC005")) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"no_opar_for_no_param"));
        }
    }

    public void actionResPositionCol_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.ResumeResource", (String)"no_entry_position"));
            SysUtil.abort();
        }
        HashMap<String, String> positionMap = new HashMap<String, String>();
        HashMap<String, String> sourceBillMap = new HashMap<String, String>();
        HashMap<String, String> applyTitleMap = new HashMap<String, String>();
        HireApplyBillEntryCollection entryCol = this.editData.getEntrys();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            if (this.kdtEntrys.getRow(i).getCell("hirePosition") == null || this.kdtEntrys.getRow(i).getCell("hirePosition").getValue() == null) continue;
            String hirePositionId = ((PositionInfo)this.kdtEntrys.getRow(i).getCell("hirePosition").getValue()).getId().toString();
            positionMap.put(hirePositionId, hirePositionId);
            if (this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number") == null || this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number").getValue() == null) continue;
            if (sourceBillMap.get(hirePositionId) != null && !sourceBillMap.get(hirePositionId).toString().equals("")) {
                if (!this.getSourceBillMapApplyBill(sourceBillMap, hirePositionId, i)) {
                    sourceBillMap.put(hirePositionId, sourceBillMap.get(hirePositionId).toString() + ";" + this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number").getValue().toString());
                }
            } else {
                sourceBillMap.put(hirePositionId, this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number").getValue().toString());
            }
            String applyTitleStr = this.getApplyTitleBysourceBillNumber(this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number").getValue().toString());
            if (applyTitleMap.get(hirePositionId) != null && !applyTitleMap.get(hirePositionId).toString().equals("")) {
                applyTitleMap.put(hirePositionId, applyTitleMap.get(hirePositionId).toString() + ";" + applyTitleStr);
                continue;
            }
            applyTitleMap.put(hirePositionId, applyTitleStr);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"positionMap", positionMap);
        uiContext.put((Object)"sourceBillMap", sourceBillMap);
        uiContext.put((Object)"applyTitleMap", applyTitleMap);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResumePostionCollectionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private boolean getSourceBillMapApplyBill(Map sourceBillMap, String hirePositionId, int i) {
        boolean isHasAppBill = false;
        String[] str = sourceBillMap.get(hirePositionId).toString().split(";");
        String appBillNumber = this.kdtEntrys.getRow(i).getCell("RequireApplyBill.number").getValue().toString();
        if (str.length > 0) {
            for (int j = 0; j < str.length; ++j) {
                if (!appBillNumber.equals(str[j])) continue;
                isHasAppBill = true;
                break;
            }
        }
        return isHasAppBill;
    }

    private String getApplyTitleBysourceBillNumber(String sourceBill) {
        String applyTitle = "";
        try {
            if (!"".equals(sourceBill)) {
                RequireApplyBillInfo info;
                IRequireApplyBill appBillFac = RequireApplyBillFactory.getRemoteInstance();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)sourceBill));
                view.setFilter(filter);
                RequireApplyBillCollection billCol = appBillFac.getRequireApplyBillCollection(view);
                if (billCol != null && billCol.size() > 0 && (info = billCol.get(0)).getTitle() != null) {
                    applyTitle = info.getTitle();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return applyTitle;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (HireApplyBillEditUI.getParamValue("REC005")) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"no_opar_for_no_param"));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (HireApplyBillEditUI.getParamValue("REC005")) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"no_opar_for_no_param"));
        }
    }

    public static boolean getParamValue(String number) throws Exception {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), number);
        return "true".equals(val);
    }

    protected void setAutoNumberByOrg(String orgType) {
        super.setAutoNumberByOrg(orgType);
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
            if (result) {
                this.isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
                this.txtNumber.setEnabled(this.isModifiable);
                this.txtNumber.setEditable(this.isModifiable);
                if (OprtState.ADDNEW.equals(this.getOprtState())) {
                    this.isIntermit = codingRuleManager.isUseIntermitNumber((IObjectValue)this.editData, orgUnitId);
                    if (this.isIntermit) {
                        this.txtNumber.setEnabled(false);
                        this.txtNumber.setEditable(false);
                    }
                }
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    this.txtNumber.setEnabled(false);
                    this.txtNumber.setEditable(false);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

