/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractImportByExcelMultiTaskUI;
import com.kingdee.eas.hr.rec.client.ResumeCategoryPromptBox;
import com.kingdee.eas.hr.rec.util.AccessField;
import com.kingdee.eas.tools.datatask.DatataskMode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ImportByExcelMultiTaskUI
extends AbstractImportByExcelMultiTaskUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportByExcelMultiTaskUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";
    private boolean isConfirm = false;
    private DlgEASDatataskLog dlgLog = null;
    private int mode = 8;
    private ArrayList params = null;
    private String uuid;
    private static final String TB_SHEETTABNAME = "excelTabName";
    private static final String TB_ISSELECT = "isSelect";
    private static final String TB_TASKNAME = "taskName";
    private boolean noStopRequested = true;
    private Thread progressThread = null;

    public void onLoad() throws Exception {
        super.onLoad();
        ResumeCategoryPromptBox box = new ResumeCategoryPromptBox((IUIObject)this);
        this.prmtResumeCategory.setSelector((KDPromptSelector)box);
        this.prmtResumeCategory.setEnabledMultiSelection(false);
        this.tblMain.getColumn(TB_TASKNAME).getStyleAttributes().setLocked(true);
    }

    protected void disableButtons() {
        super.disableButtons();
        this.tblMain.getColumn(TB_SHEETTABNAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_ISSELECT).getStyleAttributes().setLocked(true);
        this.prmtResumeCategory.setEnabled(false);
    }

    protected void enableButtons() {
        super.enableButtons();
        this.tblMain.getColumn(TB_SHEETTABNAME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_ISSELECT).getStyleAttributes().setLocked(false);
        this.prmtResumeCategory.setEnabled(true);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        super.actionCancel_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Boolean isResultImport = (Boolean)this.getUIContext().get("isResultImport");
        Object activityId = this.getUIContext().get("activityId");
        this.isConfirm = true;
        int baseRow = 0;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!((String)this.tblMain.getRow(i).getCell(TB_TASKNAME).getValue()).equals(EASResource.getString((String)RES, (String)"resumeBase"))) continue;
            baseRow = i;
            break;
        }
        if (((Boolean)this.tblMain.getRow(baseRow).getCell(TB_ISSELECT).getValue()).booleanValue()) {
            Object obj = this.prmtResumeCategory.getValue();
            if (obj == null || !(obj instanceof ResumeCategoryInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"chooseResumeCategory"));
                return;
            }
            ArrayList list = (ArrayList)this.getUIContext().get("params");
            for (int i = 0; i < list.size(); ++i) {
                DatataskParameter param = (DatataskParameter)list.get(i);
                param.putContextParam((Object)"resumeCategory", obj);
                if (isResultImport != null) {
                    param.putContextParam((Object)"isResultImport", (Object)isResultImport);
                }
                if (activityId == null) continue;
                param.putContextParam((Object)"activityId", (Object)activityId.toString());
            }
        }
        this.actionConfirm();
        this.isConfirm = true;
    }

    protected boolean isConfirm() {
        return this.isConfirm;
    }

    private ArrayList getParams(ArrayList result, String filePath) throws Exception {
        String serverTmpFileName = "";
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            DatataskParameter dp = (DatataskParameter)result.get(i);
            if (i == 0) {
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                serverTmpFileName = helper.uploadFile(filePath);
            }
            dp.setOpenFileName(serverTmpFileName);
        }
        return result;
    }

    private void getParameter() {
        this.params = (ArrayList)this.getUIContext().get("params");
        this.mode = (Integer)this.getUIContext().get("mode");
    }

    private boolean isValidFile(String filePath) {
        String fileExtension = GlobalFunction.getFileExtension((String)filePath);
        if ("xls".equals(fileExtension)) {
            try {
                ExternalExcelDataReader reader = new ExternalExcelDataReader();
                ArrayList sheetNames = null;
                sheetNames = reader.getSheetNameCollection(filePath);
                if (sheetNames.size() > 20) {
                    String msg = "Excel\u7684\u9875\u7b7e\u6570\u5927\u4e8e20";
                    MsgBox.showError((Component)((Object)this), (String)msg);
                    return false;
                }
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
        }
        FileInputStream f = null;
        try {
            f = new FileInputStream(filePath);
            if (f != null && DatataskMode.isImpMode((int)this.mode) && (long)f.available() > 0xA00000L) {
                f.close();
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importfiletoolarge"));
                return false;
            }
            f.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)"\u627e\u4e0d\u5230\u6587\u4ef6\uff01");
            return false;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean verifyInput() {
        String filePath = this.getFirstFileName();
        if (filePath == null || filePath.equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
            return false;
        }
        if (!this.isValidFile(filePath)) {
            return false;
        }
        if (!GlobalFunction.isSupportFileType((String)filePath)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
            return false;
        }
        int rowCount = this.tblMain.getRowCount();
        boolean hasSelected = false;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSlt = (Boolean)row.getCell(TB_ISSELECT).getValue();
            if (!isSlt.booleanValue() || !"xls".equals(GlobalFunction.getFileExtension((String)filePath))) continue;
            String value = (String)row.getCell(TB_SHEETTABNAME).getValue();
            if (value == null || value.trim().equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectsheet"));
                return false;
            }
            hasSelected = true;
        }
        if (!hasSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectimporttask"));
            return false;
        }
        return true;
    }

    private void actionConfirm() {
        if (!this.verifyInput()) {
            return;
        }
        this.uuid = GlobalFunction.getUuID();
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TaskLog taskLog = new TaskLog();
                try {
                    IDatataskRunServer drs = ImportByExcelMultiTaskUI.this.getInterface();
                    FilesPathInfo fpInfo = ImportByExcelMultiTaskUI.this.getAlltFilePath();
                    String[] paths = fpInfo.getFilePath();
                    ArrayList params = null;
                    for (int i = 0; i < paths.length; ++i) {
                        params = i == 0 ? ImportByExcelMultiTaskUI.this.getFirstParams() : ImportByExcelMultiTaskUI.this.getParams(params, paths[i]);
                        drs.runMuitiTask(params, true);
                        TaskLog tmpLog = drs.getTaskLog(ImportByExcelMultiTaskUI.this.uuid);
                        ImportByExcelMultiTaskUI.this.updateTaskLogSubject(tmpLog, paths[i]);
                        taskLog.addTaskLog(tmpLog);
                    }
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setTaskLog(taskLog);
                    SwingUtilities.invokeLater(update);
                }
                catch (Exception e) {
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setException(e);
                    SwingUtilities.invokeLater(update);
                    return;
                }
                finally {
                    ImportByExcelMultiTaskUI.this.clearLog(ImportByExcelMultiTaskUI.this.uuid);
                }
            }
        };
        taskThread.start();
    }

    protected String getFileName() {
        return this.txtFile.getText();
    }

    private String getFirstFileName() {
        FilesPathInfo paths = this.getAlltFilePath();
        if (paths != null && paths.getFilePath() != null && paths.getFilePath().length > 0) {
            return paths.getFilePath()[0];
        }
        return null;
    }

    private FilesPathInfo getAlltFilePath() {
        return (FilesPathInfo)this.txtFile.getUserObject();
    }

    private ArrayList getFirstParams() throws Exception {
        int tmpmode = 8;
        tmpmode = this.chkUpdate.isSelected() ? 16 : 8;
        String fileName = this.getFirstFileName();
        String fileType = GlobalFunction.getFileExtension((String)fileName);
        int rowCount = this.tblMain.getRowCount();
        ArrayList<DatataskParameter> result = new ArrayList<DatataskParameter>();
        boolean isReadFile = false;
        String serverTmpFileName = "";
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSlt = (Boolean)row.getCell(TB_ISSELECT).getValue();
            if (!isSlt.booleanValue()) continue;
            DatataskParameter dp = (DatataskParameter)row.getUserObject();
            dp.alias = (String)row.getCell(TB_SHEETTABNAME).getValue();
            dp.setFileType(fileType);
            if (!isReadFile) {
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                serverTmpFileName = helper.uploadFile(fileName);
                isReadFile = true;
            }
            dp.setOpenFileName(serverTmpFileName);
            dp.setLogUuID(this.uuid);
            dp.datataskMode = tmpmode;
            result.add(dp);
        }
        return result;
    }

    private void onPreparedToRun() {
        this.panelProgress.setVisible(true);
        this.progressBar.setValue(0);
        this.increaseValue();
        this.disableButtons();
    }

    private void increaseValue() {
        Runnable increaseRun = new Runnable(){

            public void run() {
                while (ImportByExcelMultiTaskUI.this.noStopRequested) {
                    try {
                        Thread.sleep(100L);
                        ImportByExcelMultiTaskUI.this.progressBar.setValue(ImportByExcelMultiTaskUI.this.progressBar.getValue() + 5);
                        if (ImportByExcelMultiTaskUI.this.progressBar.getValue() > ImportByExcelMultiTaskUI.this.progressBar.getMaximum()) {
                            ImportByExcelMultiTaskUI.this.progressBar.setValue(ImportByExcelMultiTaskUI.this.progressBar.getMaximum());
                        }
                        ImportByExcelMultiTaskUI.this.repaint();
                        if (ImportByExcelMultiTaskUI.this.progressBar.getValue() < ImportByExcelMultiTaskUI.this.progressBar.getMaximum()) continue;
                        ImportByExcelMultiTaskUI.this.progressBar.setValue(ImportByExcelMultiTaskUI.this.progressBar.getMinimum());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.progressThread = new Thread(increaseRun);
        this.progressThread.start();
    }

    private void updateTaskLogSubject(TaskLog log, String path) {
        int size = log.getErrorDetailCount();
        for (int i = 0; i < size; ++i) {
            log.setErrorSubject(i, EASResource.getString((String)RES, (String)"importDesc") + path + "," + log.getErrorSubject(i));
        }
    }

    private void updateUI(TaskLog log) {
        if (log == null) {
            return;
        }
        if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND) || log.getErrorDetailCount() > 0) {
            if (this.dlgLog == null) {
                this.dlgLog = new DlgEASDatataskLog((KDDialog)this.getUIWindow(), log, AccessField.getImportFailed());
                this.dlgLog.setModal(true);
                this.clearLog(log.getLogUuID());
                this.dlgLog.show();
                this.dlgLog.dispose();
                this.dlgLog = null;
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportFailed") + log.getErrorDetail(0)));
            }
        } else if (log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            this.clearLog(log.getLogUuID());
            if (this.mode == 1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportSucceeded"));
                this.getUIWindow().close();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importSucceeded"));
                this.getUIWindow().close();
            }
        }
    }

    private IDatataskRunServer getInterface() throws BOSException {
        return DatataskRunServerFactory.getRemoteInstance();
    }

    private void clearLog(String uuid) {
        try {
            if (this.getInterface() != null && uuid != null) {
                try {
                    this.getInterface().clearTaskLog(uuid);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private class UpdateUIRunnable
    implements Runnable {
        private TaskLog _log = null;
        private Exception _e = null;

        private UpdateUIRunnable() {
        }

        public void setTaskLog(TaskLog log) {
            this._log = log;
        }

        public void setException(Exception e) {
            this._e = e;
        }

        private void onFinishedRunning() {
            ImportByExcelMultiTaskUI.this.enableButtons();
            ImportByExcelMultiTaskUI.this.progressBar.setValue(100);
            ImportByExcelMultiTaskUI.this.panelProgress.setVisible(false);
        }

        public void run() {
            if (this._log != null) {
                this.onFinishedRunning();
                ImportByExcelMultiTaskUI.this.updateUI(this._log);
                return;
            }
            if (this._e != null && this._e instanceof FileNotFoundException) {
                this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)ImportByExcelMultiTaskUI.this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                return;
            }
            if (this._e != null) {
                this.onFinishedRunning();
                ExceptionHandler.handle((Component)((Object)ImportByExcelMultiTaskUI.this), (Throwable)this._e);
                return;
            }
        }
    }
}

