/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.rec.ActivityRelationLevelCollection;
import com.kingdee.eas.hr.rec.ActivityRelationLevelFactory;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterEmployEmpFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterEmployEmpFilterUI
extends AbstractInterEmployEmpFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterEmployEmpFilterUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private Set interviewLevelSet = new LinkedHashSet();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParam();
    }

    private void initParam() throws BOSException {
        this.btnUp.setActionCommand("up");
        this.btnUp.addActionListener((ActionListener)new Action());
        this.btnDown.setActionCommand("down");
        this.btnDown.addActionListener((ActionListener)new Action());
        this.tblInterviewLevel.checkParsed();
        this.tblInterviewLevel.getColumn("selected").setWidth(50);
        this.tblInterviewLevel.getColumn("level").setWidth(190);
        this.prmtActivity.setRequired(true);
        this.prmtActivity.setEditable(false);
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterEmployInterviewActivityQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        RecUtils.setPersonF7(this.prmtEmployeeName, false, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtDept, false, true, "$name$");
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.prmtEmployeeName.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtDept.setValue(null);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtActivity.getValue();
        cp = RecUtils.buildCustomerParams(cp, "activity", value);
        if (this.tblInterviewLevel.getRowCount() > 0) {
            StringBuffer ids = new StringBuffer();
            int j = this.tblInterviewLevel.getRowCount();
            for (int i = 0; i < j; ++i) {
                String id = this.tblInterviewLevel.getCell(i, "id").getValue().toString();
                cp.addCustomerParam(id + "_selected", this.tblInterviewLevel.getCell(i, "selected").getValue().toString());
                cp.addCustomerParam(id + "_index", String.valueOf(i));
                ids.append(id).append("#--#");
            }
        }
        value = this.prmtEmployeeName.getValue();
        cp = RecUtils.buildCustomerParams(cp, "name", value);
        value = this.prmtDept.getValue();
        cp = RecUtils.buildCustomerParams(cp, "dept", value);
        value = this.prmtPosition.getValue();
        cp = RecUtils.buildCustomerParams(cp, "position", value);
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo item = null;
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildFilterItemInfo(fic, "interviewActivity.id", obj, CompareType.EQUALS);
        obj = this.prmtEmployeeName.getValue();
        if (obj != null) {
            item = new FilterItemInfo("person.name", (Object)("%" + obj + "%"), CompareType.LIKE);
            fic.add(item);
        }
        obj = this.prmtPosition.getValue();
        RecUtils.buildFilterItemInfo(fic, "position.id", obj, CompareType.INCLUDE);
        obj = this.prmtDept.getValue();
        RecUtils.buildFilterItemInfo(fic, "adminOrgUnit.id", obj, CompareType.INCLUDE);
        return fi;
    }

    public void setCustomerParams(CustomerParams cp) {
        String[] ids;
        this.clear();
        String str = null;
        str = cp.getCustomerParam("activity");
        if (str != null) {
            try {
                InterviewActivityInfo info = InterviewActivityFactory.getRemoteInstance().getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(str));
                this.prmtActivity.setValue((Object)info);
            }
            catch (Exception e) {
                logger.info((Object)e);
                super.handUIException((Throwable)e);
            }
        }
        if (this.tblInterviewLevel.getRowCount() > 0) {
            int j = this.tblInterviewLevel.getRowCount();
            for (int i = 0; i < j; ++i) {
                String id = this.tblInterviewLevel.getCell(i, "id").getValue().toString();
                String selected = cp.getCustomerParam(id + "_selected").toString();
                if ("true".equals(selected)) {
                    this.tblInterviewLevel.getCell(i, "selected").setValue((Object)true);
                    continue;
                }
                this.tblInterviewLevel.getCell(i, "selected").setValue((Object)false);
            }
        }
        if ((str = cp.getCustomerParam("name")) != null) {
            try {
                PersonInfo person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(str));
                this.prmtEmployeeName.setValue((Object)person);
            }
            catch (Exception e) {
                logger.info((Object)e);
                super.handUIException((Throwable)e);
            }
        } else {
            this.prmtEmployeeName.setValue(null);
        }
        IRecCommonUtilFacade facade = null;
        str = cp.getCustomerParam("dept");
        if (str != null) {
            ids = str.split("#--#");
            List<String> list = Arrays.asList(ids);
            try {
                List orgs;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((orgs = facade.getBatchAdminOrgUnitByIds(list)) != null) {
                    this.prmtDept.setValue((Object)orgs.toArray());
                }
            }
            catch (Exception e) {
                logger.info((Object)e);
                super.handUIException((Throwable)e);
            }
        } else {
            this.prmtDept.setValue(null);
        }
        str = cp.getCustomerParam("position");
        if (str != null) {
            ids = str.split("#--#");
            List<String> list = Arrays.asList(ids);
            try {
                List positions;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((positions = facade.getBatchPositionByIds(list)) != null) {
                    this.prmtPosition.setValue((Object)positions.toArray());
                }
            }
            catch (Exception e) {
                logger.info((Object)e);
                super.handUIException((Throwable)e);
            }
        } else {
            this.prmtPosition.setValue(null);
        }
    }

    protected void prmtActivity_dataChanged(DataChangeEvent e) throws Exception {
        this.tblInterviewLevel.removeRows();
        Object obj = this.prmtActivity.getValue();
        if (obj != null) {
            InterviewActivityInfo info = (InterviewActivityInfo)obj;
            try {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)info.getId().toString()));
                SelectorItemCollection sic = evi.getSelector();
                sic.add(new SelectorItemInfo("interviewLevel.*"));
                evi.setFilter(fi);
                ActivityRelationLevelCollection coll = ActivityRelationLevelFactory.getRemoteInstance().getActivityRelationLevelCollection(evi);
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    String levelId = coll.get(i).getInterviewLevel().getId().toString();
                    IRow row = this.tblInterviewLevel.addRow();
                    row.getCell("selected").setValue((Object)true);
                    row.getCell("level").setValue((Object)coll.get(i).getInterviewLevel().getName());
                    row.getCell("id").setValue((Object)levelId);
                }
            }
            catch (Exception ex) {
                logger.info((Object)ex);
                ExceptionHandler.handle((Throwable)ex);
            }
        } else {
            this.tblInterviewLevel.removeRows();
        }
    }

    public boolean verify() {
        Object activity = this.prmtActivity.getValue();
        if (activity == null) {
            this.prmtActivity.requestFocusInWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"notInterviewActivity"));
            return false;
        }
        boolean isSelectedLevel = false;
        int j = this.tblInterviewLevel.getRowCount();
        for (int i = 0; i < j; ++i) {
            Boolean selected = (Boolean)this.tblInterviewLevel.getCell(i, "selected").getValue();
            if (selected == null || !selected.booleanValue()) continue;
            isSelectedLevel = true;
            break;
        }
        if (!isSelectedLevel) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"notInterviewLevel"));
            return false;
        }
        return true;
    }

    public class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int index;
            String command;
            if (InterEmployEmpFilterUI.this.tblInterviewLevel.getRowCount() == 0 || InterEmployEmpFilterUI.this.tblInterviewLevel.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)InterEmployEmpFilterUI.this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if ("up".equals(command = e.getActionCommand())) {
                int index2 = KDTableUtil.getSelectedRow((KDTable)InterEmployEmpFilterUI.this.tblInterviewLevel);
                if (index2 > 0) {
                    IRow row = InterEmployEmpFilterUI.this.tblInterviewLevel.getRow(index2);
                    InterEmployEmpFilterUI.this.tblInterviewLevel.addRow(index2 - 1, row);
                    InterEmployEmpFilterUI.this.tblInterviewLevel.removeRow(index2 + 1);
                    InterEmployEmpFilterUI.this.tblInterviewLevel.getSelectManager().select(index2 - 1, 1);
                }
            } else if ("down".equals(command) && (index = KDTableUtil.getSelectedRow((KDTable)InterEmployEmpFilterUI.this.tblInterviewLevel)) < InterEmployEmpFilterUI.this.tblInterviewLevel.getRowCount() - 1) {
                IRow row = InterEmployEmpFilterUI.this.tblInterviewLevel.getRow(++index);
                InterEmployEmpFilterUI.this.tblInterviewLevel.addRow(index - 1, row);
                InterEmployEmpFilterUI.this.tblInterviewLevel.removeRow(index + 1);
                InterEmployEmpFilterUI.this.tblInterviewLevel.getSelectManager().select(index, 1);
            }
        }
    }
}

