/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.InterEmployEmpMsgFactory;
import com.kingdee.eas.hr.rec.InterviewActivityFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterEmployEmpMsgReportUI;
import com.kingdee.eas.hr.rec.client.InterEmployEmpFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterEmployEmpMsgReportUI
extends AbstractInterEmployEmpMsgReportUI {
    private static final Logger logger = CoreUIObject.getLogger(InterEmployEmpMsgReportUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private Set levelSet = new LinkedHashSet();
    Map levelInfoMap = new HashMap();
    private String activityId;
    private CommonQueryDialog commonQueryDialog = null;
    private String sum = "sum";
    private KDTable tblInterviewLevel;

    public void onLoad() throws Exception {
        super.onLoad();
        RecUtils.setKDTableUISort(this.tblMain);
        if (this.activityId == null) {
            this.actionQuery_actionPerformed(null);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        FilterInfo fi = null;
        fi = this.isFirstDefaultQuery() ? RecUtils.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), this.mainQueryPK.getFullName(), "com.kingdee.eas.hr.rec.client.InterEmployEmpFilterUI") : this.mainQuery.getFilter();
        if (fi != null) {
            FilterItemCollection fic = fi.getFilterItems();
            int j = fic.size();
            for (int i = 0; i < j; ++i) {
                FilterItemInfo info = fic.get(i);
                if (!"interviewActivity.id".equals(info.getPropertyName())) continue;
                this.activityId = info.getCompareValue().toString();
                break;
            }
        }
        this.initInterviewLevel();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    private void initInterviewLevel() {
        InterEmployEmpFilterUI filterUI;
        if (this.commonQueryDialog != null && this.commonQueryDialog.getUserPanels().size() > 0 && (filterUI = (InterEmployEmpFilterUI)this.commonQueryDialog.getUserPanel(InterEmployEmpFilterUI.class.getName())) != null) {
            this.tblInterviewLevel = filterUI.tblInterviewLevel;
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.initInterviewLevel();
        this.setScore();
    }

    private void setScore() {
        ICell cell = null;
        Object levelId = null;
        Object levelName = null;
        if (this.levelInfoMap.size() > 0) {
            Iterator it = this.levelInfoMap.values().iterator();
            while (it.hasNext()) {
                this.tblMain.removeColumn(this.tblMain.getColumnIndex(it.next().toString()));
            }
        }
        for (int i = 0; i < this.tblInterviewLevel.getRowCount(); ++i) {
            cell = this.tblInterviewLevel.getCell(i, "selected");
            if (cell == null || !((Boolean)cell.getValue()).booleanValue()) continue;
            cell = this.tblInterviewLevel.getCell(i, "id");
            if (cell != null) {
                levelId = cell.getValue();
            }
            if ((cell = this.tblInterviewLevel.getCell(i, "level")) != null) {
                levelName = cell.getValue();
            }
            if (this.tblMain.getColumn("sum") == null) continue;
            IColumn column = this.tblMain.addColumn(this.tblMain.getColumn("sum").getColumnIndex());
            column.setKey(levelId.toString());
            this.tblMain.getHeadRow(0).getCell(levelId.toString()).setValue(levelName);
            column.setSortable(true);
            this.levelSet.add(levelId);
            this.levelInfoMap.put(levelId, levelId);
        }
        Map map = null;
        try {
            map = InterviewActivityFacadeFactory.getRemoteInstance().getInterviewAvgScore(this.activityId);
        }
        catch (Exception e) {
            this.handleException(e);
            logger.info((Object)e.getMessage());
        }
        BigDecimal total = new BigDecimal("0.00");
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            String id;
            Map levelMap;
            if (this.tblMain.getCell(i, "id") == null || (levelMap = (Map)map.get(id = this.tblMain.getCell(i, "id").getValue().toString())) == null) continue;
            Iterator it = this.levelSet.iterator();
            while (it.hasNext()) {
                levelId = it.next().toString();
                if (levelMap.get(levelId) != null && this.tblMain.getCell(i, levelId.toString()) != null) {
                    this.tblMain.getCell(i, levelId.toString()).setValue(levelMap.get(levelId));
                    continue;
                }
                if (this.tblMain.getCell(i, levelId.toString()) == null) continue;
                this.tblMain.getCell(i, levelId.toString()).setValue((Object)"");
            }
            try {
                total = InterviewActivityFacadeFactory.getRemoteInstance().getSumById(id);
            }
            catch (Exception ex) {
                logger.info((Object)ex.getMessage());
                super.handleException(ex);
            }
            if (total != null) {
                this.tblMain.getCell(i, this.sum).setValue((Object)total.setScale(2));
                continue;
            }
            this.tblMain.getCell(i, this.sum).setValue((Object)"");
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterEmployEmpMsgFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog cqd = super.initCommonQueryDialog();
        InterEmployEmpFilterUI userPanel = null;
        try {
            userPanel = new InterEmployEmpFilterUI();
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (userPanel != null) {
            cqd.addUserPanel((KDPanel)userPanel);
        }
        this.commonQueryDialog = cqd;
        return this.commonQueryDialog;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

