/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterviewActivityEntryImportUI;
import com.kingdee.eas.hr.rec.client.InterviewActivityEditUI;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;

public class InterviewActivityEntryImportUI
extends AbstractInterviewActivityEntryImportUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewActivityEntryImportUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.InterviewActivityResource";
    private boolean cancel = true;
    private HSSFWorkbook workbook;

    public void onload() throws Exception {
        super.onLoad();
        this.actionOk.setEnabled(true);
        this.actionNo.setEnabled(true);
        this.actionSelectFile.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectFile.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int rowNum;
        String filePath = this.textFilePath.getText();
        if (filePath == null || filePath.trim().length() <= 0 || this.workbook == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"no_select_file"));
            return;
        }
        boolean bool = this.checkTemplate(filePath);
        if (!bool) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            SysUtil.abort();
            return;
        }
        int sheetNum = this.comboxSheet.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        InterviewActivityEditUI editUi = (InterviewActivityEditUI)((Object)this.getUIContext().get("Owner"));
        KDTable kdtEntry = editUi.getKDTEntry();
        boolean isOver = this.isRemoveCommon.isSelected();
        Set<Object> oldSet = new HashSet();
        HashMap<String, Integer> oldMap = new HashMap<String, Integer>();
        if (isOver) {
            int j = kdtEntry.getRowCount();
            for (int i = 0; i < j; ++i) {
                String pNum = kdtEntry.getRow(i).getCell("entry.position.number").getValue().toString();
                oldMap.put(pNum, i);
            }
            oldSet = oldMap.keySet();
        }
        if ((rowNum = sheet.getPhysicalNumberOfRows()) <= 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"no_data_import"));
            return;
        }
        ArrayList<String> positionList = new ArrayList<String>();
        HashMap<String, String> numberNameMap = new HashMap<String, String>();
        HashMap<String, String> numberAmountMap = new HashMap<String, String>();
        HashMap<String, String> numberDescMap = new HashMap<String, String>();
        Pattern p = Pattern.compile("^[1-9]\\d*|0$");
        String pNum = null;
        String pName = null;
        String amount = null;
        String desc = null;
        String erroNumber = EASResource.getString((String)RES, (String)"wrong_position_number");
        String erroName = EASResource.getString((String)RES, (String)"wrong_position_name");
        for (int i = 1; i < rowNum; ++i) {
            block34: {
                HSSFCell cell;
                block35: {
                    block33: {
                        HSSFRow row = sheet.getRow(i);
                        if (row.getPhysicalNumberOfCells() <= 0) continue;
                        cell = row.getCell((short)1);
                        if (cell == null) {
                            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"position_number_is_null"));
                            return;
                        }
                        pNum = ExcelUtil.getCellValue((HSSFCell)cell);
                        if (pNum == null || pNum.trim().length() <= 0) {
                            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"position_number_is_null"));
                            return;
                        }
                        if (!positionList.contains(pNum)) {
                            positionList.add(pNum);
                        }
                        if ((cell = row.getCell((short)2)) != null) {
                            pName = ExcelUtil.getCellValue((HSSFCell)cell);
                            if (pName != null && pName.trim().length() > 0) {
                                numberNameMap.put(pNum, pName);
                            } else {
                                numberNameMap.put(pNum, "");
                            }
                        } else {
                            numberNameMap.put(pNum, "");
                        }
                        cell = row.getCell((short)3);
                        if (cell == null) {
                            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"person_amount_is_null"));
                            return;
                        }
                        amount = ExcelUtil.getCellValue((HSSFCell)cell);
                        if (amount == null || amount.trim().length() <= 0) break block33;
                        if (!p.matcher(amount).matches()) {
                            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"number_is_error"));
                            return;
                        }
                        numberAmountMap.put(pNum, amount);
                        cell = row.getCell((short)4);
                        if (cell == null) break block34;
                        break block35;
                    }
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"person_amount_is_null"));
                    return;
                }
                desc = ExcelUtil.getCellValue((HSSFCell)cell);
                numberDescMap.put(pNum, desc);
                continue;
            }
            numberDescMap.put(pNum, "");
        }
        IRecCommonUtilFacade commonFacade = RecCommonUtilFacadeFactory.getRemoteInstance();
        List list = commonFacade.getPositionByNumber(positionList);
        boolean isExistErroNum = false;
        StringBuffer sb = new StringBuffer();
        if (list != null && list.size() < positionList.size()) {
            isExistErroNum = true;
        }
        IRow row = null;
        int importAmount = 0;
        ArrayList<String> errorNameList = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            int i;
            int j = list.size();
            for (i = 0; i < j; ++i) {
                PositionInfo info = (PositionInfo)list.get(i);
                if (info == null) continue;
                String number = info.getNumber();
                Object tempName = numberNameMap.get(number);
                if (tempName != null && tempName.toString().trim().length() > 0 && !tempName.equals(info.getName())) {
                    isExistErroNum = true;
                    errorNameList.add(number);
                    continue;
                }
                if (isOver && oldSet.contains(info.getNumber())) {
                    int rowIndex = (Integer)oldMap.get(info.getNumber());
                    row = kdtEntry.getRow(rowIndex);
                } else {
                    row = kdtEntry.addRow();
                }
                row.getCell("entry.dept").setValue((Object)info.getAdminOrgUnit().getName());
                row.getCell("entry.position.number").setValue((Object)info.getNumber());
                row.getCell("entry.position").setValue((Object)info);
                row.getCell("amount").setValue((Object)Integer.valueOf(numberAmountMap.get(info.getNumber()).toString()));
                row.getCell("description").setValue((Object)numberDescMap.get(info.getNumber()).toString());
                ++importAmount;
                if (!isExistErroNum) continue;
                positionList.remove(info.getNumber());
            }
            if (!isExistErroNum) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"success_import") + importAmount + EASResource.getString((String)RES, (String)"item")));
            } else {
                j = positionList.size();
                for (i = 0; i < j; ++i) {
                    if (i != 0) {
                        sb.append("\n");
                    }
                    pNum = positionList.get(i).toString();
                    sb.append(pNum).append("(").append(numberNameMap.get(pNum)).append(")").append(",  ");
                    if (errorNameList != null && errorNameList.contains(pNum)) {
                        sb.append(erroName);
                        continue;
                    }
                    sb.append(erroNumber);
                }
                sb.append("\n");
                if (importAmount > 0) {
                    sb.append(EASResource.getString((String)RES, (String)"success_import") + importAmount + EASResource.getString((String)RES, (String)"item"));
                }
                MsgBox.showInfo((String)sb.toString());
            }
            this.getUIWindow().close();
            return;
        }
        int i = 0;
        int j = positionList.size();
        while (true) {
            if (i >= j) {
                MsgBox.showInfo((String)sb.toString());
                return;
            }
            if (i != 0) {
                sb.append("\n");
            }
            pNum = positionList.get(i).toString();
            sb.append(pNum).append("(").append(numberNameMap.get(pNum)).append(")");
            if (errorNameList != null && errorNameList.contains(pNum)) {
                sb.append(erroName);
            } else {
                sb.append(erroNumber);
            }
            ++i;
        }
    }

    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        String filePath = GlobalFunction.excelFileChoose((Component)((Object)this));
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"no_select_file"));
            return;
        }
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            SysUtil.abort();
        }
        this.textFilePath.setText(filePath);
        FileInputStream inputStream = new FileInputStream(filePath);
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)inputStream);
        this.workbook = new HSSFWorkbook(pfs);
        int size = this.workbook.getNumberOfSheets();
        this.comboxSheet.removeAllItems();
        for (int i = 0; i < size; ++i) {
            this.comboxSheet.addItem((Object)this.workbook.getSheetName(i));
        }
        inputStream.close();
    }

    public void actionExpTemp_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName("ActivityPositions.xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = new FileOutputStream(expFilePath);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(wb);
        HSSFCellStyle cellStyle = this.createValueCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        HSSFRow headRow = sheet.createRow(0);
        HSSFCell cell1 = headRow.createCell((short)0);
        cell1.setCellType(1);
        cell1.setCellValue(EASResource.getString((String)RES, (String)"department"));
        cell1.setCellStyle(titleStyle);
        HSSFCell cell2 = headRow.createCell((short)1);
        cell2.setCellType(1);
        cell2.setCellValue("*" + EASResource.getString((String)RES, (String)"position_number"));
        cell2.setCellStyle(titleStyle);
        HSSFCell cell3 = headRow.createCell((short)2);
        cell3.setCellType(1);
        cell3.setCellValue(EASResource.getString((String)RES, (String)"position_name"));
        cell3.setCellStyle(titleStyle);
        HSSFCell cell4 = headRow.createCell((short)3);
        cell4.setCellType(1);
        cell4.setCellValue("*" + EASResource.getString((String)RES, (String)"amount"));
        cell4.setCellStyle(titleStyle);
        HSSFCell cell5 = headRow.createCell((short)4);
        cell5.setCellType(1);
        cell5.setCellValue(EASResource.getString((String)RES, (String)"description"));
        cell5.setCellStyle(titleStyle);
        this.createValueCellStyle(wb);
        sheet.setDefaultColumnStyle(0, (CellStyle)cellStyle);
        sheet.setDefaultColumnStyle(1, (CellStyle)cellStyle);
        sheet.setDefaultColumnStyle(2, (CellStyle)cellStyle);
        sheet.setDefaultColumnStyle(3, (CellStyle)cellStyle);
        sheet.setDefaultColumnStyle(4, (CellStyle)cellStyle);
        sheet.setDefaultColumnWidth((short)20);
        wb.setSheetName(0, EASResource.getString((String)RES, (String)"resume_position"));
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"template_export_success"));
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment((short)1);
        valueStyle.setHidden(true);
        short borderstyle = 7;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = 8;
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment((short)1);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"16_InterviewActivityEntryImportUI"));
        defaultFont.setColor((short)8);
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern((short)1);
        titleStyle.setFillForegroundColor((short)26);
        titleStyle.setAlignment((short)2);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        int backColorIndex = 8;
        titleStyle.setVerticalAlignment((short)1);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"16_InterviewActivityEntryImportUI"));
        defaultFont.setColor((short)17);
        short size = 15;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        return titleStyle;
    }

    private boolean checkTemplate(String filePath) {
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            return false;
        }
        int sheetNum = this.comboxSheet.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        if (rowNum == 0) {
            return false;
        }
        HSSFRow row = sheet.getRow(0);
        int rows = row.getPhysicalNumberOfCells();
        if (rows != 5) {
            return false;
        }
        String[] names = new String[]{EASResource.getString((String)RES, (String)"department"), "*" + EASResource.getString((String)RES, (String)"position_number"), EASResource.getString((String)RES, (String)"position_name"), "*" + EASResource.getString((String)RES, (String)"amount"), EASResource.getString((String)RES, (String)"description")};
        for (int i = 0; i < 5; ++i) {
            HSSFCell cell = row.getCell((short)i);
            if (names[i].equals(cell.getStringCellValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }
}

