/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.rec.IInterviewActivity;
import com.kingdee.eas.hr.rec.IInterviewActivityFacade;
import com.kingdee.eas.hr.rec.InterviewActivityEntryCollection;
import com.kingdee.eas.hr.rec.InterviewActivityEntryInfo;
import com.kingdee.eas.hr.rec.InterviewActivityEnum;
import com.kingdee.eas.hr.rec.InterviewActivityFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterviewActivityListUI;
import com.kingdee.eas.hr.rec.client.DirectAuditInfoListUI;
import com.kingdee.eas.hr.rec.client.InterviewActivityAuditUI;
import com.kingdee.eas.hr.rec.client.InterviewActivityEditUI;
import com.kingdee.eas.hr.rec.client.InterviewActivityFilterUI;
import com.kingdee.eas.hr.rec.client.InterviewActivityPublishUI;
import com.kingdee.eas.hr.rec.client.InterviewActivitySetLevelUI;
import com.kingdee.eas.hr.rec.client.InterviewActivitySetResumeUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InterviewActivityListUI
extends AbstractInterviewActivityListUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewActivityListUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.InterviewActivityResource";
    private boolean canSetLevel = true;
    private static final String GENYRES = "com.kingdee.eas.hr.rec.client.InterviewActivityGenyResource";
    KDPanel userPanel = null;
    private CustomerParams customerParams;
    private WindowListener listenerForEditWindow = null;

    public void onLoad() throws Exception {
        RecUtils.checkValidPerson((CoreUI)this);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.btnAttachment.setVisible(true);
        this.initBottonState(null);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                InterviewActivityListUI.this.initBottonState(e);
            }
        });
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnEnd.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnSetResume.setIcon(EASResource.getIcon((String)"imgTbtn_review"));
        this.btnSetLevel.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.btnHandlerResult.setIcon(EASResource.getIcon((String)"imgTbtn_seeperformance"));
        this.btnAbandon.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemSetResume.setIcon(EASResource.getIcon((String)"imgTbtn_review"));
        this.menuItemSetLevel.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.menuItemHandleResult.setIcon(EASResource.getIcon((String)"imgTbtn_seeperformance"));
        this.menuItemAbandon.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnSetResume.setText(EASResource.getString((String)GENYRES, (String)"selectInviteEmp"));
        this.btnSetResume.setToolTipText(EASResource.getString((String)GENYRES, (String)"selectInviteEmp"));
        this.menuItemSetResume.setText(EASResource.getString((String)GENYRES, (String)"selectInviteEmp"));
    }

    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        super.actionModify_actionPerformed(e);
        int size = this.tblMain.getSelectManager().size();
        if (size < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"activity_is_null"));
            return;
        }
        int selectedRow = TrainUtils.getSelectedRow((KDTable)this.tblMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"isInterviewActivityModify", (Object)true);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("state").getValue();
        uiContext.put((Object)"InterviewActivityState", (Object)InterviewActivityEnum.getEnum(status.getInt()));
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (this.isRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    protected final boolean isRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (this.listenerForEditWindow == null) {
            this.listenerForEditWindow = new WindowAdapter(){

                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            InterviewActivityListUI.this.refresh(null);
                        }
                    }
                    catch (Exception e) {
                        InterviewActivityListUI.this.handleException(e);
                    }
                }
            };
        }
        window.removeWindowListener(this.listenerForEditWindow);
        window.addWindowListener(this.listenerForEditWindow);
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String activityId = this.getFirstSelectedActivityId();
        IInterviewActivity interviewActivity = InterviewActivityFactory.getRemoteInstance();
        InterviewActivityInfo info = interviewActivity.getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(activityId), RecUtils.getSic(new String[]{"*", "entry.*"}));
        InterviewActivityEntryCollection coll = info.getEntry();
        if (info.getPerson() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"orgPerson_is_null"));
            return;
        }
        if (info.getDept() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"orgDept_is_null"));
            return;
        }
        if (coll == null || coll.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"no_interview_position"));
            return;
        }
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            InterviewActivityEntryInfo entryInfo = coll.get(i);
            if (entryInfo.getAmount() >= 1) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"amount_is_null"));
            return;
        }
        IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
        facade.changeState(activityId, InterviewActivityEnum.submit);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        String selectedActivityId = this.getFirstSelectedActivityId();
        uiContext.put((Object)"selectedActivityId", (Object)selectedActivityId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewActivityAuditUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        int state = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirm_start_activity"));
        if (state == 0) {
            String activityId = this.getFirstSelectedActivityId();
            IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
            facade.changeState(activityId, InterviewActivityEnum.start);
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionEnd_actionPerformed(ActionEvent e) throws Exception {
        String activityId = this.getFirstSelectedActivityId();
        int state = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirm_end"));
        if (state == 0) {
            IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
            facade.changeState(activityId, InterviewActivityEnum.end);
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String activityNumber = this.getFirstSelectedActivityNumber();
        int state = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirm_abandon"));
        if (state == 0) {
            String activityId = this.getFirstSelectedActivityId();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("interviewActivity", (Object)activityId));
            fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)2));
            if (ResumeBaseFactory.getRemoteInstance().exists(fi)) {
                int state2 = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirm_interviewing_abandon"));
                if (state2 == 0) {
                    IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
                    facade.changeState(activityId, InterviewActivityEnum.abandon);
                    this.actionRefresh_actionPerformed(e);
                }
            } else {
                IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
                facade.changeState(activityId, InterviewActivityEnum.abandon);
                this.actionRefresh_actionPerformed(e);
            }
            this.dealLogInfo(activityNumber, activityId);
        }
    }

    private String getFirstSelectedActivityNumber() {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("number");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    public void actionHandlerResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        ArrayList selectedActivityIds = this.getSelectedIdValues();
        uiContext.put((Object)"billId", (Object)selectedActivityIds);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DirectAuditInfoListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        String selectedActivityId = null;
        if (this.getUIContext().get("activityId") != null && this.getUIContext().get("activityId").toString() != null) {
            selectedActivityId = this.getUIContext().get("activityId").toString();
            this.getUIContext().remove("activityId");
        } else {
            selectedActivityId = this.getFirstSelectedActivityId();
        }
        String publishInfoId = this.getPublishInfoId(selectedActivityId);
        if (publishInfoId == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"selectedActivityId", (Object)selectedActivityId);
            super.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewActivityPublishUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(InterviewActivityPublishUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)publishInfoId);
            uiContext.put((Object)"selectedActivityId", (Object)selectedActivityId);
            super.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewActivityPublishUI.class.getName(), (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(InterviewActivityPublishUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }

    public void actionSetLevel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        String selectedActivityId = this.getFirstSelectedActivityId();
        uiContext.put((Object)"selectedActivityId", (Object)selectedActivityId);
        uiContext.put((Object)"canSetLevel", (Object)this.canSetLevel);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewActivitySetLevelUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    public void actionSetResume_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        String selectedActivityId = this.getFirstSelectedActivityId();
        uiContext.put((Object)"selectedActivityId", (Object)selectedActivityId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewActivitySetResumeUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected String getEditUIName() {
        return InterviewActivityEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterviewActivityFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog cqd = super.initCommonQueryDialog();
        try {
            this.userPanel = new InterviewActivityFilterUI();
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (this.userPanel != null) {
            cqd.addUserPanel(this.userPanel);
        }
        cqd.setShowSorter(true);
        return cqd;
    }

    private String getFirstSelectedActivityId() {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private String getPublishInfoId(String interviewActivityId) {
        String id = null;
        if (interviewActivityId != null) {
            try {
                IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
                id = facade.getPublishInfoId(interviewActivityId);
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        return id;
    }

    private void initBottonState(KDTSelectEvent e) {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionAbandon.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.actionEnd.setEnabled(true);
        this.actionHandlerResult.setEnabled(true);
        this.actionPublish.setEnabled(true);
        this.actionSetLevel.setEnabled(true);
        this.actionSetResume.setEnabled(true);
        this.actionStart.setEnabled(true);
        this.actionSubmit.setEnabled(true);
        this.btnModify.setEnabled(true);
        this.menuItemModify.setEnabled(true);
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            int state = 0;
            if (row != null && row.getCell("state") != null) {
                state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
            }
            if (state != 0 && state != 8) {
                this.actionRemove.setEnabled(false);
            }
            if (state != 1 && state != 5) {
                this.actionAudit.setEnabled(false);
            }
            if (state != 4) {
                this.actionStart.setEnabled(false);
            }
            if (state != 6) {
                this.actionEnd.setEnabled(false);
                this.actionSetResume.setEnabled(false);
            }
            if (state != 7 && state != 8) {
                this.actionAttachment.setEnabled(true);
            } else {
                this.actionAttachment.setEnabled(false);
            }
            if (state != 0 && state != 5) {
                this.actionSubmit.setEnabled(false);
            }
            if (state == 7 || state == 8) {
                this.actionAbandon.setEnabled(false);
            }
            if (state == 7 || state == 8) {
                this.actionSetLevel.setEnabled(false);
                this.canSetLevel = false;
            } else {
                this.canSetLevel = true;
            }
            if (state != 4 && state != 6) {
                this.actionPublish.setEnabled(false);
            }
            if (state != 0 && state != 5) {
                this.actionEdit.setEnabled(false);
            }
            if (state != 0 && state != 8 && state != 3) continue;
            this.btnModify.setEnabled(false);
            this.menuItemModify.setEnabled(false);
        }
    }

    public boolean isPrepareInit() {
        return false;
    }

    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    public boolean isPrepareActionPublish() {
        return false;
    }

    public RequestContext prepareActionPublish(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionPublish(itemAction);
        String activityId = null;
        activityId = this.getUIContext().get("activityId") != null ? this.getUIContext().get("activityId").toString() : this.getFirstSelectedActivityId();
        request.put("activityId", (Object)activityId);
        return request;
    }

    public RequestContext prepareActionSetResume(IItemAction itemAction) throws Exception {
        return super.prepareActionSetResume(itemAction);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        String queryName = InterviewActivityListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        this.customerParams = RecUtils.getFilterUIParams(queryName, this.userPanel, ((Object)((Object)this)).getClass().getName(), this.isFirstDefaultQuery());
        this.setDipslayAdminOrgUnit();
    }

    private void setDipslayAdminOrgUnit() {
        boolean displayNameIsHide = this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().isHided();
        boolean nameIsHide = this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().isHided();
        boolean deptdisplayNameIsHide = this.tblMain.getColumn("dept.displayName").getStyleAttributes().isHided();
        boolean deptnameIsHide = this.tblMain.getColumn("dept.name").getStyleAttributes().isHided();
        if (this.customerParams != null) {
            boolean isDisplayName = this.customerParams.getBoolean("isDisplayName");
            if (isDisplayName) {
                this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(displayNameIsHide);
                this.tblMain.getColumn("dept.displayName").getStyleAttributes().setHided(deptdisplayNameIsHide);
                this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("dept.name").getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(nameIsHide);
                this.tblMain.getColumn("dept.name").getStyleAttributes().setHided(deptnameIsHide);
                this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("dept.displayName").getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("dept.displayName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("dept.name").getStyleAttributes().setHided(true);
        }
    }

    private void dealLogInfo(String loggerInfo, String activityId) throws Exception {
        if (!StringUtils.isEmpty((String)loggerInfo) && !StringUtils.isEmpty((String)activityId)) {
            IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)this.getBizType(), (IObjectPK)new ObjectUuidPK(activityId), (String)loggerInfo, (String)"rec_InterviewActivity_Abandon");
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
    }

    public boolean isPrepareActionSetResume() {
        return false;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    public boolean isPrepareActionHandlerResult() {
        return false;
    }

    public boolean isPrepareActionSetLevel() {
        return false;
    }

    public boolean isPrepareActionAddNew() {
        return false;
    }

    public boolean isPrepareActionEdit() {
        return false;
    }

    public boolean isPrepareActionView() {
        return false;
    }

    public boolean isPrepareActionRefresh() {
        return false;
    }
}

