/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.rec.ActivityRelationLevelCollection;
import com.kingdee.eas.hr.rec.ActivityRelationLevelFactory;
import com.kingdee.eas.hr.rec.ActivityRelationLevelInfo;
import com.kingdee.eas.hr.rec.IActivityRelationLevel;
import com.kingdee.eas.hr.rec.IInterviewActivityFacade;
import com.kingdee.eas.hr.rec.IInterviewLevel;
import com.kingdee.eas.hr.rec.InterviewActivityFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewLevelCollection;
import com.kingdee.eas.hr.rec.InterviewLevelFactory;
import com.kingdee.eas.hr.rec.InterviewLevelInfo;
import com.kingdee.eas.hr.rec.client.AbstractInterviewActivitySetLevelUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterviewActivitySetLevelUI
extends AbstractInterviewActivitySetLevelUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewActivitySetLevelUI.class);
    private Set selectedLevelSet = new HashSet();
    private Set oldLevelSet = new HashSet();
    String activityId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initList();
        this.customToolBar.setVisible(false);
    }

    public void initList() throws Exception {
        this.activityId = this.getUIContext().get("selectedActivityId").toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        IInterviewLevel interviewLevel = InterviewLevelFactory.getRemoteInstance();
        String sql = " where hrOrgUnit.id ='" + RecUtils.getCurrentHROrgUnit().getId().toString() + "'";
        InterviewLevelCollection ilc = interviewLevel.getInterviewLevelCollection(sql);
        int j = ilc.size();
        for (int i = 0; i < j; ++i) {
            this.listAllLevel.addElement((Object)ilc.get(i));
        }
        this.listAllLevel.setSelectionMode(2);
        IActivityRelationLevel dao = ActivityRelationLevelFactory.getRemoteInstance();
        String oql = " where InterviewActivity.Id = '" + this.activityId + "'";
        ActivityRelationLevelCollection arc = dao.getActivityRelationLevelCollection(oql);
        int j2 = arc.size();
        for (int i = 0; i < j2; ++i) {
            ActivityRelationLevelInfo info = arc.get(i);
            String levelId = info.getInterviewLevel().getId().toString();
            InterviewLevelInfo levelInfo = interviewLevel.getInterviewLevelInfo((IObjectPK)new ObjectUuidPK(levelId), sic);
            this.listSelectedLevel.addElement((Object)levelInfo);
            this.selectedLevelSet.add(levelInfo.getId());
            this.oldLevelSet.add(levelInfo.getId());
        }
        this.listSelectedLevel.setSelectionMode(2);
        if (this.getUIContext().get("canSetLevel") != null) {
            // empty if block
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAddSelected.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnRemoveSelected.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        int num = this.listAllLevel.getElementCount();
        for (int i = 0; i < num; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)this.listAllLevel.getElement(i);
            if (this.selectedLevelSet.contains(info.getId())) continue;
            this.listSelectedLevel.addElement(this.listAllLevel.getElement(i));
            this.selectedLevelSet.add(info.getId());
        }
    }

    public void actionAddSelected_actionPerformed(ActionEvent e) throws Exception {
        Object[] selectedLevels = this.listAllLevel.getSelectedValues();
        int j = selectedLevels.length;
        for (int i = 0; i < j; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)selectedLevels[i];
            if (this.selectedLevelSet.contains(info.getId())) continue;
            this.listSelectedLevel.addElement(selectedLevels[i]);
            this.selectedLevelSet.add(info.getId());
        }
    }

    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.listSelectedLevel.removeAllElements();
        this.selectedLevelSet.clear();
    }

    public void actionRemoveSelected_actionPerformed(ActionEvent e) throws Exception {
        Object[] selectedLevels = this.listSelectedLevel.getSelectedValues();
        int j = selectedLevels.length;
        for (int i = 0; i < j; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)selectedLevels[i];
            this.listSelectedLevel.removeElement((Object)info);
            this.selectedLevelSet.remove(info.getId());
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String activityId = this.getUIContext().get("selectedActivityId").toString();
        IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
        facade.setInterviewLevel(activityId, this.selectedLevelSet);
        this.oldLevelSet.clear();
        this.oldLevelSet.addAll(this.selectedLevelSet);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"save_success"));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            String activityId = this.getUIContext().get("selectedActivityId").toString();
            IInterviewActivityFacade facade = InterviewActivityFacadeFactory.getRemoteInstance();
            facade.setInterviewLevel(activityId, this.selectedLevelSet);
            this.oldLevelSet.clear();
            this.oldLevelSet.addAll(this.selectedLevelSet);
        }
        this.getUIWindow().close();
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnOk, 1001, this.btnOk.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    private boolean isModify() {
        if (this.selectedLevelSet.size() != this.oldLevelSet.size()) {
            return true;
        }
        return !this.selectedLevelSet.containsAll(this.oldLevelSet);
    }
}

