/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.InterviewException;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.client.AbstractInterviewFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterviewFilterUI
extends AbstractInterviewFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        this.prmtActivity.setEnabledMultiSelection(false);
        this.prmtActivity.setDisplayFormat("$name$");
        this.prmtActivity.setEditable(false);
        this.prmtActivity.setEnabledMultiSelection(true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        this.cbResumeState.addItem((Object)"   ");
        this.cbResumeState.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.rec.ResumeStateEnum").toArray());
        this.cbResumeState.setEditable(false);
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrg, true, false, "$name$");
        this.pkYingPDateFrom.setValue(null);
        this.pkYingPDateTo.setValue(null);
        this.prmtActivity.setEditable(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtActivity);
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDDatePicker)this.pkYingPDateFrom);
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDDatePicker)this.pkYingPDateTo);
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtPosition);
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtAdminOrg);
        Object obj = this.cbResumeState.getSelectedItem();
        if (!RecUtils.objectIsNull(obj) && obj instanceof ResumeStateEnum) {
            cp.putInt("resumeState", ((ResumeStateEnum)((Object)obj)).getValue());
        } else {
            cp.putInt("resumeState", -1);
        }
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDBizMultiLangBox)this.txtResumeBaseName);
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public boolean verify() {
        if (!RecUtils.objectIsNull(this.pkYingPDateFrom.getValue()) && !RecUtils.objectIsNull(this.pkYingPDateTo.getValue()) && ((Date)this.pkYingPDateFrom.getValue()).compareTo((Date)this.pkYingPDateTo.getValue()) > 0) {
            this.pkYingPDateTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.YINGPDATE_START_NOT_GT_END).getMessage());
            return false;
        }
        return super.verify();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtActivity, (String)InterviewActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDDatePicker)this.pkYingPDateFrom);
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDDatePicker)this.pkYingPDateTo);
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtPosition, (String)PositionInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtAdminOrg, (String)AdminOrgUnitInfo.class.getName());
        int state = cp.getInt("resumeState");
        if (state != -1) {
            this.cbResumeState.setSelectedItem((Object)ResumeStateEnum.getEnum(state));
        }
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDBizMultiLangBox)this.txtResumeBaseName);
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.pkYingPDateFrom.setValue(null);
        this.pkYingPDateTo.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.cbResumeState.setSelectedItem(null);
        this.txtResumeBaseName.setSelectedItemData(null);
        this.txtResumeBaseName.setSelectedItem(null);
        this.chkDisplayName.setSelected(true);
    }

    public FilterInfo getFilterInfo() {
        int i;
        Object[] objs;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        HashSet<String> set = null;
        int index = -1;
        StringBuffer maskString = new StringBuffer();
        Object obj = this.prmtActivity.getValue();
        if (obj != null) {
            RecUtils.buildFilterItemInfo(itemCollection, "interviewActivity.id", obj, CompareType.INCLUDE);
            ++index;
        }
        if (!RecUtils.objectIsNull(this.pkYingPDateFrom.getValue())) {
            item = new FilterItemInfo("yingPDate", (Object)((Date)this.pkYingPDateFrom.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            ++index;
        }
        if (!RecUtils.objectIsNull(this.pkYingPDateTo.getValue())) {
            Date d = (Date)this.pkYingPDateTo.getValue();
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            c.add(6, 1);
            item = new FilterItemInfo("yingPDate", (Object)c.getTime(), CompareType.LESS);
            itemCollection.add(item);
            ++index;
        }
        if (this.prmtPosition.getValue() != null && this.prmtPosition.getValue() instanceof Object[] && (objs = (Object[])this.prmtPosition.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet<String>();
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof PositionInfo)) continue;
                PositionInfo positionInfo = (PositionInfo)objs[i];
                set.add(positionInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("position.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                ++index;
            }
        }
        if (this.prmtAdminOrg.getValue() != null && this.prmtAdminOrg.getValue() instanceof Object[] && (objs = (Object[])this.prmtAdminOrg.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet();
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof AdminOrgUnitInfo)) continue;
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)objs[i];
                set.add(adminOrgUnitInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("adminOrgUnit.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                ++index;
            }
        }
        if (!RecUtils.objectIsNull(this.cbResumeState.getSelectedItem()) && this.cbResumeState.getSelectedItem() instanceof ResumeStateEnum) {
            item = new FilterItemInfo("resumeState", (Object)((ResumeStateEnum)((Object)this.cbResumeState.getSelectedItem())).getValue(), CompareType.EQUALS);
            itemCollection.add(item);
            ++index;
        }
        if (!RecUtils.objectIsNull(this.txtResumeBaseName.getSelectedItem()) && !RecUtils.objectIsNull(this.txtResumeBaseName.getSelectedItem().toString())) {
            String resumeBaseName = this.txtResumeBaseName.getSelectedItem().toString().trim();
            resumeBaseName = "%" + resumeBaseName + "%";
            item = new FilterItemInfo("name", (Object)resumeBaseName, CompareType.LIKE);
            itemCollection.add(item);
            ++index;
        }
        if (index >= 0) {
            for (int i2 = 0; i2 < index; ++i2) {
                maskString.append("#" + i2 + " and ");
            }
            maskString.append("#" + index);
            this.filterInfo.setMaskString(maskString.toString());
        }
        return this.filterInfo;
    }

    public static final class InterviewConditionSearchParam
    implements Serializable {
        public static final String YINGPDATEFROM = "yingPDateFrom";
        public static final String YINGPDATETO = "yingPDateTo";
        public static final String ADMINORGUNIT = "adminOrgUnit";
        public static final String POSITION = "position";
        public static final String RESUMESTATE = "resumeState";
        public static final String RESUMEBASENAME = "resumeBaseName";
    }
}

