/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IInterviewFacade;
import com.kingdee.eas.hr.rec.InterviewCollection;
import com.kingdee.eas.hr.rec.InterviewFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewInfo;
import com.kingdee.eas.hr.rec.InterviewRecordCollection;
import com.kingdee.eas.hr.rec.InterviewRecordInfo;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.client.AbstractInterviewHistoryRecordUI;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterviewHistoryRecordUI
extends AbstractInterviewHistoryRecordUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewHistoryRecordUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private String currentInterviewId;
    private ResumeBaseInfo resumeBaseInfo;
    private IRowSet history;
    private List compList = new ArrayList();

    public void onLoad() throws Exception {
        this.init();
        this.initIntverviewRecord();
        super.onLoad();
    }

    public void initWorkButton() {
        this.btnViewResume.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
    }

    public void nextAction_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.compList.size(); ++i) {
            this.kDPanel2.remove((Component)this.compList.get(i));
        }
        this.history.next();
        this.currentInterviewId = this.history.getObject("id").toString();
        this.initIntverviewRecord();
        this.preAction.setEnabled(true);
        if (this.history.isLast()) {
            this.nextAction.setEnabled(false);
        }
    }

    public void preAction_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.compList.size(); ++i) {
            this.kDPanel2.remove((Component)this.compList.get(i));
        }
        this.history.previous();
        this.currentInterviewId = this.history.getObject("id").toString();
        this.initIntverviewRecord();
        this.nextAction.setEnabled(true);
        if (this.history.isFirst()) {
            this.preAction.setEnabled(false);
        }
    }

    public void init() throws Exception {
        this.currentInterviewId = this.getUIContext().get("currentInterviewId").toString();
        IInterview interview = InterviewFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("resumeBase.id"));
        sic.add(new SelectorItemInfo("resumeBase.name"));
        sic.add(new SelectorItemInfo("resumeBase.gender"));
        sic.add(new SelectorItemInfo("resumeBase.age"));
        sic.add(new SelectorItemInfo("resumeBase.position.name"));
        sic.add(new SelectorItemInfo("resumeBase.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("resumeBase.highestDiploma.name"));
        sic.add(new SelectorItemInfo("resumeBase.birthday"));
        sic.add(new SelectorItemInfo("resumeBase.isInter"));
        InterviewInfo interviewInfo = interview.getInterviewInfo((IObjectPK)new ObjectUuidPK(this.currentInterviewId), sic);
        this.resumeBaseInfo = interviewInfo.getResumeBase();
        this.txtName.setText(this.resumeBaseInfo.getName());
        if (this.resumeBaseInfo.getGender() != null) {
            this.txtGender.setText(this.resumeBaseInfo.getGender().getAlias());
        }
        if (this.resumeBaseInfo.getPosition() != null) {
            this.txtPosition.setText(this.resumeBaseInfo.getPosition().getName());
        }
        if (this.resumeBaseInfo.getAdminOrgUnit() != null) {
            this.txtDepartment.setText(this.resumeBaseInfo.getAdminOrgUnit().getName());
        }
        if (this.resumeBaseInfo.getHighestDiploma() != null) {
            this.txtHighDegree.setText(this.resumeBaseInfo.getHighestDiploma().getName());
        }
        if (this.resumeBaseInfo.getAge() != 0) {
            this.txtAge.setText(String.valueOf(this.resumeBaseInfo.getAge()));
        } else if (this.resumeBaseInfo.getBirthday() != null) {
            this.txtAge.setText(String.valueOf(RecServerUtils.subTwoDate(new Date(), this.resumeBaseInfo.getBirthday())));
        }
        if (this.resumeBaseInfo.isIsInter()) {
            this.viewResumeAction.setEnabled(false);
            this.btnViewResume.setEnabled(false);
        } else {
            this.viewResumeAction.setEnabled(true);
            this.btnViewResume.setEnabled(true);
        }
        IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
        this.history = interviewFacade.getHistoryInterview(this.resumeBaseInfo.getId().toString());
        if (this.history.size() > 1) {
            this.preAction.setEnabled(false);
            this.nextAction.setEnabled(true);
        } else {
            this.preAction.setEnabled(false);
            this.nextAction.setEnabled(false);
        }
        this.history.next();
        this.currentInterviewId = this.history.getObject("id").toString();
    }

    public void initIntverviewRecord() throws Exception {
        InterviewCollection ic = this.getCureentInterview(this.currentInterviewId);
        int y = 106;
        if (ic != null && ic.size() > 0) {
            BigDecimal value = null;
            for (int i = ic.size() - 1; i < ic.size() && i >= 0; --i) {
                InterviewInfo info = ic.get(i);
                KDLabel label1 = new KDLabel("");
                if (info.getInterviewLevel() != null) {
                    label1.setText(info.getInterviewLevel().getName());
                }
                label1.setBounds(10, y += 20, 130, 20);
                this.kDPanel2.add((Component)label1);
                this.compList.add(label1);
                InterviewRecordCollection irc = info.getInterviewRecord();
                if (irc != null && irc.size() > 0) {
                    Map personPositionMap = this.initInterviewPerson(irc);
                    for (int j = 0; j < irc.size(); ++j) {
                        y += 20;
                        InterviewRecordInfo recordInfo = irc.get(j);
                        KDScrollPane scroll_person = new KDScrollPane();
                        KDTextArea textArea_person = new KDTextArea();
                        String txt = personPositionMap.containsKey(recordInfo.getPerson().getId().toString()) ? personPositionMap.get(recordInfo.getPerson().getId().toString()).toString() : personPositionMap.get("default").toString();
                        txt = recordInfo.getCommentDate() != null ? txt + EASResource.getString((String)resumeRES, (String)"date") + ": " + recordInfo.getCommentDate() : txt + EASResource.getString((String)resumeRES, (String)"date") + ": ";
                        textArea_person.setText(txt);
                        textArea_person.setEnabled(false);
                        scroll_person.setViewportView((Component)textArea_person);
                        scroll_person.setBounds(10, y, 150, 85);
                        this.compList.add(scroll_person);
                        this.kDPanel2.add((Component)scroll_person);
                        KDScrollPane scrollPane = new KDScrollPane();
                        KDTextArea t2 = new KDTextArea();
                        t2.setText(recordInfo.getInterviewComent());
                        t2.setEnabled(false);
                        scrollPane.setViewportView((Component)t2);
                        scrollPane.setBounds(165, y, 300, 85);
                        this.compList.add(scrollPane);
                        this.kDPanel2.add((Component)scrollPane);
                        KDScrollPane scroll_desc = new KDScrollPane();
                        KDTextArea ta_desc = new KDTextArea();
                        ta_desc.setText(recordInfo.getDescription());
                        ta_desc.setEnabled(false);
                        scroll_desc.setViewportView((Component)ta_desc);
                        scroll_desc.setBounds(470, y, 130, 85);
                        this.compList.add(scroll_desc);
                        this.kDPanel2.add((Component)scroll_desc);
                        value = recordInfo.getScore();
                        KDFormattedTextField tf_score = new KDFormattedTextField();
                        tf_score.setName("tf_score" + i);
                        tf_score.setDataType(1);
                        tf_score.setPrecision(2);
                        tf_score.setMinimumValue((Comparable)new BigDecimal("0"));
                        if (value != null) {
                            tf_score.setNumberValue((Number)value);
                        }
                        tf_score.setBounds(605, y, 70, 20);
                        tf_score.setEnabled(false);
                        this.compList.add(tf_score);
                        this.kDPanel2.add((Component)tf_score);
                        KDTextField t3 = new KDTextField();
                        if (recordInfo.getInterviewResult() != null) {
                            t3.setText(recordInfo.getInterviewResult().getAlias());
                        }
                        t3.setBounds(605, y + 30, 70, 20);
                        t3.setEnabled(false);
                        this.compList.add(t3);
                        this.kDPanel2.add((Component)t3);
                        KDWorkButton btnFile = new KDWorkButton();
                        btnFile.setText(EASResource.getString((String)resumeRES, (String)"attach_file"));
                        this.viewFile(btnFile, recordInfo.getId().toString());
                        btnFile.setBounds(685, y, 50, 20);
                        this.compList.add(btnFile);
                        this.kDPanel2.add((Component)btnFile);
                        y += 85;
                    }
                }
                KDSeparator separator = new KDSeparator();
                separator.setBounds(10, y += 20, 720, 10);
                this.kDPanel2.add((Component)separator);
                this.compList.add(separator);
            }
        }
        this.kDPanel2.setPreferredSize(new Dimension(750, y));
        this.kDPanel2.validate();
        this.kDPanel2.repaint();
    }

    private InterviewCollection getCureentInterview(String interviewId) throws Exception {
        IInterview interview = InterviewFactory.getRemoteInstance();
        InterviewInfo interviewInfo = interview.getInterviewInfo((IObjectPK)new ObjectUuidPK(interviewId));
        String resumeBaseId = null;
        if (interviewInfo.getResumeBase() != null) {
            resumeBaseId = interviewInfo.getResumeBase().getId().toString();
        }
        String positionId = null;
        if (interviewInfo.getPosition() != null) {
            positionId = interviewInfo.getPosition().getId().toString();
        }
        Time interviewTime = interviewInfo.getInterviewTime();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseId));
        fic.add(new FilterItemInfo("position.id", (Object)positionId));
        fic.add(new FilterItemInfo("interviewTime", (Object)interviewTime));
        entityView.setFilter(filter);
        SelectorItemCollection sic = entityView.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("interviewRecord.*"));
        sic.add(new SelectorItemInfo("interviewRecord.person.id"));
        sic.add(new SelectorItemInfo("interviewLevel.id"));
        sic.add(new SelectorItemInfo("interviewLevel.name"));
        SorterItemInfo sorterInfo = new SorterItemInfo("stepDate");
        sorterInfo.setSortType(SortType.DESCEND);
        entityView.getSorter().add(sorterInfo);
        InterviewCollection ic = interview.getInterviewCollection(entityView);
        return ic;
    }

    private Map initInterviewPerson(InterviewRecordCollection interviewRecords) throws Exception {
        String personId;
        HashMap<String, String> personPositionMap = new HashMap<String, String>();
        if (interviewRecords == null || interviewRecords.size() <= 0) {
            return personPositionMap;
        }
        IPositionMember positionMember = PositionMemberFactory.getRemoteInstance();
        HashSet<String> personIdSet = new HashSet<String>();
        StringBuffer def = new StringBuffer();
        def.append(EASResource.getString((String)resumeRES, (String)"name")).append(": ").append("").append("\n");
        def.append(EASResource.getString((String)resumeRES, (String)"position")).append(": ").append("").append("\n");
        def.append(EASResource.getString((String)resumeRES, (String)"department")).append(": ").append("").append("\n");
        personPositionMap.put("default", def.toString());
        for (int i = 0; i < interviewRecords.size(); ++i) {
            InterviewRecordInfo info = interviewRecords.get(i);
            if (info.getPerson() == null) continue;
            personId = info.getPerson().getId().toString();
            personIdSet.add(personId);
        }
        if (personIdSet.size() <= 0) {
            return personPositionMap;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = entityView.getSelector();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("person", personIdSet, CompareType.INCLUDE));
        entityView.setFilter(filter);
        PositionMemberCollection pmc = positionMember.getPositionMemberCollection(entityView);
        int n = pmc.size();
        for (int m = 0; m < n; ++m) {
            StringBuffer sb = new StringBuffer();
            PositionMemberInfo pmInfo = pmc.get(m);
            personId = pmInfo.getPerson().getId().toString();
            if (pmInfo.getPerson() != null && pmInfo.getPerson().getName() != null) {
                sb.append(EASResource.getString((String)resumeRES, (String)"name")).append(": ").append(pmInfo.getPerson().getName()).append("\n");
            } else {
                sb.append(EASResource.getString((String)resumeRES, (String)"name")).append(": ").append("").append("\n");
            }
            if (pmInfo.getPosition() != null && pmInfo.getPosition().getName() != null) {
                sb.append(EASResource.getString((String)resumeRES, (String)"position")).append(": ").append(pmInfo.getPosition().getName()).append("\n");
            } else {
                sb.append(EASResource.getString((String)resumeRES, (String)"position")).append(": ").append("").append("\n");
            }
            if (pmInfo.getPosition().getAdminOrgUnit() != null && pmInfo.getPosition().getAdminOrgUnit().getName() != null) {
                sb.append(EASResource.getString((String)resumeRES, (String)"department")).append(": ").append(pmInfo.getPosition().getAdminOrgUnit().getName()).append("\n");
            } else {
                sb.append(EASResource.getString((String)resumeRES, (String)"department")).append(": ").append("").append("\n");
            }
            personPositionMap.put(personId, sb.toString());
        }
        return personPositionMap;
    }

    private void viewFile(KDWorkButton btnFile, final String recordId) {
        btnFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                AttachmentUIContextInfo attachmentUIContextInfo = new AttachmentUIContextInfo();
                attachmentUIContextInfo.setBoID(recordId);
                attachmentUIContextInfo.setEdit(false);
                attachmentClientManager.showAttachmentListUIByBoID((Object)this, attachmentUIContextInfo);
            }
        });
    }

    public void viewResumeAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.resumeBaseInfo == null || this.resumeBaseInfo.getId() == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.resumeBaseInfo.getId().toString());
        ResumePrintProvider.executeActionPrint(list, (Component)((Object)this));
    }

    public void initUserConfig() {
    }
}

