/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.InterviewLevelInfo;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterviewMonitorFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterviewMonitorFilterUI
extends AbstractInterviewMonitorFilterUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(InterviewMonitorFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        this.prmtActivity.addDataChangeListener((DataChangeListener)this);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(6)));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(7)));
        fi.setMaskString("#0 or #1");
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        this.comboResumeStep.setSelectedIndex(-1);
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrgUnit, true, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setPersonF7(this.prmtPerson, true, false, "$name$");
        this.isInclude.setSelected(true);
        this.prmtActivity.setEditable(false);
    }

    public FilterInfo getFilterInfo() {
        Object[] objs;
        this.filterInfo = new FilterInfo();
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        Object obj = null;
        obj = this.prmtActivity.getValue();
        RecUtils.buildFilterItemInfo(fic, "interviewActivity.id", obj, CompareType.INCLUDE);
        obj = this.comboResumeStep.getSelectedItem();
        RecUtils.buildFilterItemInfo(fic, "interviewLevel.id", obj, CompareType.EQUALS);
        if (!RecUtils.objectIsNull(this.txtResumePerson.getText())) {
            item = new FilterItemInfo("resumeBase.name", (Object)("%" + this.txtResumePerson.getText().toString() + "%"), CompareType.LIKE);
            fic.add(item);
        }
        obj = this.prmtPosition.getValue();
        RecUtils.buildFilterItemInfo(fic, "position.id", obj, CompareType.INCLUDE);
        obj = this.prmtAdminOrgUnit.getValue();
        RecUtils.buildFilterItemInfo(fic, "adminOrgUnit.id", obj, CompareType.INCLUDE);
        if (this.prmtPerson.getValue() != null && this.prmtPerson.getValue() instanceof Object[] && (objs = (Object[])this.prmtPerson.getValue()).length > 0 && objs[0] != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < objs.length; ++i) {
                PersonInfo personInfo = (PersonInfo)objs[i];
                list.add(personInfo.getId().toString());
            }
            if (list.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                for (int i = 0; i < list.size(); ++i) {
                    sb.append("'");
                    sb.append(list.get(i).toString());
                    sb.append("'");
                    if (i == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append(") ");
                String sql = new String(" select interview.fid from t_hr_interviewrecord as record left outer join t_hr_interview as interview on record.finterviewid = interview.fid left outer join T_BD_Person as person on record.fpersonId = person.fid where person.fid in  " + sb.toString());
                item = new FilterItemInfo("id", (Object)sql, CompareType.INNER);
                fic.add(item);
            }
        }
        if (!this.isInclude.isSelected()) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(2));
            set.add(new Integer(1));
            fic.add(new FilterItemInfo("resumeBase.resumeState", set, CompareType.INCLUDE));
        }
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtActivity.getValue();
        cp = RecUtils.buildCustomerParams(cp, "activity", value);
        value = this.comboResumeStep.getSelectedItem();
        cp = RecUtils.buildCustomerParams(cp, "level", value);
        value = this.txtResumePerson.getText();
        cp = RecUtils.buildCustomerParams(cp, "name", value);
        value = this.prmtAdminOrgUnit.getValue();
        cp = RecUtils.buildCustomerParams(cp, "dept", value);
        value = this.prmtPosition.getValue();
        cp = RecUtils.buildCustomerParams(cp, "position", value);
        value = this.prmtPerson.getValue();
        cp = RecUtils.buildCustomerParams(cp, "person", value);
        cp.putBoolean("isInclude", this.isInclude.isSelected());
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        List<String> list;
        String[] ids;
        this.prmtActivity.setValue(null);
        this.comboResumeStep.setSelectedIndex(-1);
        this.txtResumePerson.setText(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtPerson.setValue(null);
        String str = null;
        str = cp.getCustomerParam("activity");
        if (str != null) {
            try {
                String[] ids2 = str.split("#--#");
                Object[] activitys = RecUtils.getInterviewActivitysByIDs(ids2);
                if (activitys != null) {
                    this.prmtActivity.setValue((Object)activitys);
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("level")) != null) {
            int count = this.comboResumeStep.getItemCount();
            for (int i = 1; i < count; ++i) {
                if (str.equals(((InterviewLevelInfo)this.comboResumeStep.getItemAt(i)).getId().toString())) {
                    this.comboResumeStep.setSelectedIndex(i);
                    break;
                }
                this.comboResumeStep.setSelectedIndex(0);
            }
        }
        if ((str = cp.getCustomerParam("name")) != null) {
            this.txtResumePerson.setText(str);
        }
        IRecCommonUtilFacade facade = null;
        str = cp.getCustomerParam("dept");
        if (str != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List orgs;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((orgs = facade.getBatchAdminOrgUnitByIds(list)) != null) {
                    this.prmtAdminOrgUnit.setValue((Object)orgs.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("position")) != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List positions;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((positions = facade.getBatchPositionByIds(list)) != null) {
                    this.prmtPosition.setValue((Object)positions.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("person")) != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                List persons = facade.getBatchPersonByIds(list);
                if (list != null) {
                    this.prmtPerson.setValue((Object)persons.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        this.isInclude.setSelected(cp.getBoolean("isInclude"));
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.comboResumeStep.setSelectedIndex(-1);
        this.txtResumePerson.setText(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtPerson.setValue(null);
        this.chkDisplayName.setSelected(true);
        this.isInclude.setSelected(false);
    }

    public void dataChanged(DataChangeEvent arg0) {
        Object[] objs;
        String activityIDs;
        Object[] levels;
        Object obj = this.prmtActivity.getValue();
        this.comboResumeStep.removeAllItems();
        if (obj != null && (levels = this.getInterviewLevelByActId(activityIDs = this.getIDsByInterviewActivity(objs = (Object[])obj))) != null && levels.length > 0) {
            this.comboResumeStep.addItem((Object)"");
            this.comboResumeStep.addItems(this.getInterviewLevelByActId(activityIDs));
        }
    }

    private String getIDsByInterviewActivity(Object[] acts) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < acts.length; ++i) {
            strBuffer.append("'");
            strBuffer.append(((InterviewActivityInfo)acts[i]).getId());
            strBuffer.append("'");
            if (i == acts.length - 1) continue;
            strBuffer.append(",");
        }
        return strBuffer.toString();
    }

    private Object[] getInterviewLevelByActId(String ids) {
        StringBuffer strBuffer = new StringBuffer();
        String locale = LocaleUtils.getDefaultLocale().toString();
        strBuffer.append(" select DISTINCT interviewLevel.FID FID,interviewLevel.fname_");
        strBuffer.append(locale);
        strBuffer.append(" FName");
        strBuffer.append(" FROM T_HR_ActivityRelationLevel relation  ");
        strBuffer.append(" INNER JOIN T_HR_InterviewLevel interviewLevel");
        strBuffer.append(" ON relation.FinterviewlevelID=interviewLevel.FID inner join T_HR_InterviewActivity activity");
        strBuffer.append(" ON relation.FInterviewActivityID=activity.FID");
        if (ids != null && ids.length() > 0) {
            strBuffer.append(" where activity.FID in (");
            strBuffer.append(ids);
            strBuffer.append(" )");
        }
        ArrayList<InterviewLevelInfo> interviewLevels = new ArrayList<InterviewLevelInfo>();
        InterviewLevelInfo level = null;
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)strBuffer.toString()).executeSQL();
            while (rs.next()) {
                level = new InterviewLevelInfo();
                String id = rs.getString("FID");
                String name = rs.getString("FName");
                level.setId(BOSUuid.read((String)id));
                level.setName(name);
                interviewLevels.add(level);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return interviewLevels.toArray();
    }
}

