/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.rec.IInterviewFacade;
import com.kingdee.eas.hr.rec.InterviewFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewInfo;
import com.kingdee.eas.hr.rec.client.AbstractInterviewMonitorListUI;
import com.kingdee.eas.hr.rec.client.InterviewHistoryRecordEditUI;
import com.kingdee.eas.hr.rec.client.InterviewHistoryStepUI;
import com.kingdee.eas.hr.rec.client.InterviewMonitorFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterviewMonitorListUI
extends AbstractInterviewMonitorListUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewMonitorListUI.class);
    private KDPanel userPanel = null;
    private CustomerParams customerParams;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        RecUtils.checkValidPerson((CoreUI)this);
        super.onLoad();
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            this.defaultFilterFlag = TrainUtils.hasDefaultSolution((IMetaDataPK)this.mainQueryPK, (String)this.getMetaDataPK().getFullName());
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        String queryName = InterviewMonitorListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        this.customerParams = RecUtils.getFilterUIParams(queryName, this.userPanel, this.getMetaDataPK().getFullName(), this.isFirstDefaultQuery());
    }

    private void setDipslayAdminOrgUnit() {
        boolean displayNameIsHide = this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().isHided();
        boolean nameIsHide = this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().isHided();
        if (this.customerParams != null) {
            boolean isDisplayName = this.customerParams.getBoolean("isDisplayName");
            if (isDisplayName) {
                this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(displayNameIsHide);
                this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(nameIsHide);
                this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnModifyInterview.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnViewInterview.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuItemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
    }

    public void modifyAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        if (list != null && list.size() > 0) {
            String resumeState = "";
            if (!RecUtils.objectIsNull(this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.resumeState").getValue())) {
                resumeState = this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.resumeState").getValue().toString();
            }
            String personID = null;
            if (this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.personID").getValue() != null) {
                personID = this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.personID").getValue().toString();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"resumeBase.personID", personID);
            uiContext.put((Object)"resumeState", (Object)resumeState);
            uiContext.put((Object)"currentInterviewId", list.get(0));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewHistoryRecordEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
        }
    }

    public void viewAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        if (list != null && list.size() > 0) {
            String resumeState = "";
            int selectedIndex = RecUtils.getSelectedRow(this.tblMain);
            if (!RecUtils.objectIsNull(this.tblMain.getCell(selectedIndex, "resumeBase.resumeState").getValue())) {
                resumeState = this.tblMain.getCell(selectedIndex, "resumeBase.resumeState").getValue().toString();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"resumeState", (Object)resumeState);
            if (list.get(0) != null) {
                String interViewId = list.get(0).toString();
                InterviewInfo info = InterviewFactory.getRemoteInstance().getInterviewInfo((IObjectPK)new ObjectUuidPK(interViewId));
                if (info != null && info.getInterviewActivity() != null) {
                    uiContext.put((Object)"currentActivityId", (Object)info.getInterviewActivity().getId());
                }
            }
            uiContext.put((Object)"currentInterviewId", list.get(0));
            String resumeBaseId = (String)this.tblMain.getCell(selectedIndex, "resumeBase.id").getValue();
            if (!RecUtils.objectIsNull(resumeBaseId)) {
                uiContext.put((Object)"currentResumeBaseId", (Object)resumeBaseId);
            }
            String personID = null;
            if (this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.personID").getValue() != null) {
                personID = this.tblMain.getCell(RecUtils.getSelectedRow(this.tblMain), "resumeBase.personID").getValue().toString();
            }
            uiContext.put((Object)"resumeBase.personID", personID);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewHistoryStepUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog cqd = super.initCommonQueryDialog();
        if (this.userPanel == null) {
            try {
                this.userPanel = new InterviewMonitorFilterUI();
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        cqd.addUserPanel(this.userPanel);
        cqd.setShowSorter(true);
        return cqd;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() < 2) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterviewFactory.getRemoteInstance();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                list.add(rowSet.getString("id"));
            }
            IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
            Map map = interviewFacade.getInterviewPerson(list);
            if (map != null && map.size() == list.size()) {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    rowSet.updateString("person", map.get(rowSet.getString("person")).toString());
                }
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVITE_MANAGEMENT;
    }

    public FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = RecUtils.getHRAndAdminRangeFilterInfo("activityAdminOrgUnit.id");
        return filter;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        RecUtils.setColHidden(this.tblMain, this.userPanel, InterviewMonitorListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName(), this.getMetaDataPK().getFullName(), this.isFirstDefaultQuery());
    }
}

