/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterviewResultFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterviewResultFilterUI
extends AbstractInterviewResultFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewResultFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtActivity.setRequired(true);
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)6));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)7));
        fi.setMaskString("#0 or #1");
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtDept, true, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        this.prmtActivity.setEditable(false);
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.prmtDept.setValue(null);
        this.prmtPosition.setValue(null);
        this.txtName.setText("");
        this.chkDisplayName.setSelected(true);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildCustomerParams(cp, "activity", obj);
        obj = this.txtName.getText();
        RecUtils.buildCustomerParams(cp, "name", obj);
        obj = this.prmtDept.getValue();
        RecUtils.buildCustomerParams(cp, "dept", obj);
        obj = this.prmtPosition.getValue();
        RecUtils.buildCustomerParams(cp, "position", obj);
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildFilterItemInfo(fic, "interviewActivity.id", obj, CompareType.EQUALS);
        obj = this.prmtDept.getValue();
        RecUtils.buildFilterItemInfo(fic, "adminOrgUnit.id", obj, CompareType.INCLUDE);
        obj = this.prmtPosition.getValue();
        RecUtils.buildFilterItemInfo(fic, "position.id", obj, CompareType.INCLUDE);
        String name = this.txtName.getText().trim();
        if (name != null && name.length() > 0) {
            fic.add(new FilterItemInfo("resumeBase.name", (Object)("%" + name + "%"), CompareType.LIKE));
        }
        return fi;
    }

    public void setCustomerParams(CustomerParams cp) {
        List<String> list;
        String[] ids;
        this.prmtActivity.setValue(null);
        this.prmtDept.setValue(null);
        this.prmtPosition.setValue(null);
        this.txtName.setText("");
        String str = cp.getCustomerParam("activity");
        if (str != null) {
            try {
                InterviewActivityInfo info = InterviewActivityFactory.getRemoteInstance().getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(str));
                this.prmtActivity.setValue((Object)info);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("name")) != null) {
            this.txtName.setText(str);
        }
        IRecCommonUtilFacade facade = null;
        str = cp.getCustomerParam("dept");
        if (str != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List orgs;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((orgs = facade.getBatchAdminOrgUnitByIds(list)) != null) {
                    this.prmtDept.setValue((Object)orgs.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("position")) != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List positions;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((positions = facade.getBatchPositionByIds(list)) != null) {
                    this.prmtPosition.setValue((Object)positions.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public boolean verify() {
        Object obj = this.prmtActivity.getValue();
        if (obj == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"activity_is_null"));
            this.prmtActivity.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

