/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.rec.ActivityRelationLevelCollection;
import com.kingdee.eas.hr.rec.ActivityRelationLevelFactory;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractInterviewScoreFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterviewScoreFilterUI
extends AbstractInterviewScoreFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewScoreFilterUI.class);

    public void onLoad() throws Exception {
        this.kdtLevel.checkParsed();
        this.kdtLevel.getDataRequestManager().setDataRequestMode(0);
        super.onLoad();
        this.prmtActivity.setRequired(true);
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)6));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)7));
        fi.setMaskString("#0 or #1");
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrgUnit, true, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setPersonF7(this.prmtPerson, true, false, "$name$");
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)box);
        this.kdtLevel.getColumn("selected").setEditor((ICellEditor)cellEditor);
        this.kdtLevel.getColumn("selected").setWidth(50);
        this.kdtLevel.getColumn("interviewLevel").setWidth(190);
        this.prmtActivity.addDataChangeListener((DataChangeListener)new ActivityChange());
        this.btnUp.setActionCommand("up");
        this.btnUp.addActionListener((ActionListener)new Action());
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setActionCommand("down");
        this.btnDown.addActionListener((ActionListener)new Action());
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdtLevel.getSelectManager().setSelectMode(2);
        this.prmtActivity.setEditable(false);
        this.prmtPerson.setVisible(false);
        this.prmtPerson.setEnabled(false);
        this.contPerson.setVisible(false);
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.txtName.setSelectedItemData(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtPerson.setValue(null);
        this.chkDisplayName.setSelected(true);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtActivity.getValue();
        cp = RecUtils.buildCustomerParams(cp, "activity", value);
        if (this.kdtLevel.getRowCount() > 0) {
            StringBuffer ids = new StringBuffer();
            int j = this.kdtLevel.getRowCount();
            for (int i = 0; i < j; ++i) {
                String id = this.kdtLevel.getCell(i, "id").getValue().toString();
                cp.addCustomerParam(id + "_selected", this.kdtLevel.getCell(i, "selected").getValue().toString());
                cp.addCustomerParam(id + "_index", String.valueOf(i));
                ids.append(id).append("#--#");
            }
        }
        value = this.txtName.getSelectedItemData();
        cp = RecUtils.buildCustomerParams(cp, "name", value);
        value = this.prmtAdminOrgUnit.getValue();
        cp = RecUtils.buildCustomerParams(cp, "dept", value);
        value = this.prmtPosition.getValue();
        cp = RecUtils.buildCustomerParams(cp, "position", value);
        value = String.valueOf(this.chkDisplayName.isSelected());
        cp = RecUtils.buildCustomerParams(cp, "isDisplayName", value);
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo item = null;
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildFilterItemInfo(fic, "interviewActivity.id", obj, CompareType.EQUALS);
        if (!RecUtils.objectIsNull(this.txtName.getSelectedItem())) {
            item = new FilterItemInfo("resumeBase.name", (Object)("%" + this.txtName.getSelectedItem().toString() + "%"), CompareType.LIKE);
            fic.add(item);
        }
        obj = this.prmtPosition.getValue();
        RecUtils.buildFilterItemInfo(fic, "position.id", obj, CompareType.INCLUDE);
        obj = this.prmtAdminOrgUnit.getValue();
        RecUtils.buildFilterItemInfo(fic, "adminOrgUnit.id", obj, CompareType.INCLUDE);
        FilterInfo filterInfo = new FilterInfo();
        if (this.kdtLevel.getRowCount() > 0) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            int j = this.kdtLevel.getRowCount();
            for (int i = 0; i < j; ++i) {
                Boolean selected = (Boolean)this.kdtLevel.getCell(i, "selected").getValue();
                if (selected == null || !selected.booleanValue()) continue;
                set.add(this.kdtLevel.getCell(i, "id").getValue().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("interviewLevel.id", set, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("interviewLevel.id", null, CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1");
            try {
                fi.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        return fi;
    }

    public void setCustomerParams(CustomerParams cp) {
        List<String> list;
        String[] ids;
        this.prmtActivity.setValue(null);
        this.txtName.setSelectedItemData(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtPerson.setValue(null);
        String str = null;
        str = cp.getCustomerParam("activity");
        if (str != null) {
            try {
                InterviewActivityInfo info = InterviewActivityFactory.getRemoteInstance().getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(str));
                this.prmtActivity.setValue((Object)info);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if (this.kdtLevel.getRowCount() > 0) {
            String index = null;
            int j = this.kdtLevel.getRowCount();
            for (int i = 0; i < j; ++i) {
                int myIndex = 0;
                String id = this.kdtLevel.getCell(i, "id").getValue().toString();
                String selected = cp.getCustomerParam(id + "_selected").toString();
                if ("true".equals(selected)) {
                    this.kdtLevel.getCell(i, "selected").setValue((Object)true);
                } else {
                    this.kdtLevel.getCell(i, "selected").setValue((Object)false);
                }
                IRow row = this.kdtLevel.getRow(i);
                index = cp.getCustomerParam(id + "_index").toString();
                while (myIndex < j && !index.equals(String.valueOf(myIndex))) {
                    ++myIndex;
                }
                IRow myRow = this.kdtLevel.getRow(myIndex);
                if (index.equals(String.valueOf(i))) continue;
                this.kdtLevel.removeRow(i);
                this.kdtLevel.addRow(i, myRow);
                this.kdtLevel.removeRow(myIndex);
                this.kdtLevel.addRow(myIndex, row);
            }
        }
        if ((str = cp.getCustomerParam("name")) != null) {
            this.txtName.setSelectedItemData((Object)str);
        }
        IRecCommonUtilFacade facade = null;
        str = cp.getCustomerParam("dept");
        if (str != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List orgs;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((orgs = facade.getBatchAdminOrgUnitByIds(list)) != null) {
                    this.prmtAdminOrgUnit.setValue((Object)orgs.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("position")) != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List positions;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((positions = facade.getBatchPositionByIds(list)) != null) {
                    this.prmtPosition.setValue((Object)positions.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public boolean verify() {
        Object activity = this.prmtActivity.getValue();
        if (activity == null) {
            this.prmtActivity.requestFocusInWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"18_InterviewScoreFilterUI"));
            return false;
        }
        boolean isSelectedLevel = false;
        int j = this.kdtLevel.getRowCount();
        for (int i = 0; i < j; ++i) {
            Boolean selected = (Boolean)this.kdtLevel.getCell(i, "selected").getValue();
            if (selected == null || !selected.booleanValue()) continue;
            isSelectedLevel = true;
            break;
        }
        if (!isSelectedLevel) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"19_InterviewScoreFilterUI"));
            return false;
        }
        return true;
    }

    public class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int index;
            String command;
            if (InterviewScoreFilterUI.this.kdtLevel.getRowCount() == 0 || InterviewScoreFilterUI.this.kdtLevel.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)InterviewScoreFilterUI.this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if ("up".equals(command = e.getActionCommand())) {
                int index2 = KDTableUtil.getSelectedRow((KDTable)InterviewScoreFilterUI.this.kdtLevel);
                if (index2 > 0) {
                    IRow row = InterviewScoreFilterUI.this.kdtLevel.getRow(index2);
                    InterviewScoreFilterUI.this.kdtLevel.addRow(index2 - 1, row);
                    InterviewScoreFilterUI.this.kdtLevel.removeRow(index2 + 1);
                    InterviewScoreFilterUI.this.kdtLevel.getSelectManager().select(index2 - 1, 1);
                }
            } else if ("down".equals(command) && (index = KDTableUtil.getSelectedRow((KDTable)InterviewScoreFilterUI.this.kdtLevel)) < InterviewScoreFilterUI.this.kdtLevel.getRowCount() - 1) {
                IRow row = InterviewScoreFilterUI.this.kdtLevel.getRow(++index);
                InterviewScoreFilterUI.this.kdtLevel.addRow(index - 1, row);
                InterviewScoreFilterUI.this.kdtLevel.removeRow(index + 1);
                InterviewScoreFilterUI.this.kdtLevel.getSelectManager().select(index, 1);
            }
        }
    }

    private class ActivityChange
    implements DataChangeListener {
        private ActivityChange() {
        }

        public void dataChanged(DataChangeEvent arg0) {
            InterviewScoreFilterUI.this.kdtLevel.removeRows();
            Object obj = InterviewScoreFilterUI.this.prmtActivity.getValue();
            if (obj != null) {
                InterviewActivityInfo info = (InterviewActivityInfo)obj;
                try {
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)info.getId().toString()));
                    SelectorItemCollection sic = evi.getSelector();
                    sic.add(new SelectorItemInfo("interviewLevel.*"));
                    evi.setFilter(fi);
                    ActivityRelationLevelCollection coll = ActivityRelationLevelFactory.getRemoteInstance().getActivityRelationLevelCollection(evi);
                    int j = coll.size();
                    for (int i = 0; i < j; ++i) {
                        String levelId = coll.get(i).getInterviewLevel().getId().toString();
                        IRow row = InterviewScoreFilterUI.this.kdtLevel.addRow();
                        row.getCell("selected").setValue((Object)true);
                        row.getCell("interviewLevel").setValue((Object)coll.get(i).getInterviewLevel().getName());
                        row.getCell("id").setValue((Object)levelId);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                InterviewScoreFilterUI.this.kdtLevel.removeRows();
            }
        }
    }
}

