/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.rec.IRecCommonUtilFacade;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.InterviewLevelFactory;
import com.kingdee.eas.hr.rec.InterviewLevelInfo;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.client.AbstractInterviewStepFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InterviewStepFilterUI
extends AbstractInterviewStepFilterUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(InterviewStepFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtActivity.setRequired(true);
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        this.prmtActivity.addDataChangeListener((DataChangeListener)this);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)6));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)7));
        fi.setMaskString("#0 or #1");
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrg, true, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        this.comboState.addItem((Object)"");
        this.comboState.addItem((Object)ResumeStateEnum.no_interview);
        this.comboState.addItem((Object)ResumeStateEnum.interviewing);
        this.comboState.addItem((Object)ResumeStateEnum.no_pass);
        this.comboState.addItem((Object)ResumeStateEnum.pass);
        this.comboState.addItem((Object)ResumeStateEnum.entryed);
        this.comboState.addItem((Object)ResumeStateEnum.changed);
        this.comboState.addItem((Object)ResumeStateEnum.pass_in_hireApp);
        this.comboState.addItem((Object)ResumeStateEnum.hireApp_aduit);
        this.prmtActivity.setEditable(false);
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.comboLevel.setSelectedIndex(-1);
        this.txtName.setSelectedItemData(null);
        this.comboState.setSelectedIndex(0);
        this.chkDisplayName.setSelected(true);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildCustomerParams(cp, "activity", obj);
        obj = this.comboLevel.getSelectedItem();
        RecUtils.buildCustomerParams(cp, "level", obj);
        obj = this.txtName.getSelectedItemData();
        RecUtils.buildCustomerParams(cp, "name", obj);
        obj = this.prmtAdminOrg.getValue();
        RecUtils.buildCustomerParams(cp, "dept", obj);
        obj = this.prmtPosition.getValue();
        RecUtils.buildCustomerParams(cp, "position", obj);
        obj = this.comboState.getSelectedItem();
        if (obj != null && obj instanceof ResumeStateEnum) {
            ResumeStateEnum rse = (ResumeStateEnum)((Object)obj);
            RecUtils.buildCustomerParams(cp, "state", String.valueOf(rse.getValue()));
        }
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        String name;
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        Object obj = this.prmtActivity.getValue();
        RecUtils.buildFilterItemInfo(fic, "interviewActivity.id", obj, CompareType.EQUALS);
        obj = this.comboLevel.getSelectedItem();
        RecUtils.buildFilterItemInfo(fic, "interviewLevel.id", obj, CompareType.EQUALS);
        obj = this.prmtAdminOrg.getValue();
        RecUtils.buildFilterItemInfo(fic, "adminOrgUnit.id", obj, CompareType.INCLUDE);
        obj = this.prmtPosition.getValue();
        RecUtils.buildFilterItemInfo(fic, "position.id", obj, CompareType.INCLUDE);
        obj = this.comboState.getSelectedItem();
        RecUtils.buildFilterItemInfo(fic, "resumeBase.resumeState", obj, CompareType.EQUALS);
        if (this.txtName.getSelectedItem() != null && (name = this.txtName.getSelectedItem().toString()).trim().length() > 0) {
            fic.add(new FilterItemInfo("resumeBase.name", (Object)("%" + name + "%"), CompareType.LIKE));
        }
        if ((obj = this.comboState.getSelectedItem()) != null && obj instanceof ResumeStateEnum) {
            ResumeStateEnum rse = (ResumeStateEnum)((Object)obj);
            fic.add(new FilterItemInfo("resumeBase.resumeState", (Object)rse.getValue()));
        }
        return fi;
    }

    public void setCustomerParams(CustomerParams cp) {
        List<String> list;
        String[] ids;
        this.prmtActivity.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.txtName.setSelectedItemData(null);
        this.comboState.setSelectedIndex(0);
        String str = cp.getCustomerParam("activity");
        if (str != null) {
            try {
                InterviewActivityInfo info = InterviewActivityFactory.getRemoteInstance().getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(str));
                this.prmtActivity.setValue((Object)info);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("level")) != null) {
            try {
                InterviewLevelInfo levelInfo = InterviewLevelFactory.getRemoteInstance().getInterviewLevelInfo((IObjectPK)new ObjectUuidPK(str));
                this.comboLevel.setSelectedItem((Object)levelInfo);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("name")) != null) {
            this.txtName.setSelectedItemData((Object)str);
        }
        IRecCommonUtilFacade facade = null;
        str = cp.getCustomerParam("dept");
        if (str != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List orgs;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((orgs = facade.getBatchAdminOrgUnitByIds(list)) != null) {
                    this.prmtAdminOrg.setValue((Object)orgs.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("position")) != null) {
            ids = str.split("#--#");
            list = Arrays.asList(ids);
            try {
                List positions;
                if (facade == null) {
                    facade = RecCommonUtilFacadeFactory.getRemoteInstance();
                }
                if ((positions = facade.getBatchPositionByIds(list)) != null) {
                    this.prmtPosition.setValue((Object)positions.toArray());
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if ((str = cp.getCustomerParam("state")) != null) {
            try {
                ResumeStateEnum state = ResumeStateEnum.getEnum(Integer.parseInt(str));
                this.comboState.setSelectedItem((Object)state);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public boolean verify() {
        Object obj = this.prmtActivity.getValue();
        if (obj == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"activity_is_null"));
            this.prmtActivity.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void dataChanged(DataChangeEvent event) {
        Object obj = this.prmtActivity.getValue();
        if (obj != null) {
            InterviewActivityInfo info = (InterviewActivityInfo)obj;
            try {
                RecUtils.initInterviewLevelCombo(this.comboLevel, info.getId().toString());
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        } else {
            this.comboLevel.removeAllItems();
        }
    }
}

