/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.rec.InterviewCollection;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewRecordFactory;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.client.AbstractIntroducerInfoUI;
import com.kingdee.eas.hr.rec.client.InterviewRecordListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntroducerInfoUI
extends AbstractIntroducerInfoUI {
    private static final Logger logger = CoreUIObject.getLogger(IntroducerInfoUI.class);
    private EmployeeTreeEditUI treeEditUI = null;
    private String recordId = null;
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";

    public void storeFields() {
        super.storeFields();
    }

    protected void inOnload() throws Exception {
        this.loadFields();
    }

    public void onLoad() throws Exception {
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        super.onLoad();
    }

    public void initLayout() {
        super.initLayout();
        this.btnEdit.setVisible(false);
        this.btnSubmit.setEnabled(true);
        this.txtIntroducer.setEditable(true);
        this.txtIntroducerBg.setEditable(true);
        this.txtRelationToIntr.setEditable(true);
        this.actionSubmit.setVisible(false);
        this.contIntroducer.setEnabled(false);
        this.contIntroducerBg.setEnabled(false);
        this.contRelationToIntr.setEnabled(false);
        this.tblInterviewCode.setEditable(false);
        this.btnInterviewRecord.setEnabled(true);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            this.recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (this.recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("personID", (Object)this.recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            ResumeBaseCollection rbCol = ResumeBaseFactory.getRemoteInstance().getResumeBaseCollection(view);
            if (rbCol.size() <= 0) {
                this.editData = (ResumeBaseInfo)this.createNewData();
                PersonInfo recordInfo = new PersonInfo();
                recordInfo.setId(BOSUuid.read((String)this.recordId));
                this.editData.setPersonID(this.recordId);
            } else {
                this.editData = rbCol.get(0);
                this.setOprtState(OprtState.EDIT);
                this.showMessageForStatus();
            }
            this.setDataObject((IObjectValue)this.editData);
        }
        return this.editData;
    }

    public void loadFields() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        }
        try {
            this.getValue(null);
            super.loadFields();
            this.initQuery();
            this.addInterviewFlow();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected IObjectValue createNewData() {
        ResumeBaseInfo rbinfo = new ResumeBaseInfo();
        return rbinfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ResumeBaseFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    private void initQuery() {
        this.tblInterviewCode.checkParsed();
        if (this.interviewRecodeQuery == null) {
            this.interviewRecodeQuery = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.Id", (Object)this.recordId, CompareType.EQUALS));
        this.interviewRecodeQuery.setFilter(filter);
        this.tblInterviewCode.removeRows();
    }

    public void addInterviewFlow() throws BOSException {
        String interviewActivityId = null;
        String resumeBaseID = null;
        try {
            resumeBaseID = this.getSelectedResumeBaseId();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        int j = this.tblInterviewCode.getRowCount();
        for (int i = 0; i < j; ++i) {
            if (this.tblInterviewCode.getCell(i, "interviewId").getValue() == null) continue;
            interviewActivityId = this.tblInterviewCode.getCell(i, "interviewId").getValue().toString();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseID));
            fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)interviewActivityId));
            SelectorItemCollection sic = evi.getSelector();
            sic.add(new SelectorItemInfo("interviewLevel.name"));
            evi.setFilter(fi);
            InterviewCollection coll = InterviewFactory.getRemoteInstance().getInterviewCollection(evi);
            StringBuffer interName = new StringBuffer();
            int n = coll.size();
            for (int k = 0; k < n; ++k) {
                String levelName = coll.get(k).getInterviewLevel().getName();
                if (k < n - 1) {
                    interName.append(levelName).append("--");
                    continue;
                }
                interName.append(levelName);
            }
            this.tblInterviewCode.getCell(i, "interviewLevel").setValue((Object)interName.toString());
        }
    }

    public void actionInterviewRecord_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedResumeBaseId();
        if (!StringUtils.isEmpty((String)id)) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"currentResumeBaseId", (Object)id);
            uiContext.put((Object)"resumeBase.personID", (Object)this.recordId);
            IUIWindow uiWindow = UIFactory.createUIFactory().create(InterviewRecordListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
        }
    }

    private String getSelectedResumeBaseId() throws EASBizException, BOSException {
        String personId = this.recordId;
        FilterInfo filterResumeBase = new FilterInfo();
        String resumeBaseID = null;
        if (!StringUtils.isEmpty((String)personId)) {
            filterResumeBase.getFilterItems().add(new FilterItemInfo("personID", (Object)personId, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterResumeBase);
            ResumeBaseCollection resumeBaseCol = ResumeBaseFactory.getRemoteInstance().getResumeBaseCollection(evi);
            if (resumeBaseCol.size() >= 1) {
                resumeBaseID = resumeBaseCol.get(0).getId().toString();
            }
            StringBuffer InterviewRecordSQL = new StringBuffer();
            InterviewRecordSQL.append("SELECT FID FROM T_HR_InterviewRecord WHERE FInterviewID IN ");
            InterviewRecordSQL.append("( SELECT FID FROM T_HR_Interview WHERE FResumeBaseID = ");
            InterviewRecordSQL.append("'");
            InterviewRecordSQL.append(resumeBaseID);
            InterviewRecordSQL.append("')");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)InterviewRecordSQL.toString(), CompareType.INNER));
            if (!InterviewRecordFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noRecord_beforeEntry"));
                SysUtil.abort();
            }
        }
        return resumeBaseID;
    }
}

