/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IInterviewFacade;
import com.kingdee.eas.hr.rec.InterviewEntryCollection;
import com.kingdee.eas.hr.rec.InterviewEntryFactory;
import com.kingdee.eas.hr.rec.InterviewEntryInfo;
import com.kingdee.eas.hr.rec.InterviewFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewInfo;
import com.kingdee.eas.hr.rec.InterviewRecordCollection;
import com.kingdee.eas.hr.rec.InterviewRecordFactory;
import com.kingdee.eas.hr.rec.InterviewRecordInfo;
import com.kingdee.eas.hr.rec.InterviewResultEnum;
import com.kingdee.eas.hr.rec.InterviewStepMagageFacadeFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.client.AbstractMyInterviewUI;
import com.kingdee.eas.hr.rec.client.InterviewHistorySelfStepUI;
import com.kingdee.eas.hr.rec.client.ProgressManager;
import com.kingdee.eas.hr.rec.client.ResumeExtendEditUI;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MyInterviewUI
extends AbstractMyInterviewUI {
    private static final Logger logger = CoreUIObject.getLogger(MyInterviewUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.ResumeResource";
    private static final String RESC = "com.kingdee.eas.hr.rec.client.InterviewRecordResource";
    private static final String RES_INTERVIEW = "com.kingdee.eas.hr.rec.client.InterviewStepResource";
    private String currentInterviewId;
    private String currentRecordId;
    private String currentEntryId;
    private boolean isRecorded;
    private String resumeBaseId;
    private String procInstID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void initWorkButton() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnInterviewRecordAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnViewInterview.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.btnViewResume.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    public void init() throws Exception {
        this.currentInterviewId = this.getUIContext().get("currentInterviewId").toString();
        if (this.currentInterviewId == null || this.currentInterviewId.trim().length() <= 0) {
            return;
        }
        this.updateInterviewer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo == null) {
            return;
        }
        PersonInfo pInfo = userInfo.getPerson();
        if (pInfo == null) {
            return;
        }
        fInfo.getFilterItems().add(new FilterItemInfo("interview.id", (Object)this.currentInterviewId));
        fInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString()));
        evi.setFilter(fInfo);
        EntityViewInfo recordView = new EntityViewInfo();
        FilterInfo recordFilter = new FilterInfo();
        recordFilter.getFilterItems().add(new FilterItemInfo("interview.id", (Object)this.currentInterviewId));
        recordFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString()));
        recordView.setFilter(recordFilter);
        SorterItemInfo sorterInfo = new SorterItemInfo("interviewResult");
        sorterInfo.setSortType(SortType.ASCEND);
        recordView.getSorter().add(sorterInfo);
        SorterItemInfo sorterInfo1 = new SorterItemInfo("score");
        sorterInfo.setSortType(SortType.ASCEND);
        recordView.getSorter().add(sorterInfo1);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("interviewRecord.*"));
        sic.add(new SelectorItemInfo("interviewEntry.*"));
        sic.add(new SelectorItemInfo("resumeBase.id"));
        sic.add(new SelectorItemInfo("resumeBase.name"));
        sic.add(new SelectorItemInfo("resumeBase.gender"));
        sic.add(new SelectorItemInfo("resumeBase.age"));
        sic.add(new SelectorItemInfo("resumeBase.position.name"));
        sic.add(new SelectorItemInfo("resumeBase.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("resumeBase.highestDiploma.name"));
        sic.add(new SelectorItemInfo("resumeBase.birthday"));
        IInterview interview = InterviewFactory.getRemoteInstance();
        InterviewInfo interviewInfo = (InterviewInfo)interview.getValue((IObjectPK)new ObjectUuidPK(this.currentInterviewId), sic);
        ResumeBaseInfo resumeBaseInfo = interviewInfo.getResumeBase();
        if (resumeBaseInfo != null && resumeBaseInfo.getId() != null) {
            this.resumeBaseId = resumeBaseInfo.getId().toString();
        }
        InterviewRecordCollection irc = InterviewRecordFactory.getRemoteInstance().getInterviewRecordCollection(recordView);
        InterviewEntryCollection iec = InterviewEntryFactory.getRemoteInstance().getInterviewEntryCollection(evi);
        InterviewRecordInfo rInfo = null;
        InterviewEntryInfo eInfo = null;
        this.textScore.setDataType(1);
        this.textScore.setPrecision(2);
        this.textScore.setMinimumValue((Comparable)new BigDecimal(0));
        if (irc != null && irc.size() > 0) {
            rInfo = irc.get(0);
            this.currentRecordId = rInfo.getId().toString();
        }
        if (iec != null && iec.size() > 0) {
            eInfo = iec.get(0);
            this.isRecorded = eInfo.isIsRecorded();
            this.currentEntryId = eInfo.getId().toString();
            this.procInstID = eInfo.getProcInstID();
        }
        if (eInfo != null && !this.isRecorded) {
            this.txtInterviewComent.setText(eInfo.getInterviewComent());
            if (eInfo.getScore() != null) {
                this.textScore.setNumberValue((Number)eInfo.getScore());
            } else {
                this.textScore.setNumberValue((Number)new BigDecimal(0));
            }
            this.textDesc.setText(eInfo.getDescription());
            this.combInterviewResult.setSelectedItem((Object)eInfo.getInterviewResult());
            if (!eInfo.isIsRecorded()) {
                this.txtInterviewComent.setEditable(true);
                this.combInterviewResult.setEnabled(true);
                this.textDesc.setEnabled(true);
                this.textScore.setEnabled(true);
                this.btnSave.setEnabled(true);
                this.btnSubmit.setEnabled(true);
            } else {
                this.txtInterviewComent.setEditable(false);
                this.combInterviewResult.setEnabled(false);
                this.textDesc.setEnabled(false);
                this.textScore.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            }
        } else if (rInfo != null) {
            this.txtInterviewComent.setText(rInfo.getInterviewComent());
            if (rInfo.getScore() != null) {
                this.textScore.setNumberValue((Number)rInfo.getScore());
            } else {
                this.textScore.setNumberValue((Number)new BigDecimal(0));
            }
            this.textDesc.setText(rInfo.getDescription());
            this.txtInterviewComent.setMaxLength(1000);
            this.combInterviewResult.setSelectedItem((Object)rInfo.getInterviewResult());
            if (eInfo != null && this.isRecorded) {
                this.txtInterviewComent.setEditable(false);
                this.combInterviewResult.setEnabled(false);
                this.textDesc.setEnabled(false);
                this.textScore.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            } else {
                this.txtInterviewComent.setEditable(true);
                this.combInterviewResult.setEnabled(true);
                this.textDesc.setEnabled(true);
                this.textScore.setEnabled(true);
                this.btnSave.setEnabled(true);
                this.btnSubmit.setEnabled(true);
            }
        }
        if (resumeBaseInfo != null) {
            this.txtName.setText(resumeBaseInfo.getName());
        }
        if (resumeBaseInfo != null && resumeBaseInfo.getGender() != null) {
            this.txtGender.setText(resumeBaseInfo.getGender().getAlias());
        }
        if (resumeBaseInfo != null && resumeBaseInfo.getPosition() != null) {
            this.txtPosition.setText(resumeBaseInfo.getPosition().getName());
        }
        if (resumeBaseInfo != null && resumeBaseInfo.getAdminOrgUnit() != null) {
            this.txtDepartment.setText(resumeBaseInfo.getAdminOrgUnit().getName());
        }
        if (resumeBaseInfo != null && resumeBaseInfo.getAge() != 0) {
            this.txtAge.setText(String.valueOf(resumeBaseInfo.getAge()));
        } else if (resumeBaseInfo != null && resumeBaseInfo.getBirthday() != null) {
            this.txtAge.setText(String.valueOf(RecServerUtils.subTwoDate(new Date(), resumeBaseInfo.getBirthday())));
        }
        if (resumeBaseInfo != null && resumeBaseInfo.getHighestDiploma() != null) {
            this.txtHighDegree.setText(resumeBaseInfo.getHighestDiploma().getName());
        }
    }

    private void updateInterviewer() throws BOSException, EASBizException {
        AssignmentInfo info;
        Object obj = this.getUIContext().get("WfAssignmentInfo");
        if (obj != null && obj instanceof AssignmentInfo && (info = (AssignmentInfo)obj).getAssignInfo().getSourceAssignId() != null && info.getAssignInfo().getPriorPerformerID() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("person.id"));
            UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(info.getAssignInfo().getPriorPerformerID()), sic);
            IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
            interviewFacade.updateInterviewer(user.getPerson().getId().toString(), info.getAssignInfo().getPersonEmpID().toString(), this.currentInterviewId);
        }
    }

    protected void beforeStoreFields() throws Exception {
        String score = this.textScore.getText().trim();
        String comment = this.txtInterviewComent.getText().trim();
        Object result = this.combInterviewResult.getSelectedItem();
        if (!(score != null && score.length() > 0 || comment != null && comment.length() > 0 || result != null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"score_comment_result_can_not_all_null"));
            SysUtil.abort();
        }
    }

    public void actionInterviewRecordAttachment_actionPerformed(ActionEvent e) throws Exception {
        IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
        InterviewRecordInfo rInfo = (InterviewRecordInfo)interviewFacade.getPersonInterviewRecord(this.currentInterviewId);
        if (rInfo != null) {
            AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
            AttachmentUIContextInfo attachmentUIContextInfo = new AttachmentUIContextInfo();
            attachmentUIContextInfo.setBoID(rInfo.getId().toString());
            if (this.isRecorded) {
                attachmentUIContextInfo.setEdit(false);
            } else {
                attachmentUIContextInfo.setEdit(true);
            }
            attachmentClientManager.showAttachmentListUIByBoID((Object)this, attachmentUIContextInfo);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields();
        this.textDesc.requestFocus();
        if (this.currentInterviewId != null && this.currentEntryId != null) {
            Object obj;
            IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
            InterviewEntryInfo eInfo = new InterviewEntryInfo();
            eInfo.setId(BOSUuid.read((String)this.currentEntryId));
            String str = this.txtInterviewComent.getText().trim();
            if (str != null && str.length() > 0) {
                eInfo.setInterviewComent(this.txtInterviewComent.getText());
            }
            if ((obj = this.combInterviewResult.getSelectedItem()) != null) {
                eInfo.setInterviewResult((InterviewResultEnum)((Object)obj));
            }
            if ((str = this.textScore.getText().trim()) != null && str.length() > 0) {
                eInfo.setScore((BigDecimal)this.textScore.getNumberValue());
            }
            if ((str = this.textDesc.getText().trim()) != null && str.length() > 0) {
                eInfo.setDescription(str);
            }
            interviewFacade.updateInterviewEntry((IObjectValue)eInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"saveSuccess"));
            this.refreshOwner();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields();
        if (this.currentInterviewId != null && this.currentRecordId != null) {
            String stri;
            Object result;
            IInterviewFacade interviewFacade = InterviewFacadeFactory.getRemoteInstance();
            ArrayList interviewList = new ArrayList();
            ArrayList<InterviewRecordInfo> recordList = new ArrayList<InterviewRecordInfo>();
            InterviewRecordInfo recordInfo = new InterviewRecordInfo();
            recordInfo.setId(BOSUuid.read((String)this.currentRecordId));
            recordInfo.setInterviewComent(this.txtInterviewComent.getText());
            String str = this.textScore.getText().trim();
            if (str != null && str.length() > 0) {
                recordInfo.setScore((BigDecimal)this.textScore.getNumberValue());
            }
            if ((str = this.textDesc.getText().trim()) != null && str.length() > 0) {
                recordInfo.setDescription(str);
            }
            if ((result = this.combInterviewResult.getSelectedItem()) != null) {
                recordInfo.setInterviewResult((InterviewResultEnum)((Object)result));
            }
            recordInfo.setCommentDate(new Date(System.currentTimeMillis()));
            recordList.add(recordInfo);
            interviewFacade.updateInterviewAndRecord(interviewList, recordList);
            InterviewEntryInfo eInfo = new InterviewEntryInfo();
            eInfo.setId(BOSUuid.read((String)this.currentEntryId));
            eInfo.setInterviewComent(this.txtInterviewComent.getText());
            if (result != null) {
                eInfo.setInterviewResult((InterviewResultEnum)((Object)result));
            }
            eInfo.setIsRecorded(true);
            DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
            Object obj = this.getUIContext().get("WfAssignmentInfo");
            if (obj != null && obj instanceof AssignmentInfo) {
                agent.markNewBill((IObjectValue)eInfo, this.getUIContext());
            } else if (this.procInstID != null) {
                AssignInfo assinInfo = new AssignInfo();
                String sql = "select FassignId , fpersonuserid from T_WFR_Assign where FprocInstID = '" + this.procInstID + "'";
                ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                IRowSet rs = null;
                String assingid = null;
                try {
                    rs = exec.executeSQL();
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
                try {
                    if (rs != null && rs.next()) {
                        String assignUserId;
                        assingid = rs.getString("FassignId");
                        String curUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                        if (!curUserId.equalsIgnoreCase(assignUserId = rs.getString("fpersonuserid"))) {
                            ISQLExecutor exec1 = SQLExecutorFactory.getRemoteInstance((String)("select FNUMBER from t_pm_user WHERE FID ='" + assignUserId + "'"));
                            IRowSet rs1 = exec1.executeSQL();
                            if (rs1.next()) {
                                String assignUser = rs1.getString("FNUMBER");
                                MsgBox.showWarning((Component)((Object)this), (String)("\u8bf7\u4f7f\u7528\u8d26\u6237" + assignUser + "\u767b\u5f55\uff0c\u6765\u63d0\u4ea4\u9762\u8bd5\u8bb0\u5f55\uff01"));
                                SysUtil.abort();
                            } else {
                                SysUtil.abort();
                            }
                        }
                    }
                }
                catch (SQLException e2) {
                    this.handleException(e2);
                }
                if (assingid != null) {
                    assinInfo.setAssignID(BOSUuid.read(assingid));
                    AssignmentInfo assignmentInfo = new AssignmentInfo(assinInfo);
                    HashMap<String, AssignmentInfo> map = new HashMap<String, AssignmentInfo>();
                    map.put("WfAssignmentInfo", assignmentInfo);
                    agent.markNewBill((IObjectValue)eInfo, map);
                }
            }
            interviewFacade.updateInterviewEntry((IObjectValue)eInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"submitSuccess"));
            Object ui = this.getUIContext().get("Owner");
            if (ui instanceof ListUI) {
                ((ListUI)ui).actionRefresh_actionPerformed(e);
            }
            if ((stri = InterviewStepMagageFacadeFactory.getRemoteInstance().getNoEvaluatePersonName(this.currentInterviewId)).length() <= 0) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        try {
                            InterviewFacadeFactory.getRemoteInstance().sendMessageAndEmail(MyInterviewUI.this.currentInterviewId);
                        }
                        catch (Exception e) {
                            MsgBox.showWarning((String)EASResource.getString((String)MyInterviewUI.RES_INTERVIEW, (String)"SENDMAIL_FAIL"));
                            SysUtil.abort();
                        }
                    }
                };
                ProgressManager.AfterTask show = new ProgressManager.AfterTask(){

                    public void run() {
                    }
                };
                Thread workThread = new ProgressManager(this).launchProcess(process, (CoreUIObject)this, show, EASResource.getString((String)RES_INTERVIEW, (String)"SENDMAIL_FAIL"));
                workThread.start();
            }
            this.disposeUIWindow();
        }
    }

    private void refreshOwner() {
        ListUI ui = (ListUI)this.getUIContext().get("Owner");
        try {
            ui.actionRefresh_actionPerformed(null);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void viewAction_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"currentInterviewId", (Object)this.currentInterviewId);
        String interviewLevel = null;
        if (this.getUIContext().get("interviewLevel") != null) {
            interviewLevel = this.getUIContext().get("interviewLevel").toString().trim();
        }
        uiContext.put((Object)"interviewLevel", interviewLevel);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InterviewHistorySelfStepUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    public void actionResumeView_actionPerformed(ActionEvent e) throws Exception {
        String resumeId = (String)this.getUIContext().get("resumeBaseId");
        UIContext uiContext = new UIContext((Object)this);
        if (resumeId == null) {
            uiContext.put((Object)"ID", (Object)this.resumeBaseId);
            uiContext.put((Object)"resID", (Object)this.resumeBaseId);
        } else {
            uiContext.put((Object)"ID", (Object)resumeId);
            uiContext.put((Object)"resID", (Object)resumeId);
        }
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResumeExtendEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ResumeExtendEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

