/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.rec.OutPosiTypeFactory;
import com.kingdee.eas.hr.rec.OutPosiTypeInfo;
import com.kingdee.eas.hr.rec.OutPositionFactory;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.hr.rec.client.AbstractOutPosiTypeEditUI;
import com.kingdee.eas.hr.rec.util.HRRecClientUtils;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class OutPosiTypeEditUI
extends AbstractOutPosiTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OutPosiTypeEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.rec.HRRecResource";
    private boolean isSaved = false;
    private IObjectPK pk = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"OutPosiTypeRootName"));
    }

    public void loadFields() {
        String state = this.getOprtState();
        try {
            if (OprtState.ADDNEW.equals(state) && !this.isSaved) {
                this.setAutoNumber(this, this.editData, this.txtNumber, state, RecUtils.getCurrentHROrgUnit().getId().toString());
            }
            this.isSaved = false;
            if (OprtState.EDIT.equals(state)) {
                this.setNumberEditable();
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
        super.loadFields();
    }

    public void setAutoNumber(EditUI editUI, CoreBaseInfo info, KDTextField txtNumber, String state, String orgUnitId) throws Exception {
        if (OprtState.ADDNEW.equals(state)) {
            if (info == null || orgUnitId == null || editUI == null || txtNumber == null) {
                return;
            }
            Map map = RecCommonUtilFacadeFactory.getRemoteInstance().getCodeRuleProperties((IObjectValue)info, orgUnitId);
            boolean isExist = (Boolean)map.get("isExist");
            if (isExist) {
                boolean isAddView = (Boolean)map.get("isAddView");
                boolean isModifiable = (Boolean)map.get("isModifiable");
                String[] prop = (String[])map.get("prop");
                if (isAddView) {
                    if (prop != null && prop.length > 0) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"AutoNumber"));
                    }
                    String number = map.get("number").toString();
                    info.setString("number", number);
                }
                txtNumber.setEnabled(isModifiable);
                txtNumber.setEditable(isModifiable);
            }
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OutPosiTypeFactory.getRemoteInstance();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    protected IObjectValue createNewData() {
        OutPosiTypeInfo objectValue = new OutPosiTypeInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setParent(this.getParentType());
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        return objectValue;
    }

    private OutPosiTypeInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (OutPosiTypeInfo)obj;
    }

    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((Object)this.txtName.getSelectedItemData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"30_OutPositionEditUI")});
        }
        super.beforeStoreFields(arg0);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasItems()) {
            HRRecClientUtils.showErrorMessage(RESOURCE, "HasPosiType", (CoreUI)this);
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean hasItems() throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("OutPosiType.id", (Object)this.editData.getId().toString()));
        return OutPositionFactory.getRemoteInstance().exists(filterInfo);
    }

    public void actionSubmit_actionPerformed(ActionEvent arg0) throws Exception {
        OutPosiTypeInfo outInfo = (OutPosiTypeInfo)this.editData;
        if (outInfo != null) {
            outInfo.setNumber(this.txtNumber.getText());
        }
        if (!OprtState.EDIT.equals(this.getOprtState()) && outInfo != null && this.pk == null) {
            this.pk = OutPosiTypeFactory.getRemoteInstance().addnew((CoreBaseInfo)outInfo);
            this.editData.setId(BOSUuid.read((String)this.pk.toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            OutPosiTypeInfo info = OutPosiTypeFactory.getRemoteInstance().getOutPosiTypeInfo((IObjectPK)new ObjectUuidPK(this.pk.toString()), sic);
            if (info.getNumber() != null) {
                String number = info.getNumber();
                this.txtNumber.setText(number);
            }
            this.isSaved = true;
        }
        super.actionSubmit_actionPerformed(arg0);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setNumberEditable();
    }

    private void setNumberEditable() throws Exception {
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
        if (result) {
            boolean isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
            this.txtNumber.setEnabled(isModifiable);
            this.txtNumber.setEditable(isModifiable);
        }
    }
}

