/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumePhoto;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumePhotoCollection;
import com.kingdee.eas.hr.rec.ResumePhotoFactory;
import com.kingdee.eas.hr.rec.ResumePhotoInfo;
import com.kingdee.eas.hr.rec.client.AbstractPhotoLeadInOrOutTermForResumeUI;
import com.kingdee.eas.hr.rec.client.ProgressManager;
import com.kingdee.eas.hr.rec.client.ResumePhotoErrorImpListUI;
import com.kingdee.eas.hr.rec.util.GetDataDialog;
import com.kingdee.eas.hr.rec.util.GetDataTaskAdapter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PhotoLeadInOrOutTermForResumeUI
extends AbstractPhotoLeadInOrOutTermForResumeUI {
    private static final Logger logger = CoreUIObject.getLogger(PhotoLeadInOrOutTermForResumeUI.class);
    private IResumePhoto iPP = null;
    private ArrayList errorPersonList = null;
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionConfirm.setEnabled(true);
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox("true");
        aSel.showChkSealUp(true);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void rdPhotoLeadIn_itemStateChanged(ItemEvent e) throws Exception {
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void changeAdminState() {
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.iPP = ResumePhotoFactory.getRemoteInstance();
        if (this.rdPhotoLeadIn.isSelected()) {
            KDFileChooser fileChooser = new KDFileChooser();
            fileChooser.setFileSelectionMode(1);
            int result = fileChooser.showOpenDialog((Component)((Object)this));
            if (result != 0) {
                return;
            }
            this.personBatchImport(fileChooser.getSelectedFile(), new PhotoFilter());
        } else if (this.rdPhotoLeadOut.isSelected()) {
            KDFileChooser chooser = new KDFileChooser();
            chooser.setDialogType(1);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.FILE_SELECT"));
            chooser.setApproveButtonText(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONFIRM"));
            int r = chooser.showSaveDialog((Component)((Object)this));
            if (r == 0) {
                final String selectFielPath = chooser.getSelectedFile().getAbsolutePath().trim();
                if (selectFielPath.equals("")) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.SELECT_TARGET_FILE"));
                    return;
                }
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        PhotoLeadInOrOutTermForResumeUI.this.outputPhoto(selectFielPath);
                    }
                };
                ProgressManager.AfterTask show = new ProgressManager.AfterTask(){

                    public void run() {
                        MsgBox.showInfo((Component)((Object)PhotoLeadInOrOutTermForResumeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.PERSON_PHOTO_IMPORT_TIP_OUT"));
                    }
                };
                Thread workThread = new ProgressManager(this).launchProcess(process, (CoreUIObject)this, show, "");
                workThread.start();
            }
        }
    }

    private void outputPhoto(String selectFielPath) {
        FileOutputStream out = null;
        try {
            ResumePhotoCollection PhotoCol = this.iPP.getResumePhotoCollection();
            if (PhotoCol == null || PhotoCol.size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NO_PERSON_IN_ADMIN"));
                return;
            }
            HashMap<String, ResumePhotoInfo> photoMap = new HashMap<String, ResumePhotoInfo>();
            HashSet<String> set = new HashSet<String>();
            IResumeBase resumeFac = ResumeBaseFactory.getRemoteInstance();
            for (int i = 0; i < PhotoCol.size(); ++i) {
                ResumePhotoInfo PhotoInfo = PhotoCol.get(i);
                String photoId = PhotoInfo.getId().toString();
                set.add(photoId);
                photoMap.put(photoId, PhotoInfo);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("photo", set, CompareType.INCLUDE));
            view.setFilter(filter);
            ResumeBaseCollection resumeBaseCol = resumeFac.getResumeBaseCollection(view);
            for (int i = 0; i < resumeBaseCol.size(); ++i) {
                ResumeBaseInfo tempInfo = resumeBaseCol.get(i);
                if (tempInfo == null) continue;
                if (this.rdByName.isSelected()) {
                    out = new FileOutputStream(selectFielPath + "/" + tempInfo.getNumber() + "+" + tempInfo.getName() + ".jpg");
                } else if (this.rdByNumber.isSelected()) {
                    out = new FileOutputStream(selectFielPath + "/" + tempInfo.getNumber() + ".jpg");
                }
                byte[] data = ((ResumePhotoInfo)photoMap.get(tempInfo.getPhoto().getId().toString())).getImageData();
                out.write(data);
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.HRRecResource", (String)"fileNotFound"));
            SysUtil.abort();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private ResumeBaseInfo getResumeBaseByPhotoId(IResumeBase resumeFac, String photoId) {
        ResumeBaseInfo info = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("photo.id", (Object)photoId));
            view.setFilter(filter);
            ResumeBaseCollection resumeBaseCol = resumeFac.getResumeBaseCollection();
            if (resumeBaseCol != null && resumeBaseCol.size() > 0) {
                for (int i = 0; i < resumeBaseCol.size(); ++i) {
                    ResumeBaseInfo tempInfo = resumeBaseCol.get(i);
                    if (tempInfo.getPhoto() == null || !photoId.equals(tempInfo.getPhoto().getId().toString())) continue;
                    info = tempInfo;
                    return info;
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return info;
    }

    private void personBatchImport(final File file, final PhotoFilter filter) throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                PhotoLeadInOrOutTermForResumeUI.this.errorPersonList = new ArrayList();
                PhotoLeadInOrOutTermForResumeUI.this.searchDirectory(file, filter);
                PhotoLeadInOrOutTermForResumeUI.this.showErrorPPUI();
                return null;
            }
        });
        dlg.show();
    }

    private void showSameNameDialogue(ArrayList sameNameList) {
        if (sameNameList.size() > 0) {
            StringBuffer nameStr = new StringBuffer();
            int size = sameNameList.size();
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    nameStr.append(sameNameList.get(i));
                    continue;
                }
                nameStr.append(sameNameList.get(i) + ",");
            }
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HAS_SAME_NAME") + nameStr + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NOT_IMPORT")));
        }
    }

    private void searchDirectory(File file, PhotoFilter filter) throws Exception {
        File[] files = file.listFiles(filter);
        if (files == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.HRRecResource", (String)"fileNotFound"));
            SysUtil.abort();
        }
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            if (files[i].isFile()) {
                this.insertPersonPhoto(files[i]);
                continue;
            }
            this.searchDirectory(files[i], filter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertPersonPhoto(File file) throws Exception {
        String param = file.getName();
        param = param.substring(0, param.lastIndexOf("."));
        String resumeNumber = "";
        String resumeName = "";
        if (this.rdByName.isSelected()) {
            if (param.indexOf("+") > 0) {
                resumeNumber = param.split("\\+")[0];
                resumeName = param.split("\\+")[1];
                if (resumeNumber.length() > 80 || resumeName.length() > 255) {
                    String message = EASResource.getString((String)resumeRES, (String)"photoName_too_loog");
                    Object[] variables = new Object[]{param};
                    message = MessageFormat.format(message, variables);
                    MsgBox.showWarning((String)message);
                    SysUtil.abort();
                }
                ResumePhotoInfo ppInfo = new ResumePhotoInfo();
                ppInfo.setImageData(HRUtil.convertFileTOBytes((File)file));
                boolean isHasResume = this.saveResumeBasePhotoByPhotoId(resumeNumber, resumeName, ppInfo);
                if (isHasResume) return;
                this.errorPersonList.add("1" + file.getAbsolutePath());
                return;
            }
            this.errorPersonList.add("1" + file.getAbsolutePath());
            return;
        }
        if (!this.rdByNumber.isSelected()) return;
        resumeNumber = param;
        if (resumeNumber.length() > 80) {
            String message = EASResource.getString((String)resumeRES, (String)"photoName_too_loog");
            Object[] variables = new Object[]{param};
            message = MessageFormat.format(message, variables);
            MsgBox.showWarning((String)message);
            SysUtil.abort();
        }
        ResumePhotoInfo ppInfo = new ResumePhotoInfo();
        ppInfo.setImageData(HRUtil.convertFileTOBytes((File)file));
        boolean isHasResume = this.saveResumeBasePhotoByPhotoId(resumeNumber, resumeName, ppInfo);
        if (isHasResume) return;
        this.errorPersonList.add("1" + file.getAbsolutePath());
    }

    private boolean saveResumeBasePhotoByPhotoId(String resumeNumber, String resumeName, ResumePhotoInfo ppInfo) {
        boolean isHasResume = false;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!"".equals(resumeName)) {
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)resumeName));
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)resumeNumber));
            view.setFilter(filter);
            IResumeBase resumeFac = ResumeBaseFactory.getRemoteInstance();
            ResumeBaseCollection resumeCol = resumeFac.getResumeBaseCollection(view);
            if (resumeCol != null && resumeCol.size() > 0) {
                ResumeBaseInfo resumeInfo = resumeCol.get(0);
                resumeInfo.setPhoto(ppInfo);
                CoreBaseCollection coreBaseCol = new CoreBaseCollection();
                coreBaseCol.add((CoreBaseInfo)resumeInfo);
                Result rest = resumeFac.update(coreBaseCol);
                isHasResume = true;
            } else {
                isHasResume = false;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return isHasResume;
    }

    private void showErrorPPUI() throws Exception {
        if (this.errorPersonList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.PersonPhoto_Import_Success"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"ERR_LIST", (Object)this.errorPersonList);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(ResumePhotoErrorImpListUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    class PhotoFilter
    implements FileFilter {
        PhotoFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = OutputExcelUtil.getExtension((File)f);
            if (extension != null) {
                return extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg");
            }
            return false;
        }

        public String getDescription() {
            return "JPEG ( *.jpg;*.jpeg )";
        }
    }
}

