/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.rec.client.AbstractPositionVacancyFilterUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PositionVacancyFilterUI
extends AbstractPositionVacancyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionVacancyFilterUI.class);
    public static final String ADMIN_ITEM = "Admin_Item";
    public static final String POSITION_ITEM = "Position_Item";
    private static String SEPARATOR_IDS = "@79931a4a-aa3a-4271-fe04-0a8c01c3d56a1234@";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.prmtAdminOrg.getData() != null) {
            params.addCustomerParam(ADMIN_ITEM, OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.prmtAdminOrg.getData())));
        }
        if (this.prmtPosition.getData() != null) {
            Object[] objs = (Object[])this.prmtPosition.getData();
            StringBuffer result = new StringBuffer();
            PositionInfo positionInfo = null;
            int len = objs.length;
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    result.append(SEPARATOR_IDS);
                }
                positionInfo = (PositionInfo)objs[i];
                result.append(positionInfo.getId().toString());
            }
            params.addCustomerParam(POSITION_ITEM, result.toString());
        }
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        String ids = null;
        if (cp.getCustomerParam(ADMIN_ITEM) != null) {
            ids = cp.getCustomerParam(ADMIN_ITEM);
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)ids);
            this.prmtAdminOrg.setData((Object)orgs);
        }
        if (cp.getCustomerParam(POSITION_ITEM) != null) {
            int i;
            ArrayList positionInfos = new ArrayList();
            ids = cp.getCustomerParam(POSITION_ITEM);
            String[] positionIds = ids.split(SEPARATOR_IDS);
            StringBuffer oql = new StringBuffer();
            oql.append("select id, number, name, longNumber where id in(");
            int len = positionIds.length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (i2 != 0) {
                    oql.append(",");
                }
                oql.append("'");
                oql.append(positionIds[i2]);
                oql.append("'");
            }
            oql.append(")");
            HashMap<String, PositionInfo> posiMap = new HashMap<String, PositionInfo>();
            IPosition iPosi = null;
            PositionCollection col = null;
            try {
                iPosi = PositionFactory.getRemoteInstance();
                col = iPosi.getPositionCollection(oql.toString());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            PositionInfo posiInfo = null;
            int size = col.size();
            for (i = 0; i < size; ++i) {
                posiInfo = col.get(i);
                posiMap.put(posiInfo.getId().toString(), posiInfo);
            }
            int len2 = positionIds.length;
            for (i = 0; i < len2; ++i) {
                if (posiMap.get(positionIds[i]) == null) continue;
                positionInfos.add(posiMap.get(positionIds[i]));
            }
            this.prmtPosition.setData((Object)positionInfos.toArray());
        }
    }

    public boolean isPrepareExecQuery() {
        return true;
    }

    public IUIActionPostman prepareExecQuery(CustomerParams param) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleExecQuery");
        ObjectUuidPK adminItemPk = null;
        ObjectUuidPK positionItemPk = null;
        if (param.getCustomerParam(ADMIN_ITEM) != null) {
            adminItemPk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam(ADMIN_ITEM)));
            request.put("adminItemPk", (Object)adminItemPk);
        } else if (param.getCustomerParam(POSITION_ITEM) != null) {
            positionItemPk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam(POSITION_ITEM)));
            request.put("positionItemPk", (Object)positionItemPk);
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setData(null);
        this.prmtPosition.setData(null);
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        NewAdminByHROF7 adminF7 = new NewAdminByHROF7();
        adminF7.setMultiSelect(true);
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminF7);
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setEditable(false);
        this.prmtPosition.setQueryInfo("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        PositionPromptBox2 positionf7 = new PositionPromptBox2((IUIObject)this);
        positionf7.setMultiSelect(true);
        this.prmtPosition.setEditable(false);
        this.prmtPosition.setEnabledMultiSelection(true);
        this.prmtPosition.setSelector((KDPromptSelector)positionf7);
    }
}

