/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.rec.InterviewActivityCollection;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.RecChanneCollection;
import com.kingdee.eas.hr.rec.RecChanneFactory;
import com.kingdee.eas.hr.rec.RecChanneInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryCollection;
import com.kingdee.eas.hr.rec.ResumeCategoryFactory;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractRecChanneAnalyseFilterUI;
import com.kingdee.eas.hr.rec.client.ResumeCategoryPromptBox;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class RecChanneAnalyseFilterUI
extends AbstractRecChanneAnalyseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RecChanneAnalyseFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.RecChanneResource";
    JButton btnAddRow = null;
    JButton btnRemoveRow = null;

    public RecChanneAnalyseFilterUI() throws Exception {
        this.initPropertyInOnLoad();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ResumeCategoryPromptBox box = new ResumeCategoryPromptBox((IUIObject)this, new Boolean(true));
        this.promResumeCategory.setSelector((KDPromptSelector)box);
        this.promResumeCategory.setEnabledMultiSelection(true);
        this.promResumeCategory.setEditable(false);
    }

    public CustomerParams getCustomerParams() {
        int i;
        StringBuffer strBuffer;
        CustomerParams params = new CustomerParams();
        Object value = this.promRecChanne.getData();
        if (value != null && value instanceof Object[]) {
            Object[] recChannes = (Object[])value;
            strBuffer = new StringBuffer();
            if (recChannes.length > 0 && recChannes[0] != null) {
                for (i = 0; i < recChannes.length; ++i) {
                    strBuffer.append(((RecChanneInfo)recChannes[i]).getId());
                    strBuffer.append(",");
                }
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                params.addCustomerParam("recChanne", strBuffer.toString());
            }
        }
        if ((value = this.promInterviewActivity.getData()) != null && value instanceof Object[]) {
            Object[] activitys = (Object[])value;
            strBuffer = new StringBuffer();
            if (activitys.length > 0 && activitys[0] != null) {
                for (i = 0; i < activitys.length; ++i) {
                    strBuffer.append(((InterviewActivityInfo)activitys[i]).getId());
                    strBuffer.append(",");
                }
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                params.addCustomerParam("interviewActivity", strBuffer.toString());
            }
        }
        if ((value = this.promResumeCategory.getData()) != null && value instanceof Object[]) {
            Object[] categoryIds = (Object[])value;
            strBuffer = new StringBuffer();
            if (categoryIds.length > 0 && categoryIds[0] != null) {
                for (i = 0; i < categoryIds.length; ++i) {
                    strBuffer.append(((ResumeCategoryInfo)categoryIds[i]).getId());
                    strBuffer.append(",");
                }
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                params.addCustomerParam("resumeCategory", strBuffer.toString());
            }
        }
        params.putBoolean("chkAge", this.chkAge.isSelected());
        params.putBoolean("isDefault", this.btnRadioDefault.isSelected());
        params.putBoolean("chkDiploma", this.chkDiploma.isSelected());
        params.putBoolean("chkSex", this.chkSex.isSelected());
        try {
            params.addCustomerParam("customAge", this.getStrFromList(this.getCustomAgePeriod(this.tblAges)));
        }
        catch (EmployeeException e) {
            this.handUIException(e);
        }
        params.addCustomerParam("arrayParams", this.getStrFromList(this.getSelectPersonProperty()));
        return params;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fi = super.getFilterInfo();
        return fi;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.clear();
        if (cp == null) {
            return;
        }
        InterviewActivityCollection activityInfos = null;
        String activityIDs = cp.getCustomerParam("interviewActivity");
        try {
            if (activityIDs != null) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)activityIDs, CompareType.INCLUDE));
                ev.setFilter(fi);
                activityInfos = InterviewActivityFactory.getRemoteInstance().getInterviewActivityCollection(ev);
                if (activityInfos != null) {
                    this.promInterviewActivity.setValue((Object)activityInfos.toArray());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        RecChanneCollection recChannes = null;
        String recChanneIDs = cp.getCustomerParam("recChanne");
        try {
            if (recChanneIDs != null) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)recChanneIDs, CompareType.INCLUDE));
                ev.setFilter(fi);
                recChannes = RecChanneFactory.getRemoteInstance().getRecChanneCollection(ev);
                if (recChannes != null) {
                    this.promRecChanne.setValue((Object)recChannes.toArray());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        ResumeCategoryCollection resumeCategorys = null;
        String categoryIds = cp.getCustomerParam("resumeCategory");
        try {
            if (categoryIds != null) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)categoryIds, CompareType.INCLUDE));
                ev.setFilter(fi);
                resumeCategorys = ResumeCategoryFactory.getRemoteInstance().getResumeCategoryCollection(ev);
                if (resumeCategorys != null) {
                    this.promResumeCategory.setValue((Object)resumeCategorys.toArray());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (cp.getBoolean("chkAge")) {
            this.chkAge.setSelected(true);
            if (cp.getBoolean("isDefault")) {
                this.btnRadioDefault.setSelected(true);
                this.tblAges.removeRows();
            } else {
                this.btnRadioCustom.setSelected(true);
                String customAge = cp.getCustomerParam("customAge");
                String[] cusArray = customAge.split("-@@-");
                this.addNewRowFromArrayList(this.getListFromArray(cusArray), this.tblAges);
            }
        }
        if (cp.getBoolean("chkSex")) {
            this.chkSex.setSelected(true);
        }
        if (cp.getBoolean("chkDiploma")) {
            this.chkDiploma.setSelected(true);
        }
    }

    public void clear() {
        this.chkAge.setSelected(false);
        this.btnRadioDefault.setSelected(false);
        this.btnRadioCustom.setSelected(false);
        this.tblAges.removeRows();
        this.btnAddRow.setEnabled(false);
        this.btnRemoveRow.setEnabled(false);
        this.chkSex.setSelected(false);
        this.chkDiploma.setSelected(false);
        this.promRecChanne.setValue(null);
        this.promInterviewActivity.setValue(null);
        this.promResumeCategory.setValue(null);
    }

    private void addNewRowFromArrayList(ArrayList ageList, KDTable tbl) {
        tbl.checkParsed();
        tbl.removeRows();
        if (ageList != null) {
            for (int j = 0; j < ageList.size(); ++j) {
                IRow curRow = tbl.addRow();
                String strAge = (String)ageList.get(j);
                String[] strAgePeriod = strAge.split("--");
                curRow.getCell("colFrom").setValue((Object)strAgePeriod[0]);
                curRow.getCell("colTo").setValue((Object)strAgePeriod[1]);
            }
        }
    }

    private boolean checkArrayList(ArrayList arrList) {
        if (arrList == null || arrList.size() == 0) {
            return true;
        }
        int size = arrList.size();
        for (int i = 0; i < size; ++i) {
            String strValue = (String)arrList.get(i);
            String[] str = strValue.split("--");
            int iMin = Integer.parseInt(str[0]);
            int iMax = Integer.parseInt(str[1]);
            if (iMin < 0 || iMax < 0 || iMin > iMax) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NUMBER_NOT_RIGHT"));
                return false;
            }
            if (this.checkMainAndMax(iMin, iMax, arrList, i)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NUMBER_NOT_RIGHT"));
            return false;
        }
        return true;
    }

    private boolean checkMainAndMax(int iMin, int iMax, ArrayList arrList, int counts) {
        int size = arrList.size();
        for (int i = 0; i < counts; ++i) {
            String strValue = (String)arrList.get(i);
            String[] str = strValue.split("--");
            int iMinC = Integer.parseInt(str[0]);
            int iMaxC = Integer.parseInt(str[1]);
            if (iMin != iMinC && iMax != iMaxC && (iMin <= iMinC || iMin >= iMaxC) && (iMax <= iMinC || iMax >= iMaxC)) continue;
            return false;
        }
        return true;
    }

    private void initPropertyInOnLoad() throws Exception {
        this.btnAddRow = this.conAges.add((Action)((Object)this.actionAddRow));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddRow.setToolTipText(EASResource.getString((String)RES, (String)"addRow"));
        this.btnAddRow.setEnabled(false);
        this.btnRemoveRow = this.conAges.add((Action)((Object)this.actionRemoveRow));
        this.btnRemoveRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveRow.setToolTipText(EASResource.getString((String)RES, (String)"removeRow"));
        this.btnRemoveRow.setEnabled(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(6)));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(7)));
        fi.setMaskString("#0 or #1");
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.promInterviewActivity.setEntityViewInfo(evi);
        this.promInterviewActivity.setEditable(false);
        this.promRecChanne.setEditable(false);
        this.tblAges.checkParsed();
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        this.tblAges.getColumn("colFrom").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)integerField));
        this.tblAges.getColumn("colTo").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)integerField));
    }

    public boolean verify() {
        try {
            super.verify();
            if (this.isSelectedAge() && this.btnRadioCustom.isSelected()) {
                ArrayList custList = this.getCustomAgeArrayList();
                if (custList.size() == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CUSTOM_AGE_MUST_FILL_AGESEGMENT"));
                    return false;
                }
                if (!this.checkArrayList(custList)) {
                    return false;
                }
            }
        }
        catch (EmployeeException e) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NUMBER_NOT_RIGHT"));
            return false;
        }
        return true;
    }

    protected void chkAge_stateChanged(ChangeEvent e) throws Exception {
        this.btnAddRow.setEnabled(false);
        this.btnRemoveRow.setEnabled(false);
        if (this.chkAge.isSelected()) {
            this.btnRadioCustom.setEnabled(true);
            this.btnRadioDefault.setEnabled(true);
            this.btnRadioDefault.setSelected(true);
        } else {
            this.btnRadioDefault.setSelected(false);
            this.btnRadioCustom.setSelected(false);
            this.btnRadioDefault.setEnabled(false);
            this.btnRadioCustom.setEnabled(false);
        }
    }

    protected void btnRadioCustom_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioCustom.isSelected()) {
            this.btnAddRow.setEnabled(true);
            this.btnRemoveRow.setEnabled(true);
        }
    }

    protected void btnRadioDefault_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioDefault.isSelected()) {
            this.btnAddRow.setEnabled(false);
            this.btnRemoveRow.setEnabled(false);
            this.tblAges.removeRows();
        }
    }

    public boolean isSelectedAge() {
        return this.chkAge.isSelected();
    }

    public boolean isAgeDefault() {
        return this.btnRadioDefault.isSelected();
    }

    public ArrayList getCustomAgeArrayList() throws EmployeeException {
        return this.getCustomAgePeriod(this.tblAges);
    }

    public InterviewActivityInfo[] getInterviewActivityInfo() {
        if (this.promInterviewActivity.getData() != null) {
            return (InterviewActivityInfo[])this.promInterviewActivity.getData();
        }
        return null;
    }

    public Object[] getRecChanneInfo() {
        if (this.promRecChanne.getData() != null) {
            return (Object[])this.promRecChanne.getData();
        }
        return null;
    }

    private String getStrFromList(ArrayList list) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                strBuf.append("-@@-");
            }
            strBuf.append(list.get(i));
        }
        return strBuf.toString();
    }

    private ArrayList getListFromArray(String[] strArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < strArray.length; ++i) {
            list.add(strArray[i]);
        }
        return list;
    }

    private ArrayList getCustomAgePeriod(KDTable tbl) throws EmployeeException {
        ArrayList<String> arrList = new ArrayList<String>();
        this.checkTableRowData(tbl);
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            IRow curRow = tbl.getRow(i);
            if (curRow.getCell("colFrom").getValue() == null || curRow.getCell("colTo").getValue() == null) continue;
            arrList.add(curRow.getCell("colFrom").getValue().toString() + "--" + curRow.getCell("colTo").getValue().toString());
        }
        return arrList;
    }

    private void checkTableRowData(KDTable tbl) throws EmployeeException {
        boolean bolRight = true;
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            IRow curRow = tbl.getRow(i);
            if (curRow.getCell("colFrom").getValue() == null || curRow.getCell("colTo").getValue() == null || Integer.parseInt(curRow.getCell("colFrom").getValue().toString()) <= Integer.parseInt(curRow.getCell("colTo").getValue().toString())) continue;
            bolRight = false;
            break;
        }
        if (!bolRight) {
            throw new EmployeeException(EmployeeException.FROMTIME_MUST_AFTER_TOTIME);
        }
    }

    public ArrayList getSelectPersonProperty() {
        ArrayList<String> arrList = new ArrayList<String>();
        int counts = this.pnlProp.getComponentCount();
        for (int i = 0; i < counts; ++i) {
            Component comp = this.pnlProp.getComponent(i);
            if (!(comp instanceof KDCheckBox) || !((KDCheckBox)comp).isSelected()) continue;
            String strName = ((KDCheckBox)comp).getName();
            arrList.add(strName);
        }
        return arrList;
    }

    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        RecUtils.addLine(this.tblAges);
    }

    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveRow_actionPerformed(e);
        RecUtils.removeLine(this.tblAges);
    }
}

