/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.rec.RecChanneFactory;
import com.kingdee.eas.hr.rec.RecChanneInfo;
import com.kingdee.eas.hr.rec.RecChanneTypeInfo;
import com.kingdee.eas.hr.rec.client.AbstractRecChanneEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.ComBoxInfo;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RecChanneEditUI
extends AbstractRecChanneEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RecChanneEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.RecChanneResource";
    private int oldIndex;

    protected IObjectValue createNewData() {
        RecChanneInfo recChanne = new RecChanneInfo();
        RecChanneTypeInfo channeType = (RecChanneTypeInfo)this.getUIContext().get("ParentNode");
        recChanne.setChanneType(channeType);
        recChanne.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return recChanne;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadProvince();
        this.loadCity();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecChanneFactory.getRemoteInstance();
    }

    private void loadCity() {
        if (!RecUtils.objectIsNull(this.editData.getCity())) {
            String id = this.editData.getCity().getId().toString();
            for (int j = this.combCity.getItemCount() - 1; j > -1; --j) {
                CityInfo info = (CityInfo)((ComBoxInfo)this.combCity.getItemAt(j)).getobjInfo();
                if (!id.equals(info.getId().toString())) continue;
                this.combCity.setSelectedIndex(j);
            }
        } else {
            this.combCity.setSelectedItem(null);
        }
    }

    private void loadProvince() throws BOSException {
        ProvinceCollection collection = ProvinceFactory.getRemoteInstance().getProvinceCollection();
        Object[] comboxInfos = new ComBoxInfo[collection.size()];
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            comboxInfos[i] = new ComBoxInfo((IObjectValue)collection.get(i));
        }
        this.combProvince.removeAllItems();
        this.combProvince.addItems(comboxInfos);
        if (!RecUtils.objectIsNull(this.editData.getProvince())) {
            String id = this.editData.getProvince().getId().toString();
            for (int j = this.combProvince.getItemCount() - 1; j > -1; --j) {
                ProvinceInfo info = (ProvinceInfo)((ComBoxInfo)this.combProvince.getItemAt(j)).getobjInfo();
                if (!id.equals(info.getId().toString())) continue;
                this.combProvince.setSelectedIndex(j);
            }
        } else {
            this.combProvince.setSelectedItem(null);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDBizMultiLangBox)this.txtName);
        if (!RecUtils.objectIsNull(this.txtPostCode.getText())) {
            String postCode = this.txtPostCode.getText();
            if (postCode.trim().length() != 6) {
                this.txtPostCode.requestFocus();
                RecUtils.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
            int n = postCode.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isDigit(postCode.charAt(i))) continue;
                this.txtPostCode.requestFocus();
                RecUtils.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
        }
    }

    private void storeCity() {
        if (!RecUtils.objectIsNull(this.combCity.getSelectedItem())) {
            this.editData.setCity((CityInfo)((ComBoxInfo)this.combCity.getSelectedItem()).getobjInfo());
        }
    }

    protected void combProvince_actionPerformed(ActionEvent e) throws Exception {
        super.combProvince_actionPerformed(e);
        if ("INIT".equals(this.combProvince.getActionCommand())) {
            return;
        }
        if (this.combProvince.getSelectedIndex() != this.oldIndex) {
            this.oldIndex = this.combProvince.getSelectedIndex();
            this.combProvince.setSelectedItem(this.combProvince.getItemAt(this.oldIndex));
        }
        this.initComboCity();
    }

    private void initComboCity() throws BOSException {
        if (!RecUtils.objectIsNull(this.combProvince.getSelectedItem())) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("province.id", (Object)((ProvinceInfo)((ComBoxInfo)this.combProvince.getSelectedItem()).getobjInfo()).getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CityCollection collection = CityFactory.getRemoteInstance().getCityCollection(viewInfo);
            Object[] comboxInfos = new ComBoxInfo[collection.size()];
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                comboxInfos[i] = new ComBoxInfo((IObjectValue)collection.get(i));
            }
            this.combCity.removeAllItems();
            this.combCity.addItems(comboxInfos);
        } else {
            this.combCity.removeAllItems();
        }
    }

    private void storeProvince() {
        if (!RecUtils.objectIsNull(this.combProvince.getSelectedItem())) {
            this.editData.setProvince((ProvinceInfo)((ComBoxInfo)this.combProvince.getSelectedItem()).getobjInfo());
        }
    }

    public void storeFields() {
        this.storeProvince();
        this.storeCity();
        super.storeFields();
    }
}

