/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.rec.IRecChanneType;
import com.kingdee.eas.hr.rec.RecChanneTypeFactory;
import com.kingdee.eas.hr.rec.RecChanneTypeInfo;
import com.kingdee.eas.hr.rec.client.AbstractRecChanneTypeEditUI;
import com.kingdee.eas.hr.rec.util.HRRecClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RecChanneTypeEditUI
extends AbstractRecChanneTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RecChanneTypeEditUI.class);
    private static final String REC = "com.kingdee.eas.hr.rec.ResumeResource";

    protected IObjectValue createNewData() {
        RecChanneTypeInfo rec = new RecChanneTypeInfo();
        rec.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        rec.setParent(this.getParentType());
        return rec;
    }

    private RecChanneTypeInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (RecChanneTypeInfo)obj;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecChanneTypeFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, (KDBizMultiLangBox)this.txtName);
        if (this.isNameUniqueInLevel()) {
            this.txtName.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)REC, (String)"nameNotUniqueInLevel"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private boolean isNameUniqueInLevel() throws Exception {
        String name = this.txtName.getSelectedItem().toString().trim();
        if (this.editData.getName() != null && this.editData.getName().equals(name)) {
            return false;
        }
        IRecChanneType recChanneType = RecChanneTypeFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)name, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (this.editData.getParent() != null) {
            filterItemInfo = new FilterItemInfo("parent.id", (Object)this.editData.getParent().getId(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        return recChanneType.exists(filterInfo);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasItems()) {
            HRRecClientUtils.showErrorMessage(REC, "hasRecChanneType", (CoreUI)this);
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean hasItems() throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.editData.getId().toString()));
        return RecChanneTypeFactory.getRemoteInstance().exists(filterInfo);
    }
}

