/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.InterviewActivityFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.RecAuditStatesEnum;
import com.kingdee.eas.hr.rec.RecruitSummaryFactory;
import com.kingdee.eas.hr.rec.RecruitSummaryInfo;
import com.kingdee.eas.hr.rec.client.AbstractRecruitSummaryEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class RecruitSummaryEditUI
extends AbstractRecruitSummaryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RecruitSummaryEditUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.rec.RecRecruitSummaryResource";
    private InterviewActivityInfo interviewActivity = null;
    private BigDecimal avgCost = new BigDecimal("0.00");
    private boolean isLoadField = false;
    private int planNumber;
    private int realNumber;

    public void loadFields() {
        this.isLoadField = true;
        super.loadFields();
        this.clearInitValue();
        this.isLoadField = false;
    }

    protected void inOnload() throws Exception {
        super.inOnload();
        this.txtPerf.setText(this.getPerfForInterviewActivity(this.editData.getRealNumber(), this.editData.getPlanNumber()));
        if (RecAuditStatesEnum.UNAUDITED.equals((Object)this.editData.getAuditState())) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtInterviewActivity.setRequired(true);
        this.prmtInterviewActivity.setEditable(false);
        this.prmtInterviewActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)7));
        fi.mergeFilter(RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id"), "and");
        evi.setFilter(fi);
        this.prmtInterviewActivity.setEntityViewInfo(evi);
        this.menuBiz.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    protected IObjectValue createNewData() {
        RecruitSummaryInfo recruitSummaryInfo = new RecruitSummaryInfo();
        recruitSummaryInfo.setAuditState(RecAuditStatesEnum.UNAUDITED);
        return recruitSummaryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecruitSummaryFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (RecUtils.objectIsNull(this.prmtInterviewActivity.getValue())) {
            this.prmtInterviewActivity.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"INTERVIEWACTIVITY_NOT_NULL"));
            SysUtil.abort();
        }
        if (RecUtils.objectIsNull(this.pkRealStartDate.getValue())) {
            this.pkRealStartDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"START_DATE_NOT_NULL"));
            SysUtil.abort();
        }
        if (RecUtils.objectIsNull(this.pkRealEndDate.getValue())) {
            this.pkRealEndDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"END_DATE_NOT_NULL"));
            SysUtil.abort();
        }
        if (DateTimeUtils.dayAfter((Date)this.pkRealStartDate.getSqlDate(), (Date)this.pkRealEndDate.getSqlDate())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"END_DATE_LITTLE_START_DATE"));
            SysUtil.abort();
        }
        InterviewActivityInfo interviewActivity = this.getInterviewActivity((InterviewActivityInfo)this.prmtInterviewActivity.getData());
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkActivityAlreadyRecruitSummary((IObjectValue)interviewActivity);
        } else {
            this.realNumber = this.editData.getRealNumber();
        }
        this.editData.setHrOrgUnit(interviewActivity.getHrOrgUnit());
        this.editData.setAdminOrgUnit(interviewActivity.getAdminOrgunit());
        if (!RecUtils.objectIsNull(this.txtRealCost.getValue()) && this.realNumber != 0) {
            try {
                this.avgCost = new BigDecimal(Double.parseDouble(this.txtRealCost.getValue().toString()) / (double)this.realNumber);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        if (this.editData.getRealNumber() != 0) {
            this.editData.setAvgCost(this.avgCost);
        }
    }

    protected void prmtInterviewActivity_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLoadField) {
            return;
        }
        super.prmtInterviewActivity_dataChanged(e);
        if (this.prmtInterviewActivity.getData() != null) {
            this.interviewActivity = this.getInterviewActivity((InterviewActivityInfo)this.prmtInterviewActivity.getData());
            this.initInfoForInterviewActivity(this.interviewActivity);
        }
    }

    private InterviewActivityInfo getInterviewActivity(InterviewActivityInfo interviewActivity) throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("dept.name"));
        selector.add(new SelectorItemInfo("adminOrgunit.name"));
        selector.add(new SelectorItemInfo("person.name"));
        return InterviewActivityFactory.getRemoteInstance().getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(interviewActivity.getId()), selector);
    }

    private void initInfoForInterviewActivity(InterviewActivityInfo interviewActivity) throws Exception {
        this.txtNumber.setText(interviewActivity.getNumber());
        this.txtPerson.setText(interviewActivity.getPerson().getName());
        this.txtDept.setText(interviewActivity.getDept().getName());
        this.txtBudgetCost.setValue((Object)interviewActivity.getBudgetCost());
        this.planNumber = InterviewActivityFacadeFactory.getRemoteInstance().getSumPlanNumberForInterviewActivity(interviewActivity.getId().toString());
        this.realNumber = InterviewActivityFacadeFactory.getRemoteInstance().getSumRealNumberForInterviewActivity(interviewActivity.getId().toString());
        this.txtPlanNum.setValue((Object)this.planNumber);
        this.txtRealNum.setValue((Object)this.realNumber);
        this.txtPerf.setValue((Object)new BigDecimal((double)this.realNumber * 1.0 / (double)this.planNumber));
        this.txtPerf.setText(this.getPerfForInterviewActivity(this.realNumber, this.planNumber));
        this.txtAdminOrgUnit.setText(interviewActivity.getAdminOrgunit().getName());
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return objectPK;
    }

    private void clearInitValue() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtPlanNum.setValue(null);
            this.txtRealNum.setValue(null);
        }
    }

    private void checkActivityAlreadyRecruitSummary(IObjectValue model) throws BOSException, EASBizException {
        InterviewActivityInfo interviewActivityInfo = (InterviewActivityInfo)model;
        if (interviewActivityInfo != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)interviewActivityInfo.getId(), CompareType.EQUALS));
            if (RecruitSummaryFactory.getRemoteInstance().exists(filterInfo)) {
                MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"ALREADY_SUMMARIZED"));
                this.prmtInterviewActivity.requestFocus();
                logger.info(RecruitSummaryEditUI.class);
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.activityChanged()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"ACTIVITY_CHANGE"));
            this.checkActivityAlreadyRecruitSummary((IObjectValue)this.interviewActivity);
        }
        super.actionSubmit_actionPerformed(e);
    }

    private boolean activityChanged() throws Exception {
        if (TrainClientUtil.objectIsNull((Object)this.editData.getId())) {
            return false;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)this.editData.getInterviewActivity().getId(), CompareType.EQUALS));
        return !RecruitSummaryFactory.getRemoteInstance().exists(filterInfo);
    }

    private String getPerfForInterviewActivity(int realNumber, int planNumber) {
        return String.valueOf((double)realNumber * 1.0 / (double)planNumber * 100.0).length() <= 5 ? String.valueOf((double)realNumber * 1.0 / (double)planNumber * 100.0) : String.valueOf((double)realNumber * 1.0 / (double)planNumber * 100.0).substring(0, 5);
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        super.afterSubmitEdit(pk);
        this.txtPerf.setText(this.getPerfForInterviewActivity(this.editData.getRealNumber(), this.editData.getPlanNumber()));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("auditState"));
        return sic;
    }
}

