/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.RecAuditStatesEnum;
import com.kingdee.eas.hr.rec.RecruitSummaryFacadeFactory;
import com.kingdee.eas.hr.rec.RecruitSummaryFactory;
import com.kingdee.eas.hr.rec.client.AbstractRecruitSummaryListUI;
import com.kingdee.eas.hr.rec.client.RecruitSummaryEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecruitSummaryListUI
extends AbstractRecruitSummaryListUI {
    private static final Logger logger = CoreUIObject.getLogger(RecruitSummaryListUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.rec.RecRecruitSummaryResource";
    private boolean able = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("interviewActivity.budgetCost").getStyleAttributes().setNumberFormat("#,###");
        this.tblMain.getColumn("realCost").getStyleAttributes().setNumberFormat("#,###");
        this.tblMain.getColumn("avgCost").getStyleAttributes().setNumberFormat("#,###");
        this.checkMenuableByRecruitSummaryState(null);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                RecruitSummaryListUI.this.checkMenuableByRecruitSummaryState(e);
            }
        });
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        RecruitSummaryFacadeFactory.getRemoteInstance().recruitSummaryAuditOrUnAudit(RecUtils.getTableSelectedValue(this.tblMain, "id"), RecAuditStatesEnum.AUDITED);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        RecruitSummaryFacadeFactory.getRemoteInstance().recruitSummaryAuditOrUnAudit(RecUtils.getTableSelectedValue(this.tblMain, "id"), RecAuditStatesEnum.UNAUDITED);
        this.actionRefresh_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecruitSummaryFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RecruitSummaryEditUI.class.getName();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("ID", this.getSelectedKeyValue());
        uiContext.put("superOprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private boolean checkMenuableByRecruitSummaryState(KDTSelectEvent e) {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            int state = 60;
            if (row != null && row.getCell("auditState") != null) {
                state = ((BizEnumValueInfo)row.getCell("auditState").getValue()).getInt();
            }
            if (state == 50) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(true);
                this.able = false;
                return false;
            }
            if (state != 60) continue;
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(false);
            this.able = true;
            return true;
        }
        return this.able;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        queryExecutor.option().isAutoIgnoreZero = false;
        return queryExecutor;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.able) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"AUDITED"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }
}

