/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.IResumeCategory;
import com.kingdee.eas.hr.rec.ResumeCategoryFactory;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.client.AbstractResumeCategoryEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ResumeCategoryEditUI
extends AbstractResumeCategoryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ResumeCategoryEditUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected IObjectValue createNewData() {
        ResumeCategoryInfo resumeCategoryInfo = new ResumeCategoryInfo();
        resumeCategoryInfo.setParent(this.getParentType());
        this.txtNumber.setEditable(true);
        this.txtNumber.setEnabled(true);
        this.txtNumber.requestFocus();
        return resumeCategoryInfo;
    }

    private ResumeCategoryInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (ResumeCategoryInfo)obj;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ResumeCategoryFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDBizMultiLangBox)this.txtName);
        if (this.isNameUniqueInLevel()) {
            this.txtName.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)resumeRES, (String)"nameNotUniqueInLevel"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null && this.isHaveResume()) {
            MsgBox.showWarning((String)EASResource.getString((String)resumeRES, (String)"can_not_add_has_data"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isHaveResume()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotDeleteWithTalent"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (OprtState.EDIT.equals(this.oprtState)) {
            this.txtNumber.setEditable(false);
        } else if (OprtState.ADDNEW.equals(this.oprtState)) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if ("EDIT".equals(this.oprtState)) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        } else if ("ADDNEW".equals(this.oprtState)) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.requestFocus();
        }
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("EDIT".equals(this.oprtState)) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        } else if ("ADDNEW".equals(this.oprtState)) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.requestFocus();
        }
    }

    private boolean isHaveResume() throws Exception {
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("category.id", (Object)this.editData.getId(), CompareType.EQUALS));
        return ResumeExtendFactory.getRemoteInstance().exists(info);
    }

    private boolean isNameUniqueInLevel() throws Exception {
        FilterInfo filter;
        String name = this.txtName.getSelectedItem().toString().trim();
        if (this.editData.getName() != null && this.editData.getName().equals(name)) {
            return false;
        }
        IResumeCategory resumeCategory = ResumeCategoryFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)name, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (this.editData.getParent() != null) {
            filterItemInfo = new FilterItemInfo("parent.id", (Object)this.editData.getParent().getId(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if ((filter = RecUtils.getHRFilterByParam("REC002")) != null) {
            filterInfo.mergeFilter(filter, "And");
        }
        return resumeCategory.exists(filterInfo);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }
}

