/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.hr.rec.InterviewException;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.client.AbstractResumeEntryFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ResumeEntryFilterUI
extends AbstractResumeEntryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ResumeEntryFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtActivity.setQueryInfo("com.kingdee.eas.hr.rec.app.InterviewActivityQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(6)));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(7)));
        fi.setMaskString("#0 or #1");
        FilterInfo filter = RecUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
        filter.getFilterItems().add(new FilterItemInfo("isCrossHR", (Object)new Boolean(true)));
        filter.setMaskString("#0 or #1");
        fi.mergeFilter(filter, "And");
        evi.setFilter(fi);
        this.prmtActivity.setEntityViewInfo(evi);
        this.cbPersonState.addItem((Object)"  ");
        this.cbPersonState.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.rec.PersonStateEnum").toArray());
        this.cbPersonState.setEditable(false);
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrgUnit, true, false, "$name$");
        this.cbSex.addItem((Object)"  ");
        this.cbSex.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.basedata.person.Genders").toArray());
        this.cbSex.setEditable(false);
        this.clear();
        this.prmtActivity.setEditable(false);
        this.txtAgeFrom.setSupportedEmpty(true);
        this.txtAgeTo.setSupportedEmpty(true);
    }

    public void clear() {
        this.prmtActivity.setValue(null);
        this.txtAgeFrom.setText("");
        this.txtAgeTo.setText("");
        this.txtName.setSelectedItemData(null);
        this.cbPersonState.setSelectedItem(null);
        this.cbSex.setSelectedItem(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtHighestDiploma.setValue(null);
        this.prmtPosition.setValue(null);
        this.kdpEntryDateStart.setValue(null);
        this.kdpEntryDateEnd.setValue(null);
        this.chkDisplayName.setSelected(true);
    }

    public boolean verify() {
        int to;
        int from;
        if (!RecUtils.objectIsNull(this.txtAgeFrom.getText()) && !RecUtils.objectIsNull(this.txtAgeTo.getText()) && (from = Integer.valueOf(this.txtAgeFrom.getText()).intValue()) > (to = Integer.valueOf(this.txtAgeTo.getText()).intValue())) {
            this.txtAgeTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.AGE_FROM_GT_TO).getMessage());
            return false;
        }
        if (!RecUtils.objectIsNull(this.kdpEntryDateStart.getValue()) && !RecUtils.objectIsNull(this.kdpEntryDateEnd.getValue()) && ((Date)this.kdpEntryDateStart.getValue()).compareTo((Date)this.kdpEntryDateEnd.getValue()) > 0) {
            this.kdpEntryDateEnd.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.WORKDATE_FROM_GT_TO).getMessage());
            return false;
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        int i;
        Object[] objs;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        HashSet<String> set = null;
        Object obj = this.prmtActivity.getValue();
        if (obj != null) {
            RecUtils.buildFilterItemInfo(itemCollection, "interviewActivity.id", obj, CompareType.INCLUDE);
        }
        if (!RecUtils.objectIsNull(this.kdpEntryDateStart.getValue())) {
            item = new FilterItemInfo("workDate", (Object)((Date)this.kdpEntryDateStart.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.kdpEntryDateEnd.getValue())) {
            item = new FilterItemInfo("workDate", (Object)((Date)this.kdpEntryDateEnd.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtAgeFrom.getText())) {
            item = new FilterItemInfo("age", (Object)Integer.valueOf(this.txtAgeFrom.getText()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtAgeTo.getText())) {
            item = new FilterItemInfo("age", (Object)Integer.valueOf(this.txtAgeTo.getText()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.prmtHighestDiploma.getValue())) {
            item = new FilterItemInfo("educationExp.diploma.id", (Object)((DiplomaInfo)this.prmtHighestDiploma.getValue()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (this.prmtPosition.getValue() != null && this.prmtPosition.getValue() instanceof Object[] && (objs = (Object[])this.prmtPosition.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet<String>();
            for (i = 0; i < objs.length; ++i) {
                PositionInfo positionInfo = (PositionInfo)objs[i];
                set.add(positionInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("position.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (this.prmtAdminOrgUnit.getValue() != null && this.prmtAdminOrgUnit.getValue() instanceof Object[] && (objs = (Object[])this.prmtAdminOrgUnit.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet();
            for (i = 0; i < objs.length; ++i) {
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)objs[i];
                set.add(adminOrgUnitInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("adminOrgUnit.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (!RecUtils.objectIsNull(this.cbSex.getSelectedItem()) && this.cbSex.getSelectedItem() instanceof Genders) {
            item = new FilterItemInfo("gender", (Object)((Genders)this.cbSex.getSelectedItem()).getValue(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.cbPersonState.getSelectedItem()) && this.cbPersonState.getSelectedItem() instanceof PersonStateEnum) {
            item = new FilterItemInfo("personState", (Object)((PersonStateEnum)((Object)this.cbPersonState.getSelectedItem())).getValue(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtName.getSelectedItem()) && !RecUtils.objectIsNull(this.txtName.getSelectedItem().toString())) {
            String name = this.txtName.getSelectedItem().toString().trim();
            name = "%" + name + "%";
            item = new FilterItemInfo("name", (Object)name, CompareType.LIKE);
            itemCollection.add(item);
        }
        return this.filterInfo;
    }

    public void setCustomerParams(CustomerParams cp) {
        int personState;
        int sex;
        String str;
        String[] ids;
        Object[] activitys;
        Object value = null;
        EntityViewInfo evi = new EntityViewInfo();
        if (RecUtils.objectIsNull(cp)) {
            return;
        }
        this.clear();
        value = cp.getCustomerParam("activity");
        if (value != null && (activitys = RecUtils.getInterviewActivitysByIDs(ids = (str = value.toString()).split("#--#"))) != null) {
            this.prmtActivity.setValue((Object)activitys);
        }
        if (!RecUtils.objectIsNull(value = cp.getDate("workDateStart"))) {
            this.kdpEntryDateStart.setValue(value);
        }
        if (!RecUtils.objectIsNull(value = cp.getDate("workDateEnd"))) {
            this.kdpEntryDateEnd.setValue(value);
        }
        if (!RecUtils.objectIsNull(value = cp.getCustomerParam("ageFrom"))) {
            this.txtAgeFrom.setText((String)value);
        }
        if (!RecUtils.objectIsNull(value = cp.getCustomerParam("ageTo"))) {
            this.txtAgeTo.setText((String)value);
        }
        if (!RecUtils.objectIsNull(value = cp.getCustomerParam("name"))) {
            this.txtName.setSelectedItemData((Object)((String)value));
        }
        if ((sex = cp.getInt("sex")) != -1) {
            this.cbSex.setSelectedItem((Object)Genders.getEnum((int)sex));
        }
        if ((personState = cp.getInt("personState")) != -1) {
            this.cbPersonState.setSelectedItem((Object)PersonStateEnum.getEnum(personState));
        }
        try {
            PositionCollection col;
            FilterInfo fi;
            ObjectUuidPK pk = null;
            value = cp.getCustomerParam("highestDiploma");
            if (!RecUtils.objectIsNull(value)) {
                IDiploma diploma = DiplomaFactory.getRemoteInstance();
                pk = new ObjectUuidPK((String)value);
                this.prmtHighestDiploma.setValue((Object)diploma.getDiplomaInfo((IObjectPK)pk));
            }
            if (!RecUtils.objectIsNull(value = cp.getCustomerParam("position"))) {
                String[] positions = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IPosition position = PositionFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(positions)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = position.getPositionCollection(evi);
                this.prmtPosition.setValue((Object)col.toArray());
            }
            if (!RecUtils.objectIsNull(value = cp.getCustomerParam("adminOrgUnit"))) {
                String[] adminOrg = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.prmtAdminOrgUnit.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public CustomerParams getCustomerParams() {
        Object[] ogs;
        int i;
        Object[] ps;
        CustomerParams cp = new CustomerParams();
        String emptyString = "";
        Object obj = null;
        obj = this.prmtActivity.getValue();
        cp = RecUtils.buildCustomerParams(cp, "activity", obj);
        obj = this.kdpEntryDateStart.getValue();
        if (!RecUtils.objectIsNull(obj)) {
            cp.putDate("workDateStart", (Date)obj);
        }
        if (!RecUtils.objectIsNull(obj = this.kdpEntryDateEnd.getValue())) {
            cp.putDate("workDateEnd", (Date)obj);
        }
        if (!RecUtils.objectIsNull(obj = this.txtAgeFrom.getText())) {
            cp.addCustomerParam("ageFrom", (String)obj);
        }
        if (!RecUtils.objectIsNull(obj = this.txtAgeTo.getText())) {
            cp.addCustomerParam("ageTo", (String)obj);
        }
        if (!RecUtils.objectIsNull(obj = this.prmtHighestDiploma.getValue()) && obj instanceof DiplomaInfo) {
            cp.addCustomerParam("highestDiploma", ((DiplomaInfo)obj).getId().toString());
        }
        if ((obj = this.prmtPosition.getValue()) != null && obj instanceof Object[] && (ps = (Object[])obj).length > 0 && ps[0] != null) {
            StringBuffer positions = new StringBuffer();
            for (i = 0; i < ps.length - 1; ++i) {
                positions.append(((PositionInfo)ps[i]).getId().toString());
                positions.append("\u2014\u2014");
            }
            positions.append(((PositionInfo)ps[i]).getId().toString());
            cp.addCustomerParam("position", positions.toString());
        }
        if (!RecUtils.objectIsNull(obj = this.cbSex.getSelectedItem()) && obj instanceof Genders) {
            cp.putInt("sex", ((Genders)obj).getValue());
        } else {
            cp.putInt("sex", -1);
        }
        obj = this.cbPersonState.getSelectedItem();
        if (!RecUtils.objectIsNull(obj) && obj instanceof PersonStateEnum) {
            cp.putInt("personState", ((PersonStateEnum)((Object)obj)).getValue());
        } else {
            cp.putInt("personState", -1);
        }
        obj = this.prmtAdminOrgUnit.getValue();
        if (obj != null && obj instanceof Object[] && (ogs = (Object[])obj).length > 0 && ogs[0] != null) {
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("adminOrgUnit", orgUnits.toString());
        }
        if (!RecUtils.objectIsNull(obj = this.txtName.getSelectedItem()) && !RecUtils.objectIsNull(obj.toString())) {
            cp.addCustomerParam("name", obj.toString());
        } else {
            cp.addCustomerParam("name", emptyString);
        }
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public static final class ConditionSearchParam
    implements Serializable {
        public static final String SEX = "sex";
        public static final String WORKDATESTART = "workDateStart";
        public static final String WORKDATEEND = "workDateEnd";
        public static final String AGEFROM = "ageFrom";
        public static final String AGETO = "ageTo";
        public static final String ADMINORGUNIT = "adminOrgUnit";
        public static final String HIGHESTDIPLOMA = "highestDiploma";
        public static final String POSITION = "position";
        public static final String NAME = "name";
        public static final String INTERVIEWLEVEL = "InterviewLevel";
        public static final String PERSONSTATE = "personState";
    }
}

