/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.rec.IResumeCategory;
import com.kingdee.eas.hr.rec.ResumeCategoryCollection;
import com.kingdee.eas.hr.rec.ResumeCategoryFactory;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractResumeExtendTypeF7UI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ResumeExtendTypeF7UI
extends AbstractResumeExtendTypeF7UI {
    private static final Logger logger = CoreUIObject.getLogger(ResumeExtendTypeF7UI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";
    private boolean isConfirmed = false;
    private ResumeCategoryInfo data = null;
    private boolean isLeaf = false;
    private Boolean isShowCheckBox = false;
    private Set returnValue = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTree();
    }

    private void initTree() throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RES, (String)"resumeCategory"));
        this.treeMain.setShowCheckBox(this.isShowCheckBox().booleanValue());
        root.setCheckBoxVisible(false);
        IResumeCategory resumeCategory = ResumeCategoryFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            viewInfo.setFilter(filter);
        }
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        ResumeCategoryCollection typeCollection = resumeCategory.getResumeCategoryCollection(viewInfo);
        ResumeCategoryInfo typeInfo = null;
        int size = typeCollection.size();
        for (int i = 0; i < size; ++i) {
            typeInfo = typeCollection.get(i);
            DefaultKingdeeTreeNode child = null;
            if (typeInfo.getParent() != null || typeInfo.getLevel() != 1) continue;
            child = this.getNode(typeCollection, typeInfo);
            root.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
    }

    private DefaultKingdeeTreeNode getNode(ResumeCategoryCollection typeColl, ResumeCategoryInfo typeInfo) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)typeInfo.getName());
        root.setCheckBoxVisible(true);
        root.setUserObject((Object)typeInfo);
        ResumeCategoryInfo info = null;
        int size = typeColl.size();
        for (int i = 0; i < size; ++i) {
            info = typeColl.get(i);
            if (info.getParent() == null || !info.getParent().getId().equals((Object)typeInfo.getId())) continue;
            DefaultKingdeeTreeNode child = this.getNode(typeColl, info);
            child.setCheckBoxVisible(true);
            root.add((MutableTreeNode)child);
        }
        return root;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectNode();
        if (!this.isLeaf) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"leafResumeExtendTypePlease"));
            SysUtil.abort();
        }
        this.isConfirmed = true;
        this.clearReturnValue();
        this.saveReturnValues(this.returnValue);
        if (this.data != null) {
            this.fillFullName(this.data);
        }
        super.actionExitCurrent_actionPerformed(null);
    }

    private void getSelectNode() {
        this.treeMain.getLastSelectedPathComponent();
        Object obj = this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode node = null;
        if (obj instanceof DefaultKingdeeTreeNode && !(node = (DefaultKingdeeTreeNode)obj).isRoot()) {
            this.isLeaf = node.isLeaf();
            this.data = (ResumeCategoryInfo)node.getUserObject();
        }
    }

    private void clearReturnValue() {
        if (this.returnValue == null) {
            this.returnValue = new HashSet();
        } else {
            this.returnValue.clear();
        }
    }

    private void saveReturnValues(Set returnSet) throws Exception {
        if (this.isShowCheckBox().booleanValue()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
            this.traceNode(root, returnSet);
        } else {
            DefaultKingdeeTreeNode node;
            if (this.treeMain == null) {
                return;
            }
            TreePath path = this.treeMain.getSelectionPath();
            if (path != null && (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject() instanceof ResumeCategoryInfo) {
                returnSet.add((ResumeCategoryInfo)node.getUserObject());
            }
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, Set list) throws Exception {
        if (root.getUserObject() instanceof ResumeCategoryInfo && root.isChecked()) {
            list.add((ResumeCategoryInfo)root.getUserObject());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    public void actionCancelOP_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(null);
    }

    protected void treeMain_mouseClicked(MouseEvent e) throws Exception {
        this.clearReturnValue();
        this.saveReturnValues(this.returnValue);
        Object obj = null;
        Object obj2 = this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode node = null;
        boolean state = this.treeMain.isCollapsed(this.treeMain.getMaxSelectionRow());
        if (e.getClickCount() == 1) {
            if (this.isShowCheckBox().booleanValue()) {
                for (int i = 0; i < this.returnValue.size(); ++i) {
                    obj = this.returnValue.iterator().next();
                    if (!(obj instanceof ResumeCategoryInfo) || !(node = new DefaultKingdeeTreeNode(obj)).isRoot()) continue;
                    this.isLeaf = node.isLeaf();
                }
            } else {
                obj = this.treeMain.getLastSelectedPathComponent();
                if (obj instanceof DefaultKingdeeTreeNode && !(node = (DefaultKingdeeTreeNode)obj).isRoot()) {
                    this.isLeaf = node.isLeaf();
                    this.data = (ResumeCategoryInfo)node.getUserObject();
                }
            }
        } else if (e.getClickCount() == 2 && obj2 instanceof DefaultKingdeeTreeNode && !(node = (DefaultKingdeeTreeNode)obj2).isRoot() && state) {
            this.isLeaf = node.isLeaf();
            this.data = (ResumeCategoryInfo)node.getUserObject();
            this.actionConfirm_actionPerformed(null);
        }
    }

    public boolean isCanceled() {
        return !this.isConfirmed;
    }

    public ResumeCategoryInfo getSelectedData() {
        return this.data;
    }

    private void fillFullName(ResumeCategoryInfo type) throws Exception {
        String longNumber = type.getLongNumber();
        if (longNumber.length() <= 0 || longNumber.indexOf("!") == -1) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber.substring(0, longNumber.indexOf(33)) + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber.substring(0, longNumber.lastIndexOf(33)) + "!%"), CompareType.NOTLIKE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("id");
        sic.add("name");
        ResumeCategoryCollection coll = ResumeCategoryFactory.getRemoteInstance().getResumeCategoryCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            StringBuffer fullName = new StringBuffer();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                fullName.append(coll.get(i).getName());
                fullName.append("-");
            }
            fullName.append(type.getName());
            type.setName(fullName.toString());
        }
    }

    public Boolean isShowCheckBox() {
        return this.getUIContext().get("isShowCheckBox") == null ? this.isShowCheckBox : (Boolean)this.getUIContext().get("isShowCheckBox");
    }

    public void setShowCheckBox(Boolean isShowCheckBox) {
        this.isShowCheckBox = isShowCheckBox;
    }

    public Set getReturnValue() {
        return this.returnValue;
    }
}

