/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeCategory;
import com.kingdee.eas.hr.rec.ITalentCategory;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryFactory;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeF7Enum;
import com.kingdee.eas.hr.rec.TalentCategoryFactory;
import com.kingdee.eas.hr.rec.TalentCategoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractResumeF7UI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ResumeF7UI
extends AbstractResumeF7UI
implements TreeSelectionListener,
ItemListener {
    private static final Logger logger = CoreUIObject.getLogger(ResumeF7UI.class);
    public boolean isCanceled = true;
    private boolean isTalent = false;
    private ResumeBaseCollection datas;
    private ResumeBaseInfo data;
    private boolean isMultiSelect = false;
    private Set selectedResume = new HashSet();
    DefaultKingdeeTreeNode resumeRootTreeNode;
    DefaultKingdeeTreeNode talentRootTreeNode;
    JButton btnAddSelected;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        super.onLoad();
        this.initTblSelected();
        this.init();
        this.getUIMenuBar().setVisible(false);
    }

    private void init() throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            ev.setFilter(filter);
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeCategoryQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(ev);
        IRowSet rows = queryExcu.executeQuery();
        this.resumeRootTreeNode = this.createResumeCategoryTreeNode(rows);
        queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.TalentCategoryQuery");
        queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(ev);
        rows = queryExcu.executeQuery();
        this.talentRootTreeNode = this.createTalentCategoryTreeNode(rows);
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.isInclude.setSelected(true);
        this.isInclude.addItemListener((ItemListener)this);
        this.radioBtnResume.addItemListener((ItemListener)this);
        this.radioBtnTalent.addItemListener((ItemListener)this);
        this.radioBtnResume.setSelected(true);
        this.execQuery();
    }

    private void initTblSelected() {
        this.btnAddSelected = this.contSelected.add((Action)((Object)new ActionAddSelected()));
        this.btnAddSelected.setText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"add"));
        JButton btnRemoveSelected = this.contSelected.add((Action)((Object)new ActionRemoveSelected()));
        btnRemoveSelected.setText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"remove"));
        JButton btnAddAll = this.contSelected.add((Action)((Object)new ActionAddAll()));
        btnAddAll.setText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"add_all"));
        JButton btnRemoveAll = this.contSelected.add((Action)((Object)new ActionRemoveAll()));
        btnRemoveAll.setText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"remove_all"));
    }

    private DefaultKingdeeTreeNode createResumeCategoryTreeNode(IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        KDTreeNode rootTreeNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"resume_category"));
        while (rows.next()) {
            ResumeCategoryInfo categoryInfo = new ResumeCategoryInfo();
            categoryInfo.setId(BOSUuid.read((String)rows.getString("id")));
            categoryInfo.setName(rows.getString("name"));
            categoryInfo.setNumber(rows.getString("number"));
            categoryInfo.setLongNumber(rows.getString("longNumber"));
            categoryInfo.setLevel(rows.getInt("level"));
            categoryInfo.setIsLeaf(rows.getBoolean("isLeaf"));
            ResumeCategoryInfo parentInfo = new ResumeCategoryInfo();
            if (rows.getString("parent.id") == null || rows.getString("parent.id").equals("")) {
                parentInfo = null;
            } else {
                parentInfo.setId(BOSUuid.read((String)rows.getString("parent.id")));
            }
            categoryInfo.setParent(parentInfo);
            if (rootTreeNode == null) continue;
            KDTreeNode subTreeNode = new KDTreeNode((Object)categoryInfo);
            if (categoryInfo.getParent() != null && nodeMap.containsKey(categoryInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(categoryInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            } else {
                rootTreeNode.add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(categoryInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    private DefaultKingdeeTreeNode createTalentCategoryTreeNode(IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        KDTreeNode rootTreeNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"talent_category"));
        while (rows.next()) {
            TalentCategoryInfo categoryInfo = new TalentCategoryInfo();
            categoryInfo.setId(BOSUuid.read((String)rows.getString("id")));
            categoryInfo.setName(rows.getString("name"));
            categoryInfo.setNumber(rows.getString("number"));
            categoryInfo.setLongNumber(rows.getString("longNumber"));
            categoryInfo.setLevel(rows.getInt("level"));
            categoryInfo.setIsLeaf(rows.getBoolean("isLeaf"));
            TalentCategoryInfo parentInfo = new TalentCategoryInfo();
            if (rows.getString("parent.id") == null || rows.getString("parent.id").equals("")) {
                parentInfo = null;
            } else {
                parentInfo.setId(BOSUuid.read((String)rows.getString("parent.id")));
            }
            categoryInfo.setParent(parentInfo);
            if (rootTreeNode == null) continue;
            KDTreeNode subTreeNode = new KDTreeNode((Object)categoryInfo);
            subTreeNode.setUserObject((Object)categoryInfo);
            if (categoryInfo.getParent() != null && nodeMap.containsKey(categoryInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(categoryInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            } else {
                rootTreeNode.add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(categoryInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = RecUtils.getHRFilterByParam("REC002");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("resumeBase.isInter", (Object)Boolean.FALSE));
        return filterInfo;
    }

    public void actionFastQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo defaultFilter = this.getDefaultFilterForQuery();
        FilterInfo fi = this.createFastQueryFilter();
        if (fi != null && fi.getFilterItems().size() > 0) {
            if (FilterUtility.hasFilterItem((FilterInfo)defaultFilter)) {
                fi.mergeFilter(defaultFilter, "and");
            }
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(fi);
        } else if (defaultFilter.getFilterItems() != null && defaultFilter.getFilterItems().size() > 0) {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(defaultFilter);
        }
        this.execQuery();
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
    }

    private FilterInfo createFastQueryFilter() {
        int type = ((ResumeF7Enum)((Object)this.comboType.getSelectedItem())).getValue();
        String text = this.textValue.getText().trim();
        FilterInfo fi = new FilterInfo();
        if (type == 1) {
            if (this.isLikeQuery.isSelected()) {
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.name", (Object)("%" + text + "%"), CompareType.LIKE));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.name", (Object)text));
            }
        } else if (type == 2) {
            if (this.isLikeQuery.isSelected()) {
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.number", (Object)("%" + text + "%"), CompareType.LIKE));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.number", (Object)text));
            }
        }
        return fi;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0) {
            if (e.getClickCount() == 2) {
                this.btnAddSelected.doClick();
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        try {
            if (this.selectedResume != null && this.selectedResume.size() > 0) {
                IResumeBase dao = ResumeBaseFactory.getRemoteInstance();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.selectedResume, CompareType.INCLUDE));
                evi.setFilter(fi);
                this.datas = dao.getResumeBaseCollection(evi);
            }
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        if (!this.isMultiSelect && this.datas != null && this.datas.size() > 0) {
            this.data = this.datas.get(0);
        }
        if (this.data == null && !this.isMultiSelect) {
            return;
        }
        if (this.datas == null && this.isMultiSelect) {
            return;
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return ResumeCategoryFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.createTreeFilter();
        this.execQuery();
    }

    private void createTreeFilter() {
        FilterItemCollection col;
        FilterInfo mainFilter;
        block17: {
            KDTreeNode treeNode = this.getSelectedTreeNode();
            if (treeNode == null) {
                return;
            }
            if (this.mainQuery.getFilter() == null) {
                this.mainQuery.setFilter(new FilterInfo());
            }
            mainFilter = this.mainQuery.getFilter();
            col = mainFilter.getFilterItems();
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            this.mainQuery.getFilter().remove("maskString");
            if (treeNode.getUserObject() instanceof CoreBaseInfo) {
                String categoryId = ((CoreBaseInfo)treeNode.getUserObject()).getId().toString();
                if (this.isInclude.isSelected()) {
                    try {
                        SelectorItemCollection sic = RecUtils.getSic(new String[]{"id", "name", "longNumber"});
                        if (this.radioBtnResume.isSelected()) {
                            IResumeCategory dao = ResumeCategoryFactory.getRemoteInstance();
                            ResumeCategoryInfo categoryInfo = dao.getResumeCategoryInfo((IObjectPK)new ObjectUuidPK(categoryId), sic);
                            col.add(new FilterItemInfo("category.longNumber", (Object)categoryInfo.getLongNumber(), CompareType.EQUALS));
                            col.add(new FilterItemInfo("category.longNumber", (Object)(categoryInfo.getLongNumber() + "!%"), CompareType.LIKE));
                            mainFilter.setMaskString("#0 or #1");
                            break block17;
                        }
                        ITalentCategory dao = TalentCategoryFactory.getRemoteInstance();
                        TalentCategoryInfo categoryInfo = dao.getTalentCategoryInfo((IObjectPK)new ObjectUuidPK(categoryId), sic);
                        col.add(new FilterItemInfo("category.longNumber", (Object)categoryInfo.getLongNumber(), CompareType.EQUALS));
                        col.add(new FilterItemInfo("category.longNumber", (Object)(categoryInfo.getLongNumber() + "!%"), CompareType.LIKE));
                        mainFilter.setMaskString("#0 or #1");
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                } else {
                    col.add(new FilterItemInfo("category.id", (Object)categoryId));
                }
            } else if (this.isInclude.isSelected()) {
                col.add(new FilterItemInfo("category.id", (Object)this.getTreeIds(), CompareType.INCLUDE));
                col.add(new FilterItemInfo("category.id", null));
                mainFilter.setMaskString("#0 or #1");
            } else {
                col.add(new FilterItemInfo("category.id", null));
            }
        }
        FilterInfo fi = this.getDefaultFilterForQuery();
        if (fi != null && fi.getFilterItems().size() > 0) {
            try {
                if (col.size() > 0) {
                    mainFilter.mergeFilter(fi, "and");
                } else {
                    this.mainQuery.setFilter(fi);
                }
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButton) {
            if (this.radioBtnResume.isSelected()) {
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeF7Query");
                this.isTalent = false;
                if (this.resumeRootTreeNode == null) {
                    this.treeMain.setModel(null);
                } else {
                    this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.resumeRootTreeNode));
                }
                if (this.resumeRootTreeNode != null) {
                    TreePath path = new TreePath(this.resumeRootTreeNode.getPath());
                    this.treeMain.expandPath(path);
                    this.treeMain.setSelectionPath(path);
                }
            } else {
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeF7ForTalentQuery");
                this.isTalent = true;
                if (this.talentRootTreeNode == null) {
                    this.treeMain.setModel(null);
                } else {
                    this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.talentRootTreeNode));
                }
                if (this.talentRootTreeNode != null) {
                    TreePath path = new TreePath(this.talentRootTreeNode.getPath());
                    this.treeMain.expandPath(path);
                    this.treeMain.setSelectionPath(path);
                }
            }
            this.tblSelected.removeRows();
            this.selectedResume.clear();
        } else {
            this.createTreeFilter();
            this.execQuery();
        }
    }

    public boolean isTalent() {
        return this.isTalent;
    }

    public ResumeBaseCollection getDatas() {
        return this.datas;
    }

    public ResumeBaseInfo getData() {
        return this.data;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        String resumeCategoryQuery = "com.kingdee.eas.hr.rec.app.ResumeCategoryQuery";
        request.put("resumeCategoryQuery", (Object)resumeCategoryQuery);
        String talentCategoryQuery = "com.kingdee.eas.hr.rec.app.TalentCategoryQuery";
        request.put("talentCategoryQuery", (Object)talentCategoryQuery);
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public String getTreeIds() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            ev.setFilter(filter);
        }
        ev.getSelector().add(new SelectorItemInfo("id"));
        TreeBaseCollection treeCols = null;
        try {
            treeCols = this.radioBtnResume.isSelected() ? ResumeCategoryFactory.getRemoteInstance().getAllChildren(null, ev) : TalentCategoryFactory.getRemoteInstance().getAllChildren(null, ev);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        StringBuffer treeIds = new StringBuffer();
        if (treeCols != null) {
            for (int i = 0; i < treeCols.size(); ++i) {
                if (i == treeCols.size() - 1) {
                    treeIds.append(treeCols.get(i).getId());
                    continue;
                }
                treeIds.append(treeCols.get(i).getId()).append(",");
            }
        }
        return treeIds.toString();
    }

    private class ActionRemoveSelected
    extends ItemAction {
        public ActionRemoveSelected() {
            this(null);
        }

        public ActionRemoveSelected(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift r"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)ResumeF7UI.this.tblSelected);
            int j = selectRows.length;
            for (int i = 0; i < j; ++i) {
                if (ResumeF7UI.this.tblSelected.getCell(selectRows[i], "id") == null) continue;
                String id = ResumeF7UI.this.tblSelected.getCell(selectRows[i], "id").getValue().toString();
                ResumeF7UI.this.selectedResume.remove(id);
                ResumeF7UI.this.tblSelected.removeRow(i);
            }
        }
    }

    private class ActionAddSelected
    extends ItemAction {
        public ActionAddSelected() {
            this(null);
        }

        public ActionAddSelected(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift s"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)ResumeF7UI.this.tblMain);
            Object obj = null;
            int j = selectRows.length;
            for (int i = 0; i < j; ++i) {
                IRow row = ResumeF7UI.this.tblMain.getRow(selectRows[i]);
                if (row == null || row.getCell("resumeBase.id") == null || row.getCell("interviewActivity.id") == null) continue;
                String id = row.getCell("resumeBase.id").getValue().toString();
                Object activityId = row.getCell("interviewActivity.id").getValue();
                BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("resumeBase.resumeState").getValue();
                if (activityId != null && state != null && (state.getInt() != 4 || state.getInt() == 0)) {
                    MsgBox.showWarning((Component)((Object)ResumeF7UI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"resume_locked"));
                    SysUtil.abort();
                }
                if (state != null && (state.getInt() == 6 || state.getInt() == 3)) {
                    MsgBox.showWarning((Component)((Object)ResumeF7UI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"can_not_set_interview_pass_resume"));
                    SysUtil.abort();
                }
                if (ResumeF7UI.this.selectedResume.contains(id)) continue;
                ResumeF7UI.this.selectedResume.add(id);
                IRow row2 = ResumeF7UI.this.tblSelected.addRow();
                row2.getCell("id").setValue((Object)id);
                obj = row.getCell("resumeBase.name").getValue();
                row2.getCell("name").setValue(obj);
                obj = row.getCell("resumeBase.number").getValue();
                row2.getCell("number").setValue(obj);
                obj = row.getCell("resumeBase.gender").getValue();
                row2.getCell("gender").setValue(obj);
                obj = row.getCell("resumeBase.age").getValue();
                if (obj != null) {
                    row2.getCell("age").setValue(obj.toString().equals("0") ? "" : obj);
                    continue;
                }
                row2.getCell("age").setValue(obj);
            }
        }
    }

    private class ActionRemoveAll
    extends ItemAction {
        public ActionRemoveAll() {
            this(null);
        }

        public ActionRemoveAll(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift a"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            ResumeF7UI.this.tblSelected.removeRows();
            ResumeF7UI.this.selectedResume.clear();
        }
    }

    private class ActionAddAll
    extends ItemAction {
        public ActionAddAll() {
            this(null);
        }

        public ActionAddAll(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift I"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount = ResumeF7UI.this.tblMain.getRowCount3();
            Object obj = null;
            for (int i = 0; i < rowCount; ++i) {
                IRow row = ResumeF7UI.this.tblMain.getRow(i);
                String id = row.getCell("resumeBase.id").getValue().toString();
                Object activityId = row.getCell("interviewActivity.id").getValue();
                BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("resumeBase.resumeState").getValue();
                if (activityId != null && state != null && (state.getInt() != 4 || state.getInt() == 0)) {
                    MsgBox.showWarning((Component)((Object)ResumeF7UI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"resume_locked"));
                    SysUtil.abort();
                }
                if (state != null && (state.getInt() == 6 || state.getInt() == 3)) {
                    MsgBox.showWarning((Component)((Object)ResumeF7UI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewActivityResource", (String)"can_not_set_interview_pass_resume"));
                    SysUtil.abort();
                }
                if (ResumeF7UI.this.selectedResume.contains(id)) continue;
                ResumeF7UI.this.selectedResume.add(id);
                IRow newRow = ResumeF7UI.this.tblSelected.addRow();
                newRow.getCell("id").setValue((Object)id);
                obj = row.getCell("resumeBase.name").getValue();
                newRow.getCell("name").setValue(obj);
                obj = row.getCell("resumeBase.number").getValue();
                newRow.getCell("number").setValue(obj);
                obj = row.getCell("resumeBase.gender").getValue();
                newRow.getCell("gender").setValue(obj);
                obj = row.getCell("resumeBase.age").getValue();
                if (obj != null) {
                    newRow.getCell("age").setValue(obj.toString().equals("0") ? "" : obj);
                    continue;
                }
                newRow.getCell("age").setValue(obj);
            }
        }
    }
}

