/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.base.ISpecialtyType;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.SpecialtyTypeInfo;
import com.kingdee.eas.hr.rec.InterviewException;
import com.kingdee.eas.hr.rec.InterviewLevelCollection;
import com.kingdee.eas.hr.rec.InterviewLevelFactory;
import com.kingdee.eas.hr.rec.InterviewLevelInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.client.AbstractResumeFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ResumeFilterUI
extends AbstractResumeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ResumeFilterUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private boolean isContextSearch = false;
    private Object[] comboxInfos;
    private final int PageSize = 10;

    public void onLoad() throws Exception {
        this.ypDateFrom.setValue(null);
        this.ypDateTo.setValue(null);
        this.workDateFrom.setValue(null);
        this.workDateTo.setValue(null);
        this.txtWorkYearsFrom.setText("");
        this.txtWorkYearsFrom.setSupportedEmpty(true);
        this.txtWorkYearsTo.setText("");
        this.txtWorkYearsTo.setSupportedEmpty(true);
        this.txtAgeFrom.setText("");
        this.txtAgeFrom.setSupportedEmpty(true);
        this.txtAgeTo.setText("");
        this.txtAgeTo.setSupportedEmpty(true);
        this.comboResumeState.addItem((Object)"");
        this.comboResumeState.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.rec.ResumeStateEnum").toArray());
        this.comboResumeState.setEditable(false);
        this.comboResumeStep.setEnabled(false);
        this.comboResumeStep.setEditable(false);
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrgUnit, true, false, "$name$");
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        this.prmtHighestDiploma.setValue(null);
        this.prmtHighestDiploma.setEditable(false);
        this.prmtSpecialtyType.setValue(null);
        this.prmtSpecialtyType.setEnabledMultiSelection(true);
        this.prmtSpecialtyType.setEditable(false);
        this.txtSkill.setText("");
        this.txtCertificate.setText("");
        super.onLoad();
        this.cbContextSearch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg) {
                ResumeFilterUI.this.isContextSearch = ResumeFilterUI.this.cbContextSearch.isSelected();
                ResumeFilterUI.this.setState(ResumeFilterUI.this.isContextSearch);
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1));
        this.txtPage.setModel((SpinnerModel)model);
        this.clear();
    }

    public void actionStateChange_actionPerformed(ActionEvent e) {
        Object state = this.comboResumeState.getSelectedItem();
        if (state != null && state instanceof ResumeStateEnum && ((ResumeStateEnum)((Object)state)).getValue() == 2) {
            this.comboResumeStep.setEnabled(true);
            this.initComboResumeStep();
        } else {
            this.comboResumeStep.setSelectedIndex(-1);
            this.comboResumeStep.setEnabled(false);
        }
    }

    public FilterInfo getFilterInfo() {
        Object[] objs;
        DiplomaInfo diplomaInfo;
        int i;
        HashSet<String> set;
        Object[] objs2;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        this.isContextSearch = this.cbContextSearch.isSelected();
        if (this.isContextSearch) {
            Object keyWord = this.txtContextSearch.getSelectedItem();
            if (keyWord != null && !StringUtils.isEmpty((String)keyWord.toString())) {
                int page = (Integer)this.txtPage.getValue() - 1;
                int startRecord = 0;
                startRecord = page < 0 ? 0 : page * 10;
                try {
                    Map results = TalentExtendFactory.getRemoteInstance().searchContext(keyWord.toString(), startRecord, 10);
                    HashSet ids = (HashSet)results.get("resultIdsSet");
                    if (ids != null && ids.size() > 0) {
                        itemCollection.add(new FilterItemInfo("resumeBase.id", (Object)ids, CompareType.INCLUDE));
                    } else {
                        itemCollection.add(new FilterItemInfo("resumeBase.id", (Object)"no"));
                    }
                }
                catch (Exception ex) {
                    super.handUIException((Throwable)ex);
                }
            }
            return this.filterInfo;
        }
        if (!RecUtils.objectIsNull(this.ypDateFrom.getValue())) {
            item = new FilterItemInfo("resumeBase.yingPDate", (Object)((Date)this.ypDateFrom.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.ypDateTo.getValue())) {
            Date d = (Date)this.ypDateTo.getValue();
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            c.add(6, 1);
            item = new FilterItemInfo("resumeBase.yingPDate", (Object)c.getTime(), CompareType.LESS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.workDateFrom.getValue())) {
            item = new FilterItemInfo("resumeBase.workDate", (Object)((Date)this.workDateFrom.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.workDateTo.getValue())) {
            item = new FilterItemInfo("resumeBase.workDate", (Object)((Date)this.workDateTo.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.comboResumeState.getSelectedItem())) {
            ResumeStateEnum resumeStateEnum = (ResumeStateEnum)((Object)this.comboResumeState.getSelectedItem());
            item = new FilterItemInfo("resumeBase.resumeState", (Object)new Integer(resumeStateEnum.getValue()), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.comboResumeStep.getSelectedItem())) {
            InterviewLevelInfo interviewInfo = (InterviewLevelInfo)this.comboResumeStep.getSelectedItem();
            item = new FilterItemInfo("interviewLevel.id", (Object)interviewInfo.getId(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtAgeFrom.getText())) {
            item = new FilterItemInfo("resumeBase.age", (Object)new Integer(this.txtAgeFrom.getText()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtAgeTo.getText())) {
            item = new FilterItemInfo("resumeBase.age", (Object)new Integer(this.txtAgeTo.getText()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtWorkYearsFrom.getText())) {
            item = new FilterItemInfo("resumeBase.workYears", (Object)new Integer(this.txtWorkYearsFrom.getText()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtWorkYearsTo.getText())) {
            item = new FilterItemInfo("resumeBase.workYears", (Object)new Integer(this.txtWorkYearsTo.getText()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (this.prmtPosition.getValue() != null && (objs2 = (Object[])this.prmtPosition.getValue()).length > 0 && objs2[0] != null) {
            set = new HashSet<String>();
            for (i = 0; i < objs2.length; ++i) {
                PositionInfo positionInfo = (PositionInfo)objs2[i];
                set.add(positionInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("position.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (this.prmtAdminOrgUnit.getValue() != null && (objs2 = (Object[])this.prmtAdminOrgUnit.getValue()).length > 0 && objs2[0] != null) {
            set = new HashSet();
            for (i = 0; i < objs2.length; ++i) {
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)objs2[i];
                set.add(adminOrgUnitInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("adminOrgUnit.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (!RecUtils.objectIsNull(diplomaInfo = (DiplomaInfo)this.prmtHighestDiploma.getValue())) {
            item = new FilterItemInfo("diploma.id", (Object)diplomaInfo.getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            item = new FilterItemInfo("educationExp1.highDegree", (Object)new Boolean(true), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (this.prmtSpecialtyType.getValue() != null && this.prmtSpecialtyType.getValue() instanceof Object[] && (objs = (Object[])this.prmtSpecialtyType.getValue()).length > 0 && objs[0] != null) {
            HashSet<String> set2 = new HashSet<String>();
            for (int i2 = 0; i2 < objs.length; ++i2) {
                SpecialtyTypeInfo specialtyTypeInfo = (SpecialtyTypeInfo)objs[i2];
                set2.add(specialtyTypeInfo.getId().toString());
            }
            if (set2.size() > 0) {
                item = new FilterItemInfo("specialtyType.id", set2, CompareType.INCLUDE);
                itemCollection.add(item);
            }
            item = new FilterItemInfo("educationExp1.highDegree", (Object)new Boolean(true), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtSkill.getText())) {
            item = new FilterItemInfo("resumeBase.skill.name", (Object)("%" + this.txtSkill.getText().trim() + "%"), CompareType.LIKE);
            itemCollection.add(item);
        }
        if (!RecUtils.objectIsNull(this.txtCertificate.getText())) {
            item = new FilterItemInfo("resumebase.certificate.name", (Object)("%" + this.txtCertificate.getText().trim() + "%"), CompareType.LIKE);
            itemCollection.add(item);
        }
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        Object[] sts;
        int i;
        Object[] ogs;
        CustomerParams cp = new CustomerParams();
        Object value = this.ypDateFrom.getValue();
        if (value != null) {
            cp.putDate("ypDateFrom", (Date)value);
        }
        if ((value = this.ypDateTo.getValue()) != null) {
            cp.putDate("ypDateTo", (Date)value);
        }
        if ((value = this.workDateFrom.getValue()) != null) {
            cp.putDate("workDateFrom", (Date)value);
        }
        if ((value = this.workDateTo.getValue()) != null) {
            cp.putDate("workDateTo", (Date)value);
        }
        if ((value = this.txtWorkYearsFrom.getText()) != null) {
            cp.addCustomerParam("workYearsFrom", value.toString());
        }
        if ((value = this.txtWorkYearsTo.getText()) != null) {
            cp.addCustomerParam("workYearsTo", value.toString());
        }
        if ((value = this.txtAgeFrom.getText()) != null) {
            cp.addCustomerParam("ageFrom", value.toString());
        }
        if ((value = this.txtAgeTo.getText()) != null) {
            cp.addCustomerParam("ageTo", value.toString());
        }
        if ((value = this.comboResumeState.getSelectedItem()) != null && value instanceof ResumeStateEnum) {
            cp.putInt("resumeState", ((ResumeStateEnum)((Object)value)).getValue());
        } else {
            cp.putInt("resumeState", -1);
        }
        value = this.comboResumeStep.getSelectedItem();
        if (value != null && !"".equals(value)) {
            InterviewLevelInfo levelInfo = (InterviewLevelInfo)this.comboResumeStep.getSelectedItem();
            cp.addCustomerParam("interviewLevel", levelInfo.getId().toString());
        }
        if ((value = this.prmtAdminOrgUnit.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("adminOrgUnit", orgUnits.toString());
        }
        if ((value = this.prmtPosition.getValue()) != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            StringBuffer positions = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                positions.append(((PositionInfo)ogs[i]).getId().toString());
                positions.append("\u2014\u2014");
            }
            positions.append(((PositionInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("position", positions.toString());
        }
        if (!RecUtils.objectIsNull(value = this.prmtHighestDiploma.getValue()) && value instanceof DiplomaInfo) {
            cp.addCustomerParam("highestDiploma", ((DiplomaInfo)value).getId().toString());
        }
        if ((value = this.prmtSpecialtyType.getValue()) != null && value instanceof Object[] && (sts = (Object[])value).length > 0 && sts[0] != null) {
            StringBuffer specialTypes = new StringBuffer();
            for (i = 0; i < sts.length - 1; ++i) {
                specialTypes.append(((SpecialtyTypeInfo)sts[i]).getId().toString());
                specialTypes.append("\u2014\u2014");
            }
            specialTypes.append(((SpecialtyTypeInfo)sts[i]).getId().toString());
            cp.addCustomerParam("specialtyType", specialTypes.toString());
        }
        if (!RecUtils.objectIsNull(value = this.txtSkill.getText())) {
            cp.addCustomerParam("skill", value.toString());
        }
        if (!RecUtils.objectIsNull(value = this.txtCertificate.getText())) {
            cp.addCustomerParam("certificate", value.toString());
        }
        cp.putBoolean("isContext", this.cbContextSearch.isSelected());
        value = this.txtContextSearch.getSelectedItem();
        if (!RecUtils.objectIsNull(value) && !RecUtils.objectIsNull(value.toString())) {
            cp.addCustomerParam("contextData", value.toString());
        }
        if ((value = this.txtPage.getValue()) != null) {
            cp.addCustomerParam("page", value.toString());
        }
        boolean isDisplayName = this.chkDisplayName.isSelected();
        cp.addCustomerParam("isDisplayName", String.valueOf(isDisplayName));
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        AdminOrgUnitCollection col;
        this.clear();
        EntityViewInfo evi = new EntityViewInfo();
        Object value = cp.getDate("ypDateFrom");
        if (!this.objectIsNull(value)) {
            this.ypDateFrom.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("ypDateTo"))) {
            this.ypDateTo.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("workDateFrom"))) {
            this.workDateFrom.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("workDateTo"))) {
            this.workDateTo.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("workYearsFrom"))) {
            this.txtWorkYearsFrom.setText(value.toString());
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("workYearsTo"))) {
            this.txtWorkYearsTo.setText(value.toString());
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("ageFrom"))) {
            this.txtAgeFrom.setText(value.toString());
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("ageTo"))) {
            this.txtAgeTo.setText(value.toString());
        }
        int state = cp.getInt("resumeState");
        switch (state) {
            case 2: {
                this.comboResumeState.setSelectedItem((Object)ResumeStateEnum.interviewing);
                break;
            }
            case 0: {
                this.comboResumeState.setSelectedItem((Object)ResumeStateEnum.no_dispose);
                break;
            }
            case 1: {
                this.comboResumeState.setSelectedItem((Object)ResumeStateEnum.no_interview);
                break;
            }
            case 4: {
                this.comboResumeState.setSelectedItem((Object)ResumeStateEnum.no_pass);
                break;
            }
            case 3: {
                this.comboResumeState.setSelectedItem((Object)ResumeStateEnum.pass);
                break;
            }
            default: {
                this.comboResumeState.setSelectedIndex(-1);
            }
        }
        value = cp.getCustomerParam("interviewLevel");
        if (!this.objectIsNull(value)) {
            InterviewLevelInfo levelInfo = null;
            if (this.comboxInfos == null) {
                this.initComboResumeStep();
            }
            int length = this.comboxInfos.length;
            for (int i = 0; i < length; ++i) {
                InterviewLevelInfo info = (InterviewLevelInfo)this.comboxInfos[i];
                if (!info.getId().toString().equals(value.toString())) continue;
                levelInfo = info;
                break;
            }
            this.comboResumeStep.setSelectedItem(levelInfo);
        }
        try {
            value = cp.getCustomerParam("adminOrgUnit");
            if (!RecUtils.objectIsNull(value)) {
                String[] adminOrg = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.prmtAdminOrgUnit.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        try {
            value = cp.getCustomerParam("position");
            if (!RecUtils.objectIsNull(value)) {
                String[] positionIds = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IPosition position = PositionFactory.getRemoteInstance();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(positionIds)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = position.getPositionCollection(evi);
                this.prmtPosition.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        try {
            value = cp.getCustomerParam("highestDiploma");
            if (value != null) {
                IDiploma diploma = DiplomaFactory.getRemoteInstance();
                DiplomaInfo info = diploma.getDiplomaInfo((IObjectPK)new ObjectUuidPK(value.toString()));
                this.prmtHighestDiploma.setValue((Object)info);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        try {
            value = cp.getCustomerParam("specialtyType");
            if (value != null) {
                ISpecialtyType specialtyType = SpecialtyTypeFactory.getRemoteInstance();
                String[] typeIds = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(typeIds)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = specialtyType.getSpecialtyTypeCollection(evi);
                this.prmtSpecialtyType.setValue((Object)col.toArray());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        value = cp.getCustomerParam("skill");
        if (!RecUtils.objectIsNull(value)) {
            this.txtSkill.setText(value.toString());
        }
        if (!RecUtils.objectIsNull(value = cp.getCustomerParam("certificate"))) {
            this.txtCertificate.setText(value.toString());
        }
        this.isContextSearch = cp.getBoolean("isContext");
        this.cbContextSearch.setSelected(this.isContextSearch);
        this.setState(this.isContextSearch);
        value = cp.getCustomerParam("contextData");
        if (!RecUtils.objectIsNull(value)) {
            this.txtContextSearch.setSelectedItemData(value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("page"))) {
            this.txtPage.setValue((Object)new Integer(value.toString()));
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("isDisplayName"))) {
            if ("true".equals(value.toString())) {
                this.chkDisplayName.setSelected(true);
            } else {
                this.chkDisplayName.setSelected(false);
            }
        }
    }

    private void setState(boolean isContext) {
        this.ypDateFrom.setEnabled(!isContext);
        this.ypDateTo.setEnabled(!isContext);
        this.workDateFrom.setEnabled(!isContext);
        this.workDateTo.setEnabled(!isContext);
        this.txtWorkYearsFrom.setEnabled(!isContext);
        this.txtWorkYearsTo.setEnabled(!isContext);
        this.txtAgeFrom.setEnabled(!isContext);
        this.txtAgeTo.setEnabled(!isContext);
        this.comboResumeState.setEnabled(!isContext);
        Object state = this.comboResumeState.getSelectedItem();
        if (state != null && state instanceof ResumeStateEnum && ((ResumeStateEnum)((Object)state)).getValue() == 2) {
            this.comboResumeStep.setEnabled(!isContext);
        } else {
            this.comboResumeStep.setEnabled(false);
        }
        this.prmtAdminOrgUnit.setEnabled(!isContext);
        this.prmtHighestDiploma.setEnabled(!isContext);
        this.prmtPosition.setEnabled(!isContext);
        this.prmtSpecialtyType.setEnabled(!isContext);
        this.txtSkill.setEnabled(!isContext);
        this.txtCertificate.setEnabled(!isContext);
        this.txtContextSearch.setEnabled(isContext);
        this.txtPage.setEnabled(isContext);
    }

    public void clear() {
        this.ypDateFrom.setValue(null);
        this.ypDateTo.setValue(null);
        this.workDateFrom.setValue(null);
        this.workDateTo.setValue(null);
        this.txtWorkYearsFrom.setText("");
        this.txtWorkYearsTo.setText("");
        this.txtAgeFrom.setText("");
        this.txtAgeTo.setText("");
        this.comboResumeState.setEditable(false);
        this.comboResumeState.setSelectedIndex(-1);
        this.comboResumeStep.setEnabled(false);
        this.comboResumeStep.setEditable(false);
        this.comboResumeStep.setSelectedIndex(-1);
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtHighestDiploma.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtSpecialtyType.setValue(null);
        this.txtSkill.setText("");
        this.txtCertificate.setText("");
        this.cbContextSearch.setSelected(false);
        this.txtContextSearch.setEnabled(false);
        this.txtContextSearch.setSelectedItemData(null);
        this.txtPage.setEnabled(false);
        this.txtPage.setValue((Object)new Integer(1));
        this.chkDisplayName.setSelected(true);
    }

    public boolean verify() {
        int to;
        int from;
        Date ypStartDate = (Date)this.ypDateFrom.getValue();
        Date ypEndDate = (Date)this.ypDateTo.getValue();
        if (ypStartDate != null && ypEndDate != null && ypStartDate.after(ypEndDate)) {
            this.ypDateTo.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"endDate_little_startDate"));
            SysUtil.abort();
        }
        Date workStartDate = (Date)this.workDateFrom.getValue();
        Date workEndDate = (Date)this.workDateTo.getValue();
        if (workStartDate != null && workEndDate != null && workStartDate.after(workEndDate)) {
            this.workDateTo.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"endDate_little_startDate"));
            SysUtil.abort();
        }
        if (!RecUtils.objectIsNull(this.txtAgeFrom.getText()) && !RecUtils.objectIsNull(this.txtAgeTo.getText()) && (from = new Integer(this.txtAgeFrom.getText()).intValue()) > (to = new Integer(this.txtAgeTo.getText()).intValue())) {
            this.txtAgeTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.AGE_FROM_GT_TO).getMessage());
            return false;
        }
        if (!RecUtils.objectIsNull(this.txtWorkYearsFrom.getText()) && !RecUtils.objectIsNull(this.txtWorkYearsTo.getText()) && (from = new Integer(this.txtWorkYearsFrom.getText()).intValue()) > (to = new Integer(this.txtWorkYearsTo.getText()).intValue())) {
            this.txtWorkYearsTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.WORKYEARS_FROM_GT_TO).getMessage());
            return false;
        }
        this.isContextSearch = this.cbContextSearch.isSelected();
        if (this.isContextSearch) {
            Object keyWord = this.txtContextSearch.getSelectedItem();
            if (keyWord != null && !StringUtils.isEmpty((String)keyWord.toString())) {
                if (this.objectIsNull(this.txtPage.getValue())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"contextSearchPageNotNull"));
                    return false;
                }
                int page = (Integer)this.txtPage.getValue() - 1;
                int startRecord = 0;
                int totalSize = 0;
                startRecord = page < 0 ? 0 : page * 10;
                try {
                    Map results = TalentExtendFactory.getRemoteInstance().searchContext(keyWord.toString(), startRecord, 10);
                    totalSize = new Double(new Integer((String)results.get("totalResultSize")) / 10).intValue() + 1;
                    if (totalSize < page) {
                        MsgBox.showWarning((Component)((Object)this), (String)new StringBuffer().append(EASResource.getString((String)resumeRES, (String)"contextSearchTotalResultSize")).append(totalSize).append(",").append(EASResource.getString((String)resumeRES, (String)"pleaseChangePage")).toString());
                        return false;
                    }
                }
                catch (Exception ex) {
                    super.handUIException((Throwable)ex);
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"contextSearchContentNotNull"));
                return false;
            }
        }
        return true;
    }

    private boolean objectIsNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return StringUtils.isEmpty((String)object.toString());
        }
        return false;
    }

    private void initComboResumeStep() {
        try {
            if (this.comboxInfos == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
                if (filter != null) {
                    viewInfo.setFilter(filter);
                }
                InterviewLevelCollection collection = InterviewLevelFactory.getRemoteInstance().getInterviewLevelCollection(viewInfo);
                int length = collection.size();
                this.comboxInfos = new Object[length];
                for (int i = 0; i < length; ++i) {
                    this.comboxInfos[i] = collection.get(i);
                }
            }
            this.comboResumeStep.removeAllItems();
            this.comboResumeStep.addItem((Object)"");
            this.comboResumeStep.addItems(this.comboxInfos);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }
}

