/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.emp.client.PhotoPanel;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.ResumePhotoInfo;
import com.kingdee.eas.hr.rec.client.AbstractResumeHistoryEditUI;
import com.kingdee.eas.hr.rec.client.ResumeListEditUI;
import com.kingdee.eas.hr.rec.util.ProvinceAndCityComboBoxHelper;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.client.ComBoxInfo;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;

public class ResumeHistoryEditUI
extends AbstractResumeHistoryEditUI {
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private PhotoPanel pPanel = new PhotoPanel();
    private BufferedImage oldPhoto;

    public void onLoad() throws Exception {
        ProvinceAndCityComboBoxHelper.initProvinceAndCity(this.provinceComboBox, this.cityComboBox);
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.pPanel.setBounds(0, 0, this.photoPanel.getWidth(), this.photoPanel.getHeight());
        this.photoPanel.add((Component)this.pPanel);
        this.setPreferredSize(new Dimension(770, 820));
    }

    public void initWorkButton() {
        this.btnPrintResume.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.promRecChanne.setEditable(false);
        this.menuEdit.setVisible(false);
        this.menuEdit.setEnabled(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String idCardNO;
        Integer workYears;
        String email;
        String name;
        String number = this.txtNumber.getText();
        if (number == null || number.trim().length() <= 0) {
            this.txtNumber.requestFocusInWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"please_enter_number"));
            SysUtil.abort();
        }
        if ((name = this.txtName.getSelectedItemData().toString()) == null || name.trim().length() <= 0) {
            this.txtName.requestFocusInWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.RecCommonResource", (String)"please_enter_name"));
            SysUtil.abort();
        }
        if ((email = this.txtEmail.getText()) != null && email.length() > 0 && email.indexOf("@") < 0) {
            this.txtEmail.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"wrong_email"));
            SysUtil.abort();
        }
        if ((workYears = this.txtWorkYears.getIntegerValue()) < 0) {
            this.txtWorkYears.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"workYears_is_positive"));
            SysUtil.abort();
        }
        if ((idCardNO = this.txtIdCardNO.getText()) != null && idCardNO.length() > 0 && idCardNO.length() != 15 && idCardNO.length() != 18) {
            this.txtIdCardNO.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"wrong_IDNO"));
            SysUtil.abort();
        }
    }

    public void storeFields() {
        this.storeProvince();
        this.storeCity();
        super.storeFields();
    }

    public void loadFields() {
        CodingRuleHelper.setAutoNumber((EditUI)this, (CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.getOprtState());
        super.loadFields();
        this.loadProvince();
        this.loadCity();
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.pPanel.setOprtStat(OprtState.EDIT);
        } else {
            this.pPanel.setOprtStat(null);
        }
        this.setPhotoImage();
        Object date = this.pkYingPDate.getValue();
        if (date == null) {
            this.pkYingPDate.setValue((Object)new Date());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void lockUIForViewStatus() {
        this.prmtFolk.setEnabled(false);
        this.prmtHealth.setEnabled(false);
        this.prmtPoliticalFace.setEnabled(false);
        this.prmtWed.setEnabled(false);
        this.comboGender.setEnabled(false);
        this.cityComboBox.setEnabled(false);
        this.provinceComboBox.setEnabled(false);
        super.lockUIForViewStatus();
    }

    protected void unLockUI() {
        super.unLockUI();
        this.comboGender.setEnabled(true);
        this.cityComboBox.setEnabled(true);
        this.provinceComboBox.setEnabled(true);
        this.prmtFolk.setEnabled(true);
        this.prmtHealth.setEnabled(true);
        this.prmtPoliticalFace.setEnabled(true);
        this.prmtWed.setEnabled(true);
    }

    public void actionPrintResume_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid resumeBaseId = this.editData.getId();
        if (resumeBaseId == null) {
            return;
        }
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(resumeBaseId);
        ResumePrintProvider.executeActionPrint(list, (Component)((Object)this));
    }

    protected IObjectValue createNewData() {
        ResumeHistoryInfo ResumeHistoryInfo2 = new ResumeHistoryInfo();
        return ResumeHistoryInfo2;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ResumeHistoryFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String resumeHistoryId = null;
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        if (resumeListEditUI.getUIContext().get("ID") != null) {
            resumeHistoryId = resumeListEditUI.getUIContext().get("ID").toString();
        }
        if (resumeHistoryId != null) {
            ResumeHistoryInfo resumeHistoryInfo;
            this.editData = resumeHistoryInfo = ResumeHistoryFactory.getRemoteInstance().getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(resumeHistoryId), this.getMergedSelector());
            this.setDataObject((IObjectValue)this.editData);
            resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
        } else {
            this.createNewData();
        }
        return this.editData;
    }

    public boolean isModify() {
        BufferedImage currPhoto = this.pPanel.getSelectImage();
        if (currPhoto == null) {
            return super.isModify();
        }
        return true;
    }

    private void storeProvince() {
        if (!TrainClientUtil.objectIsNull((Object)this.provinceComboBox.getSelectedItem())) {
            this.editData.setProvince((ProvinceInfo)((ComBoxInfo)this.provinceComboBox.getSelectedItem()).getobjInfo());
        }
    }

    private void storeCity() {
        if (!TrainClientUtil.objectIsNull((Object)this.cityComboBox.getSelectedItem())) {
            this.editData.setCity((CityInfo)((ComBoxInfo)this.cityComboBox.getSelectedItem()).getobjInfo());
        }
    }

    private void loadCity() {
        if (!TrainClientUtil.objectIsNull((Object)this.editData.getCity())) {
            String id = this.editData.getCity().getId().toString();
            for (int j = this.cityComboBox.getItemCount() - 1; j > -1; --j) {
                CityInfo info = (CityInfo)((ComBoxInfo)this.cityComboBox.getItemAt(j)).getobjInfo();
                if (!id.equals(info.getId().toString())) continue;
                this.cityComboBox.setSelectedIndex(j);
            }
        } else {
            this.cityComboBox.setSelectedItem(null);
        }
    }

    private void loadProvince() {
        if (!TrainClientUtil.objectIsNull((Object)this.editData.getProvince())) {
            String id = this.editData.getProvince().getId().toString();
            for (int j = this.provinceComboBox.getItemCount() - 1; j > -1; --j) {
                ProvinceInfo info;
                Object ComboBoxItemObj = this.provinceComboBox.getItemAt(j);
                if (!(ComboBoxItemObj instanceof ComBoxInfo) || !id.equals((info = (ProvinceInfo)((ComBoxInfo)ComboBoxItemObj).getobjInfo()).getId().toString())) continue;
                this.provinceComboBox.setSelectedIndex(j);
            }
        } else {
            this.provinceComboBox.setSelectedItem(null);
        }
    }

    private void setPhotoImage() {
        if (this.editData != null && this.editData.getPhoto() != null) {
            try {
                ResumePhotoInfo resumePhotoInfo = this.editData.getPhoto();
                byte[] data = resumePhotoInfo.getImageData();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                BufferedImage bfg = ImageIO.read(bais);
                this.pPanel.setSelectImage(bfg);
                bais.close();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else if (this.editData != null && this.editData.getId() != null) {
            try {
                ResumeHistoryInfo resumeHistoryInfo = (ResumeHistoryInfo)ResumeHistoryFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
                if (resumeHistoryInfo.getPhoto() != null) {
                    ResumePhotoInfo resumePhotoInfo = resumeHistoryInfo.getPhoto();
                    byte[] data = resumePhotoInfo.getImageData();
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    BufferedImage bfg = ImageIO.read(bais);
                    this.pPanel.setSelectImage(bfg);
                    bais.close();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.pPanel.setSelectImage(null);
            this.pPanel.repaint();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("photo.*"));
        sic.add(new SelectorItemInfo("province.name"));
        sic.add(new SelectorItemInfo("city.name"));
        return sic;
    }
}

