/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractRewardListUI;
import com.kingdee.eas.hr.rec.client.IResumeBaseUI;
import com.kingdee.eas.hr.rec.client.ResumeListEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RewardListUI
extends AbstractRewardListUI
implements IResumeBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(RewardListUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private ItemAction[] actions;
    private boolean isHistory = false;
    private String resumeBaseId;
    private boolean requireReLoad = false;

    public void onLoad() throws Exception {
        this.initKdtSkill();
        super.onLoad();
    }

    private void initKdtSkill() {
        this.tblMain.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.actions != null && this.actions.length == 3) {
            for (int i = 0; i < this.actions.length; ++i) {
                ItemAction ia = this.actions[i];
                ia.setEnabled(true);
            }
            this.tblMain.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState()) && this.actions == null) {
            this.actions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contTable, (KDTable)this.tblMain);
            this.tblMain.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contTable, (KDTable)this.tblMain);
            for (int i = 0; i < this.actions.length; ++i) {
                ItemAction ia = this.actions[i];
                ia.setEnabled(false);
            }
            this.tblMain.setEnabled(false);
        }
        RecUtils.setCellTextEditor(this.tblMain, "name", 0, 200);
        RecUtils.setCellTextEditor(this.tblMain, "org", 0, 200);
        RecUtils.setCellDateEditor(this.tblMain, "date", false);
        this.tblMain.getColumn("name").setRequired(true);
    }

    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    public void beforeStoreFields(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            String name = (String)row.getCell("name").getValue();
            if (name != null) continue;
            this.tblMain.getEditManager().editCellAt(i, 0);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"reward_name"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        if (this.isHistory) {
            return new ResumeHistoryInfo();
        }
        return new ResumeBaseInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isHistory) {
            return ResumeHistoryFactory.getRemoteInstance();
        }
        return ResumeBaseFactory.getRemoteInstance();
    }

    public void initWorkButton() {
        this.btnPrintResume.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void actionPrintResume_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid resumeBaseId = this.editData.getId();
        if (resumeBaseId != null) {
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            list.add(resumeBaseId);
            ResumePrintProvider.executeActionPrint(list, (Component)((Object)this), this.isHistory);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        super.actionSubmit_actionPerformed(e);
        resumeListEditUI.showSubmitSuccess();
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return objectPK;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        if (resumeListEditUI.getUIContext().get("ID") != null) {
            recordId = resumeListEditUI.getUIContext().get("ID").toString();
        }
        this.isHistory = this.getUIContext().get("isHistory") != null ? (Boolean)this.getUIContext().get("isHistory") : false;
        if (recordId != null) {
            if (this.isHistory) {
                ResumeHistoryInfo resumeHistoryInfo = ResumeHistoryFactory.getRemoteInstance().getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.editData = resumeHistoryInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeHistoryInfo.getNumber());
                this.txtName.setText(resumeHistoryInfo.getName());
                Genders gender = resumeHistoryInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeHistoryInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            } else {
                ResumeBaseInfo resumeBaseInfo = ResumeBaseFactory.getRemoteInstance().getResumeBaseInfo((IObjectPK)new ObjectUuidPK(recordId), this.getSelectors());
                this.editData = resumeBaseInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeBaseInfo.getNumber());
                this.txtName.setText(resumeBaseInfo.getName());
                Genders gender = resumeBaseInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeBaseInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
                this.resumeBaseId = recordId;
            }
        }
        return this.editData;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("gender"));
        sic.add(new SelectorItemInfo("job_1"));
        sic.add(new SelectorItemInfo("job_2"));
        sic.add(new SelectorItemInfo("job_3"));
        sic.add(new SelectorItemInfo("reward.*"));
        return sic;
    }

    public boolean isRequireReLoad() {
        return this.requireReLoad;
    }

    public void reLoad() throws Exception {
        this.loadData();
    }

    public void setRequireReLoad(boolean requireReLoad) {
        this.requireReLoad = requireReLoad;
    }
}

