/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.hr.rec.InterviewFacadeFactory;
import com.kingdee.eas.hr.rec.OutPositionInfo;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.client.AbstractSetPositionUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SetPositionUI
extends AbstractSetPositionUI {
    private static final Logger logger = CoreUIObject.getLogger(SetPositionUI.class);
    private final String RES = "com.kingdee.eas.hr.rec.client.InterviewRecordResource";
    private Map map;
    String activityId;

    public void onLoad() throws Exception {
        this.tblResume.checkParsed();
        super.onLoad();
        this.map = (Map)this.getUIContext().get("resumeIds");
        if (this.map == null) {
            return;
        }
        if (this.getUIContext().get("activityId") == null) {
            return;
        }
        this.initTable();
        this.activityId = this.getUIContext().get("activityId").toString();
        this.fillData();
    }

    protected void initWorkButton() {
        this.btnSelectedCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.btnSelectedCopy.setVisible(true);
        JButton btnRemoveResume = this.kdconResume.add((Action)((Object)this.actionRemoveRow));
        btnRemoveResume.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveResume.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewRecordResource", (String)"removeRow"));
        this.actionRemoveRow.setEnabled(true);
        this.actionCancel.setEnabled(true);
    }

    private void initTable() throws EASBizException, BOSException {
        this.tblResume.getColumn("id").getStyleAttributes().setLocked(true);
        this.tblResume.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblResume.getColumn("dept").getStyleAttributes().setLocked(true);
        RecUtils.setCellQueryInfo2(this.tblResume, "outposition", "com.kingdee.eas.hr.rec.app.OutPositonF7Query", false);
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), "REC008");
        if ("false".equals(val)) {
            hashMap.put("HRO_FILTER", new Boolean(true));
        }
        if ("true".equals(val)) {
            hashMap.put("ALL_ADMIN", new Boolean(true));
        }
        PositionPromptBox2 positionBox = new PositionPromptBox2((IUIObject)this, hashMap);
        prmtPosition.setSelector((KDPromptSelector)positionBox);
        prmtPosition.setDisplayFormat("$name$");
        prmtPosition.setEditable(false);
        KDTDefaultCellEditor positionf7 = new KDTDefaultCellEditor((IKDEditor)prmtPosition);
        this.tblResume.getColumn("position").setEditor((ICellEditor)positionf7);
        this.tblResume.addKDTPropertyChangeListener((KDTPropertyChangeListener)new PositionPropertyChange());
    }

    private void fillData() throws Exception {
        LinkedHashSet set = new LinkedHashSet(this.map.keySet());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = RecUtils.getSic(new String[]{"id", "name", "position.adminOrgUnit.id", "position.adminOrgUnit.name", "position.id", "position.name", "outPosition.id", "outPosition.name"});
        evi.setSelector(sic);
        ResumeBaseCollection coll = ResumeBaseFactory.getRemoteInstance().getResumeBaseCollection(evi);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            ResumeBaseInfo info = coll.get(i);
            IRow row = this.tblResume.addRow();
            row.setUserObject((Object)info);
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("position").setValue((Object)info.getPosition());
            row.getCell("outposition").setValue((Object)info.getOutPosition());
            if (info.getOutPosition() == null) continue;
            row.getCell("dept").setValue(this.map.get(info.getId().toString()));
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        ResumeBaseInfo info = null;
        Object value = null;
        HashMap<String, ResumeBaseInfo> saveMap = new HashMap<String, ResumeBaseInfo>();
        for (int i = 0; i < this.tblResume.getRowCount(); ++i) {
            IRow row = this.tblResume.getRow(i);
            info = (ResumeBaseInfo)row.getUserObject();
            value = row.getCell("id").getValue();
            if (value == null) continue;
            PositionInfo pInfo = (PositionInfo)row.getCell("position").getValue();
            info.setPosition(pInfo);
            OutPositionInfo outPInfo = (OutPositionInfo)row.getCell("outposition").getValue();
            info.setOutPosition(outPInfo);
            if (row.getCell("dept").getValue() != null) {
                info.setAdminOrgUnit((AdminOrgUnitInfo)row.getCell("dept").getValue());
            }
            saveMap.put(info.getId().toString(), info);
        }
        InterviewFacadeFactory.getRemoteInstance().setSalaryAndPosition(saveMap, BOSUuid.read((String)this.activityId));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.client.InterviewRecordResource", (String)"saveSuccess"));
        this.getUIWindow().close();
    }

    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        RecUtils.removeLine(this.tblResume);
    }

    public void actionSelectedCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblResume.getRowCount() == 0) {
            return;
        }
        int size = this.tblResume.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblResume.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblResume.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || this.tblResume.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblResume.getCell(row, column).getValue();
            for (int i = 0; i < size; ++i) {
                sb = this.tblResume.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    if (this.tblResume.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    this.tblResume.getCell(j, column).setValue(value);
                }
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionOK.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnOK, 1001, this.btnOK.getActionCommand());
                this.actionOK.actionPerformed(event);
                return !this.actionOK.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    private boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (this.tblResume.getRowCount3() == 0) {
            return false;
        }
        int j = this.tblResume.getRowCount3();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblResume.getRow(i);
            ResumeBaseInfo rInfo = (ResumeBaseInfo)row.getUserObject();
            if (rInfo == null) {
                return true;
            }
            Object value = row.getCell("position").getValue();
            if (this.isEq(value, rInfo.getPosition())) {
                return true;
            }
            value = row.getCell("outposition").getValue();
            if (!this.isEq(value, rInfo.getOutPosition())) continue;
            return true;
        }
        return false;
    }

    private boolean isEq(Object o1, Object o2) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return true;
        }
        return o2 == null && o1 != null;
    }

    private class PositionPropertyChange
    implements KDTPropertyChangeListener {
        private PositionPropertyChange() {
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            int cPositionIndex = SetPositionUI.this.tblResume.getColumnIndex("position");
            int cDeptIndex = SetPositionUI.this.tblResume.getColumnIndex("dept");
            if (evt.getType() == 1 && evt.getColIndex() == cPositionIndex) {
                IRow row = SetPositionUI.this.tblResume.getRow(evt.getRowIndex());
                PositionInfo pInfo = (PositionInfo)row.getCell(cPositionIndex).getValue();
                if (pInfo != null) {
                    AdminOrgUnitInfo adminOrgUnitInfo = pInfo.getAdminOrgUnit();
                    String id = pInfo.getAdminOrgUnit().getId().toString();
                    try {
                        adminOrgUnitInfo = RecUtils.getDataBaseInfo((IDataBase)AdminOrgUnitFactory.getRemoteInstance(), id);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    row.getCell(cDeptIndex).setValue((Object)adminOrgUnitInfo);
                } else {
                    row.getCell(cDeptIndex).setValue(null);
                }
            }
        }
    }
}

