/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractSkillListUI;
import com.kingdee.eas.hr.rec.client.IResumeBaseUI;
import com.kingdee.eas.hr.rec.client.ResumeListEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SkillListUI
extends AbstractSkillListUI
implements IResumeBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(SkillListUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private ItemAction[] kdtSkillActions;
    private ItemAction[] kdtCertificateActions;
    private boolean isHistory = false;
    private String resumeBaseId;
    protected boolean isCheckModify = true;
    private boolean requireReLoad = false;

    public void onLoad() throws Exception {
        this.initKdtSkill();
        this.initKdtCertificate();
        super.onLoad();
    }

    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    public void beforeStoreFields(ActionEvent e) throws Exception {
        String name;
        IRow row;
        int i;
        for (i = 0; i < this.kdtSkill.getRowCount(); ++i) {
            row = this.kdtSkill.getRow(i);
            name = (String)row.getCell("name").getValue();
            if (name != null) continue;
            this.kdtSkill.getEditManager().editCellAt(i, 1);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"skill_name"));
            SysUtil.abort();
        }
        for (i = 0; i < this.kdtCertificate.getRowCount(); ++i) {
            row = this.kdtCertificate.getRow(i);
            name = (String)row.getCell("name").getValue();
            if (name != null) continue;
            this.kdtCertificate.getEditManager().editCellAt(i, 0);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"Certificate_name"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        if (this.isHistory) {
            ResumeHistoryInfo resumeHistoryInfo = new ResumeHistoryInfo();
            return resumeHistoryInfo;
        }
        ResumeBaseInfo resumeBaseInfo = new ResumeBaseInfo();
        return resumeBaseInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isHistory) {
            return ResumeHistoryFactory.getRemoteInstance();
        }
        return ResumeBaseFactory.getRemoteInstance();
    }

    public void initWorkButton() {
        this.btnPrintResume.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void actionPrintResume_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid resumeBaseId = this.editData.getId();
        if (resumeBaseId != null) {
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            list.add(resumeBaseId);
            ResumePrintProvider.executeActionPrint(list, (Component)((Object)this), this.isHistory);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        super.actionSubmit_actionPerformed(e);
        resumeListEditUI.showSubmitSuccess();
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return objectPK;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        if (resumeListEditUI.getUIContext().get("ID") != null) {
            recordId = resumeListEditUI.getUIContext().get("ID").toString();
        }
        this.isHistory = this.getUIContext().get("isHistory") != null ? (Boolean)this.getUIContext().get("isHistory") : false;
        if (recordId != null) {
            if (this.isHistory) {
                ResumeHistoryInfo resumeHistoryInfo = ResumeHistoryFactory.getRemoteInstance().getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.editData = resumeHistoryInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeHistoryInfo.getNumber());
                this.txtName.setText(resumeHistoryInfo.getName());
                Genders gender = resumeHistoryInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeHistoryInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            } else {
                ResumeBaseInfo resumeBaseInfo = ResumeBaseFactory.getRemoteInstance().getResumeBaseInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.editData = resumeBaseInfo;
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeBaseInfo.getNumber());
                this.txtName.setText(resumeBaseInfo.getName());
                Genders gender = resumeBaseInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeBaseInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
                this.resumeBaseId = recordId;
            }
        }
        return this.editData;
    }

    private void initKdtSkill() {
        this.kdtSkill.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtSkillActions != null && this.kdtSkillActions.length == 3) {
            for (int i = 0; i < this.kdtSkillActions.length; ++i) {
                ItemAction ia = this.kdtSkillActions[i];
                ia.setEnabled(true);
            }
            this.kdtSkill.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtSkillActions == null) {
            this.kdtSkillActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contSkill, (KDTable)this.kdtSkill);
            this.kdtSkill.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtSkillActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contSkill, (KDTable)this.kdtSkill);
            for (int i = 0; i < this.kdtSkillActions.length; ++i) {
                ItemAction ia = this.kdtSkillActions[i];
                ia.setEnabled(false);
            }
            this.kdtSkill.setEnabled(false);
        }
        RecUtils.setCellTextEditor(this.kdtSkill, "name", 0, 80);
        RecUtils.setCellTextEditor(this.kdtSkill, "useDate", 0, 80);
        this.kdtSkill.getColumn("name").setRequired(true);
        RecUtils.setCellQueryInfo2(this.kdtSkill, "langGrade", "com.kingdee.eas.hr.base.app.LangGradeQuery", false);
    }

    private void initKdtCertificate() {
        this.kdtCertificate.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtCertificateActions != null && this.kdtCertificateActions.length == 3) {
            for (int i = 0; i < this.kdtCertificateActions.length; ++i) {
                ItemAction ia = this.kdtCertificateActions[i];
                ia.setEnabled(true);
            }
            this.kdtCertificate.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState()) && this.kdtCertificateActions == null) {
            this.kdtCertificateActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contCertificate, (KDTable)this.kdtCertificate);
            this.kdtCertificate.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtCertificateActions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contCertificate, (KDTable)this.kdtCertificate);
            for (int i = 0; i < this.kdtCertificateActions.length; ++i) {
                ItemAction ia = this.kdtCertificateActions[i];
                ia.setEnabled(false);
            }
            this.kdtCertificate.setEnabled(false);
        }
        RecUtils.setCellDateEditor(this.kdtCertificate, "certifyDate", false);
        RecUtils.setCellTextEditor(this.kdtCertificate, "cerNumber", 0, 80);
        RecUtils.setCellTextEditor(this.kdtCertificate, "name", 0, 80);
        RecUtils.setCellTextEditor(this.kdtCertificate, "organ", 0, 80);
        RecUtils.setCellTextEditor(this.kdtCertificate, "validPeriod", 0, 80);
        this.kdtCertificate.getColumn("cerNumber").setWidth(146);
        this.kdtCertificate.getColumn("name").setWidth(200);
        this.kdtCertificate.getColumn("organ").setWidth(200);
        this.kdtCertificate.getColumn("certifyDate").setWidth(100);
        this.kdtCertificate.getColumn("validPeriod").setWidth(150);
        this.kdtCertificate.getColumn("name").setRequired(true);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("gender"));
        sic.add(new SelectorItemInfo("job_1"));
        sic.add(new SelectorItemInfo("job_2"));
        sic.add(new SelectorItemInfo("job_3"));
        sic.add(new SelectorItemInfo("skill.*"));
        sic.add(new SelectorItemInfo("skill.langGrade.name"));
        sic.add(new SelectorItemInfo("certificate.*"));
        return sic;
    }

    public boolean isModify() {
        if (!this.isCheckModify) {
            return false;
        }
        return super.isModify();
    }

    public boolean isCheckModify() {
        return this.isCheckModify;
    }

    public void setCheckModify(boolean isCheckModify) {
        this.isCheckModify = isCheckModify;
    }

    public boolean isRequireReLoad() {
        return this.requireReLoad;
    }

    public void reLoad() throws Exception {
        this.loadData();
    }

    public void setRequireReLoad(boolean requireReLoad) {
        this.requireReLoad = requireReLoad;
    }
}

