/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ITalentCategory;
import com.kingdee.eas.hr.rec.TalentCategoryFactory;
import com.kingdee.eas.hr.rec.TalentCategoryInfo;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.client.AbstractTalentExtendTreeEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class TalentExtendTreeEditUI
extends AbstractTalentExtendTreeEditUI {
    private static final String RES = "com.kingdee.eas.hr.rec.client.TalentResource";

    protected IObjectValue createNewData() {
        TalentCategoryInfo info = new TalentCategoryInfo();
        info.setParent(this.getParentType());
        return info;
    }

    private TalentCategoryInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (TalentCategoryInfo)obj;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TalentCategoryFactory.getRemoteInstance();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTalentTreeNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getSelectedItem() == null || StringUtils.isEmpty((String)this.txtName.getSelectedItem().toString())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTalentTreeName"));
            SysUtil.abort();
        }
        if (!OprtState.EDIT.equals(this.oprtState) && this.isNumberUniqueInTree()) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"numberNotUniqueInTree"));
            SysUtil.abort();
        }
        if (this.isNameUniqueInLevel()) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nameNotUniqueInLevel"));
            SysUtil.abort();
        }
    }

    private boolean isNumberUniqueInTree() throws Exception {
        ITalentCategory iTalentCategory = TalentCategoryFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("number", (Object)this.txtNumber.getText().trim(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            filterInfo.mergeFilter(filter, "AND");
        }
        return iTalentCategory.exists(filterInfo);
    }

    private boolean isNameUniqueInLevel() throws Exception {
        FilterInfo filter;
        String name = this.txtName.getSelectedItem().toString().trim();
        if (this.editData.getName() != null && this.editData.getName().equals(name)) {
            return false;
        }
        ITalentCategory iTalentCategory = TalentCategoryFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)name, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (this.editData.getParent() != null) {
            filterItemInfo = new FilterItemInfo("parent.id", (Object)this.editData.getParent().getId(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString("#0 and #1");
        }
        if ((filter = RecUtils.getHRFilterByParam("REC002")) != null) {
            filterInfo.mergeFilter(filter, "AND");
        }
        return iTalentCategory.exists(filterInfo);
    }

    private boolean isHaveTanlent() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("category.id", (Object)this.editData.getId(), CompareType.EQUALS));
        return TalentExtendFactory.getRemoteInstance().exists(filterInfo);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null && this.isHaveTanlent()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotAddSubType"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isHaveTanlent()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotDeleteWithTalent"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if ("EDIT".equals(this.oprtState)) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        } else if ("ADDNEW".equals(this.oprtState)) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.requestFocus();
        }
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("EDIT".equals(this.oprtState)) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        } else if ("ADDNEW".equals(this.oprtState)) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.requestFocus();
        }
    }
}

