/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.rec.ITalentCategory;
import com.kingdee.eas.hr.rec.TalentCategoryCollection;
import com.kingdee.eas.hr.rec.TalentCategoryFactory;
import com.kingdee.eas.hr.rec.TalentCategoryInfo;
import com.kingdee.eas.hr.rec.client.AbstractTalentExtendTypeF7UI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TalentExtendTypeF7UI
extends AbstractTalentExtendTypeF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TalentExtendTypeF7UI.class);
    private static final String RES = "com.kingdee.eas.hr.rec.ResumeResource";
    private boolean isConfirmed = false;
    private TalentCategoryInfo data = null;
    private boolean isLeaf = false;

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTree();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isLeaf) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"leafPerfTypePlease"));
            SysUtil.abort();
        }
        this.isConfirmed = true;
        if (this.data != null) {
            this.fillFullName(this.data);
        }
        super.actionExitCurrent_actionPerformed(null);
    }

    public void actionCancelOP_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(null);
    }

    protected void treeMain_mouseClicked(MouseEvent e) throws Exception {
        Object obj = this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode node = null;
        boolean state = this.treeMain.isCollapsed(this.treeMain.getMaxSelectionRow());
        if (e.getClickCount() == 1) {
            if (obj instanceof DefaultKingdeeTreeNode && !(node = (DefaultKingdeeTreeNode)obj).isRoot()) {
                this.isLeaf = node.isLeaf();
                this.data = (TalentCategoryInfo)node.getUserObject();
            }
        } else if (e.getClickCount() == 2 && obj instanceof DefaultKingdeeTreeNode && !(node = (DefaultKingdeeTreeNode)obj).isRoot() && state) {
            this.isLeaf = node.isLeaf();
            this.data = (TalentCategoryInfo)node.getUserObject();
            this.actionConfirm_actionPerformed(null);
        }
    }

    private void initTree() throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RES, (String)"talentCategory"));
        root.setCheckBoxVisible(false);
        ITalentCategory talentCategory = TalentCategoryFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = RecUtils.getHRFilterByParam("REC002");
        if (filter != null) {
            viewInfo.setFilter(filter);
        }
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        TalentCategoryCollection categoryCollection = talentCategory.getTalentCategoryCollection(viewInfo);
        TalentCategoryInfo categoryInfo = null;
        DefaultKingdeeTreeNode child = null;
        int size = categoryCollection.size();
        for (int i = 0; i < size; ++i) {
            categoryInfo = categoryCollection.get(i);
            if (categoryInfo.getParent() != null || categoryInfo.getLevel() != 1) continue;
            child = this.getNode(categoryCollection, categoryInfo);
            root.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
    }

    private DefaultKingdeeTreeNode getNode(TalentCategoryCollection categoryColl, TalentCategoryInfo categoryInfo) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)categoryInfo.getName());
        root.setCheckBoxVisible(true);
        root.setUserObject((Object)categoryInfo);
        TalentCategoryInfo info = null;
        int size = categoryColl.size();
        for (int i = 0; i < size; ++i) {
            info = categoryColl.get(i);
            if (info.getParent() == null || !info.getParent().getId().equals((Object)categoryInfo.getId())) continue;
            DefaultKingdeeTreeNode child = this.getNode(categoryColl, info);
            child.setCheckBoxVisible(true);
            root.add((MutableTreeNode)child);
        }
        return root;
    }

    public boolean isCanceled() {
        return !this.isConfirmed;
    }

    public TalentCategoryInfo getSelectedData() {
        return this.data;
    }

    private void fillFullName(TalentCategoryInfo type) throws Exception {
        String longNumber = type.getLongNumber();
        if (longNumber.length() <= 0 || longNumber.indexOf("!") == -1) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber.substring(0, longNumber.indexOf(33)) + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber.substring(0, longNumber.lastIndexOf(33)) + "!%"), CompareType.NOTLIKE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("id");
        sic.add("name");
        TalentCategoryCollection coll = TalentCategoryFactory.getRemoteInstance().getTalentCategoryCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            StringBuffer fullName = new StringBuffer();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                fullName.append(coll.get(i).getName());
                fullName.append("-");
            }
            fullName.append(type.getName());
            type.setName(fullName.toString());
        }
    }
}

