/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.hr.base.ISpecialtyType;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.SpecialtyTypeInfo;
import com.kingdee.eas.hr.rec.InterviewException;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.client.AbstractTalentFilterUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TalentFilterUI
extends AbstractTalentFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TalentFilterUI.class);
    private boolean isHistory = false;
    private boolean isContextSearch = false;
    private final int PageSize = 10;
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";

    public boolean isHistoryFilter() {
        return this.isHistory;
    }

    public boolean getBtnHistoryState() {
        return this.btnHistory.isSelected();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboSex.addItem((Object)"  ");
        this.comboSex.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.basedata.person.Genders").toArray());
        this.comboSex.setEditable(false);
        this.comboInterviewResult.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.rec.InterviewResultEnum").toArray());
        this.comboInterviewResult.setEditable(false);
        RecUtils.setPositionF7((CoreUIObject)this, this.prmtPosition, true, false, true, "$name$");
        RecUtils.setAdminOrgUnitF7((JPanel)((Object)this), this.prmtAdminOrgUnit, true, false, "$name$");
        this.prmtSpecialty.setEnabledMultiSelection(true);
        this.prmtHighestDiploma.setEditable(false);
        this.prmtSpecialty.setEditable(false);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add((AbstractButton)this.btnTalentExtend);
        btnGroup.add((AbstractButton)this.btnHistory);
        this.btnTalentExtend.setSelected(true);
        this.btnHistory.setSelected(false);
        SpinnerNumberModel model = new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1);
        this.txtPage.setModel((SpinnerModel)model);
        this.clear();
        this.cbContextSearch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg) {
                TalentFilterUI.this.isContextSearch = TalentFilterUI.this.cbContextSearch.isSelected();
                TalentFilterUI.this.setState(TalentFilterUI.this.isContextSearch);
            }
        });
        this.btnHistory.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg) {
                TalentFilterUI.this.cbContextSearch.setSelected(false);
                TalentFilterUI.this.cbContextSearch.setEnabled(false);
                TalentFilterUI.this.isContextSearch = TalentFilterUI.this.cbContextSearch.isSelected();
                TalentFilterUI.this.cbContextSearch.setVisible(false);
                TalentFilterUI.this.txtContextData.setVisible(false);
                TalentFilterUI.this.txtPage.setVisible(false);
                TalentFilterUI.this.contPage.setVisible(false);
                TalentFilterUI.this.setState(TalentFilterUI.this.isContextSearch);
            }
        });
        this.btnTalentExtend.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg) {
                TalentFilterUI.this.cbContextSearch.setSelected(false);
                TalentFilterUI.this.cbContextSearch.setEnabled(true);
                TalentFilterUI.this.isContextSearch = TalentFilterUI.this.cbContextSearch.isSelected();
                TalentFilterUI.this.cbContextSearch.setVisible(true);
                TalentFilterUI.this.txtContextData.setVisible(true);
                TalentFilterUI.this.txtPage.setVisible(true);
                TalentFilterUI.this.contPage.setVisible(true);
                TalentFilterUI.this.setState(TalentFilterUI.this.isContextSearch);
            }
        });
    }

    public FilterInfo getFilterInfo() {
        int i;
        Object[] objs;
        this.isHistory = this.btnHistory.isSelected();
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        HashSet<String> set = null;
        this.isContextSearch = this.cbContextSearch.isSelected();
        if (this.isContextSearch && !this.isHistory) {
            Object keyWord = this.txtContextData.getSelectedItem();
            if (keyWord != null && !StringUtils.isEmpty((String)keyWord.toString())) {
                int page = (Integer)this.txtPage.getValue() - 1;
                int startRecord = 0;
                startRecord = page < 0 ? 0 : page * 10;
                try {
                    Map results = TalentExtendFactory.getRemoteInstance().searchContext(keyWord.toString(), startRecord, 10);
                    HashSet ids = (HashSet)results.get("resultIdsSet");
                    if (ids != null && ids.size() > 0) {
                        itemCollection.add(new FilterItemInfo("resumeBase.id", (Object)ids, CompareType.INCLUDE));
                    } else {
                        itemCollection.add(new FilterItemInfo("resumeBase.id", (Object)"no_exist"));
                    }
                }
                catch (Exception ex) {
                    super.handUIException((Throwable)ex);
                }
            }
            return this.filterInfo;
        }
        if (!this.objectIsNull(this.pkEntryDateFrom.getValue())) {
            item = new FilterItemInfo("entryDate", this.pkEntryDateFrom.getValue(), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.pkEntryDateTo.getValue())) {
            Date nextDay = (Date)this.pkEntryDateTo.getValue();
            nextDay = RecUtils.dateAdd(nextDay, 1);
            item = new FilterItemInfo("entryDate", (Object)nextDay, CompareType.LESS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.txtWorkYearsFrom.getText())) {
            item = new FilterItemInfo("resumeBase.workYears", (Object)Integer.valueOf(this.txtWorkYearsFrom.getText()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.txtWorkYearsTo.getText())) {
            item = new FilterItemInfo("resumeBase.workYears", (Object)Integer.valueOf(this.txtWorkYearsTo.getText()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.pkYingPDateFrom.getValue())) {
            item = new FilterItemInfo("resumeBase.yingPDate", (Object)((Date)this.pkYingPDateFrom.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.pkYingPDateTo.getValue())) {
            Date d = (Date)this.pkYingPDateTo.getValue();
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            c.add(6, 1);
            item = new FilterItemInfo("resumeBase.yingPDate", (Object)c.getTime(), CompareType.LESS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.txtAgeFrom.getText())) {
            item = new FilterItemInfo("resumeBase.age", (Object)Integer.valueOf(this.txtAgeFrom.getText()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.txtAgeTo.getText())) {
            item = new FilterItemInfo("resumeBase.age", (Object)Integer.valueOf(this.txtAgeTo.getText()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.prmtHighestDiploma.getValue())) {
            item = new FilterItemInfo("Diploma.id", (Object)((DiplomaInfo)this.prmtHighestDiploma.getValue()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (this.prmtPosition.getValue() != null && this.prmtPosition.getValue() instanceof Object[] && (objs = (Object[])this.prmtPosition.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet<String>();
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof PositionInfo)) continue;
                PositionInfo positionInfo = (PositionInfo)objs[i];
                set.add(positionInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("position.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (this.prmtAdminOrgUnit.getValue() != null && this.prmtAdminOrgUnit.getValue() instanceof Object[] && (objs = (Object[])this.prmtAdminOrgUnit.getValue()).length > 0 && objs[0] != null) {
            set = new HashSet();
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof AdminOrgUnitInfo)) continue;
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)objs[i];
                set.add(adminOrgUnitInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("adminOrgUnit.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
            }
        }
        if (!this.objectIsNull(this.comboSex.getSelectedItem()) && this.comboSex.getSelectedItem() instanceof Genders) {
            item = new FilterItemInfo("resumeBase.gender", (Object)((Genders)this.comboSex.getSelectedItem()).getValue(), CompareType.EQUALS);
            itemCollection.add(item);
        }
        if (this.prmtSpecialty.getValue() != null) {
            objs = (Object[])this.prmtSpecialty.getValue();
            SpecialtyTypeInfo specialtyTypeInfo = null;
            if (objs.length > 0 && objs[0] != null) {
                set = new HashSet();
                for (i = 0; i < objs.length; ++i) {
                    if (!(objs[i] instanceof SpecialtyTypeInfo)) continue;
                    specialtyTypeInfo = (SpecialtyTypeInfo)objs[i];
                    set.add(specialtyTypeInfo.getId().toString());
                }
                if (set.size() > 0) {
                    item = new FilterItemInfo("specialtyType.id", set, CompareType.INCLUDE);
                    itemCollection.add(item);
                }
            }
        }
        if (!this.objectIsNull(this.txtSkill.getSelectedItem()) && !this.objectIsNull(this.txtSkill.getSelectedItem().toString())) {
            String skill = this.txtSkill.getSelectedItem().toString().trim();
            skill = "%" + skill + "%";
            item = new FilterItemInfo("Skill.name", (Object)skill, CompareType.LIKE);
            itemCollection.add(item);
        }
        if (!this.objectIsNull(this.txtCertificate.getSelectedItem()) && !this.objectIsNull(this.txtCertificate.getSelectedItem().toString())) {
            String certificate = this.txtCertificate.getSelectedItem().toString().trim();
            certificate = "%" + certificate + "%";
            item = new FilterItemInfo("Certificate.name", (Object)certificate, CompareType.LIKE);
            itemCollection.add(item);
        }
        return this.filterInfo;
    }

    private void setState(boolean isContext) {
        this.txtSkill.setEnabled(!isContext);
        this.txtCertificate.setEnabled(!isContext);
        this.comboSex.setEnabled(!isContext);
        this.pkEntryDateFrom.setEnabled(!isContext);
        this.pkEntryDateTo.setEnabled(!isContext);
        this.txtWorkYearsFrom.setEnabled(!isContext);
        this.txtWorkYearsTo.setEnabled(!isContext);
        this.pkEntryDateTo.setEnabled(!isContext);
        this.pkYingPDateFrom.setEnabled(!isContext);
        this.pkYingPDateTo.setEnabled(!isContext);
        this.txtAgeFrom.setEnabled(!isContext);
        this.txtAgeTo.setEnabled(!isContext);
        this.prmtAdminOrgUnit.setEnabled(!isContext);
        this.prmtHighestDiploma.setEnabled(!isContext);
        this.prmtPosition.setEnabled(!isContext);
        this.prmtSpecialty.setEnabled(!isContext);
        this.txtContextData.setEnabled(isContext);
        this.txtPage.setEnabled(isContext);
    }

    public void clear() {
        this.txtSkill.setSelectedItemData(null);
        this.txtCertificate.setSelectedItemData(null);
        this.comboSex.setSelectedItem(null);
        this.pkEntryDateFrom.setValue(null);
        this.pkEntryDateTo.setValue(null);
        this.txtWorkYearsFrom.setText("");
        this.txtWorkYearsTo.setText("");
        this.pkEntryDateTo.setValue(null);
        this.pkYingPDateFrom.setValue(null);
        this.pkYingPDateTo.setValue(null);
        this.txtAgeFrom.setText("");
        this.txtAgeTo.setText("");
        this.prmtAdminOrgUnit.setValue(null);
        this.prmtHighestDiploma.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtSpecialty.setValue(null);
        this.btnTalentExtend.setSelected(true);
        this.btnHistory.setSelected(false);
        this.cbContextSearch.setSelected(false);
        this.txtContextData.setEnabled(false);
        this.txtPage.setEnabled(false);
        this.txtContextData.setSelectedItemData(null);
        this.txtPage.setValue((Object)1);
        this.chkDisplayName.setSelected(true);
    }

    public CustomerParams getCustomerParams() {
        Object[] ogs;
        int i;
        CustomerParams cp = new CustomerParams();
        String emptyString = "";
        Object obj = null;
        obj = this.pkEntryDateFrom.getValue();
        if (!this.objectIsNull(obj)) {
            cp.putDate("entryDateFrom", (Date)obj);
        }
        if (!this.objectIsNull(obj = this.pkEntryDateTo.getValue())) {
            cp.putDate("entryDateTo", (Date)obj);
        }
        if (!this.objectIsNull(obj = this.txtWorkYearsFrom.getText())) {
            cp.addCustomerParam("workYearsFrom", (String)obj);
        }
        if (!this.objectIsNull(obj = this.txtWorkYearsTo.getText())) {
            cp.addCustomerParam("workYearsTo", (String)obj);
        }
        if (!this.objectIsNull(obj = this.pkYingPDateFrom.getValue())) {
            cp.putDate("yingPDateFrom", (Date)obj);
        }
        if (!this.objectIsNull(obj = this.pkYingPDateTo.getValue())) {
            cp.putDate("yingPDateTo", (Date)obj);
        }
        if (!this.objectIsNull(obj = this.txtAgeFrom.getText())) {
            cp.addCustomerParam("ageFrom", (String)obj);
        }
        if (!this.objectIsNull(obj = this.txtAgeTo.getText())) {
            cp.addCustomerParam("ageTo", (String)obj);
        }
        if (!this.objectIsNull(obj = this.prmtHighestDiploma.getValue()) && obj instanceof DiplomaInfo) {
            cp.addCustomerParam("highestDiploma", ((DiplomaInfo)obj).getId().toString());
        }
        if ((obj = this.prmtPosition.getValue()) != null) {
            Object[] ps = (Object[])obj;
            StringBuffer positions = new StringBuffer();
            if (ps.length > 0 && ps[0] != null) {
                for (i = 0; i < ps.length - 1; ++i) {
                    positions.append(((PositionInfo)ps[i]).getId().toString());
                    positions.append("\u2014\u2014");
                }
                positions.append(((PositionInfo)ps[i]).getId().toString());
                cp.addCustomerParam("position", positions.toString());
            }
        }
        if (!this.objectIsNull(obj = this.comboSex.getSelectedItem()) && obj instanceof Genders) {
            cp.putInt("sex", ((Genders)obj).getValue());
        } else {
            cp.putInt("sex", -1);
        }
        obj = this.prmtAdminOrgUnit.getValue();
        if (obj != null && obj instanceof Object[] && (ogs = (Object[])obj).length > 0 && ogs[0] != null) {
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("adminOrgUnit", orgUnits.toString());
        }
        if (!this.objectIsNull(obj = this.prmtSpecialty.getValue()) && ((Object[])obj).length > 0 && ((Object[])obj)[0] != null) {
            StringBuffer specialTypes = new StringBuffer();
            Object[] sts = (Object[])obj;
            for (i = 0; i < sts.length - 1; ++i) {
                specialTypes.append(((SpecialtyTypeInfo)sts[i]).getId().toString());
                specialTypes.append("\u2014\u2014");
            }
            specialTypes.append(((SpecialtyTypeInfo)sts[i]).getId().toString());
            cp.addCustomerParam("specialty", specialTypes.toString());
        }
        if (!this.objectIsNull(obj = this.txtSkill.getSelectedItem()) && !this.objectIsNull(obj.toString())) {
            cp.addCustomerParam("skill", obj.toString());
        } else {
            cp.addCustomerParam("skill", emptyString);
        }
        obj = this.txtCertificate.getSelectedItem();
        if (!this.objectIsNull(obj) && !this.objectIsNull(obj.toString())) {
            cp.addCustomerParam("certificate", obj.toString());
        }
        cp.putBoolean("isHistory", this.btnHistory.isSelected());
        cp.putBoolean("isContext", this.cbContextSearch.isSelected());
        obj = this.txtContextData.getSelectedItem();
        if (!RecUtils.objectIsNull(obj) && !RecUtils.objectIsNull(obj.toString())) {
            cp.addCustomerParam("contextData", obj.toString());
        }
        if ((obj = this.txtPage.getValue()) != null) {
            cp.addCustomerParam("page", obj.toString());
        }
        cp.putBoolean("isDisplayName", this.chkDisplayName.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        Object value = null;
        EntityViewInfo evi = new EntityViewInfo();
        if (this.objectIsNull(cp)) {
            return;
        }
        this.clear();
        value = cp.getDate("entryDateFrom");
        if (!this.objectIsNull(value)) {
            this.pkEntryDateFrom.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("entryDateTo"))) {
            this.pkEntryDateTo.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("yingPDateFrom"))) {
            this.pkYingPDateFrom.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getDate("yingPDateTo"))) {
            this.pkYingPDateTo.setValue(value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("workYearsFrom"))) {
            this.txtWorkYearsFrom.setText((String)value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("workYearsTo"))) {
            this.txtWorkYearsTo.setText((String)value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("ageFrom"))) {
            this.txtAgeFrom.setText((String)value);
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("ageTo"))) {
            this.txtAgeTo.setText((String)value);
        }
        try {
            PositionCollection col;
            FilterInfo fi;
            ObjectUuidPK pk = null;
            value = cp.getCustomerParam("highestDiploma");
            if (!this.objectIsNull(value)) {
                IDiploma diploma = DiplomaFactory.getRemoteInstance();
                pk = new ObjectUuidPK((String)value);
                this.prmtHighestDiploma.setValue((Object)diploma.getDiplomaInfo((IObjectPK)pk));
            }
            if (!this.objectIsNull(value = cp.getCustomerParam("position"))) {
                String[] positionIds = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IPosition position = PositionFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(positionIds)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = position.getPositionCollection(evi);
                this.prmtPosition.setValue((Object)col.toArray());
            }
            if (!this.objectIsNull(value = cp.getCustomerParam("adminOrgUnit"))) {
                String[] adminOrg = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(adminOrg)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                this.prmtAdminOrgUnit.setValue((Object)col.toArray());
            }
            if (!this.objectIsNull(value = cp.getCustomerParam("specialty"))) {
                ISpecialtyType specialtyType = SpecialtyTypeFactory.getRemoteInstance();
                String[] typeIds = StringUtils.split((String)((String)value), (String)"\u2014\u2014");
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(typeIds)), CompareType.INCLUDE));
                evi.setFilter(fi);
                col = specialtyType.getSpecialtyTypeCollection(evi);
                this.prmtSpecialty.setValue((Object)col.toArray());
            }
            this.btnHistory.setSelected(cp.getBoolean("isHistory"));
            this.btnTalentExtend.setSelected(!cp.getBoolean("isHistory"));
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        int sex = cp.getInt("sex");
        if (sex != -1) {
            this.comboSex.setSelectedItem((Object)Genders.getEnum((int)sex));
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("skill"))) {
            this.txtSkill.setSelectedItemData((Object)((String)value));
        }
        if (!this.objectIsNull(value = cp.getCustomerParam("certificate"))) {
            this.txtCertificate.setSelectedItemData((Object)((String)value));
        }
        this.isContextSearch = cp.getBoolean("isContext");
        this.cbContextSearch.setSelected(this.isContextSearch);
        this.setState(this.isContextSearch);
        value = cp.getCustomerParam("contextData");
        if (!RecUtils.objectIsNull(value)) {
            this.txtContextData.setSelectedItemData(value);
        } else {
            this.txtContextData.setSelectedItemData(null);
        }
        value = cp.getCustomerParam("page");
        if (!this.objectIsNull(value)) {
            this.txtPage.setValue((Object)Integer.valueOf(value.toString()));
        }
        this.chkDisplayName.setSelected(cp.getBoolean("isDisplayName"));
    }

    public boolean verify() {
        int to;
        int from;
        if (!RecUtils.objectIsNull(this.txtAgeFrom.getText()) && !RecUtils.objectIsNull(this.txtAgeTo.getText()) && (from = Integer.valueOf(this.txtAgeFrom.getText()).intValue()) > (to = Integer.valueOf(this.txtAgeTo.getText()).intValue())) {
            this.txtAgeTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.AGE_FROM_GT_TO).getMessage());
            return false;
        }
        if (!RecUtils.objectIsNull(this.txtWorkYearsFrom.getText()) && !RecUtils.objectIsNull(this.txtWorkYearsTo.getText()) && (from = Integer.valueOf(this.txtWorkYearsFrom.getText()).intValue()) > (to = Integer.valueOf(this.txtWorkYearsTo.getText()).intValue())) {
            this.txtWorkYearsTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.WORKYEARS_FROM_GT_TO).getMessage());
            return false;
        }
        if (!RecUtils.objectIsNull(this.pkYingPDateFrom.getValue()) && !RecUtils.objectIsNull(this.pkYingPDateTo.getValue()) && ((Date)this.pkYingPDateFrom.getValue()).compareTo((Date)this.pkYingPDateTo.getValue()) > 0) {
            this.pkYingPDateTo.requestFocus();
            MsgBox.showWarning((String)new InterviewException(InterviewException.YINGPDATE_START_NOT_GT_END).getMessage());
            return false;
        }
        if (!RecUtils.objectIsNull(this.pkEntryDateFrom.getValue()) && !RecUtils.objectIsNull(this.pkEntryDateTo.getValue())) {
            this.pkEntryDateTo.requestFocus();
            if (((Date)this.pkEntryDateFrom.getValue()).compareTo((Date)this.pkEntryDateTo.getValue()) > 0) {
                MsgBox.showWarning((String)new InterviewException(InterviewException.ENTRYDATE_FROM_GT_TO).getMessage());
                return false;
            }
        }
        this.isContextSearch = this.cbContextSearch.isSelected();
        this.isHistory = this.btnHistory.isSelected();
        if (!this.isHistory && this.isContextSearch) {
            Object keyWord = this.txtContextData.getSelectedItem();
            if (keyWord != null && !StringUtils.isEmpty((String)keyWord.toString())) {
                if (this.txtPage.getValue() == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"contextSearchPageNotNull"));
                    return false;
                }
                int page = (Integer)this.txtPage.getValue() - 1;
                int startRecord = 0;
                int totalSize = 0;
                startRecord = page < 0 ? 0 : page * 10;
                try {
                    Map results = TalentExtendFactory.getRemoteInstance().searchContext(keyWord.toString(), startRecord, 10);
                    totalSize = Double.valueOf((double)Integer.valueOf((String)results.get("totalResultSize")).intValue() / 10.0).intValue() + 1;
                    if (totalSize < page) {
                        MsgBox.showWarning((Component)((Object)this), (String)new StringBuffer().append(EASResource.getString((String)resumeRES, (String)"contextSearchTotalResultSize")).append(totalSize).append(",").append(EASResource.getString((String)resumeRES, (String)"pleaseChangePage")).toString());
                        return false;
                    }
                }
                catch (Exception ex) {
                    super.handUIException((Throwable)ex);
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"contextSearchContentNotNull"));
                return false;
            }
        }
        return super.verify();
    }

    private boolean objectIsNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return StringUtils.isEmpty((String)object.toString());
        }
        return false;
    }

    public static final class ConditionSearchParam
    implements Serializable {
        public static final String SKILL = "skill";
        public static final String CERTIFICATE = "certificate";
        public static final String SEX = "sex";
        public static final String ENTRYDATEFROM = "entryDateFrom";
        public static final String ENTRYDATETO = "entryDateTo";
        public static final String WORKYEARSFROM = "workYearsFrom";
        public static final String WORKYEARSTO = "workYearsTo";
        public static final String YINGPDATEFROM = "yingPDateFrom";
        public static final String YINGPDATETO = "yingPDateTo";
        public static final String AGEFROM = "ageFrom";
        public static final String AGETO = "ageTo";
        public static final String ADMINORGUNIT = "adminOrgUnit";
        public static final String HIGHESTDIPLOMA = "highestDiploma";
        public static final String POSITION = "position";
        public static final String SPECIALTY = "specialty";
        public static final String ISHISTORY = "isHistory";
        public static final String INTERVIEWRESULT = "InterviewResult";
    }
}

