/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.client.AbstractWorkExpListUI;
import com.kingdee.eas.hr.rec.client.IResumeBaseUI;
import com.kingdee.eas.hr.rec.client.ResumeListEditUI;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.eas.hr.rec.util.ResumePrintProvider;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class WorkExpListUI
extends AbstractWorkExpListUI
implements IResumeBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkExpListUI.class);
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private boolean isHistory = false;
    private ItemAction[] actions;
    protected boolean isCheckModify = true;
    private boolean requireReLoad = false;

    public void onLoad() throws Exception {
        this.initKdtWorkExp();
        super.onLoad();
    }

    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    public void beforeStoreFields(ActionEvent e) throws Exception {
        int columnCount = this.kdtWorkExp.getColumnCount();
        for (int i = 0; i < this.kdtWorkExp.getRowCount(); ++i) {
            String organ;
            Object value;
            IRow row = this.kdtWorkExp.getRow(i);
            for (int j = 0; j < columnCount && (value = row.getCell(j).getValue()) == null; ++j) {
                if (j != columnCount - 1) continue;
                this.kdtWorkExp.getEditManager().editCellAt(i, 0);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"row_null"));
                SysUtil.abort();
            }
            Date startDate = (Date)row.getCell("startDate").getValue();
            Date endDate = (Date)row.getCell("endDate").getValue();
            if (startDate != null && endDate != null && startDate.after(endDate)) {
                this.kdtWorkExp.getEditManager().editCellAt(i, 1);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"endDate_little_startDate"));
                SysUtil.abort();
            }
            if ((organ = (String)row.getCell("organ").getValue()) != null) continue;
            this.kdtWorkExp.getEditManager().editCellAt(i, 2);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resumeRES, (String)"wokrExp_organ"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        super.actionSubmit_actionPerformed(e);
        resumeListEditUI.showSubmitSuccess();
    }

    public void initWorkButton() {
        this.btnPrintResume.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void actionPrintResume_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid resumeBaseId = this.editData.getId();
        if (resumeBaseId != null) {
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            list.add(resumeBaseId);
            ResumePrintProvider.executeActionPrint(list, (Component)((Object)this), this.isHistory);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return objectPK;
    }

    protected IObjectValue createNewData() {
        WorkExpInfo workExpInfo = new WorkExpInfo();
        if (this.isHistory) {
            ResumeHistoryInfo resumeHistoryInfo = new ResumeHistoryInfo();
            resumeHistoryInfo.setId(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            workExpInfo.setResumeBase(resumeHistoryInfo);
            return resumeHistoryInfo;
        }
        ResumeBaseInfo resumeBaseInfo = new ResumeBaseInfo();
        resumeBaseInfo.setId(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
        workExpInfo.setResumeBase(resumeBaseInfo);
        return resumeBaseInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isHistory) {
            return ResumeHistoryFactory.getRemoteInstance();
        }
        return ResumeBaseFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        ResumeListEditUI resumeListEditUI = (ResumeListEditUI)((Object)this.getUIContext().get("ListEditUI"));
        if (resumeListEditUI.getUIContext().get("ID") != null) {
            recordId = resumeListEditUI.getUIContext().get("ID").toString();
        }
        this.isHistory = this.getUIContext().get("isHistory") != null ? (Boolean)this.getUIContext().get("isHistory") : false;
        if (recordId != null) {
            if (this.isHistory) {
                ResumeHistoryInfo resumeHistoryInfo = ResumeHistoryFactory.getRemoteInstance().getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeHistoryInfo.getNumber());
                this.txtName.setText(resumeHistoryInfo.getName());
                Genders gender = resumeHistoryInfo.getGender();
                this.txtGender.setText(gender.getAlias());
                this.txtJob1.setText(resumeHistoryInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            } else {
                ResumeBaseInfo resumeBaseInfo;
                this.editData = resumeBaseInfo = ResumeBaseFactory.getRemoteInstance().getResumeBaseInfo((IObjectPK)new ObjectUuidPK(recordId), this.getMergedSelector());
                this.setDataObject((IObjectValue)this.editData);
                resumeListEditUI.getUIContext().put("ID", this.editData.getId().toString());
                this.txtNumber.setText(resumeBaseInfo.getNumber());
                this.txtName.setText(resumeBaseInfo.getName());
                Genders gender = resumeBaseInfo.getGender();
                if (gender != null) {
                    this.txtGender.setText(gender.getAlias());
                }
                this.txtJob1.setText(resumeBaseInfo.getJob_1());
                this.txtNumber.setEditable(false);
                this.txtName.setEditable(false);
                this.txtGender.setEditable(false);
                this.txtJob1.setEditable(false);
            }
        }
        return this.editData;
    }

    private void initKdtWorkExp() {
        this.kdtWorkExp.checkParsed();
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.actions != null && this.actions.length == 3) {
            for (int i = 0; i < this.actions.length; ++i) {
                ItemAction ia = this.actions[i];
                ia.setEnabled(true);
            }
            this.kdtWorkExp.setEnabled(true);
        } else if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.actions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contWorkExp, (KDTable)this.kdtWorkExp);
            this.kdtWorkExp.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actions = TrainUtils.addButtonsToMutilTable((KDContainer)this.contWorkExp, (KDTable)this.kdtWorkExp);
            for (int i = 0; i < this.actions.length; ++i) {
                ItemAction ia = this.actions[i];
                ia.setEnabled(false);
            }
            this.kdtWorkExp.setEnabled(false);
        }
        RecUtils.setCellDateEditor(this.kdtWorkExp, "startDate", false);
        RecUtils.setCellDateEditor(this.kdtWorkExp, "endDate", false);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "organAddress", 0, 80);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "organ", 0, 50);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "industryType", 0, 50);
        RecUtils.setCellQueryInfo2(this.kdtWorkExp, "organType", "com.kingdee.eas.hr.base.app.UnitTypeQuery", false);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "organDempartment", 0, 50);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "linkman", 0, 50);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "linkmanPhone", 0, 50);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "position", 0, 50);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "dimissionReason", 0, 80);
        RecUtils.setCellTextEditor(this.kdtWorkExp, "duty", 0, 1000);
        this.kdtWorkExp.getColumn("organ").setRequired(true);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("gender"));
        sic.add(new SelectorItemInfo("job_1"));
        sic.add(new SelectorItemInfo("job_2"));
        sic.add(new SelectorItemInfo("job_3"));
        sic.add(new SelectorItemInfo("workExp.*"));
        return sic;
    }

    public boolean isModify() {
        if (!this.isCheckModify) {
            return false;
        }
        return super.isModify();
    }

    public boolean isCheckModify() {
        return this.isCheckModify;
    }

    public void setCheckModify(boolean isCheckModify) {
        this.isCheckModify = isCheckModify;
    }

    public boolean isRequireReLoad() {
        return this.requireReLoad;
    }

    public void reLoad() throws Exception {
        this.loadData();
    }

    public void setRequireReLoad(boolean requireReLoad) {
        this.requireReLoad = requireReLoad;
    }
}

