/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.RowSet;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class AccessFunction {
    private static File lastSelectPath = null;
    private static String RES = "com.kingdee.eas.hr.rec.AccessFunctionResource";
    public static final String AccessFileType = "mdb";
    private static Logger logger = Logger.getLogger(AccessFunction.class);

    public static boolean isFileExists(String fileName) {
        boolean isFileExists = false;
        try {
            File file = new File(fileName);
            isFileExists = file.exists();
            file = null;
        }
        catch (Exception ex) {
            isFileExists = false;
        }
        return isFileExists;
    }

    public static final String accessFileChoose(Component parent) throws Exception {
        String sFileName = null;
        KDFileChooser choose = new KDFileChooser(lastSelectPath);
        SimpleFileFilter ff = new SimpleFileFilter(AccessFileType);
        choose.setFileFilter((FileFilter)ff);
        boolean isFileValid = false;
        while (!isFileValid) {
            int rVal = choose.showOpenDialog(parent);
            lastSelectPath = choose.getCurrentDirectory();
            if (rVal == 0) {
                sFileName = choose.getSelectedFile().getPath();
                if (!AccessFunction.isSupportFileType(sFileName)) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)RES, (String)"supportfiletype"));
                    isFileValid = false;
                    sFileName = "";
                    continue;
                }
                isFileValid = true;
                continue;
            }
            isFileValid = true;
            sFileName = "";
        }
        return sFileName;
    }

    public static String getFileExtension(String path) {
        if (path != null) {
            String filename = path;
            int i = filename.lastIndexOf(46);
            int j = filename.lastIndexOf(File.separator);
            if (i > 0 && i < filename.length() - 1 && j < i) {
                return filename.substring(i + 1).toLowerCase();
            }
        }
        return null;
    }

    public static boolean isSupportFileType(String filePath) {
        String fileExtension = AccessFunction.getFileExtension(filePath);
        if (fileExtension == null) {
            return false;
        }
        return AccessFileType.equalsIgnoreCase(fileExtension);
    }

    public static synchronized String getUuID() {
        return Uuid.create().toString();
    }

    public static String getTempFileName(String uuid, String fileType) {
        return uuid + "." + fileType;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RowSet getJdbcRowSet(String accessName, String strSql) throws SQLException, Exception {
        JdbcRowSet jdbcRowSet;
        Connection cn = null;
        Statement stmt = null;
        ResultSet rset = null;
        StringBuffer driverURL = new StringBuffer("jdbc:odbc:Driver={MicroSoft Access Driver (*.mdb)};DBQ=");
        driverURL.append(accessName);
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
            cn = DriverManager.getConnection(driverURL.toString());
            stmt = cn.createStatement();
            rset = stmt.executeQuery(strSql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rset);
            jdbcRowSet = rowset;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
                catch (Exception e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt, (Connection)cn);
        return jdbcRowSet;
    }
}

